/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs12.SafeContents;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class SafeContentsBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid = PKCSOID.SAFECONTENTSBAG_OID;
    private SafeContents value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.SafeContentsBag";

    public SafeContentsBag(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeContentsBag", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SafeContentsBag");
        }
    }

    public SafeContentsBag(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContentsBag", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SafeContentsBag");
        }
    }

    public SafeContentsBag(SafeContents safeContents) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeContentsBag", safeContents);
            debug.exit(16384L, className, "SafeContentsBag");
        }
        this.value = safeContents;
    }

    public SafeContentsBag(SafeContents safeContents, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContentsBag", safeContents, string);
            debug.exit(16384L, className, "SafeContentsBag");
        }
        this.value = safeContents;
    }

    public SafeContentsBag(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContentsBag", string, new Boolean(bl));
            debug.exit(16384L, className, "SafeContentsBag");
        }
    }

    public SafeContentsBag(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SafeContentsBag", objectArray);
            debug.exit(16384L, className, "SafeContentsBag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.value.encode(outputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception exception) {
            objectIdentifier = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", objectIdentifier);
        }
        return objectIdentifier;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.value.clone());
        }
        return this.value.clone();
    }

    public byte[] getEncodedValue() {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
        }
        try {
            this.value.encode(derOutputStream);
            byte[] byArray = derOutputStream.toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedValue_1", byArray);
            }
            return byArray;
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedValue", iOException);
                debug.exit(16384L, (Object)className, "getEncodedValue_2", null);
            }
            return null;
        }
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "SafeContentsBag");
        }
        return "SafeContentsBag";
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof SafeContentsBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((SafeContentsBag)object));
            }
            return this.equals((SafeContentsBag)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SafeContentsBag safeContentsBag = new SafeContentsBag(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", safeContentsBag);
            }
            return safeContentsBag;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "SafeContentsBag:";
        string = string + "\r\nobject identifier: " + this.oid;
        string = string + "\r\nsafe contents:\r\n";
        string = string + this.value.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        this.value = new SafeContents(derValue.toByteArray(), this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(SafeContentsBag safeContentsBag) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", safeContentsBag);
        }
        if (safeContentsBag == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            safeContentsBag.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

