/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.pkcs12.PFX;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.cert.Certificate;

public class parsePFX {
    public static void main(String[] stringArray) throws Throwable {
        int n = 0;
        String string = null;
        char[] cArray = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length < 8) {
            parsePFX.usage();
            System.exit(1);
        }
        try {
            EncryptedPrivateKeyInfo[] encryptedPrivateKeyInfoArray;
            Object[] objectArray;
            Object object;
            while (n < stringArray.length) {
                object = stringArray[n];
                if (((String)object).equals("-f")) {
                    if (string != null) {
                        System.out.println("ERROR: PFX file has already been specified.");
                        parsePFX.usage();
                        System.exit(1);
                    }
                    string = stringArray[++n];
                } else if (((String)object).equals("-p")) {
                    if (cArray != null) {
                        System.out.println("ERROR: Password has already been specified.");
                        parsePFX.usage();
                        System.exit(1);
                    }
                    cArray = stringArray[++n].toCharArray();
                } else if (((String)object).equals("-k")) {
                    if (string3 != null) {
                        System.out.println("ERROR: Key file has already been specified.");
                        parsePFX.usage();
                        System.exit(1);
                    }
                    string3 = stringArray[++n];
                } else if (((String)object).equals("-c")) {
                    if (string2 != null) {
                        System.out.println("ERROR: Certificate file has already been specified.");
                        parsePFX.usage();
                        System.exit(1);
                    }
                    string2 = stringArray[++n];
                }
                ++n;
            }
            if (string == null) {
                System.out.println("ERROR: PFX file must be specified.");
                parsePFX.usage();
                System.exit(1);
            }
            if (cArray == null) {
                System.out.println("ERROR: Password must be specified.");
                parsePFX.usage();
                System.exit(1);
            }
            if (string2 == null) {
                System.out.println("ERROR: Certificate file must be specified.");
                parsePFX.usage();
                System.exit(1);
            }
            if (string3 == null) {
                System.out.println("ERROR: Key file must be specified.");
                parsePFX.usage();
                System.exit(1);
            }
            object = new FileInputStream(string);
            byte[] byArray = new byte[((FileInputStream)object).available()];
            ((FileInputStream)object).read(byArray);
            ((FileInputStream)object).close();
            PFX pFX = new PFX(byArray);
            System.out.println("PFX constructed from " + string);
            System.out.println(pFX.toString());
            System.out.println("Verifying MAC with input password.");
            if (pFX.verifyMac(cArray)) {
                System.out.println("MAC is verified.");
            } else {
                System.out.println("MAC is not verified.");
                System.exit(2);
            }
            String string4 = null;
            FileOutputStream fileOutputStream = null;
            Certificate[] certificateArray = pFX.getCertificates(cArray);
            if (certificateArray != null && certificateArray.length > 0) {
                System.out.println("Found " + certificateArray.length + " certificates.");
                for (n = 0; n < certificateArray.length; ++n) {
                    string4 = string2 + n + ".cer";
                    System.out.println("Writing certificate to " + string4);
                    objectArray = certificateArray[n].getEncoded();
                    fileOutputStream = new FileOutputStream(string4);
                    fileOutputStream.write((byte[])objectArray);
                    fileOutputStream.close();
                }
            } else {
                System.out.println("Found no certificates.");
            }
            if ((objectArray = pFX.getPrivateKeys(cArray)) != null && objectArray.length > 0) {
                System.out.println("Found " + objectArray.length + " private keys.");
                for (n = 0; n < objectArray.length; ++n) {
                    string4 = string3 + n + ".pri";
                    System.out.println("Writing private key to " + string4);
                    objectArray[n].write(string4, false);
                }
            } else {
                System.out.println("Found no private keys.");
            }
            if ((encryptedPrivateKeyInfoArray = pFX.getShroudedKeys(cArray)) != null && encryptedPrivateKeyInfoArray.length > 0) {
                System.out.println("Found " + encryptedPrivateKeyInfoArray.length + " shrouded keys.");
                for (n = 0; n < encryptedPrivateKeyInfoArray.length; ++n) {
                    string4 = string3 + n + ".epri";
                    System.out.println("Writing shrouded key to " + string4);
                    encryptedPrivateKeyInfoArray[n].write(string4, false);
                    System.out.println("Converting shrouded key to private key.");
                    string4 = string3 + n + ".pri";
                    System.out.println("Writing decrypted private key to " + string4);
                    byte[] byArray2 = encryptedPrivateKeyInfoArray[n].decrypt(cArray);
                    PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(byArray2);
                    privateKeyInfo.write(string4, false);
                }
            } else {
                System.out.println("Found no shrouded keys.");
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Caught exception.");
            exception.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: parsePFX -f PFXfile -p password -c certfile -k keyfile");
        System.out.println("where  PFXfile is the PFX file");
        System.out.println("       password is the password used to protect the PFX");
        System.out.println("       certfile will hold any parsed certificates (.cer extension)");
        System.out.println("       keyfile will hold any parsed keys (.pri extension for private keys,");
        System.out.println("           .epri extension for shrouded keys)");
    }
}

