/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public final class CertificateAlgorithmId
implements CertAttrSet {
    private AlgorithmId algId;
    public static final String IDENT = "x509.info.algorithmID";
    public static final String NAME = "algorithmID";
    public static final String ALGORITHM = "algorithm";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateAlgorithmId";

    public CertificateAlgorithmId(AlgorithmId algorithmId) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateAlgorithmId", algorithmId);
            debug.exit(16384L, className, "CertificateAlgorithmId");
        }
        this.algId = algorithmId;
    }

    public CertificateAlgorithmId(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateAlgorithmId", derInputStream);
        }
        DerValue derValue = derInputStream.getDerValue();
        this.algId = AlgorithmId.parse(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateAlgorithmId");
        }
    }

    public CertificateAlgorithmId(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateAlgorithmId", inputStream);
        }
        DerValue derValue = new DerValue(inputStream);
        this.algId = AlgorithmId.parse(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateAlgorithmId");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.algId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", this.algId.toString() + ", OID = " + this.algId.getOID().toString() + "\n");
        }
        return this.algId.toString() + ", OID = " + this.algId.getOID().toString() + "\n";
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.algId.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof AlgorithmId)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type AlgorithmId.");
            }
            throw new IOException("Attribute must be of type AlgorithmId.");
        }
        if (!string.equalsIgnoreCase(ALGORITHM)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        this.algId = (AlgorithmId)object;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(ALGORITHM)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", this.algId);
            }
            return this.algId;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(ALGORITHM)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        this.algId = null;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(ALGORITHM);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.algId.getOID());
        }
        return this.algId.getOID();
    }
}

