/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMExtensionItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.util.Vector;

public class MSCertificateStore {
    private static Vector cspNameList = null;
    private String cspName = null;
    private String password = null;
    private Vector keyLabelList = null;
    private Vector personalKeyLabelList = null;
    private Vector signerKeyLabelList = null;

    public static native int c_GetCSPNameList();

    public native int c_BuildKeyLabelList(String var1, String var2);

    public native int c_DeleteKeyItemByLabel(String var1, String var2, String var3);

    public native KeyItem c_GetKeyItemByLabel(String var1, String var2, String var3);

    public native KeyItem[] c_GetKeyItemListByLabel(String var1, String var2, String var3);

    public native KeyItem[] c_GetKeyItemsByPublicKey(String var1, String var2, int var3, byte[] var4);

    public native int c_ImportCertificate(String var1, String var2, String var3, int var4, byte[] var5, int var6, byte[] var7);

    public native int c_AddSignerCertificate(String var1, String var2, String var3, String var4, boolean var5);

    public native int c_CreateNewSelfSignedCertificate(String var1, String var2, int var3, String var4, int var5, DNItem var6, int var7, int var8, int var9, byte[] var10);

    public static void addCSPName(String string) {
        if (string != null) {
            if (cspNameList == null) {
                cspNameList = new Vector();
            }
            cspNameList.addElement(string);
        }
    }

    public static Vector getCSPNameList() {
        KMUtil.debugMsg("MSCertificateStore::getCSPNameList(), before calling c_GetCSPNameList()");
        MSCertificateStore.c_GetCSPNameList();
        return cspNameList;
    }

    public MSCertificateStore(String string, String string2) {
        this.cspName = string;
        this.password = string2;
        this.keyLabelList = null;
        this.personalKeyLabelList = null;
        this.signerKeyLabelList = null;
    }

    public void open() throws KMException {
        try {
            this.buildKeyLabelList();
        }
        catch (KMException kMException) {
            throw this.buildNewKMException("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_OPEN_FAILED", kMException.getErrCodeName());
        }
    }

    public void buildKeyLabelList() throws KMException {
        KMUtil.debugMsg("MSCertificateStore::buildKeyLabelList() 0000");
        this.keyLabelList = new Vector();
        this.personalKeyLabelList = new Vector();
        this.signerKeyLabelList = new Vector();
        int n = this.c_BuildKeyLabelList(this.cspName, this.password);
        if (n != 0) {
            String string = CMSKeyDatabaseException.getErrKey(n);
            KMUtil.debugMsg("MSCertificateStore::buildKeyLabelList() 9999-1, returnCode=" + n);
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        KMUtil.debugMsg("MSCertificateStore::buildKeyLabelList() 9999");
    }

    public void close() {
        this.password = null;
        this.keyLabelList = null;
        this.personalKeyLabelList = null;
        this.signerKeyLabelList = null;
    }

    public String getCSPName() {
        return this.cspName;
    }

    public Vector getKeyLabelList() {
        return this.keyLabelList;
    }

    public Vector getPersonalKeyLabelList() {
        return this.personalKeyLabelList;
    }

    public Vector getSignerKeyLabelList() {
        return this.signerKeyLabelList;
    }

    public void deleteKeyItemByLabel(String string) throws KMException {
        KeyItem keyItem = this.getKeyItemByLabel(string);
        int n = this.c_DeleteKeyItemByLabel(this.cspName, this.password, string);
        if (n != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_KEYDB_KEY_DELETE", CMSKeyDatabaseException.getErrKey(n));
        }
        Vector vector = null;
        vector = keyItem.hasPrivateKey() ? this.personalKeyLabelList : this.signerKeyLabelList;
        this.deleteKeyLabel(vector, string);
        vector = this.keyLabelList;
        this.deleteKeyLabel(vector, string);
    }

    public KeyItem getKeyItemByLabel(String string) throws KMException {
        KeyItem keyItem = null;
        keyItem = this.c_GetKeyItemByLabel(this.cspName, this.password, string);
        if (keyItem == null) {
            String string2 = "GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_LABEL";
            throw this.buildNewKMException(string2, string2);
        }
        return keyItem;
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws KMException {
        KeyItem[] keyItemArray = this.c_GetKeyItemListByLabel(this.cspName, this.password, string);
        if (keyItemArray == null) {
            String string2 = "GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX";
            throw this.buildNewKMException(string2, string2);
        }
        return keyItemArray;
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws KMException {
        byte[] byArray = bERObject.getEncoded();
        int n = bERObject.getLength();
        KeyItem[] keyItemArray = this.c_GetKeyItemsByPublicKey(this.cspName, this.password, n, byArray);
        if (keyItemArray == null) {
            String string = "GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_PUBKEY";
            throw this.buildNewKMException(string, string);
        }
        Vector<KeyItem> vector = new Vector<KeyItem>(keyItemArray.length);
        int n2 = 0;
        while (n2 < keyItemArray.length) {
            vector.addElement(keyItemArray[n2]);
            ++n2;
        }
        return vector;
    }

    public void importCertificate(KeyItem keyItem) throws KMException {
        int n;
        if (keyItem == null || !keyItem.hasCertificate()) {
            String string = "GSKKM_ERR_CMN_KEYDB_KEY_INSERT";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        String string = keyItem.getKeyLabel();
        CertificateItem certificateItem = (CertificateItem)keyItem.getCertificateChain().elementAt(0);
        int n2 = certificateItem.getLength();
        byte[] byArray = certificateItem.getEncoded();
        int n3 = 0;
        byte[] byArray2 = null;
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItem.getEncryptedPrivateKeyInfoItem();
        if (encryptedPrivateKeyInfoItem != null) {
            byArray2 = encryptedPrivateKeyInfoItem.getEncoded();
            n3 = encryptedPrivateKeyInfoItem.getLength();
        }
        if ((n = this.c_ImportCertificate(this.cspName, this.password, string, n2, byArray, n3, byArray2)) != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_KEYDB_KEY_INSERT", CMSKeyDatabaseException.getErrKey(n));
        }
        this.addKeyLabel(string);
        if (n3 > 0) {
            this.addPersonalKeyLabel(string);
        } else {
            this.addSignerKeyLabel(string);
        }
    }

    public void addSignerCertificate(String string, String string2, boolean bl) throws KMException {
        int n = this.c_AddSignerCertificate(this.cspName, this.password, string, string2, bl);
        if (n != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_CERT_STORE", CMSKeyDatabaseException.getErrKey(n));
        }
        this.addKeyLabel(string);
        this.addSignerKeyLabel(string);
    }

    public void createNewSelfSignedCertificate(int n, String string, int n2, DNItem dNItem, int n3, int n4, Vector vector) throws KMException {
        int n5;
        byte[] byArray = this.encodeExtensions(vector);
        int n6 = 0;
        if (byArray != null) {
            n6 = byArray.length;
        }
        if ((n5 = this.c_CreateNewSelfSignedCertificate(this.cspName, this.password, n - 1, string, n2, dNItem, n3, n4, n6, byArray)) != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_KEYDB_NEW_SSCERT", CMSKeyDatabaseException.getErrKey(n5));
        }
        this.addKeyLabel(string);
        this.addPersonalKeyLabel(string);
    }

    public byte[] encodeExtensions(Vector vector) throws KMException {
        byte[] byArray = null;
        PKCSAttributes pKCSAttributes = null;
        try {
            if (vector != null && vector.size() > 0) {
                Object var4_4 = null;
                Object var5_6 = null;
                Object var6_8 = null;
                boolean bl = false;
                String string = "";
                int n = 0;
                while (n < vector.size()) {
                    string = string + "<" + (String)((KMExtensionItem)vector.elementAt(n)).getFieldValue() + ">";
                    ++n;
                }
                DerValue derValue = new DerValue(19, string);
                DerValue derValue2 = new DerValue(49, derValue.toByteArray());
                PKCSAttribute pKCSAttribute = new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, (Object)derValue2.toByteArray());
                PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
                pKCSAttributes = new PKCSAttributes(pKCSAttributeArray);
                byArray = pKCSAttributes.generateDerEncoding();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        return byArray;
    }

    private boolean containsKeyLabel(Vector vector, String string) {
        if (vector != null && string != null) {
            int n = 0;
            while (n < vector.size()) {
                if (string.equals(vector.elementAt(n))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void deleteKeyLabel(Vector vector, String string) {
        if (vector != null && string != null) {
            int n = 0;
            while (n < vector.size()) {
                if (string.equals(vector.elementAt(n))) {
                    vector.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
    }

    public void addKeyLabel(String string) {
        if (string != null) {
            if (this.keyLabelList == null) {
                this.keyLabelList = new Vector();
            }
            this.keyLabelList.addElement(string);
        }
    }

    public void addPersonalKeyLabel(String string) {
        if (string != null) {
            if (this.personalKeyLabelList == null) {
                this.personalKeyLabelList = new Vector();
            }
            this.personalKeyLabelList.addElement(string);
        }
    }

    public void addSignerKeyLabel(String string) {
        if (string != null) {
            if (this.signerKeyLabelList == null) {
                this.signerKeyLabelList = new Vector();
            }
            this.signerKeyLabelList.addElement(string);
        }
    }

    private KMException buildNewKMException(String string, String string2) {
        KMException kMException = new KMException(KMSystem.getNLSErrString(string), string2);
        return kMException;
    }
}

