/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.TabContext;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

class GTKEngine {
    static final GTKEngine INSTANCE = new GTKEngine();
    static final int[] DEFAULT_FOCUS_PATTERN = new int[]{1, 1};

    GTKEngine() {
    }

    static int adjustAxisForComponentOrientation(JComponent jComponent, int n) {
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            return n;
        }
        switch (n) {
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        return n;
    }

    public void paintArrow(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        int n8 = n6 / 2;
        if (n6 % 2 == 1) {
            ++n8;
        }
        int n9 = n7 / 2;
        if (n7 % 2 == 1) {
            ++n9;
        }
        int n10 = Math.max(2, Math.min(n8, n9));
        switch (n3) {
            case 100: {
                n4 += n6 / 2 - 1;
                n5 += (n7 - n10) / 2;
                break;
            }
            case 101: {
                n4 += n6 / 2 - 1;
                n5 += (n7 - n10) / 2 + 1;
                break;
            }
            case 102: {
                n4 += (n6 - n10) / 2;
                n5 += n7 / 2 - 1;
                break;
            }
            case 103: {
                n4 += (n6 - n10) / 2 + 1;
                n5 += n7 / 2 - 1;
            }
        }
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n11 = 0;
        int n12 = n10 / 2 - 1;
        graphics.translate(n4, n5);
        if (n == 8) {
            graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.WHITE));
        } else {
            graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.FOREGROUND));
        }
        switch (n3) {
            case 100: {
                int n13 = 0;
                while (n13 < n10) {
                    graphics.drawLine(n12 - n13, n13, n12 + n13, n13);
                    ++n13;
                }
                break;
            }
            case 101: {
                n11 = 0;
                int n14 = n10 - 1;
                while (n14 >= 0) {
                    graphics.drawLine(n12 - n14, n11, n12 + n14, n11);
                    ++n11;
                    --n14;
                }
                break;
            }
            case 102: {
                int n15 = 0;
                while (n15 < n10) {
                    graphics.drawLine(n15, n12 - n15, n15, n12 + n15);
                    ++n15;
                }
                break;
            }
            case 103: {
                n11 = 0;
                int n16 = n10 - 1;
                while (n16 >= 0) {
                    graphics.drawLine(n11, n12 - n16, n11, n12 + n16);
                    ++n11;
                    --n16;
                }
                break;
            }
        }
        graphics.translate(-n4, -n5);
    }

    public void paintBox(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Region region = synthContext.getRegion();
        this.paintBackground(synthContext, graphics, n, gTKStyle.getGTKColor(synthContext.getComponent(), region, n, GTKColorType.BACKGROUND), n3, n4, n5, n6);
        this.paintShadow(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
    }

    public void paintBoxGap(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this._paintBoxGap(synthContext, graphics, n, n2, n3, n4, n5, n6, n7, n8, n9, GTKColorType.BACKGROUND, GTKColorType.LIGHT, GTKColorType.BLACK, GTKColorType.DARK, false);
    }

    void _paintBoxGap(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4, boolean bl) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        this.paintBackground(synthContext, graphics, n, gTKStyle.getGTKColor(jComponent, region, n, colorType), n3, n4, n5, n6);
        int n10 = n8 + n9;
        Color color = gTKStyle.getGTKColor(jComponent, region, n, colorType2);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n, colorType3);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n, colorType4);
        Color color4 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.WHITE);
        graphics.translate(n3, n4);
        if (n7 == 2) {
            graphics.setColor(color2);
            graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n6 - 2);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 0, 1, n6 - 3);
            }
            graphics.setColor(color2);
            graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5 - 2, 0, n5 - 2, n6 - 2);
            if (n8 > 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n8, 0);
            }
            graphics.setColor(color);
            graphics.drawLine(n10, 0, n5 - 2, 0);
            if (bl) {
                graphics.setColor(color4);
                if (n8 > 0) {
                    graphics.drawLine(0, 1, n8, 1);
                }
                graphics.drawLine(n10, 1, n5 - 2, 1);
            }
        } else if (n7 == 3) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n5 - 1, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n5 - 1, 1);
            }
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n6 - 1);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n6 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 2);
            if (n8 > 0) {
                graphics.setColor(color2);
                graphics.drawLine(0, n6 - 1, n8, n6 - 1);
                graphics.setColor(color3);
                graphics.drawLine(1, n6 - 2, n8, n6 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n10, n6 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n10, n6 - 2, n5 - 2, n6 - 2);
        } else if (n7 == 1) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n5 - 1, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n5 - 1, 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n6 - 2);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n6 - 3);
            }
            if (n8 > 0) {
                graphics.setColor(color2);
                graphics.drawLine(n5 - 1, 0, n5 - 1, n8);
                graphics.setColor(color3);
                graphics.drawLine(n5 - 2, 1, n5 - 2, n8);
            }
            graphics.setColor(color2);
            graphics.drawLine(n5 - 1, n10, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5 - 2, n10, n5 - 2, n6 - 2);
        } else if (n7 == 0) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n5 - 2, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n5 - 2, 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
            graphics.setColor(color2);
            graphics.drawLine(n5 - 1, 1, n5 - 1, n6 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5 - 2, 0, n5 - 2, n6 - 2);
            if (n8 > 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n8);
            }
            graphics.setColor(color);
            graphics.drawLine(0, n10, 0, n6 - 2);
            if (bl) {
                graphics.setColor(color4);
                if (n8 > 0) {
                    graphics.drawLine(1, 0, 1, n8);
                }
                graphics.drawLine(1, n10, 1, n6 - 3);
            }
        }
        graphics.translate(-n3, -n4);
    }

    public void paintCheck(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        int n7 = synthContext.getComponentState();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if ("checkbutton" == string) {
            if ((n7 & 4) == 0) {
                this.paintBox(synthContext, graphics, 1, 0, string, n3, n4, n5, n6);
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.WHITE));
            } else {
                this.paintBox(synthContext, graphics, 4, 0, string, n3, n4, n5, n6);
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BACKGROUND));
            }
        }
        graphics.translate(n3, n4);
        int n8 = n6 / 2 - 1;
        if ("checkbutton" == string) {
            graphics.fillRect(2, 2, n5 - 4, n6 - 4);
        }
        if ((n7 & 0x200) != 0) {
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK));
            graphics.drawLine(3, n8 + 2, 4, n8 + 2);
            graphics.drawLine(5, n8 + 3, 6, n8 + 3);
            graphics.drawLine(6, n8 + 2, 6, n8 + 4);
            graphics.drawLine(7, n8 + 1, 7, n8);
            graphics.drawLine(7, n8, 8, n8);
            graphics.drawLine(8, n8, 8, n8 - 1);
            graphics.drawLine(8, n8 - 1, 9, n8 - 1);
            graphics.drawLine(9, n8 - 1, 9, n8 - 2);
            if ((n7 & 4) != 0) {
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, 4, GTKColorType.DARK));
            } else {
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, 1, GTKColorType.DARK));
            }
            graphics.drawLine(3, n8 + 1, 4, n8 + 1);
            graphics.drawLine(4, n8 + 3, 4, n8 + 3);
            graphics.drawLine(5, n8 + 2, 5, n8 + 2);
            graphics.drawLine(6, n8 + 1, 6, n8 + 1);
            graphics.drawLine(7, n8 + 2, 7, n8 + 2);
            graphics.drawLine(10, n8 - 2, 10, n8 - 2);
        }
        graphics.translate(-n3, -n4);
    }

    public void paintExtension(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        this._paintExtension(synthContext, graphics, n, n2, n3, n4, n5, n6, n7, GTKColorType.LIGHT, GTKColorType.BACKGROUND, GTKColorType.BLACK, GTKColorType.DARK, false);
    }

    void _paintExtension(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4, boolean bl) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        TabContext tabContext = (TabContext)synthContext;
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        int n8 = gTKStyle.getXThickness();
        int n9 = gTKStyle.getYThickness();
        if (n8 < 0 && n9 < 0) {
            return;
        }
        Color color = gTKStyle.getGTKColor(jComponent, region, n, colorType);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n, colorType2);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n, colorType3);
        Color color4 = gTKStyle.getGTKColor(jComponent, region, n, colorType4);
        Color color5 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.WHITE);
        int n10 = tabContext.getTabIndex();
        int n11 = ((JTabbedPane)jComponent).getSelectedIndex();
        graphics.translate(n3, n4);
        if (n7 == 3) {
            this.paintBackground(synthContext, graphics, n, color2, 0, 1, n5, n6);
            if (n10 == n11 || n10 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 1, 0, n6 - 1);
                graphics.drawLine(1, 0, n5 - 2, 0);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, 1, n6 - 1);
                    graphics.drawLine(1, 1, n5 - 3, 1);
                }
            } else {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n5 - 2, 0);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 1, n5 - 3, 1);
                }
            }
            if (n10 + 1 != n11) {
                graphics.setColor(color4);
                graphics.drawLine(n5 - 2, 2, n5 - 2, n6 - 1);
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, 1, n5 - 1, n6 - 1);
            }
        } else if (n7 == 2) {
            this.paintBackground(synthContext, graphics, n, color2, 0, 0, n5, n6 - 1);
            if (n10 == n11 || n10 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n6 - 2);
                graphics.setColor(color3);
                graphics.drawLine(1, n6 - 1, n5 - 2, n6 - 1);
                graphics.setColor(color4);
                graphics.drawLine(2, n6 - 2, n5 - 2, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 0, 1, n6 - 2);
                }
            } else {
                graphics.setColor(color3);
                graphics.drawLine(0, n6 - 1, n5 - 2, n6 - 1);
                graphics.setColor(color4);
                graphics.drawLine(0, n6 - 2, n5 - 2, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 0, 0, n6 - 2);
                }
            }
            if (n10 + 1 != n11) {
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n5 - 2, 0, n5 - 2, n6 - 2);
            }
        } else if (n7 == 1) {
            this.paintBackground(synthContext, graphics, n, color2, 1, 0, n5, n6);
            if (n10 == n11 || n10 == 0) {
                graphics.setColor(color);
                graphics.drawLine(1, 0, n5 - 1, 0);
                graphics.drawLine(0, 1, 0, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, n5, 1);
                    graphics.drawLine(1, 1, 1, n6 - 3);
                }
            } else {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, 1, n6 - 3);
                }
            }
            if (n10 + 1 != n11) {
                graphics.setColor(color3);
                graphics.drawLine(1, n6 - 1, n5 - 1, n6 - 1);
                graphics.setColor(color4);
                graphics.drawLine(2, n6 - 2, n5 - 1, n6 - 2);
            }
        } else if (n7 == 0) {
            this.paintBackground(synthContext, graphics, n, color2, 0, 0, n5 - 1, n6);
            if (n10 == n11 || n10 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n5 - 2, 0);
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, 1, n5 - 1, n6 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n5 - 2, 2, n5 - 2, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 1, n5 - 2, 1);
                    graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 3);
                }
            } else {
                graphics.setColor(color3);
                graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n5 - 2, 0, n5 - 2, n6 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 3);
                }
            }
            if (n10 + 1 != n11) {
                graphics.setColor(color3);
                graphics.drawLine(0, n6 - 1, n5 - 2, n6 - 1);
                graphics.setColor(color4);
                graphics.drawLine(0, n6 - 2, n5 - 2, n6 - 2);
            }
        }
        graphics.translate(-n3, -n4);
    }

    void paintFlatBoxNormal(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.BACKGROUND));
        this.paintFlatBox(synthContext, graphics, n, string, n2, n3, n4, n5);
    }

    void paintFlatBoxText(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.TEXT_BACKGROUND));
        this.paintFlatBox(synthContext, graphics, n, string, n2, n3, n4, n5);
    }

    public void paintFlatBox(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (string == "cell_odd") {
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            this.paintBackground(synthContext, graphics, n, graphics.getColor(), n2, n3, n4, n5);
        }
        if (string == "tooltip") {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
        }
    }

    public void paintFocus(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int[] nArray = (int[])gTKStyle.getClassSpecificValue(synthContext, "focus-line-pattern");
        int n6 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        if (nArray == null) {
            nArray = DEFAULT_FOCUS_PATTERN;
        }
        if (n6 <= 0) {
            return;
        }
        graphics.setColor(this.getFocusColor(synthContext, n));
        this._paintFocus(graphics, n2, n3, n4, n5, nArray, n6);
    }

    void _paintFocus(Graphics graphics, int n, int n2, int n3, int n4, int[] nArray, int n5) {
        int n6;
        graphics.translate(n, n2);
        int n7 = n6 = n5 / 2;
        int n8 = 0;
        int n9 = n3 - n5;
        int n10 = n9 + n4 - n5;
        int n11 = n10 + n3 - n5;
        int n12 = n11 + n4;
        while (n7 < n12) {
            int n13 = n7 + nArray[n8];
            if (n8 % 2 == 0) {
                int n14;
                int n15;
                if (n7 < n9) {
                    graphics.fillRect(n7, 0, Math.min(n13, n3) - n7, n5);
                    n7 = Math.min(n13, n9);
                }
                if (n7 != n13 && n7 < n10) {
                    graphics.fillRect(n3 - n5, n7 - n9, n5, Math.min(n10, n13) - n7);
                    n7 = Math.min(n10, n13);
                }
                if (n7 != n13 && n7 < n11) {
                    n15 = n3 - (n7 - n10);
                    n14 = Math.min(n13 - n7, n11 - n7);
                    graphics.fillRect(n15 - n14, n4 - n5, n14, n5);
                    n7 += n14;
                }
                if (n7 != n13) {
                    n15 = n4 - (n7 - n11);
                    n14 = Math.min(n13 - n7, n12 - n7);
                    graphics.fillRect(0, n15 - n14, n5, n14);
                    n7 += n14;
                }
            } else {
                n7 = n13;
            }
            n8 = (n8 + 1) % nArray.length;
        }
        graphics.translate(-n, -n2);
    }

    Color getFocusColor(SynthContext synthContext, int n) {
        return ((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, ColorType.FOREGROUND);
    }

    public void paintHandle(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        this.paintBox(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        graphics.translate(n3, n4);
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Color color = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.LIGHT);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK);
        if (string == "paned") {
            int n8;
            int n9;
            JSplitPane jSplitPane = (JSplitPane)jComponent;
            int n10 = 33;
            if (n7 == 0) {
                n9 = n5 / 2 - n10 / 2;
                n8 = jSplitPane.getDividerSize() / 2 - 1;
            } else {
                n9 = jSplitPane.getDividerSize() / 2 - 1;
                n8 = n6 / 2 - n10 / 2;
            }
            int n11 = 0;
            while (n11 < 7) {
                if (n7 == 0) {
                    n9 += 5;
                } else {
                    n8 += 5;
                }
                graphics.setColor(color);
                graphics.fillRect(n9, n8, 2, 2);
                graphics.setColor(color3);
                graphics.fillRect(n9 + 1, n8 + 1, 2, 2);
                graphics.setColor(color2);
                graphics.fillRect(n9 + 1, n8 + 1, 1, 1);
                ++n11;
            }
        } else if (string == "handlebox") {
            JToolBar jToolBar = (JToolBar)jComponent;
            int n12 = 2;
            int n13 = 2;
            if (jToolBar.getOrientation() == 0) {
                while (n13 < n6) {
                    graphics.setColor(color2);
                    graphics.fillRect(n12 + 1, n13 + 1, 2, 2);
                    graphics.fillRect(n12 + 4, n13 + 2, 2, 2);
                    graphics.setColor(color);
                    graphics.fillRect(n12, n13, 2, 2);
                    graphics.fillRect(n12 + 3, n13 + 1, 2, 2);
                    n13 += 3;
                }
            } else {
                boolean bl = true;
                while (n12 < n5) {
                    graphics.setColor(color2);
                    graphics.fillRect(n12 + 1, n13 + 1, 2, 2);
                    graphics.fillRect(n12 + 1, n13 + 4, 2, 2);
                    graphics.setColor(color);
                    graphics.fillRect(n12, n13, 2, 2);
                    graphics.fillRect(n12, n13 + 3, 2, 2);
                    n12 += 3;
                    if (bl) {
                        ++n13;
                        bl = false;
                        continue;
                    }
                    --n13;
                    bl = true;
                }
            }
            this.paintShadow(synthContext, graphics, n, n2, string, 0, 0, n5, n6);
        }
        graphics.translate(-n3, -n4);
    }

    public void paintOption(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        graphics.translate(n3, n4);
        int n7 = synthContext.getComponentState();
        int n8 = n6 / 2 - 1;
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if ((n7 & 4) == 0) {
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.WHITE));
        } else {
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.MID));
        }
        if (region != Region.RADIO_BUTTON_MENU_ITEM) {
            graphics.fillOval(1, 0, 11, 11);
            graphics.drawLine(13, n8 - 1, 13, n8 + 2);
            graphics.drawLine(12, n8 + 3, 12, n8 + 4);
            graphics.drawLine(11, n8 + 5, 11, n8 + 5);
            graphics.drawLine(9, n8 + 6, 10, n8 + 6);
            graphics.drawLine(5, n8 + 7, 8, n8 + 7);
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK));
            graphics.drawOval(1, 0, 11, 11);
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK));
            graphics.drawLine(5, n8 - 4, 8, n8 - 4);
            graphics.drawLine(9, n8 - 4, 10, n8 - 3);
            graphics.drawLine(3, n8 - 3, 4, n8 - 3);
            graphics.drawLine(3, n8 - 2, 2, n8 - 1);
            graphics.drawLine(2, n8, 2, n8 + 2);
            graphics.drawLine(2, n8 + 3, 3, n8 + 4);
        }
        if ((n7 & 0x200) != 0) {
            if (region == Region.RADIO_BUTTON_MENU_ITEM) {
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK));
            }
            graphics.fillRect(5, n8, 5, 3);
            graphics.drawLine(6, n8 - 1, 8, n8 - 1);
            graphics.drawLine(6, n8 + 3, 8, n8 + 3);
        }
        graphics.translate(-n3, -n4);
    }

    public void paintShadow(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (string == "buttondefault") {
            graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.BLACK));
            graphics.drawRect(n3, n4, n5 - 1, n6 - 1);
            return;
        }
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        int n7 = gTKStyle.getXThickness();
        int n8 = gTKStyle.getYThickness();
        if (string == "trough" || string == "spinbutton" && jComponent instanceof JButton) {
            n8 = 1;
            n7 = 1;
        }
        if (n7 < 0 && n8 < 0) {
            return;
        }
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        switch (n2) {
            case 0: {
                if (string == "spinbutton" && jComponent instanceof JButton) {
                    color4 = color = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK);
                    color3 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK);
                    break;
                }
                color = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK);
                color2 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK);
                color3 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.LIGHT);
                color4 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BACKGROUND);
                break;
            }
            case 1: {
                color = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.LIGHT);
                color2 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BACKGROUND);
                color3 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.BLACK);
                color4 = gTKStyle.getGTKColor(jComponent, region, n, GTKColorType.DARK);
                break;
            }
        }
        if (string == "spinbutton" && jComponent instanceof JButton) {
            this._paintSpinButtonShadow(graphics, n3, n4, n5, n6, n7, n8, color, color2, color3, color4);
        } else {
            this._paintShadow(graphics, n3, n4, n5, n6, n7, n8, color, color2, color3, color4);
        }
    }

    void _paintShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n, n2);
        graphics.setColor(color);
        if (n5 > 0) {
            graphics.drawLine(0, 0, 0, n4 - 1);
        }
        if (n6 > 0) {
            graphics.drawLine(1, 0, n3 - 1, 0);
        }
        if (n5 > 1 || n6 > 1) {
            graphics.setColor(color2);
            if (n5 > 1) {
                graphics.drawLine(1, 1, 1, n4 - 2);
            }
            if (n6 > 1) {
                graphics.drawLine(2, 1, n3 - 2, 1);
            }
        }
        graphics.setColor(color3);
        if (n5 > 0) {
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
        }
        if (n6 > 0) {
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
        }
        if (n5 > 1 || n6 > 1) {
            graphics.setColor(color4);
            if (n5 > 1) {
                graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 2);
            }
            if (n6 > 1) {
                graphics.drawLine(2, n4 - 2, n3 - 3, n4 - 2);
            }
        }
        graphics.translate(-n, -n2);
    }

    void _paintSpinButtonShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.setColor(color4);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.setColor(color3);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    public void paintExpander(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (n2 == 0) {
            if (n != 2) {
                this.paintHollowTriangle(synthContext, graphics, n, n3, n4, Math.min(n5, n6), GTKEngine.adjustAxisForComponentOrientation(synthContext.getComponent(), 3));
            }
        } else if (n != 2) {
            this.paintHollowTriangle(synthContext, graphics, n, n3, n4, Math.min(n5, n6), 5);
        }
    }

    private void paintHollowTriangle(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n4 / 2;
        int n7 = n4 / 2 + 1;
        int n8 = Math.max(1, n4 / 7);
        graphics.translate(n2, n3);
        Color color = gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.FOREGROUND);
        Color color2 = gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.BACKGROUND);
        switch (n5) {
            case 1: {
                int n9 = n4 / 2 + n7 / 2 - 1;
                graphics.setColor(color2);
                int n10 = n7 - 1;
                while (n10 > 0) {
                    graphics.drawLine(n6 - n10 + 1, n9, n6 + n10 - 1, n9);
                    --n9;
                    --n10;
                }
                graphics.setColor(color);
                n9 = n4 / 2 + n7 / 2 - 1;
                int n11 = n8 - 1;
                int n12 = 0;
                while (n12 < n8) {
                    graphics.drawLine(0 - n11, n9 - n12, n4 + n11, n9 - n12);
                    --n11;
                    ++n12;
                }
                --n9;
                n10 = n7 - 1;
                while (n10 > 0) {
                    n12 = 0;
                    while (n12 < n8) {
                        graphics.drawLine(n6 - n10 + 1 - n12, n9, n6 - n10 + 1 - n12, n9);
                        graphics.drawLine(n6 + n10 - 1 + n12, n9, n6 + n10 - 1 + n12, n9);
                        ++n12;
                    }
                    --n9;
                    --n10;
                }
                if (n8 <= 1) break;
                n12 = n8 - 2;
                while (n12 >= 0) {
                    graphics.drawLine(n6 - n12, n9, n6 + n12, n9);
                    --n9;
                    --n12;
                }
                break;
            }
            case 5: {
                int n13 = n4 / 2 - n7 / 2 - 1;
                graphics.setColor(color2);
                int n14 = n7 - 1;
                while (n14 > 0) {
                    graphics.drawLine(n6 - n14 + 1, n13, n6 + n14 - 1, n13);
                    ++n13;
                    --n14;
                }
                graphics.setColor(color);
                n13 = n4 / 2 - n7 / 2 - 1;
                int n15 = n8 - 1;
                int n16 = 0;
                while (n16 < n8) {
                    graphics.drawLine(0 - n15, n13 + n16, n4 + n15, n13 + n16);
                    --n15;
                    ++n16;
                }
                ++n13;
                n14 = n7 - 1;
                while (n14 > 0) {
                    n16 = 0;
                    while (n16 < n8) {
                        graphics.drawLine(n6 - n14 + 1 - n16, n13, n6 - n14 + 1 - n16, n13);
                        graphics.drawLine(n6 + n14 - 1 + n16, n13, n6 + n14 - 1 + n16, n13);
                        ++n16;
                    }
                    ++n13;
                    --n14;
                }
                if (n8 <= 1) break;
                n16 = n8 - 2;
                while (n16 >= 0) {
                    graphics.drawLine(n6 - n16, n13, n6 + n16, n13);
                    ++n13;
                    --n16;
                }
                break;
            }
            case 7: {
                int n17 = n4 / 2 + n7 / 2 - 1;
                graphics.setColor(color2);
                int n18 = n7 - 1;
                while (n18 > 0) {
                    graphics.drawLine(n17, n6 - n18 + 1, n17, n6 + n18 - 1);
                    --n17;
                    --n18;
                }
                graphics.setColor(color);
                n17 = n4 / 2 + n7 / 2 - 1;
                int n19 = n8 - 1;
                int n20 = 0;
                while (n20 < n8) {
                    graphics.drawLine(n17 - n20, 0 - n19, n17 - n20, n4 + n19);
                    --n19;
                    ++n20;
                }
                --n17;
                n18 = n7 - 1;
                while (n18 > 0) {
                    n20 = 0;
                    while (n20 < n8) {
                        graphics.drawLine(n17, n6 - n18 + 1 - n20, n17, n6 - n18 + 1 - n20);
                        graphics.drawLine(n17, n6 + n18 - 1 + n20, n17, n6 + n18 - 1 + n20);
                        ++n20;
                    }
                    --n17;
                    --n18;
                }
                if (n8 <= 1) break;
                n20 = n8 - 2;
                while (n20 >= 0) {
                    graphics.drawLine(n17, n6 - n20, n17, n6 + n20);
                    --n17;
                    --n20;
                }
                break;
            }
            case 3: {
                int n21 = n4 / 2 - n7 / 2 - 1;
                graphics.setColor(color2);
                int n22 = n7 - 1;
                while (n22 > 0) {
                    graphics.drawLine(n21, n6 - n22 + 1, n21, n6 + n22 - 1);
                    ++n21;
                    --n22;
                }
                graphics.setColor(color);
                n21 = n4 / 2 - n7 / 2 - 1;
                int n23 = n8 - 1;
                int n24 = 0;
                while (n24 < n8) {
                    graphics.drawLine(n21 + n24, 0 - n23, n21 + n24, n4 + n23);
                    --n23;
                    ++n24;
                }
                ++n21;
                n22 = n7 - 1;
                while (n22 > 0) {
                    n24 = 0;
                    while (n24 < n8) {
                        graphics.drawLine(n21, n6 - n22 + 1 - n24, n21, n6 - n22 + 1 - n24);
                        graphics.drawLine(n21, n6 + n22 - 1 + n24, n21, n6 + n22 - 1 + n24);
                        ++n24;
                    }
                    ++n21;
                    --n22;
                }
                if (n8 <= 1) break;
                n24 = n8 - 2;
                while (n24 >= 0) {
                    graphics.drawLine(n21, n6 - n24, n21, n6 + n24);
                    ++n21;
                    --n24;
                }
                break;
            }
        }
        graphics.translate(-n2, -n3);
    }

    public void paintSlider(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        this.paintBox(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        if (synthContext.getRegion() == Region.SLIDER_THUMB) {
            if (n7 == 0) {
                this.paintVline(synthContext, graphics, n, string, n3 + n5 / 2 - 1, n4 + 2, 2, n6 - 4);
            } else {
                this.paintHline(synthContext, graphics, n, string, n3 + 2, n4 + n6 / 2 - 1, n5 - 4, 2);
            }
        }
    }

    public void paintHline(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n5 / 2;
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.DARK));
        graphics.drawLine(0, n6, n4 - 2, n6);
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.LIGHT));
        graphics.drawLine(0, n6 + 1, n4 - 1, n6 + 1);
        graphics.drawLine(n4 - 1, n6, n4 - 1, n6 + 1);
        graphics.translate(-n2, -n3);
    }

    public void paintVline(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n4 / 2;
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.DARK));
        graphics.drawLine(n6, 0, n6, n5 - 2);
        graphics.drawLine(n6, 0, n6 + 1, 0);
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n, GTKColorType.LIGHT));
        graphics.drawLine(n6 + 1, 1, n6 + 1, n5 - 1);
        graphics.drawLine(n6, n5 - 1, n6 + 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (gTKStyle.fillBackground(synthContext, n)) {
            graphics.setColor(color);
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            int n6;
            int n7;
            Image image = gTKStyle.getBackgroundImage(synthContext, n);
            if (image != null && (n7 = image.getWidth(null)) > 0 && (n6 = image.getHeight(null)) > 0) {
                Serializable serializable;
                int n8 = n2;
                int n9 = n3;
                Container container = synthContext.getComponent().getParent();
                while (container != null && !(container instanceof Window) && !(container instanceof Applet)) {
                    serializable = container.getParent();
                    if (container instanceof JRootPane && !(serializable instanceof Window) && !(serializable instanceof Applet)) {
                        n8 += container.getX();
                        n9 += container.getY();
                    }
                    container = serializable;
                }
                n8 %= n7;
                n9 %= n6;
                serializable = graphics.getClipRect();
                int n10 = ((Rectangle)serializable).x;
                int n11 = ((Rectangle)serializable).y;
                int n12 = n10 + ((Rectangle)serializable).width;
                int n13 = n11 + ((Rectangle)serializable).height;
                int n14 = n9;
                int n15 = n3;
                int n16 = n3 + n5;
                while (n15 < n16) {
                    int n17 = n8;
                    int n18 = n2;
                    int n19 = n2 + n4;
                    while (n18 < n19) {
                        int n20 = Math.min(n19, n18 + n7 - n17);
                        int n21 = Math.min(n16, n15 + n6 - n14);
                        if (n20 > n10 && n21 > n11 && n12 > n18 && n13 > n15) {
                            graphics.drawImage(image, n18, n15, n20, n21, n17, n14, n17 + n20 - n18, n14 + n21 - n15, null);
                        }
                        n18 += n7 - n17;
                        n17 = 0;
                    }
                    n15 += n6 - n14;
                    n14 = 0;
                }
            }
        }
    }
}

