/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.Metacity;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.TabContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

class GTKPainter
extends SynthPainter {
    static final GTKPainter INSTANCE = new GTKPainter();
    static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets TEMP_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets BUTTON_DEFAULT_BORDER_INSETS = new Insets(1, 1, 1, 1);

    GTKPainter() {
    }

    public void paint(SynthContext synthContext, Object object, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        String string = region.isSubregion() ? null : synthContext.getComponent().getName();
        GTKEngine gTKEngine = ((GTKStyle)synthContext.getStyle()).getEngine(synthContext);
        if (object == "background") {
            Insets insets;
            Border border;
            if (!region.isSubregion() && (border = synthContext.getComponent().getBorder()) != null && !(border instanceof UIResource) && (insets = synthContext.getComponent().getInsets(TEMP_INSETS)) != null) {
                n += insets.left;
                n2 += insets.right;
                n3 -= insets.left + insets.right;
                n4 -= insets.top + insets.bottom;
            }
            if (region == Region.ARROW_BUTTON) {
                this.paintArrowButtonBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.BUTTON) {
                if (string != null && string.startsWith("InternalFrameTitlePane.")) {
                    Metacity.INSTANCE.paintButtonBackground(synthContext, graphics, n, n2, n3, n4);
                } else {
                    this.paintButtonBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4, "button");
                }
            } else if (region == Region.FORMATTED_TEXT_FIELD) {
                this.paintTextFieldBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.LABEL) {
                if ("TableHeader.renderer" == string || string == "GTKFileChooser.directoryListLabel" || string == "GTKFileChooser.fileListLabel") {
                    this.paintButtonBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4, "button");
                } else if (string == "ComboBox.renderer") {
                    this.paintTextFieldBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
                }
            } else if (region == Region.LIST) {
                this.paintListBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.MENU) {
                this.paintMenuBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.MENU_BAR) {
                this.paintMenuBarBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.MENU_ITEM) {
                this.paintMenuItemBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.POPUP_MENU) {
                this.paintPopupMenuBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.PROGRESS_BAR) {
                this.paintProgressBarBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
                this.paintCheckButtonBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.CHECK_BOX_MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM) {
                this.paintCheckButtonMenuItemBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.ROOT_PANE) {
                this.paintRootPaneBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.SCROLL_BAR) {
                this.paintScrollBarBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.SCROLL_BAR_THUMB) {
                this.paintScrollBarThumbBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.SEPARATOR) {
                this.paintSeparatorBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.SLIDER_TRACK) {
                this.paintSliderTrackBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.SLIDER_THUMB) {
                this.paintSliderThumbBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.SPINNER) {
                this.paintSpinnerBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.SPLIT_PANE_DIVIDER) {
                this.paintSplitPaneDividerBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TABBED_PANE_CONTENT) {
                this.paintTabbedPaneContentBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TABBED_PANE_TAB) {
                this.paintTabbedPaneTabBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TEXT_AREA) {
                this.paintTextAreaBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TEXT_FIELD) {
                if (string == "Tree.cellEditor") {
                    this.paintTreeCellEditorBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
                } else {
                    this.paintTextFieldBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
                }
            } else if (region == Region.TOGGLE_BUTTON) {
                this.paintToggleButtonBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TOOL_BAR || region == Region.TOOL_BAR_DRAG_WINDOW) {
                this.paintToolBarBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TOOL_BAR_CONTENT) {
                this.paintToolBarContentBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TOOL_TIP) {
                this.paintToolTipBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TREE) {
                this.paintTreeBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.TREE_CELL) {
                this.paintTreeCellBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.VIEWPORT) {
                this.paintViewportBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            }
        } else if (object == "border") {
            if (region == Region.INTERNAL_FRAME || region == Region.DESKTOP_ICON) {
                Metacity.INSTANCE.paintFrameBorder(synthContext, graphics, n, n2, n3, n4);
            } else if (region == Region.VIEWPORT) {
                this.paintScrollPaneBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            }
        } else if (object == "foreground") {
            if (region == Region.ARROW_BUTTON) {
                this.paintArrowButtonForeground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.PROGRESS_BAR) {
                this.paintProgressBarForeground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            } else if (region == Region.SPLIT_PANE_DIVIDER) {
                this.paintSplitPaneDividerDragBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
            }
        } else if (object == "focus" && region == Region.TREE_CELL) {
            this.paintTreeCellFocus(synthContext, gTKEngine, graphics, n, n2, n3, n4);
        }
    }

    Insets getInsets(SynthContext synthContext, Insets insets) {
        String string;
        Region region = synthContext.getRegion();
        String string2 = string = region.isSubregion() ? null : synthContext.getComponent().getName();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.top = 0;
        }
        if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON || region == Region.CHECK_BOX || region == Region.RADIO_BUTTON || region == Region.ARROW_BUTTON || region == Region.TOGGLE_BUTTON || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM) {
            if ("Spinner.previousButton" == string || "Spinner.nextButton" == string) {
                return this.getSpinnerButtonInsets(synthContext, insets);
            }
            return this.getButtonInsets(synthContext, insets);
        }
        if (region == Region.FORMATTED_TEXT_FIELD) {
            return this.getTextFieldInsets(synthContext, insets);
        }
        if (region == Region.INTERNAL_FRAME) {
            insets = Metacity.INSTANCE.getBorderInsets(synthContext, insets);
        } else if (region == Region.LABEL) {
            if ("TableHeader.renderer" == string) {
                return this.getButtonInsets(synthContext, insets);
            }
            if ("ComboBox.renderer" == string) {
                return this.getTextFieldInsets(synthContext, insets);
            }
            if ("Tree.cellRenderer" == string) {
                return this.getTreeCellRendererInsets(synthContext, insets);
            }
        } else {
            if (region == Region.MENU_BAR) {
                return this.getMenuBarInsets(synthContext, insets);
            }
            if (region == Region.OPTION_PANE) {
                return this.getOptionPaneInsets(synthContext, insets);
            }
            if (region == Region.POPUP_MENU) {
                return this.getPopupMenuInsets(synthContext, insets);
            }
            if (region == Region.PROGRESS_BAR) {
                return this.getProgressBarInsets(synthContext, insets);
            }
            if (region == Region.SCROLL_BAR) {
                return this.getScrollBarInsets(synthContext, insets);
            }
            if (region == Region.SEPARATOR) {
                return this.getSeparatorInsets(synthContext, insets);
            }
            if (region == Region.SLIDER) {
                return this.getSliderInsets(synthContext, insets);
            }
            if (region == Region.SLIDER_TRACK) {
                return this.getSliderTrackInsets(synthContext, insets);
            }
            if (region == Region.SPINNER) {
                return this.getSpinnerInsets(synthContext, insets);
            }
            if (region == Region.TABBED_PANE) {
                return this.getTabbedPaneInsets(synthContext, insets);
            }
            if (region == Region.TABBED_PANE_CONTENT) {
                return this.getTabbedPaneContentInsets(synthContext, insets);
            }
            if (region == Region.TABBED_PANE_TAB) {
                return this.getTabbedPaneTabInsets(synthContext, insets);
            }
            if (region == Region.TEXT_FIELD) {
                if (string == "Tree.cellEditor") {
                    return this.getTreeCellEditorInsets(synthContext, insets);
                }
                return this.getTextFieldInsets(synthContext, insets);
            }
            if (region == Region.TOOL_BAR) {
                return this.getToolBarInsets(synthContext, insets);
            }
            if (region == Region.TOOL_TIP) {
                return this.getToolTipInsets(synthContext, insets);
            }
        }
        return insets;
    }

    private Insets getButtonInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n3 = gTKStyle.getXThickness();
        int n4 = gTKStyle.getYThickness();
        int n5 = n + n2 + n3;
        int n6 = n + n2 + n4;
        JComponent jComponent = synthContext.getComponent();
        insets.left = insets.right = n5;
        insets.top = insets.bottom = n6;
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultCapable()) {
            Insets insets2 = gTKStyle.getClassSpecificInsetsValue(synthContext, "default-border", BUTTON_DEFAULT_BORDER_INSETS);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    private void paintButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4, String string) {
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n7 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n9 = n7 + n8;
        int n10 = gTKStyle.getXThickness();
        int n11 = gTKStyle.getYThickness();
        JComponent jComponent = synthContext.getComponent();
        boolean bl2 = true;
        boolean bl3 = true;
        if (jComponent instanceof AbstractButton) {
            bl2 = ((AbstractButton)jComponent).isFocusPainted();
            bl3 = ((AbstractButton)jComponent).isBorderPainted();
        }
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultCapable()) {
            Insets insets = gTKStyle.getClassSpecificInsetsValue(synthContext, "default-border", BUTTON_DEFAULT_BORDER_INSETS);
            if ((n5 & 0x400) == 1024 && bl3) {
                gTKEngine.paintBox(synthContext, graphics, 1, 0, "buttondefault", n, n2, n3, n4);
            }
            n += insets.left;
            n2 += insets.top;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
        }
        if (!bl && (n5 & 0x100) == 256) {
            n += n9;
            n2 += n9;
            n3 -= 2 * n9;
            n4 -= 2 * n9;
        }
        if (!(jComponent.getParent() instanceof JToolBar) || n6 != 1) {
            int n12 = (n5 & 4) == 4 ? 0 : 1;
            if (bl3) {
                gTKEngine.paintBox(synthContext, graphics, n6, n12, string, n, n2, n3, n4);
            }
        }
        if ((n5 & 0x100) == 256) {
            if (bl) {
                n += n10 + n8;
                n2 += n11 + n8;
                n3 -= 2 * (n10 + n8);
                n4 -= 2 * (n11 + n8);
            } else {
                n -= n9;
                n2 -= n9;
                n3 += 2 * n9;
                n4 += 2 * n9;
            }
            if (bl2) {
                gTKEngine.paintFocus(synthContext, graphics, n6, string, n, n2, n3, n4);
            }
        }
    }

    private void paintArrowButtonForeground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(Region.ARROW_BUTTON, synthContext.getComponentState());
        int n6 = n5 == 4 ? 1 : 0;
        int n7 = ((SynthArrowButton)synthContext.getComponent()).getDirection();
        switch (n7) {
            case 1: {
                n7 = 100;
                break;
            }
            case 5: {
                n7 = 101;
                break;
            }
            case 3: {
                n7 = 103;
                break;
            }
            case 7: {
                n7 = 102;
            }
        }
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        String string2 = "arrow";
        if (string == "ScrollBar.button" && jComponent.getParent() instanceof JScrollBar) {
            string2 = ((JScrollBar)jComponent.getParent()).getOrientation() == 0 ? "hscrollbar" : "vscrollbar";
        }
        int n8 = Math.min(n3 / 2, n4 / 2);
        gTKEngine.paintArrow(synthContext, graphics, n5, n6, n7, string2, n += (n3 - n8) / 2, n2 += (n4 - n8) / 2, n8, n8);
    }

    private void paintArrowButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        String string2 = "button";
        if (string == "ScrollBar.button") {
            if (jComponent.getParent() instanceof JScrollBar) {
                string2 = ((JScrollBar)jComponent.getParent()).getOrientation() == 0 ? "hscrollbar" : "vscrollbar";
            }
        } else if ("Spinner.previousButton" == string || "Spinner.nextButton" == string) {
            string2 = "spinbutton";
        }
        this.paintButtonBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4, string2);
    }

    private void paintCheckButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((n5 & 2) != 0) {
            gTKEngine.paintFlatBoxNormal(synthContext, graphics, 2, "checkbutton", n, n2, n3, n4);
        }
    }

    public void paintCheckButtonMenuItemBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((synthContext.getComponentState() & 2) != 0) {
            gTKEngine.paintBox(synthContext, graphics, n5, 1, "menuitem", n, n2, n3, n4);
        }
    }

    private void paintListBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(Region.LIST, synthContext.getComponentState());
        if (synthContext.getComponent().getName() == "ComboBox.list") {
            // empty if block
        }
        gTKEngine.paintFlatBoxText(synthContext, graphics, n5, "base", n, n2, n3, n4);
    }

    private Insets getMenuBarInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n = gTKStyle.getClassSpecificIntValue(synthContext, "internal-padding", 1);
        int n2 = gTKStyle.getXThickness();
        int n3 = gTKStyle.getYThickness();
        insets.top = insets.bottom = n + n3;
        insets.left = insets.right = n + n2;
        return insets;
    }

    private void paintMenuBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = gTKStyle.getClassSpecificIntValue(synthContext, "shadow-type", 1);
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintBox(synthContext, graphics, n6, n5, "menubar", n, n2, n3, n4);
    }

    private void paintMenuBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if (n5 == 2) {
            gTKEngine.paintBox(synthContext, graphics, n5, 1, "menuitem", n, n2, n3, n4);
        }
    }

    private Insets getMenuItemInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n = gTKStyle.getClassSpecificIntValue(synthContext, "internal-padding", 1);
        int n2 = gTKStyle.getXThickness();
        int n3 = gTKStyle.getYThickness();
        insets.top = insets.bottom = n + n3;
        insets.left = insets.right = n + n2;
        return insets;
    }

    private void paintMenuItemBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((synthContext.getComponentState() & 2) != 0) {
            gTKEngine.paintBox(synthContext, graphics, n5, 1, "menuitem", n, n2, n3, n4);
        }
    }

    private Insets getPopupMenuInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 2;
        insets.top = 2;
        insets.right = 2;
        insets.left = 2;
        return insets;
    }

    private void paintPopupMenuBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintBox(synthContext, graphics, n5, 1, "menu", n, n2, n3, n4);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = gTKStyle.getXThickness();
        int n7 = gTKStyle.getYThickness();
        gTKEngine.paintBackground(synthContext, graphics, n5, gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n5, GTKColorType.BACKGROUND), n + n6, n2 + n7, n3 - n6 - n6, n4 - n7 - n7);
    }

    private Insets getProgressBarInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.left = insets.right = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    private void paintProgressBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        gTKEngine.paintBox(synthContext, graphics, 1, 0, "trough", n, n2, n3 -= gTKStyle.getXThickness(), n4 -= gTKStyle.getYThickness());
    }

    private void paintProgressBarForeground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        if (n3 != 0 || n4 != 0) {
            gTKEngine.paintBox(synthContext, graphics, 1, 1, "bar", n, n2, n3, n4);
        }
    }

    private void paintScrollPaneBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        gTKEngine.paintShadow(synthContext, graphics, 1, 0, "scrolled_window", n, n2, n3, n4);
    }

    Insets getScrollPaneInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.right = insets.left = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    private Insets getSeparatorInsets(SynthContext synthContext, Insets insets) {
        return insets;
    }

    private void paintSeparatorBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        if (((JSeparator)synthContext.getComponent()).getOrientation() == 0) {
            gTKEngine.paintHline(synthContext, graphics, 1, "hseparator", n, n2, n3, n4);
        } else {
            gTKEngine.paintVline(synthContext, graphics, 1, "vseparator", n, n2, n3, n4);
        }
    }

    private Insets getSliderInsets(SynthContext synthContext, Insets insets) {
        int n;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n = gTKStyle.getYThickness());
        insets.right = insets.left = n2;
        return insets;
    }

    private Insets getSliderTrackInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        insets.left = insets.right = n + n2;
        insets.bottom = insets.right;
        insets.top = insets.right;
        return insets;
    }

    private void paintSliderTrackBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        gTKEngine.paintBox(synthContext, graphics, n6, 0, "trough", n, n2, n3, n4);
        if ((n5 & 0x100) == 256) {
            int n7 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            gTKEngine.paintFocus(synthContext, graphics, 1, "trough", n -= (n7 += gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1)), n2 -= n7, n3 += 2 * n7, n4 += 2 * n7);
        }
    }

    private void paintSliderThumbBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = ((JSlider)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1;
        gTKEngine.paintSlider(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "slider", n, n2, n3, n4, n5);
    }

    private void paintSpinnerBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintBox(synthContext, graphics, n5, 0, "spinbutton", n, n2, n3, n4);
    }

    private Insets getSpinnerInsets(SynthContext synthContext, Insets insets) {
        int n;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n = gTKStyle.getYThickness());
        insets.right = 1;
        insets.left = n2;
        return insets;
    }

    private Insets getSpinnerButtonInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.left = 1;
        insets.right = 1;
        return insets;
    }

    private void paintSplitPaneDividerBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = ((JSplitPane)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1;
        gTKEngine.paintHandle(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), -100, "paned", n, n2, n3, n4, n5);
    }

    private void paintSplitPaneDividerDragBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(synthContext.getStyle().getColor(synthContext, GTKColorType.BACKGROUND));
        graphics.fillRect(n, n2, n3, n4);
        this.paintSplitPaneDividerBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
    }

    private Insets getTabbedPaneInsets(SynthContext synthContext, Insets insets) {
        int n;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n = gTKStyle.getYThickness());
        insets.right = insets.left = n2;
        return insets;
    }

    private Insets getTabbedPaneContentInsets(SynthContext synthContext, Insets insets) {
        int n;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n = gTKStyle.getYThickness());
        insets.right = insets.left = n2;
        return insets;
    }

    private void paintTabbedPaneContentBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Region region = synthContext.getRegion();
        int n5 = GTKLookAndFeel.SwingOrientationConstantToGTK(jTabbedPane.getTabPlacement());
        int n6 = 0;
        int n7 = 0;
        int n8 = jTabbedPane.getSelectedIndex();
        if (n8 != -1) {
            Rectangle rectangle = jTabbedPane.getBoundsAt(n8);
            if (n5 == 2 || n5 == 3) {
                n6 = rectangle.x - 1;
                n7 = rectangle.width;
            } else {
                n6 = rectangle.y - 1;
                n7 = rectangle.height;
            }
        }
        gTKEngine.paintBoxGap(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "notebook", n, n2, n3, n4, n5, n6, n7);
    }

    private Insets getTabbedPaneTabInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n = gTKStyle.getXThickness();
        int n2 = gTKStyle.getYThickness();
        int n3 = 0;
        int n4 = 2;
        n3 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        insets.left = insets.right = n3 + n4 + n;
        insets.top = insets.bottom = n3 + n4 + n2;
        return insets;
    }

    private void paintTabbedPaneTabBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = ((TabContext)synthContext).getTabIndex();
        int n8 = ((JTabbedPane)synthContext.getComponent()).getSelectedIndex();
        int n9 = n8 == n7 ? 0 : 2;
        n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        switch (((JTabbedPane)synthContext.getComponent()).getTabPlacement()) {
            case 1: {
                n5 = 3;
                n2 += n9;
                n4 -= n9;
                break;
            }
            case 3: {
                n4 -= n9;
                n5 = 2;
                break;
            }
            case 2: {
                n += n9;
                n3 -= n9;
                n5 = 1;
                break;
            }
            default: {
                n3 -= n9;
                n5 = 0;
            }
        }
        gTKEngine.paintExtension(synthContext, graphics, n6, 1, "tab", n, n2, n3, n4, n5);
    }

    private void paintTextAreaBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = synthContext.getComponentState();
        gTKEngine.paintFlatBoxText(synthContext, graphics, n5, "base", n, n2, n3, n4);
    }

    private void paintTextFieldBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n9 = gTKStyle.getXThickness();
        int n10 = gTKStyle.getYThickness();
        this.paintTextBackground(synthContext, gTKEngine, graphics, n, n2, n3, n4);
        boolean bl2 = false;
        if (synthContext.getComponent().getName() == "ComboBox.renderer") {
            Container container = synthContext.getComponent().getParent();
            while (container != null) {
                if (container instanceof JComboBox && container.hasFocus()) {
                    bl2 = true;
                }
                container = container.getParent();
            }
        }
        if (!bl && ((n6 & 0x100) == 256 || bl2)) {
            n5 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            n += n5;
            n2 += n5;
            n3 -= 2 * n5;
            n4 -= 2 * n5;
        } else {
            n5 = 0;
        }
        gTKEngine.paintFlatBoxText(synthContext, graphics, 1, "entry_bg", n + n9, n2 + n10, n3 - 2 * n9, n4 - 2 * n10);
        if (synthContext.getComponent().getName() != "Spinner.formattedTextField") {
            gTKEngine.paintShadow(synthContext, graphics, 1, 0, "entry", n, n2, n3, n4);
        }
        if (n5 > 0) {
            gTKEngine.paintFocus(synthContext, graphics, n7, "entry", n -= n5, n2 -= n5, n3 += 2 * n5, n4 += 2 * n5);
        } else if (bl2 && bl) {
            gTKEngine.paintFocus(synthContext, graphics, n7, "entry", n += n9 + n8, n2 += n10 + n8, n3 -= 2 * (n9 + n8), n4 -= 2 * (n10 + n8));
        }
    }

    private Insets getTextFieldInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n = gTKStyle.getXThickness();
        int n2 = gTKStyle.getYThickness();
        boolean bl = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n3 = 0;
        int n4 = 2;
        if (!bl) {
            n3 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        }
        insets.left = insets.right = n3 + n4 + n;
        insets.top = insets.bottom = n3 + n4 + n2;
        return insets;
    }

    private void paintTextBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.isOpaque() && jComponent.getBackground() instanceof ColorUIResource) {
            graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), 1, GTKColorType.TEXT_BACKGROUND));
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    private Insets getOptionPaneInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 6;
        insets.top = 6;
        insets.right = 6;
        insets.left = 6;
        return insets;
    }

    public void paintToggleButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n7 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n9 = n7 + n8;
        int n10 = gTKStyle.getXThickness();
        int n11 = gTKStyle.getYThickness();
        JToggleButton jToggleButton = (JToggleButton)synthContext.getComponent();
        if (!bl && (n5 & 0x100) == 256) {
            n += n9;
            n2 += n9;
            n3 -= 2 * n9;
            n4 -= 2 * n9;
        }
        int n12 = 1;
        if (jToggleButton.isSelected() || (n5 & 4) != 0) {
            n12 = 0;
        }
        gTKEngine.paintBox(synthContext, graphics, n6, n12, "button", n, n2, n3, n4);
        if ((n5 & 0x100) == 256) {
            if (bl) {
                n += n10 + n8;
                n2 += n11 + n8;
                n3 -= 2 * (n10 + n8);
                n4 -= 2 * (n11 + n8);
            } else {
                n -= n9;
                n2 -= n9;
                n3 += 2 * n9;
                n4 += 2 * n9;
            }
            gTKEngine.paintFocus(synthContext, graphics, n6, "button", n, n2, n3, n4);
        }
    }

    public void paintRootPaneBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxNormal(synthContext, graphics, n5, "base", n, n2, n3, n4);
    }

    private void paintScrollBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        int n7 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n9 = n7 + n8;
        gTKEngine.paintBox(synthContext, graphics, 4, 0, "trough", n + n9, n2 + n9, n3 - 2 * n9, n4 - 2 * n9);
        if ((n5 & 0x100) == 256) {
            gTKEngine.paintFocus(synthContext, graphics, 1, "trough", n, n2, n3, n4);
        }
    }

    private Insets getScrollBarInsets(SynthContext synthContext, Insets insets) {
        int n;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (synthContext.getComponent().isFocusable()) {
            n = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
            int n3 = n + n2;
            int n4 = n + n2;
            insets.left = insets.right = n3;
            insets.top = insets.bottom = n4;
        }
        n = gTKStyle.getClassSpecificIntValue(synthContext, "trough-border", 1);
        insets.left += n;
        insets.right += n;
        insets.top += n;
        insets.bottom += n;
        return insets;
    }

    private void paintScrollBarThumbBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = ((JScrollBar)synthContext.getComponent()).getOrientation() == 1 ? 1 : 0;
        gTKEngine.paintSlider(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "slider", n, n2, n3, n4, n5);
    }

    private void paintToolBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n5, GTKColorType.BACKGROUND));
        gTKEngine.paintFlatBox(synthContext, graphics, n6, "handlebox_bin", n, n2, n3, n4);
    }

    private Insets getToolBarInsets(SynthContext synthContext, Insets insets) {
        int n;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n = gTKStyle.getYThickness());
        insets.right = insets.left = n2;
        return insets;
    }

    private void paintToolBarContentBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        gTKEngine.paintShadow(synthContext, graphics, 1, 1, "handlebox_bin", n, n2, n3, n4);
    }

    private void paintToolTipBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        gTKEngine.paintFlatBoxNormal(synthContext, graphics, 1, "tooltip", n, n2, n3, n4);
    }

    private Insets getToolTipInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.left = insets.right = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    private void paintTreeCellBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxText(synthContext, graphics, n5, "cell_odd", n, n2, n3, n4);
    }

    private void paintTreeCellFocus(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFocus(synthContext, graphics, n5, "treeview", n, n2, n3, n4);
    }

    private Insets getTreeCellRendererInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.right = 1;
        insets.left = 1;
        return insets;
    }

    private Insets getTreeCellEditorInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.right = 1;
        insets.left = 1;
        return insets;
    }

    private void paintTreeCellEditorBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxText(synthContext, graphics, n5, "entry_bg", n, n2, n3, n4);
    }

    private void paintTreeBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n5, GTKColorType.TEXT_BACKGROUND));
        graphics.fillRect(n, n2, n3, n4);
    }

    private void paintViewportBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n5, GTKColorType.TEXT_BACKGROUND));
        graphics.fillRect(n, n2, n3, n4);
    }

    static class ListTableFocusBorder
    extends AbstractBorder
    implements UIResource {
        ListTableFocusBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.BLACK);
            GTKEngine.INSTANCE._paintFocus(graphics, n, n2, n3, n4, GTKEngine.DEFAULT_FOCUS_PATTERN, 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return this.getBorderInsets(component);
            }
            insets.bottom = 1;
            insets.top = 1;
            insets.right = 1;
            insets.left = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

