/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;

class LazyActionMap
extends ActionMapUIResource {
    private transient Object _loader;
    private transient JComponent _component;
    static /* synthetic */ Class class$javax$swing$ActionMap;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$LazyActionMap;

    static void installLazyActionMap(JComponent jComponent, Loader loader) {
        SwingUtilities.replaceUIActionMap(jComponent, new LazyActionMap(loader, jComponent));
    }

    static void installLazyActionMap(JComponent jComponent, Class clazz, String string) {
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null) {
            actionMap = new LazyActionMap(clazz);
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        SwingUtilities.replaceUIActionMap(jComponent, actionMap);
    }

    static ActionMap getActionMap(Class clazz, String string) {
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null) {
            actionMap = new LazyActionMap(clazz);
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        return actionMap;
    }

    private LazyActionMap(Loader loader, JComponent jComponent) {
        this._loader = loader;
        this._component = jComponent;
    }

    private LazyActionMap(Class clazz) {
        this._loader = clazz;
    }

    public void put(Object object, Action action) {
        this.loadIfNecessary();
        super.put(object, action);
    }

    public Action get(Object object) {
        this.loadIfNecessary();
        return super.get(object);
    }

    public void remove(Object object) {
        this.loadIfNecessary();
        super.remove(object);
    }

    public void clear() {
        this.loadIfNecessary();
        super.clear();
    }

    public Object[] keys() {
        this.loadIfNecessary();
        return super.keys();
    }

    public int size() {
        this.loadIfNecessary();
        return super.size();
    }

    public Object[] allKeys() {
        this.loadIfNecessary();
        return super.allKeys();
    }

    private void loadIfNecessary() {
        if (this._loader != null) {
            block11: {
                Object object = this._loader;
                this._loader = null;
                if (object instanceof Loader) {
                    ((Loader)object).loadActionMap(this._component, this);
                } else {
                    Class clazz = (Class)object;
                    try {
                        Method method = clazz.getDeclaredMethod("loadActionMap", class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = LazyActionMap.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap);
                        method.invoke((Object)clazz, this);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("LazyActionMap unable to load actions " + clazz));
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("LazyActionMap unable to load actions " + illegalAccessException));
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("LazyActionMap unable to load actions " + invocationTargetException));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError((Object)("LazyActionMap unable to load actions " + illegalArgumentException));
                    }
                }
            }
            this._component = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$java$swing$plaf$gtk$LazyActionMap == null ? (class$com$sun$java$swing$plaf$gtk$LazyActionMap = LazyActionMap.class$("com.sun.java.swing.plaf.gtk.LazyActionMap")) : class$com$sun$java$swing$plaf$gtk$LazyActionMap).desiredAssertionStatus();
    }

    public static interface Loader {
        public void loadActionMap(JComponent var1, ActionMap var2);
    }
}

