/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.MetacityBluecurve;
import com.sun.java.swing.plaf.gtk.MetacityCrux;
import com.sun.java.swing.plaf.gtk.SynthConstants;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

abstract class Metacity
implements SynthConstants {
    static Metacity INSTANCE;
    private FrameGeometry geometry;
    private static LayoutManager titlePaneLayout;
    private ColorizeImageFilter imageFilter = new ColorizeImageFilter();
    protected String themeDir = null;
    protected SynthContext context;

    protected Metacity(String string, FrameGeometry frameGeometry) {
        this.themeDir = string;
        this.geometry = frameGeometry;
    }

    public static LayoutManager getTitlePaneLayout() {
        return titlePaneLayout;
    }

    abstract void paintButtonBackground(SynthContext var1, Graphics var2, int var3, int var4, int var5, int var6);

    abstract void paintFrameBorder(SynthContext var1, Graphics var2, int var3, int var4, int var5, int var6);

    abstract Insets getBorderInsets(SynthContext var1, Insets var2);

    private static String getThemeDir(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] stringArray = new String[]{"/usr/share/themes/" + string + "/metacity-1", "/usr/gnome/share/themes/" + string + "/metacity-1", "/opt/gnome2/share/themes/" + string + "/metacity-1"};
                int n = 0;
                while (n < stringArray.length) {
                    if (new File(stringArray[n], "metacity-theme-1.xml").canRead()) {
                        return stringArray[n];
                    }
                    ++n;
                }
                return null;
            }
        });
    }

    private static String getUserTheme() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    int n;
                    int n2;
                    String string = System.getProperty("swing.metacitythemename");
                    if (string != null) {
                        return string;
                    }
                    String string2 = System.getProperty("user.home");
                    URL uRL = new URL("file:" + string2 + "/.gconf/apps/metacity/general/%25gconf.xml");
                    InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), "ISO-8859-1");
                    char[] cArray = new char[1024];
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n2 = inputStreamReader.read(cArray)) >= 0) {
                        stringBuffer.append(cArray, 0, n2);
                    }
                    ((Reader)inputStreamReader).close();
                    String string3 = stringBuffer.toString();
                    if (string3 != null && (n = string3.toLowerCase().indexOf("<entry name=\"theme\"")) >= 0 && (n = string3.toLowerCase().indexOf("<stringvalue>", n)) > 0) {
                        int n3 = string3.indexOf("<", n += "<stringvalue>".length());
                        return string3.substring(n, n3);
                    }
                }
                catch (Exception exception) {}
                return null;
            }
        });
    }

    protected void tileImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, float[] fArray) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        int n7 = n2;
        while (n7 < n2 + n4) {
            n6 = Math.min(n6, n2 + n4 - n7);
            int n8 = n;
            while (n8 < n + n3) {
                float f = ((float)fArray.length - 1.0f) * (float)n8 / (float)(n + n3);
                int n9 = (int)f;
                f -= (float)((int)f);
                float f2 = (1.0f - f) * fArray[n9] + f * fArray[n9 + 1];
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                int n10 = Math.min(n5, n + n3 - n8);
                graphics.drawImage(image, n8, n7, n8 + n10, n7 + n6, 0, 0, n10, n6, null);
                n8 += n10;
            }
            n7 += n6;
        }
        graphics2D.setComposite(composite);
    }

    protected Color getColor(int n, ColorType colorType) {
        return ((GTKStyle)this.context.getStyle()).getGTKColor(this.context.getComponent(), this.context.getRegion(), n, colorType);
    }

    protected static Color shadeColor(Color color, float f) {
        return GTKColorType.adjustColor(color, 1.0f, f, f);
    }

    protected Color blendColor(Color color, Color color2, float f) {
        return new Color((int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f), (int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f), (int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f));
    }

    protected void tintRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, float f) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawVerticalGradient(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, float f) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setPaint(new GradientPaint(n, n2, color, n, n2 + n4, color2));
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawVerticalGradient(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(n, n2, color, n, n2 + n4, color2));
            graphics2D.fillRect(n, n2, n3, n4);
        }
    }

    protected void drawVerticalGradient(Graphics graphics, Color color, Color color2, Color color3, int n, int n2, int n3, int n4) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(n, n2, color, n, n2 + n4 / 2, color2));
            graphics2D.fillRect(n, n2, n3, n4 / 2);
            graphics2D.setPaint(new GradientPaint(n, n2 + n4 / 2, color2, n, n2 + n4, color3));
            graphics2D.fillRect(n, n2 + n4 / 2, n3, n4 / 2);
        }
    }

    protected void drawDiagonalGradient(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, float f) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setPaint(new GradientPaint(n, n2, color, n + n3, n2 + n4, color2));
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawDiagonalGradient(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(n, n2, color, n + n3, n2 + n4, color2));
            graphics2D.fillRect(n, n2, n3, n4);
        }
    }

    protected Image colorizeImage(Image image, Color color) {
        return this.imageFilter.colorize(image, color);
    }

    protected static JComponent findChild(JComponent jComponent, String string) {
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(n2);
            if (string.equals(jComponent2.getName())) {
                return jComponent2;
            }
            ++n2;
        }
        return null;
    }

    protected FrameGeometry getFrameGeometry() {
        return this.geometry;
    }

    protected void setFrameGeometry(JComponent jComponent, FrameGeometry frameGeometry) {
        this.geometry = frameGeometry;
        if (frameGeometry.top_height == 0) {
            frameGeometry.top_height = jComponent.getHeight();
        }
    }

    static {
        String string = null;
        String string2 = Metacity.getUserTheme();
        if (string2 == null) {
            string2 = "Bluecurve";
            string = Metacity.getThemeDir(string2);
            if (string == null) {
                string2 = "Crux";
                string = Metacity.getThemeDir(string2);
            }
            if (string == null) {
                string2 = null;
            }
        }
        if (string2 != null && string == null) {
            string = Metacity.getThemeDir(string2);
        }
        if (string != null) {
            if (string2.equals("Bluecurve")) {
                INSTANCE = new MetacityBluecurve(string);
            } else if (string2.equals("Crux")) {
                INSTANCE = new MetacityCrux(string);
            }
        }
        if (INSTANCE == null) {
            INSTANCE = new MetacityCrux(null);
        }
        titlePaneLayout = new TitlePaneLayout();
    }

    protected static class FrameGeometry {
        int left_width;
        int right_width;
        int top_height;
        int bottom_height;
        int left_titlebar_edge;
        int right_titlebar_edge;
        float aspect_ratio;
        int title_vertical_pad;
        Insets title_border;
        Insets button_border;

        protected FrameGeometry() {
        }
    }

    protected static class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            JInternalFrame jInternalFrame;
            JComponent jComponent = (JComponent)container;
            Container container2 = jComponent.getParent();
            if (container2 instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container2;
            } else if (container2 instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)container2).getInternalFrame();
            } else {
                return null;
            }
            FrameGeometry frameGeometry = INSTANCE.getFrameGeometry();
            int n3 = 22;
            if (jInternalFrame.isClosable()) {
                n3 += 19;
            }
            if (jInternalFrame.isMaximizable()) {
                n3 += 19;
            }
            if (jInternalFrame.isIconifiable()) {
                n3 += 19;
            }
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            String string = jInternalFrame.getTitle();
            int n4 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 3 ? (n3 += n4 < (n = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n4 : n) : (n3 += n4);
            Icon icon = jInternalFrame.getFrameIcon();
            int n6 = fontMetrics.getHeight() + frameGeometry.title_vertical_pad + frameGeometry.title_border.top + frameGeometry.title_border.bottom;
            int n7 = 0;
            if (icon != null) {
                n7 = Math.min(icon.getIconHeight(), 16);
            }
            int n8 = Math.max(n6, n7 + 2);
            return new Dimension(n3, n8);
        }

        public void layoutContainer(Container container) {
            JInternalFrame jInternalFrame;
            JComponent jComponent = (JComponent)container;
            Container container2 = jComponent.getParent();
            if (container2 instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container2;
            } else if (container2 instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)container2).getInternalFrame();
            } else {
                return;
            }
            boolean bl = SynthLookAndFeel.isLeftToRight(jInternalFrame);
            FrameGeometry frameGeometry = INSTANCE.getFrameGeometry();
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            JComponent jComponent2 = Metacity.findChild(jComponent, "InternalFrameTitlePane.menuButton");
            JComponent jComponent3 = Metacity.findChild(jComponent, "InternalFrameTitlePane.iconifyButton");
            JComponent jComponent4 = Metacity.findChild(jComponent, "InternalFrameTitlePane.maximizeButton");
            JComponent jComponent5 = Metacity.findChild(jComponent, "InternalFrameTitlePane.closeButton");
            int n3 = 0;
            int n4 = n2 - frameGeometry.title_border.top - frameGeometry.title_border.bottom;
            int n5 = (int)((float)n4 / frameGeometry.aspect_ratio);
            Icon icon = jInternalFrame.getFrameIcon();
            int n6 = icon != null ? icon.getIconHeight() : n4;
            int n7 = bl ? frameGeometry.left_titlebar_edge : n - n5 - frameGeometry.right_titlebar_edge;
            int n8 = frameGeometry.title_border.top;
            jComponent2.setBounds(n7, n8, n5, n4);
            int n9 = n7 = bl ? n - n5 - frameGeometry.right_titlebar_edge : frameGeometry.left_titlebar_edge;
            if (jInternalFrame.isClosable()) {
                jComponent5.setBounds(n7, n8, n5, n4);
                n7 += bl ? -(n5 + n3) : n5 + n3;
            }
            if (jInternalFrame.isMaximizable()) {
                jComponent4.setBounds(n7, n8, n5, n4);
                n7 += bl ? -(n5 + n3) : n5 + n3;
            }
            if (jInternalFrame.isIconifiable()) {
                jComponent3.setBounds(n7, n8, n5, n4);
            }
        }
    }

    private class ColorizeImageFilter
    extends RGBImageFilter {
        double cr;
        double cg;
        double cb;

        public ColorizeImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this.cr = (double)color.getRed() / 255.0;
            this.cg = (double)color.getGreen() / 255.0;
            this.cb = (double)color.getBlue() / 255.0;
        }

        public Image colorize(Image image, Color color) {
            this.setColor(color);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this);
            return new ImageIcon(Metacity.this.context.getComponent().createImage(filteredImageSource)).getImage();
        }

        public int filterRGB(int n, int n2, int n3) {
            double d;
            double d2;
            double d3;
            double d4 = (double)(2 * (n3 & 0xFF)) / 255.0;
            if (d4 <= 1.0) {
                d3 = this.cr * d4;
                d2 = this.cg * d4;
                d = this.cb * d4;
            } else {
                d3 = this.cr + (1.0 - this.cr) * (d4 -= 1.0);
                d2 = this.cg + (1.0 - this.cg) * d4;
                d = this.cb + (1.0 - this.cb) * d4;
            }
            return (n3 & 0xFF000000) + ((int)(d3 * 255.0) << 16) + ((int)(d2 * 255.0) << 8) + (int)(d * 255.0);
        }
    }
}

