/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthScrollBarUI;
import com.sun.java.swing.plaf.gtk.SynthScrollPaneUI;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;

class SynthDesktopPaneUI
extends DesktopPaneUI
implements PropertyChangeListener,
SynthUI,
LazyActionMap.Loader {
    private static Dimension minSize = new Dimension(0, 0);
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private SynthStyle style;
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    protected KeyStroke minimizeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke closeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    private static Vector framesCache;
    private boolean moving = false;
    private boolean resizing = false;
    private final int MOVE_RESIZE_INCREMENT = 10;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthDesktopPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.desktop = (JDesktopPane)jComponent;
        this.installDefaults();
        this.installDesktopManager();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.uninstallListeners();
        this.desktop = null;
    }

    protected void installListeners() {
        this.desktop.addPropertyChangeListener(this);
    }

    protected void installDefaults() {
        this.fetchStyle(this.desktop);
    }

    private void fetchStyle(JDesktopPane jDesktopPane) {
        SynthContext synthContext = this.getContext(jDesktopPane, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void uninstallListeners() {
        this.desktop.removePropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.desktop, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new DefaultDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() == this.desktopManager) {
            this.desktop.setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 2, inputMap);
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 1, inputMap);
        }
        LazyActionMap.installLazyActionMap(this.desktop, this);
        this.registerKeyboardActions();
    }

    protected void registerKeyboardActions() {
    }

    protected void unregisterKeyboardActions() {
    }

    InputMap getInputMap(int n) {
        if (n == 2) {
            return this.createInputMap(n);
        }
        if (n == 1) {
            SynthContext synthContext = this.getContext(this.desktop, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, "Desktop.ancestorInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    InputMap createInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("Desktop.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.desktop, objectArray);
        }
        return null;
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        actionMap.put("restore", new OpenAction());
        actionMap.put("close", new CloseAction());
        actionMap.put("move", new MoveResizeAction("move"));
        actionMap.put("resize", new MoveResizeAction("resize"));
        actionMap.put("left", new MoveResizeAction("left"));
        actionMap.put("shrinkLeft", new MoveResizeAction("shrinkLeft"));
        actionMap.put("right", new MoveResizeAction("right"));
        actionMap.put("shrinkRight", new MoveResizeAction("shrinkRight"));
        actionMap.put("up", new MoveResizeAction("up"));
        actionMap.put("shrinkUp", new MoveResizeAction("shrinkUp"));
        actionMap.put("down", new MoveResizeAction("down"));
        actionMap.put("shrinkDown", new MoveResizeAction("shrinkDown"));
        actionMap.put("escape", new MoveResizeAction("escape"));
        actionMap.put("minimize", new MinimizeAction());
        actionMap.put("maximize", new MaximizeAction());
        actionMap.put("selectNextFrame", new NavigateAction());
        actionMap.put("selectPreviousFrame", new PreviousAction());
        actionMap.put("navigateNext", new NavigateOutAction(true));
        actionMap.put("navigatePrevious", new NavigateOutAction(false));
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
        SwingUtilities.replaceUIInputMap(this.desktop, 2, null);
        SwingUtilities.replaceUIInputMap(this.desktop, 1, null);
        SwingUtilities.replaceUIActionMap(this.desktop, null);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthDesktopPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return minSize;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return maxSize;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle((JDesktopPane)propertyChangeEvent.getSource());
        }
    }

    private void verifyFramesCache() {
        Object object;
        if (framesCache == null) {
            framesCache = new Vector();
        }
        boolean bl = false;
        int n = framesCache.size();
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame jInternalFrame;
            JComponent jComponent;
            object = (JComponent)framesCache.elementAt(n2);
            if (object instanceof JInternalFrame) {
                jComponent = (JInternalFrame)object;
                if (((JInternalFrame)jComponent).isClosed()) {
                    bl = true;
                    break;
                }
            } else if (object instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = ((JInternalFrame.JDesktopIcon)(jComponent = (JInternalFrame.JDesktopIcon)object)).getInternalFrame()).isClosed()) {
                bl = true;
                break;
            }
            ++n2;
        }
        object = this.desktop.getAllFrames();
        if (bl || ((JInternalFrame[])object).length != framesCache.size()) {
            int n3;
            framesCache.clear();
            int n4 = this.desktop.lowestLayer();
            int n5 = n3 = this.desktop.highestLayer();
            while (n5 >= n4) {
                Component[] componentArray = this.desktop.getComponentsInLayer(n5);
                if (componentArray.length > 0) {
                    int n6 = 0;
                    while (n6 < componentArray.length) {
                        framesCache.addElement(componentArray[n6]);
                        ++n6;
                    }
                }
                --n5;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NavigateOutAction
    extends AbstractAction {
        private boolean moveForward;

        public NavigateOutAction(boolean bl) {
            this.moveForward = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            FocusTraversalPolicy focusTraversalPolicy;
            Container container = SynthDesktopPaneUI.this.desktop.getFocusCycleRootAncestor();
            if (container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) != null && focusTraversalPolicy instanceof SortingFocusTraversalPolicy) {
                SortingFocusTraversalPolicy sortingFocusTraversalPolicy = (SortingFocusTraversalPolicy)focusTraversalPolicy;
                boolean bl = sortingFocusTraversalPolicy.getImplicitDownCycleTraversal();
                try {
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(false);
                    if (this.moveForward) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(SynthDesktopPaneUI.this.desktop);
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(SynthDesktopPaneUI.this.desktop);
                    }
                    Object var7_6 = null;
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(bl);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(bl);
                    throw throwable;
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n = 0;
            SynthDesktopPaneUI.this.verifyFramesCache();
            if (framesCache.size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = SynthDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n = framesCache.indexOf(jInternalFrame);
            }
            if (n == -1 && (n = framesCache.indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (--n == -1) {
                n = framesCache.size() - 1;
            }
            if ((jComponent = (JComponent)framesCache.elementAt(n)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n = 0;
            SynthDesktopPaneUI.this.verifyFramesCache();
            if (framesCache.size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = SynthDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n = framesCache.indexOf(jInternalFrame);
            }
            if (n == -1 && (n = framesCache.indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (++n == framesCache.size()) {
                n = 0;
            }
            if ((jComponent = (JComponent)framesCache.elementAt(n)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                    SynthDesktopPaneUI.this.desktopManager.activateFrame((JInternalFrame)jComponent);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                    SynthDesktopPaneUI.this.desktopManager.activateFrame(((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame());
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                JInternalFrame jInternalFrame = SynthDesktopPaneUI.this.desktop.getSelectedFrame();
                if (jInternalFrame == null) {
                    return;
                }
                if (!jInternalFrame.isMaximizable() || jInternalFrame.isMaximum()) break block7;
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JInternalFrame jInternalFrame = SynthDesktopPaneUI.this.desktop.getSelectedFrame();
                if (jInternalFrame == null) {
                    return;
                }
                if (!jInternalFrame.isIconifiable() || jInternalFrame.isIcon()) break block3;
                try {
                    jInternalFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class MoveResizeAction
    extends AbstractAction {
        private String command;

        public MoveResizeAction(String string) {
            this.command = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            JInternalFrame jInternalFrame = SynthDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if ("move".equals(this.command) || "resize".equals(this.command) || "escape".equals(this.command)) {
                int n = SynthDesktopPaneUI.this.desktop.getComponentCount();
                object = SynthDesktopPaneUI.this.desktop.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame2;
                    Container container;
                    if (object[n2] instanceof JInternalFrame && (container = (jInternalFrame2 = (JInternalFrame)object[n2]).getContentPane()) instanceof JScrollPane) {
                        Object object2;
                        JScrollPane jScrollPane = (JScrollPane)container;
                        if (jScrollPane.getUI() instanceof SynthScrollPaneUI) {
                            object2 = (SynthScrollPaneUI)jScrollPane.getUI();
                            if ("move".equals(this.command) || "resize".equals(this.command)) {
                                ((SynthScrollPaneUI)object2).uninstallKeyboardActions(jScrollPane);
                            } else if ("escape".equals(this.command) && (SynthDesktopPaneUI.this.moving || SynthDesktopPaneUI.this.resizing)) {
                                ((SynthScrollPaneUI)object2).installKeyboardActions(jScrollPane);
                            }
                        }
                        object2 = jScrollPane.getHorizontalScrollBar();
                        int n3 = 0;
                        while (n3 < 2) {
                            if (object2 != null && ((JScrollBar)object2).getUI() instanceof SynthScrollBarUI) {
                                SynthScrollBarUI synthScrollBarUI = (SynthScrollBarUI)((JScrollBar)object2).getUI();
                                if ("move".equals(this.command) || "resize".equals(this.command)) {
                                    synthScrollBarUI.uninstallKeyboardActions();
                                } else if ("escape".equals(this.command) && (SynthDesktopPaneUI.this.moving || SynthDesktopPaneUI.this.resizing)) {
                                    synthScrollBarUI.installKeyboardActions();
                                }
                            }
                            object2 = jScrollPane.getVerticalScrollBar();
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            if ("move".equals(this.command)) {
                SynthDesktopPaneUI.this.moving = true;
                SynthDesktopPaneUI.this.resizing = false;
                return;
            }
            if ("resize".equals(this.command)) {
                SynthDesktopPaneUI.this.moving = false;
                SynthDesktopPaneUI.this.resizing = true;
                return;
            }
            if ("escape".equals(this.command)) {
                SynthDesktopPaneUI.this.moving = (SynthDesktopPaneUI.this.resizing = false);
                return;
            }
            if (!SynthDesktopPaneUI.this.moving && !SynthDesktopPaneUI.this.resizing) {
                return;
            }
            Dimension dimension = jInternalFrame.getSize();
            object = jInternalFrame.getMinimumSize();
            Point point = jInternalFrame.getLocation();
            if ("left".equals(this.command)) {
                if (SynthDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                } else if (SynthDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("right".equals(this.command)) {
                if (SynthDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                } else if (SynthDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("up".equals(this.command)) {
                if (SynthDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                } else if (SynthDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("down".equals(this.command)) {
                if (SynthDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                } else if (SynthDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("shrinkLeft".equals(this.command) && SynthDesktopPaneUI.this.resizing) {
                if (object.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setSize(object.width, dimension.height);
                }
            } else if ("shrinkRight".equals(this.command) && SynthDesktopPaneUI.this.resizing) {
                if (object.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setLocation(point.x - object.width + dimension.width, point.y);
                    jInternalFrame.setSize(object.width, dimension.height);
                }
            } else if ("shrinkUp".equals(this.command) && SynthDesktopPaneUI.this.resizing) {
                if (object.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setSize(dimension.width, object.height);
                }
            } else if ("shrinkDown".equals(this.command) && SynthDesktopPaneUI.this.resizing) {
                if (object.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setLocation(point.x, point.y - object.height + dimension.height);
                    jInternalFrame.setSize(dimension.width, object.height);
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JInternalFrame jInternalFrame = SynthDesktopPaneUI.this.desktop.getSelectedFrame();
                if (jInternalFrame == null) {
                    return;
                }
                if (!jInternalFrame.isClosable()) break block3;
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = SynthDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            try {
                if (jInternalFrame.isIcon()) {
                    jInternalFrame.setIcon(false);
                } else if (jInternalFrame.isMaximum()) {
                    jInternalFrame.setMaximum(false);
                }
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

