/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;

class SynthRootPaneUI
extends RootPaneUI
implements SynthUI,
PropertyChangeListener,
LazyActionMap.Loader {
    private SynthStyle style;
    private boolean oldOpacity;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    SynthRootPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthRootPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.oldOpacity = ((JRootPane)jComponent).isOpaque();
        this.installDefaults((JRootPane)jComponent);
        this.installComponents((JRootPane)jComponent);
        this.installListeners((JRootPane)jComponent);
        this.installKeyboardActions((JRootPane)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JRootPane)jComponent);
        this.uninstallComponents((JRootPane)jComponent);
        this.uninstallListeners((JRootPane)jComponent);
        this.uninstallKeyboardActions((JRootPane)jComponent);
        ((JRootPane)jComponent).setOpaque(this.oldOpacity);
    }

    protected void installDefaults(JRootPane jRootPane) {
        this.fetchStyle(jRootPane);
    }

    protected void installComponents(JRootPane jRootPane) {
    }

    protected void installListeners(JRootPane jRootPane) {
        jRootPane.addPropertyChangeListener(this);
    }

    protected void installKeyboardActions(JRootPane jRootPane) {
        InputMap inputMap = this.getInputMap(2, jRootPane);
        SwingUtilities.replaceUIInputMap(jRootPane, 2, inputMap);
        LazyActionMap.installLazyActionMap(jRootPane, this);
        this.updateDefaultButtonBindings(jRootPane);
    }

    protected void uninstallDefaults(JRootPane jRootPane) {
        SynthContext synthContext = this.getContext(jRootPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallComponents(JRootPane jRootPane) {
    }

    protected void uninstallListeners(JRootPane jRootPane) {
        jRootPane.removePropertyChangeListener(this);
    }

    protected void uninstallKeyboardActions(JRootPane jRootPane) {
        SwingUtilities.replaceUIInputMap(jRootPane, 2, null);
        SwingUtilities.replaceUIActionMap(jRootPane, null);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthRootPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    InputMap getInputMap(int n, JComponent jComponent) {
        if (n == 2) {
            return this.createInputMap(n, jComponent);
        }
        return null;
    }

    ComponentInputMap createInputMap(int n, JComponent jComponent) {
        return new RootPaneInputMap(jComponent);
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        actionMap.put("press", new DefaultAction((JRootPane)jComponent, true));
        actionMap.put("release", new DefaultAction((JRootPane)jComponent, false));
    }

    void updateDefaultButtonBindings(JRootPane jRootPane) {
        InputMap inputMap = SwingUtilities.getUIInputMap(jRootPane, 2);
        while (inputMap != null && !(inputMap instanceof RootPaneInputMap)) {
            inputMap = inputMap.getParent();
        }
        if (inputMap != null) {
            inputMap.clear();
            if (jRootPane.getDefaultButton() != null) {
                SynthContext synthContext = this.getContext(jRootPane, 1);
                Object[] objectArray = (Object[])this.style.get(synthContext, "RootPane.defaultButtonWindowKeyBindings");
                if (objectArray != null) {
                    LookAndFeel.loadKeyBindings(inputMap, objectArray);
                }
                synthContext.dispose();
            }
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle((JRootPane)propertyChangeEvent.getSource());
        }
        if ("defaultButton".equals(propertyChangeEvent.getPropertyName())) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            this.updateDefaultButtonBindings(jRootPane);
            if (jRootPane.getClientProperty("temporaryDefaultButton") == null) {
                jRootPane.putClientProperty("initialDefaultButton", propertyChangeEvent.getNewValue());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class RootPaneInputMap
    extends ComponentInputMapUIResource {
        public RootPaneInputMap(JComponent jComponent) {
            super(jComponent);
        }
    }

    static class DefaultAction
    extends AbstractAction {
        JRootPane root;
        boolean press;

        DefaultAction(JRootPane jRootPane, boolean bl) {
            this.root = jRootPane;
            this.press = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = this.root.getDefaultButton();
            if (jButton != null && SwingUtilities.getRootPane(jButton) == this.root && this.press) {
                jButton.doClick(20);
            }
        }

        public boolean isEnabled() {
            JButton jButton = this.root.getDefaultButton();
            return jButton != null && jButton.getModel().isEnabled();
        }
    }
}

