/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.InternationalFormatter;

class SynthSpinnerUI
extends SpinnerUI
implements SynthUI {
    private SynthStyle style;
    protected JSpinner spinner;
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthSpinnerUI;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    SynthSpinnerUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSpinnerUI();
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("increment", nextButtonHandler);
        actionMap.put("decrement", previousButtonHandler);
    }

    public void installUI(JComponent jComponent) {
        JComponent jComponent2;
        Component component;
        this.spinner = (JSpinner)jComponent;
        this.installDefaults();
        this.installListeners();
        Component component2 = this.createNextButton();
        if (component2 != null) {
            component2.setName("Spinner.nextButton");
            if (component2 instanceof JComponent) {
                ((JComponent)component2).updateUI();
            }
            this.spinner.add(component2, "Next");
        }
        if ((component = this.createPreviousButton()) != null) {
            component.setName("Spinner.previousButton");
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
            this.spinner.add(component, "Previous");
        }
        if ((jComponent2 = this.createEditor()) != null) {
            jComponent2.setName("Spinner.editor");
            if (jComponent2 instanceof JComponent) {
                jComponent2.updateUI();
            }
            this.spinner.add((Component)jComponent2, "Editor");
        }
        this.updateEnabledState();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.spinner = null;
        jComponent.removeAll();
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(propertyChangeListener);
    }

    protected void installDefaults() {
        JComponent jComponent;
        LayoutManager layoutManager = this.spinner.getLayout();
        if (layoutManager == null || layoutManager instanceof UIResource) {
            this.spinner.setLayout(this.createLayout());
        }
        if ((jComponent = this.spinner.getEditor()) instanceof JSpinner.DefaultEditor) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            jFormattedTextField.setName("Spinner.formattedTextField");
        }
        this.fetchStyle(this.spinner);
    }

    private void fetchStyle(JSpinner jSpinner) {
        SynthContext synthContext = this.getContext(jSpinner, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        if (this.spinner.getLayout() instanceof UIResource) {
            this.spinner.setLayout(null);
        }
        SynthContext synthContext = this.getContext(this.spinner, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return propertyChangeListener;
    }

    protected Component createPreviousButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(5);
        synthArrowButton.addActionListener(previousButtonHandler);
        synthArrowButton.addMouseListener(previousButtonHandler);
        return synthArrowButton;
    }

    protected Component createNextButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(1);
        synthArrowButton.addActionListener(nextButtonHandler);
        synthArrowButton.addMouseListener(nextButtonHandler);
        return synthArrowButton;
    }

    protected JComponent createEditor() {
        return this.spinner.getEditor();
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.spinner.add((Component)jComponent2, "Editor");
        JComponent jComponent3 = this.spinner.getEditor();
        if (jComponent3 instanceof JSpinner.DefaultEditor) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent3).getTextField();
            jFormattedTextField.setName("Spinner.formattedTextField");
        }
    }

    private void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    private void updateEnabledState(Container container, boolean bl) {
        int n = container.getComponentCount() - 1;
        while (n >= 0) {
            Component component = container.getComponent(n);
            component.setEnabled(bl);
            if (component instanceof Container) {
                this.updateEnabledState((Container)component, bl);
            }
            --n;
        }
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.spinner, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.spinner, class$com$sun$java$swing$plaf$gtk$SynthSpinnerUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthSpinnerUI = SynthSpinnerUI.class$("com.sun.java.swing.plaf.gtk.SynthSpinnerUI")) : class$com$sun$java$swing$plaf$gtk$SynthSpinnerUI, "Spinner.actionMap");
    }

    private InputMap getInputMap(int n) {
        if (n == 1) {
            SynthContext synthContext = this.getContext(this.spinner, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, "Spinner.ancestorInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthSpinnerUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JSpinner jSpinner = (JSpinner)propertyChangeEvent.getSource();
            SpinnerUI spinnerUI = jSpinner.getUI();
            if (spinnerUI instanceof SynthSpinnerUI) {
                SynthSpinnerUI synthSpinnerUI = (SynthSpinnerUI)spinnerUI;
                if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                    synthSpinnerUI.fetchStyle(jSpinner);
                }
                if ("editor".equals(string)) {
                    JComponent jComponent = (JComponent)propertyChangeEvent.getOldValue();
                    JComponent jComponent2 = (JComponent)propertyChangeEvent.getNewValue();
                    synthSpinnerUI.replaceEditor(jComponent, jComponent2);
                    synthSpinnerUI.updateEnabledState();
                } else if ("enabled".equals(string)) {
                    synthSpinnerUI.updateEnabledState();
                }
            }
        }
    }

    private static class SpinnerLayout
    implements LayoutManager,
    UIResource {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? new Dimension(0, 0) : component.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            return dimension4;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (component != null) {
                component.setBounds(n, n2, n3, n4);
            }
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            Insets insets = container.getInsets();
            int n3 = container.getWidth() - (insets.left + insets.right);
            int n4 = container.getHeight() - (insets.top + insets.bottom);
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            int n5 = n4 / 2;
            int n6 = n4 - n5;
            int n7 = Math.max(dimension.width, dimension2.width);
            int n8 = n3 - n7;
            if (container.getComponentOrientation().isLeftToRight()) {
                n2 = insets.left;
                n = n2 + n8;
            } else {
                n = insets.left;
                n2 = n + n7;
            }
            int n9 = insets.top + n5;
            this.setBounds(this.editor, n2, insets.top, n8, n4);
            this.setBounds(this.nextButton, n, insets.top, n7, n5);
            this.setBounds(this.previousButton, n, n9, n7, n6);
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(String string, boolean bl) {
            super(string);
            this.isNext = bl;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            while (object instanceof Component && !(object instanceof JSpinner)) {
                object = ((Component)object).getParent();
            }
            return object instanceof JSpinner ? (JSpinner)object : null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                JSpinner jSpinner = this.spinner;
                if (!(actionEvent.getSource() instanceof Timer)) {
                    jSpinner = this.eventToSpinner(actionEvent);
                }
                if (jSpinner == null) break block6;
                try {
                    Object object;
                    int n = this.getCalendarField(jSpinner);
                    jSpinner.commitEdit();
                    if (n != -1) {
                        ((SpinnerDateModel)jSpinner.getModel()).setCalendarField(n);
                    }
                    Object object2 = object = this.isNext ? jSpinner.getNextValue() : jSpinner.getPreviousValue();
                    if (object != null) {
                        jSpinner.setValue(object);
                        this.select(jSpinner);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
                catch (ParseException parseException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
            }
        }

        private void select(JSpinner jSpinner) {
            block4: {
                SpinnerDateModel spinnerDateModel;
                DateFormat.Field field;
                Object object;
                JComponent jComponent = jSpinner.getEditor();
                if (!(jComponent instanceof JSpinner.DateEditor)) break block4;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                SimpleDateFormat simpleDateFormat = dateEditor.getFormat();
                if (simpleDateFormat != null && (object = jSpinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((spinnerDateModel = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator attributedCharacterIterator = ((Format)simpleDateFormat).formatToCharacterIterator(object);
                        if (!this.select(jFormattedTextField, attributedCharacterIterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(jFormattedTextField, attributedCharacterIterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }

        private boolean select(JFormattedTextField jFormattedTextField, AttributedCharacterIterator attributedCharacterIterator, DateFormat.Field field) {
            int n = jFormattedTextField.getDocument().getLength();
            attributedCharacterIterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> map;
                if ((map = attributedCharacterIterator.getAttributes()) == null || !map.containsKey(field)) continue;
                int n2 = attributedCharacterIterator.getRunStart(field);
                int n3 = attributedCharacterIterator.getRunLimit(field);
                if (n2 != -1 && n3 != -1 && n2 <= n && n3 <= n) {
                    jFormattedTextField.select(n2, n3);
                }
                return true;
            } while (attributedCharacterIterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner jSpinner) {
            JComponent jComponent = jSpinner.getEditor();
            if (jComponent instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                int n = jFormattedTextField.getSelectionStart();
                JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
                if (abstractFormatter instanceof InternationalFormatter) {
                    Format.Field[] fieldArray = ((InternationalFormatter)abstractFormatter).getFields(n);
                    int n2 = 0;
                    while (n2 < fieldArray.length) {
                        int n3;
                        if (fieldArray[n2] instanceof DateFormat.Field && (n3 = fieldArray[n2] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fieldArray[n2]).getCalendarField()) != -1) {
                            return n3;
                        }
                        ++n2;
                    }
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(mouseEvent);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void focusSpinnerIfNecessary() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (component == null || !SwingUtilities.isDescendingFrom(component, this.spinner))) {
                FocusTraversalPolicy focusTraversalPolicy;
                Component component2;
                Container container = this.spinner;
                if (!container.isFocusCycleRoot()) {
                    container = container.getFocusCycleRootAncestor();
                }
                if (container != null && (component2 = (focusTraversalPolicy = container.getFocusTraversalPolicy()).getComponentAfter(container, this.spinner)) != null && SwingUtilities.isDescendingFrom(component2, this.spinner)) {
                    component2.requestFocus();
                }
            }
        }
    }
}

