/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import com.sun.java.swing.plaf.gtk.TabContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

class SynthTabbedPaneUI
extends TabbedPaneUI
implements SynthUI,
SwingConstants {
    private static Action scrollTabsForwardAction = new ScrollTabsForwardAction();
    private static Action scrollTabsBackwardAction = new ScrollTabsBackwardAction();
    private SynthContext tabAreaContext;
    private TabContext tabContext;
    private SynthContext tabContentContext;
    private SynthStyle style;
    private SynthStyle tabStyle;
    private SynthStyle tabAreaStyle;
    private SynthStyle tabContentStyle;
    private int tabRunOverlay;
    protected JTabbedPane tabPane;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseInputListener mouseInputListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int tabCount;
    private int mouseIndex;
    private boolean selectionFollowsFocus = true;
    private int focusIndex = -1;
    private Rectangle mouseBounds;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthTabbedPaneUI;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthContext;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$TabContext;

    SynthTabbedPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTabbedPaneUI();
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("navigateNext", new NextAction());
        actionMap.put("navigatePrevious", new PreviousAction());
        actionMap.put("navigateRight", new RightAction());
        actionMap.put("navigateLeft", new LeftAction());
        actionMap.put("navigateUp", new UpAction());
        actionMap.put("navigateDown", new DownAction());
        actionMap.put("navigatePageUp", new PageUpAction());
        actionMap.put("navigatePageDown", new PageDownAction());
        actionMap.put("requestFocus", new RequestFocusAction());
        actionMap.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        actionMap.put("setSelectedIndex", new SetSelectedIndexAction());
        actionMap.put("selectTabWithFocus", new SelectFocusIndexAction());
        actionMap.put("scrollTabsForwardAction", scrollTabsForwardAction);
        actionMap.put("scrollTabsBackwardAction", scrollTabsBackwardAction);
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected void installDefaults() {
        this.fetchStyle(this.tabPane);
    }

    private void fetchStyle(JTabbedPane jTabbedPane) {
        SynthContext synthContext = this.getContext((JComponent)jTabbedPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.tabRunOverlay = 0;
            Integer n = (Integer)synthContext.getStyle().get(synthContext, "tabRunOverlay");
            if (n != null) {
                this.tabRunOverlay = n;
            }
            this.selectionFollowsFocus = synthContext.getStyle().getBoolean(synthContext, "TabbedPane.selectionFollowsFocus", true);
        }
        synthContext.dispose();
        if (this.tabContext != null) {
            this.tabContext.dispose();
        }
        this.tabContext = (TabContext)this.getContext(jTabbedPane, Region.TABBED_PANE_TAB, 1);
        this.tabStyle = SynthLookAndFeel.updateStyle(this.tabContext, this);
        if (this.tabAreaContext != null) {
            this.tabAreaContext.dispose();
        }
        this.tabAreaContext = this.getContext(jTabbedPane, Region.TABBED_PANE_TAB_AREA, 1);
        this.tabAreaStyle = SynthLookAndFeel.updateStyle(this.tabAreaContext, this);
        if (this.tabContentContext != null) {
            this.tabContentContext.dispose();
        }
        this.tabContentContext = this.getContext(jTabbedPane, Region.TABBED_PANE_CONTENT, 1);
        this.tabContentStyle = SynthLookAndFeel.updateStyle(this.tabContentContext, this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.tabPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.tabPane, Region.TABBED_PANE_TAB, 1);
        this.tabStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.tabStyle = null;
        synthContext = this.getContext(this.tabPane, Region.TABBED_PANE_TAB_AREA, 1);
        this.tabAreaStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.tabAreaStyle = null;
        synthContext = this.getContext(this.tabPane, Region.TABBED_PANE_CONTENT, 1);
        this.tabContentStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.tabContentStyle = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseInputListener = this.createMouseInputListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseListener(this.mouseInputListener);
                this.tabScroller.tabPanel.addMouseMotionListener(this.mouseInputListener);
            } else {
                this.tabPane.addMouseListener(this.mouseInputListener);
                this.tabPane.addMouseMotionListener(this.mouseInputListener);
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseInputListener);
                this.tabScroller.tabPanel.removeMouseMotionListener(this.mouseInputListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseInputListener);
                this.tabPane.removeMouseMotionListener(this.mouseInputListener);
            }
            this.mouseInputListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.tabPane, class$com$sun$java$swing$plaf$gtk$SynthTabbedPaneUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthTabbedPaneUI = SynthTabbedPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthTabbedPaneUI")) : class$com$sun$java$swing$plaf$gtk$SynthTabbedPaneUI, "TabbedPane.actionMap");
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.scrollForwardButton.setAction(scrollTabsForwardAction);
            this.tabScroller.scrollBackwardButton.setAction(scrollTabsBackwardAction);
        }
    }

    InputMap getInputMap(int n) {
        SynthContext synthContext = this.getContext((JComponent)this.tabPane, 1);
        InputMap inputMap = null;
        if (n == 1) {
            inputMap = (InputMap)synthContext.getStyle().get(synthContext, "TabbedPane.ancestorInputMap");
        } else if (n == 0) {
            inputMap = (InputMap)synthContext.getStyle().get(synthContext, "TabbedPane.focusInputMap");
        }
        synthContext.dispose();
        return inputMap;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        int n = this.tabPane.getTabCount() - 1;
        while (n >= 0) {
            int n2 = this.tabPane.getMnemonicAt(n);
            if (n2 > 0) {
                this.addMnemonic(n, n2);
            }
            --n;
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n, int n2) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n2, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(n2), new Integer(n));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    private void repaintTab(int n) {
    }

    private void updateMouseOver(int n, int n2) {
        this.setMouseOverTab(this.getTabAtLocation(n, n2));
    }

    private void setMouseOverTab(int n) {
        if (n != this.mouseIndex) {
            if (this.mouseBounds != null) {
                this.tabPane.repaint(this.mouseBounds);
            }
            this.mouseIndex = n;
            if (n != -1 && n < this.tabPane.getTabCount()) {
                this.mouseBounds = this.tabPane.getBoundsAt(n);
                if (this.mouseBounds != null) {
                    this.tabPane.repaint(this.mouseBounds);
                }
            } else {
                this.mouseBounds = null;
            }
        }
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthTabbedPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        Class clazz;
        SynthStyle synthStyle = null;
        Class clazz2 = clazz = class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthTabbedPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext;
        if (region == Region.TABBED_PANE_TAB) {
            synthStyle = this.tabStyle;
            clazz = class$com$sun$java$swing$plaf$gtk$TabContext == null ? (class$com$sun$java$swing$plaf$gtk$TabContext = SynthTabbedPaneUI.class$("com.sun.java.swing.plaf.gtk.TabContext")) : class$com$sun$java$swing$plaf$gtk$TabContext;
        } else if (region == Region.TABBED_PANE_TAB_AREA) {
            synthStyle = this.tabAreaStyle;
        } else if (region == Region.TABBED_PANE_CONTENT) {
            synthStyle = this.tabContentStyle;
        }
        return SynthContext.getContext(clazz, jComponent, region, synthStyle, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        int n = this.tabPane.getTabCount();
        if (this.tabCount != n) {
            this.tabCount = n;
            this.updateMnemonics();
        }
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            Insets insets = this.tabPane.getInsets();
            int n4 = insets.left;
            int n5 = insets.top;
            int n6 = this.tabPane.getWidth() - insets.left - insets.right;
            int n7 = this.tabPane.getHeight() - insets.top - insets.bottom;
            switch (n3) {
                case 2: {
                    n6 = this.calculateTabAreaWidth(n3, this.runCount, this.maxTabWidth);
                    break;
                }
                case 4: {
                    int n8 = this.calculateTabAreaWidth(n3, this.runCount, this.maxTabWidth);
                    n4 = n4 + n6 - n8;
                    n6 = n8;
                    break;
                }
                case 3: {
                    int n9 = this.calculateTabAreaHeight(n3, this.runCount, this.maxTabHeight);
                    n5 = n5 + n7 - n9;
                    n7 = n9;
                    break;
                }
                default: {
                    n7 = this.calculateTabAreaHeight(n3, this.runCount, this.maxTabHeight);
                }
            }
            this.paintTabArea(this.tabAreaContext, graphics, n3, n2, new Rectangle(n4, n5, n6, n7));
        }
        this.paintContentBorder(this.tabContentContext, graphics, n3, n2);
    }

    protected void paintTabArea(SynthContext synthContext, Graphics graphics, int n, int n2, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        int n3 = this.tabPane.getTabCount();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = graphics.getClipBounds();
        int n4 = this.runCount - 1;
        while (n4 >= 0) {
            int n5 = this.tabRuns[n4];
            int n6 = this.tabRuns[n4 == this.runCount - 1 ? 0 : n4 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n3 - 1;
            int n8 = n5;
            while (n8 <= n7) {
                if (this.rects[n8].intersects(rectangle4) && n2 != n8) {
                    this.paintTab(this.tabContext, graphics, n, this.rects, n8, rectangle2, rectangle3);
                }
                ++n8;
            }
            --n4;
        }
        if (n2 >= 0 && this.rects[n2].intersects(rectangle4)) {
            this.paintTab(this.tabContext, graphics, n, this.rects, n2, rectangle2, rectangle3);
        }
    }

    protected void paintTab(SynthContext synthContext, Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        this.tabContext.update(n2, bl, this.mouseIndex == n2, this.focusIndex == n2);
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle3);
        String string = this.tabPane.getTitleAt(n2);
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(synthContext, n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(synthContext, graphics, n, font, fontMetrics, n2, string, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
    }

    protected void layoutLabel(SynthContext synthContext, int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        synthContext.getStyle().getSynthGraphics(synthContext).layoutText(synthContext, fontMetrics, string, icon, 0, 0, 10, 11, rectangle, rectangle2, rectangle3, this.getTextIconGap());
        this.tabPane.putClientProperty("html", null);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(SynthContext synthContext, Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
            synthContext.getStyle().getSynthGraphics(synthContext).paintFocus(synthContext, graphics, 1, "tabbedPane", rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            synthContext.getStyle().getSynthGraphics(synthContext).paintText(synthContext, graphics, string, rectangle, n3);
        }
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = bl ? -1 : 1;
                break;
            }
            case 4: {
                n3 = bl ? 1 : -1;
                break;
            }
            default: {
                n3 = rectangle.width % 2;
            }
        }
        return n3;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 3: {
                n3 = bl ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n3 = rectangle.height % 2;
                break;
            }
            default: {
                n3 = bl ? -1 : 1;
            }
        }
        return n3;
    }

    protected void paintContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        SynthLookAndFeel.updateSubregion(synthContext, graphics, new Rectangle(n5, n6, n7, n8));
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n, rectangle);
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        Point point = new Point(n, n2);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n, n2, point);
        }
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        while (n4 < n3) {
            if (this.rects[n4].contains(point.x, point.y)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.width = this.rects[n].width;
        rectangle.height = this.rects[n].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n].x - point.x - point2.x;
            rectangle.y = this.rects[n].y - point.y - point2.y;
        } else {
            rectangle.x = this.rects[n].x;
            rectangle.y = this.rects[n].y;
        }
        return rectangle;
    }

    private int getTabAtLocation(int n, int n2) {
        this.ensureCurrentLayout();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        while (n4 < n3) {
            if (this.rects[n4].contains(n, n2)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private int getClosestTab(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n3 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n6 = this.tabPane.getTabPlacement();
        boolean bl = n6 == 1 || n6 == 3;
        int n7 = bl ? n : n2;
        while (n4 != n5) {
            int n8;
            int n9;
            int n10 = (n5 + n4) / 2;
            if (bl) {
                n9 = this.rects[n10].x;
                n8 = n9 + this.rects[n10].width;
            } else {
                n9 = this.rects[n10].y;
                n8 = n9 + this.rects[n10].height;
            }
            if (n7 < n9) {
                n5 = n10;
                if (n4 != n5) continue;
                return Math.max(0, n10 - 1);
            }
            if (n7 >= n8) {
                n4 = n10;
                if (n5 - n4 > 1) continue;
                return Math.max(n10 + 1, n3 - 1);
            }
            return n10;
        }
        return n4;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n + point2.x + point3.x;
        point.y = n2 + point2.y + point3.y;
        return point;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n) {
        int n2 = this.rects.length;
        if (n != n2) {
            Rectangle[] rectangleArray = new Rectangle[n];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n2, n));
            this.rects = rectangleArray;
            int n3 = n2;
            while (n3 < n) {
                this.rects[n3] = new Rectangle();
                ++n3;
            }
        }
    }

    protected void expandTabRunsArray() {
        int n = this.tabRuns.length;
        int[] nArray = new int[n + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    protected int getRunForTab(int n, int n2) {
        int n3 = 0;
        while (n3 < this.runCount) {
            int n4 = this.tabRuns[n3];
            int n5 = this.lastTabInRun(n, n3);
            if (n2 >= n4 && n2 <= n5) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    protected int lastTabInRun(int n, int n2) {
        int n3;
        if (this.runCount == 1) {
            return n - 1;
        }
        int n4 = n3 = n2 == this.runCount - 1 ? 0 : n2 + 1;
        if (this.tabRuns[n3] == 0) {
            return n - 1;
        }
        return this.tabRuns[n3] - 1;
    }

    protected int getTabRunOverlay(int n) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected Icon getIconForTab(int n) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n) ? this.tabPane.getDisabledIconAt(n) : this.tabPane.getIconAt(n);
    }

    protected View getTextViewForTab(int n) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(n);
        }
        return null;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        int n4 = 0;
        View view = this.getTextViewForTab(n2);
        n4 = view != null ? (n4 += (int)view.getPreferredSpan(1)) : (n4 += n3);
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        if (icon != null) {
            n4 = Math.max(n4, icon.getIconHeight());
        }
        return n4 += insets.top + insets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = fontMetrics.getHeight();
        int n5 = 0;
        while (n5 < n2) {
            n3 = Math.max(this.calculateTabHeight(n, n5, n4), n3);
            ++n5;
        }
        return n3;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        View view;
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n3 = insets.left + insets.right + 3;
        if (icon != null) {
            n3 += icon.getIconWidth() + this.getTextIconGap();
        }
        if ((view = this.getTextViewForTab(n2)) != null) {
            n3 += (int)view.getPreferredSpan(0);
        } else {
            String string = this.tabPane.getTitleAt(n2);
            n3 += this.tabContext.getStyle().getSynthGraphics(this.tabContext).computeStringWidth(this.tabContext, fontMetrics.getFont(), fontMetrics, string);
        }
        return n3;
    }

    private int getTextIconGap() {
        Integer n = (Integer)this.tabContext.getStyle().get(this.tabContext, "textIconGap");
        if (n == null) {
            return 0;
        }
        return n;
    }

    protected int calculateMaxTabWidth(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = Math.max(this.calculateTabWidth(n, n4, fontMetrics), n3);
            ++n4;
        }
        return n3;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.left + insets.right : 0;
    }

    protected Insets getTabInsets(int n, int n2) {
        this.tabContext.update(n2, false, this.mouseIndex == n2, this.focusIndex == n2);
        return this.tabContext.getStyle().getInsets(this.tabContext, null);
    }

    protected Insets getSelectedTabPadInsets(int n) {
        Insets insets = (Insets)this.tabContext.getStyle().get(this.tabContext, "selectedTabPadInsets");
        if (insets == null) {
            return new Insets(0, 0, 0, 0);
        }
        Insets insets2 = new Insets(0, 0, 0, 0);
        SynthTabbedPaneUI.rotateInsets(insets, new Insets(0, 0, 0, 0), n);
        return insets2;
    }

    protected Insets getTabAreaInsets(int n) {
        return this.tabAreaContext.getStyle().getInsets(this.tabAreaContext, null);
    }

    protected Insets getContentBorderInsets(int n) {
        return this.tabContentContext.getStyle().getInsets(this.tabContentContext, null);
    }

    protected FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
    }

    protected FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n) {
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.selectionFollowsFocus ? this.tabPane.getSelectedIndex() : this.focusIndex;
        int n4 = this.tabPane.getTabCount();
        if (n4 <= 0) {
            return;
        }
        block0 : switch (n2) {
            case 12: {
                this.selectNextTab(n3);
                break;
            }
            case 13: {
                this.selectPreviousTab(n3);
                break;
            }
            case 2: 
            case 4: {
                switch (n) {
                    case 1: {
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        int n5 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n5);
                        break block0;
                    }
                    case 3: {
                        int n6 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n6);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n) {
                    case 1: {
                        int n7 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n7);
                        break block0;
                    }
                    case 5: {
                        int n8 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n8);
                        break block0;
                    }
                    case 3: {
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int n) {
        int n2 = this.tabPane.getTabCount();
        int n3 = this.getNextTabIndexInRun(n2, n);
        while (n3 != n && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndexInRun(n2, n3);
        }
        this.navigateTo(n3);
    }

    protected void selectPreviousTabInRun(int n) {
        int n2 = this.tabPane.getTabCount();
        int n3 = this.getPreviousTabIndexInRun(n2, n);
        while (n3 != n && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndexInRun(n2, n3);
        }
        this.navigateTo(n3);
    }

    protected void selectNextTab(int n) {
        int n2 = this.getNextTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getNextTabIndex(n2);
        }
        this.navigateTo(n2);
    }

    protected void selectPreviousTab(int n) {
        int n2 = this.getPreviousTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getPreviousTabIndex(n2);
        }
        this.navigateTo(n2);
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n2];
        switch (n) {
            case 2: 
            case 4: {
                n4 = this.getTabAtLocation(rectangle.x + rectangle.width / 2 + n3, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n4 = this.getTabAtLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n3);
            }
        }
        if (n4 != -1) {
            while (!this.tabPane.isEnabledAt(n4) && n4 != n2) {
                n4 = this.getNextTabIndex(n4);
            }
            this.navigateTo(n4);
        }
    }

    private void navigateTo(int n) {
        if (this.selectionFollowsFocus) {
            this.setFocusIndex(n);
            this.tabPane.setSelectedIndex(n);
        } else {
            int n2 = this.focusIndex;
            this.setFocusIndex(n);
            this.tabPane.repaint(this.getTabBounds(this.tabPane, this.focusIndex));
            if (n2 != -1) {
                this.tabPane.repaint(this.getTabBounds(this.tabPane, n2));
            }
        }
    }

    void setFocusIndex(int n) {
        this.focusIndex = n;
    }

    int getFocusIndex() {
        return this.focusIndex;
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.getRunForTab(n2, n3);
        switch (n) {
            case 2: {
                if (n5 == 0) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n4 = bl ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n4 = n5 == 0 ? (bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n5 == this.runCount - 1 ? (bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n4;
    }

    protected int getPreviousTabIndex(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.tabPane.getTabCount() - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabIndex(int n) {
        return (n + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        int n4 = this.getNextTabIndex(n2);
        if (n4 == this.tabRuns[this.getNextTabRun(n3)]) {
            return this.tabRuns[n3];
        }
        return n4;
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        if (n2 == this.tabRuns[n3]) {
            int n4 = this.tabRuns[this.getNextTabRun(n3)] - 1;
            return n4 != -1 ? n4 : n - 1;
        }
        return this.getPreviousTabIndex(n2);
    }

    protected int getPreviousTabRun(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.runCount - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabRun(int n) {
        return (n + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector<View> vector = new Vector<View>();
        int n = this.tabPane.getTabCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                String string = this.tabPane.getTitleAt(n2);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                } else {
                    vector.addElement(null);
                }
                ++n2;
            }
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n = jTabbedPane.indexOfComponent(component);
            String string = jTabbedPane.getTitleAt(n);
            boolean bl = BasicHTML.isHTMLString(string);
            if (bl) {
                if (SynthTabbedPaneUI.this.htmlViews == null) {
                    SynthTabbedPaneUI.this.htmlViews = SynthTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    SynthTabbedPaneUI.this.htmlViews.insertElementAt(view, n);
                }
            } else if (SynthTabbedPaneUI.this.htmlViews != null) {
                SynthTabbedPaneUI.this.htmlViews.insertElementAt(null, n);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            Integer n = (Integer)jTabbedPane.getClientProperty("__index_to_remove__");
            if (n != null) {
                int n2 = n;
                if (SynthTabbedPaneUI.this.htmlViews != null && SynthTabbedPaneUI.this.htmlViews.size() >= n2) {
                    SynthTabbedPaneUI.this.htmlViews.removeElementAt(n2);
                }
            }
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            if (SynthTabbedPaneUI.this.focusIndex == -1) {
                SynthTabbedPaneUI.this.setFocusIndex(jTabbedPane.getSelectedIndex());
            }
            if (SynthTabbedPaneUI.this.focusIndex != -1 && n > 0 && n == SynthTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(SynthTabbedPaneUI.this.getTabBounds(jTabbedPane, SynthTabbedPaneUI.this.focusIndex));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            if (SynthTabbedPaneUI.this.focusIndex != -1 && n > 0 && n == SynthTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(SynthTabbedPaneUI.this.getTabBounds(jTabbedPane, SynthTabbedPaneUI.this.focusIndex));
                SynthTabbedPaneUI.this.setFocusIndex(-1);
            }
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SynthTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = SynthTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && SynthTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                if (n != SynthTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    SynthTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                }
                if (SynthTabbedPaneUI.this.tabPane.isRequestFocusEnabled() && n != SynthTabbedPaneUI.this.focusIndex) {
                    SynthTabbedPaneUI.this.tabPane.requestFocus();
                    int n2 = SynthTabbedPaneUI.this.focusIndex;
                    SynthTabbedPaneUI.this.setFocusIndex(n);
                    SynthTabbedPaneUI.this.tabPane.repaint(SynthTabbedPaneUI.this.getTabBounds(SynthTabbedPaneUI.this.tabPane, SynthTabbedPaneUI.this.focusIndex));
                    if (n2 != -1) {
                        SynthTabbedPaneUI.this.tabPane.repaint(SynthTabbedPaneUI.this.getTabBounds(SynthTabbedPaneUI.this.tabPane, n2));
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            SynthTabbedPaneUI.this.updateMouseOver(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            SynthTabbedPaneUI.this.updateMouseOver(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SynthTabbedPaneUI.this.setMouseOverTab(-1);
        }
    }

    class TabSelectionHandler
    implements ChangeListener {
        TabSelectionHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (jTabbedPane.getTabLayoutPolicy() == 1 && (n = jTabbedPane.getSelectedIndex()) < SynthTabbedPaneUI.this.rects.length && n != -1) {
                ((SynthTabbedPaneUI)SynthTabbedPaneUI.this).tabScroller.tabPanel.scrollRectToVisible(SynthTabbedPaneUI.this.rects[n]);
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthTabbedPaneUI.this.fetchStyle(jTabbedPane);
            }
            if ("mnemonicAt".equals(string)) {
                SynthTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(string)) {
                jTabbedPane.repaint();
            } else if (string.equals("indexForTitle")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                String string2 = SynthTabbedPaneUI.this.tabPane.getTitleAt(n);
                if (BasicHTML.isHTMLString(string2)) {
                    if (SynthTabbedPaneUI.this.htmlViews == null) {
                        SynthTabbedPaneUI.this.htmlViews = SynthTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View view = BasicHTML.createHTMLView(SynthTabbedPaneUI.this.tabPane, string2);
                        SynthTabbedPaneUI.this.htmlViews.setElementAt(view, n);
                    }
                } else if (SynthTabbedPaneUI.this.htmlViews != null && SynthTabbedPaneUI.this.htmlViews.elementAt(n) != null) {
                    SynthTabbedPaneUI.this.htmlViews.setElementAt(null, n);
                }
                SynthTabbedPaneUI.this.updateMnemonics();
            } else if (string.equals("tabLayoutPolicy")) {
                SynthTabbedPaneUI.this.uninstallUI(jTabbedPane);
                SynthTabbedPaneUI.this.installUI(jTabbedPane);
            }
        }
    }

    private class ScrollableTabButton
    extends SynthArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n) {
            super(n);
        }

        public boolean scrollsForward() {
            return this.getDirection() == 3 || this.getDirection() == 5;
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            SynthTabbedPaneUI.this.paintTabArea(SynthTabbedPaneUI.this.tabAreaContext, graphics, SynthTabbedPaneUI.this.tabPane.getTabPlacement(), SynthTabbedPaneUI.this.tabPane.getSelectedIndex(), this.getBounds());
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (n == 1 || n == 3) {
                this.scrollForwardButton = new ScrollableTabButton(3);
                this.scrollBackwardButton = new ScrollableTabButton(7);
            } else {
                this.scrollForwardButton = new ScrollableTabButton(5);
                this.scrollBackwardButton = new ScrollableTabButton(1);
            }
        }

        public void scrollForward(int n) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n == 1 || n == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int n, int n2) {
            this.leadingTabIndex = n2;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n) {
                case 1: 
                case 3: {
                    int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : SynthTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n4 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : SynthTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n = SynthTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = SynthTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = SynthTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n2) {
                switch (n) {
                    case 1: 
                    case 3: {
                        if (SynthTabbedPaneUI.this.rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (SynthTabbedPaneUI.this.rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = SynthTabbedPaneUI.this.getContentBorderInsets(n);
            switch (n) {
                case 2: {
                    SynthTabbedPaneUI.this.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    SynthTabbedPaneUI.this.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    SynthTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    SynthTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            return SynthTabbedPaneUI.this.calculateMaxTabHeight(n);
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            return SynthTabbedPaneUI.this.calculateMaxTabWidth(n);
        }

        public void layoutContainer(Container container) {
            int n = SynthTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = SynthTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = SynthTabbedPaneUI.this.tabPane.getInsets();
            int n3 = SynthTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = SynthTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    SynthTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = SynthTabbedPaneUI.this.tabPane.getComponentAt(n3);
                boolean bl = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    SynthTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = SynthTabbedPaneUI.this.getContentBorderInsets(n);
                Rectangle rectangle = SynthTabbedPaneUI.this.tabPane.getBounds();
                int n4 = SynthTabbedPaneUI.this.tabPane.getComponentCount();
                if (n4 > 0) {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    switch (n) {
                        case 2: {
                            n12 = SynthTabbedPaneUI.this.calculateTabAreaWidth(n, SynthTabbedPaneUI.this.runCount, SynthTabbedPaneUI.this.maxTabWidth);
                            n11 = rectangle.height - insets.top - insets.bottom;
                            n10 = insets.left;
                            n9 = insets.top;
                            n8 = n10 + n12 + insets2.left;
                            n7 = n9 + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - n12 - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n12 = SynthTabbedPaneUI.this.calculateTabAreaWidth(n, SynthTabbedPaneUI.this.runCount, SynthTabbedPaneUI.this.maxTabWidth);
                            n11 = rectangle.height - insets.top - insets.bottom;
                            n10 = rectangle.width - insets.right - n12;
                            n9 = insets.top;
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - n12 - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n12 = rectangle.width - insets.left - insets.right;
                            n11 = SynthTabbedPaneUI.this.calculateTabAreaHeight(n, SynthTabbedPaneUI.this.runCount, SynthTabbedPaneUI.this.maxTabHeight);
                            n10 = insets.left;
                            n9 = rectangle.height - insets.bottom - n11;
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - n11 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n12 = rectangle.width - insets.left - insets.right;
                            n11 = SynthTabbedPaneUI.this.calculateTabAreaHeight(n, SynthTabbedPaneUI.this.runCount, SynthTabbedPaneUI.this.maxTabHeight);
                            n10 = insets.left;
                            n9 = insets.top;
                            n8 = n10 + insets2.left;
                            n7 = n9 + n11 + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - n11 - insets2.top - insets2.bottom;
                        }
                    }
                    int n13 = 0;
                    while (n13 < n4) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        Cloneable cloneable;
                        JComponent jComponent;
                        Component component3 = SynthTabbedPaneUI.this.tabPane.getComponent(n13);
                        if (component3 instanceof ScrollableTabViewport) {
                            jComponent = (JViewport)component3;
                            cloneable = ((JViewport)jComponent).getViewRect();
                            n17 = n12;
                            n16 = n11;
                            switch (n) {
                                case 2: 
                                case 4: {
                                    n15 = SynthTabbedPaneUI.this.rects[n2 - 1].y + SynthTabbedPaneUI.this.rects[n2 - 1].height;
                                    if (n15 <= n11 || n15 - cloneable.y > (n16 = Math.max(n11 - 36, 36))) break;
                                    n16 = n15 - cloneable.y;
                                    break;
                                }
                                default: {
                                    n14 = SynthTabbedPaneUI.this.rects[n2 - 1].x + SynthTabbedPaneUI.this.rects[n2 - 1].width;
                                    if (n14 <= n12 || n14 - cloneable.x > (n17 = Math.max(n12 - 36, 36))) break;
                                    n17 = n14 - cloneable.x;
                                }
                            }
                            component3.setBounds(n10, n9, n17, n16);
                        } else if (component3 instanceof ScrollableTabButton) {
                            jComponent = (ScrollableTabButton)component3;
                            cloneable = jComponent.getPreferredSize();
                            n17 = 0;
                            n16 = 0;
                            n15 = ((Dimension)cloneable).width;
                            n14 = ((Dimension)cloneable).height;
                            boolean bl2 = false;
                            switch (n) {
                                case 2: 
                                case 4: {
                                    int n18 = SynthTabbedPaneUI.this.rects[n2 - 1].y + SynthTabbedPaneUI.this.rects[n2 - 1].height;
                                    if (n18 <= n11) break;
                                    int n19 = ((ScrollableTabButton)jComponent).scrollsForward() ? 5 : 1;
                                    ((SynthArrowButton)jComponent).setDirection(n19);
                                    bl2 = true;
                                    n17 = n == 2 ? n10 + n12 - ((Dimension)cloneable).width : n10;
                                    n16 = n19 == 5 ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                    break;
                                }
                                default: {
                                    int n19 = SynthTabbedPaneUI.this.rects[n2 - 1].x + SynthTabbedPaneUI.this.rects[n2 - 1].width;
                                    if (n19 <= n12) break;
                                    int n20 = ((ScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                    ((SynthArrowButton)jComponent).setDirection(n20);
                                    bl2 = true;
                                    n17 = n20 == 3 ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                    n16 = n == 1 ? n9 + n11 - ((Dimension)cloneable).height : n9;
                                }
                            }
                            component3.setVisible(bl2);
                            if (bl2) {
                                component3.setBounds(n17, n16, n15, n14);
                            }
                        } else {
                            component3.setBounds(n8, n7, n6, n5);
                        }
                        ++n13;
                    }
                    if (bl && !SynthTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                        SynthTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        protected void calculateTabRects(int n, int n2) {
            FontMetrics fontMetrics = SynthTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = SynthTabbedPaneUI.this.tabPane.getSize();
            Insets insets = SynthTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = SynthTabbedPaneUI.this.getTabAreaInsets(n);
            int n3 = fontMetrics.getHeight();
            int n4 = SynthTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = SynthLookAndFeel.isLeftToRight(SynthTabbedPaneUI.this.tabPane);
            int n5 = insets2.left;
            int n6 = insets2.top;
            int n7 = 0;
            int n8 = 0;
            switch (n) {
                case 2: 
                case 4: {
                    SynthTabbedPaneUI.this.maxTabWidth = SynthTabbedPaneUI.this.calculateMaxTabWidth(n);
                    break;
                }
                default: {
                    SynthTabbedPaneUI.this.maxTabHeight = SynthTabbedPaneUI.this.calculateMaxTabHeight(n);
                }
            }
            SynthTabbedPaneUI.this.runCount = 0;
            SynthTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            SynthTabbedPaneUI.this.selectedRun = 0;
            SynthTabbedPaneUI.this.runCount = 1;
            int n9 = 0;
            while (n9 < n2) {
                Rectangle rectangle = SynthTabbedPaneUI.this.rects[n9];
                if (!bl) {
                    if (n9 > 0) {
                        rectangle.x = SynthTabbedPaneUI.this.rects[n9 - 1].x + SynthTabbedPaneUI.this.rects[n9 - 1].width;
                    } else {
                        SynthTabbedPaneUI.this.tabRuns[0] = 0;
                        SynthTabbedPaneUI.this.maxTabWidth = 0;
                        n8 += SynthTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n5;
                    }
                    rectangle.width = SynthTabbedPaneUI.this.calculateTabWidth(n, n9, fontMetrics);
                    n7 = rectangle.x + rectangle.width;
                    SynthTabbedPaneUI.this.maxTabWidth = Math.max(SynthTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n6;
                    rectangle.height = SynthTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n9 > 0) {
                        rectangle.y = SynthTabbedPaneUI.this.rects[n9 - 1].y + SynthTabbedPaneUI.this.rects[n9 - 1].height;
                    } else {
                        SynthTabbedPaneUI.this.tabRuns[0] = 0;
                        SynthTabbedPaneUI.this.maxTabHeight = 0;
                        n7 = SynthTabbedPaneUI.this.maxTabWidth;
                        rectangle.y = n6;
                    }
                    rectangle.height = SynthTabbedPaneUI.this.calculateTabHeight(n, n9, n3);
                    n8 = rectangle.y + rectangle.height;
                    SynthTabbedPaneUI.this.maxTabHeight = Math.max(SynthTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    rectangle.x = n5;
                    rectangle.width = SynthTabbedPaneUI.this.maxTabWidth;
                }
                ++n9;
            }
            if (!bl2 && !bl) {
                int n10 = dimension.width - (insets.right + insets2.right);
                n9 = 0;
                while (n9 < n2) {
                    SynthTabbedPaneUI.this.rects[n9].x = n10 - SynthTabbedPaneUI.this.rects[n9].x - SynthTabbedPaneUI.this.rects[n9].width;
                    ++n9;
                }
            }
            ((SynthTabbedPaneUI)SynthTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(n7, n8));
        }
    }

    class TabbedPaneLayout
    implements LayoutManager {
        TabbedPaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean bl) {
            int n = SynthTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = SynthTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = SynthTabbedPaneUI.this.getContentBorderInsets(n);
            Insets insets3 = SynthTabbedPaneUI.this.getTabAreaInsets(n);
            Dimension dimension = new Dimension(0, 0);
            int n2 = insets2.top + insets2.bottom;
            int n3 = insets2.left + insets2.right;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < SynthTabbedPaneUI.this.tabPane.getTabCount()) {
                Component component = SynthTabbedPaneUI.this.tabPane.getComponentAt(n6);
                if (component != null) {
                    Dimension dimension2 = dimension;
                    Dimension dimension3 = dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
                    if (dimension2 != null) {
                        n5 = Math.max(dimension2.height, n5);
                        n4 = Math.max(dimension2.width, n4);
                    }
                }
                ++n6;
            }
            n3 += n4;
            n2 += n5;
            int n7 = 0;
            switch (n) {
                case 2: 
                case 4: {
                    n2 = Math.max(n2, SynthTabbedPaneUI.this.calculateMaxTabHeight(n) + insets3.top + insets3.bottom);
                    n7 = this.preferredTabAreaWidth(n, n2);
                    n3 += n7;
                    break;
                }
                default: {
                    n3 = Math.max(n3, SynthTabbedPaneUI.this.calculateMaxTabWidth(n) + insets3.left + insets3.right);
                    n7 = this.preferredTabAreaHeight(n, n3);
                    n2 += n7;
                }
            }
            return new Dimension(n3 + insets.left + insets.right, n2 + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            FontMetrics fontMetrics = SynthTabbedPaneUI.this.getFontMetrics();
            int n3 = SynthTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = SynthTabbedPaneUI.this.calculateMaxTabHeight(n);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = SynthTabbedPaneUI.this.calculateTabWidth(n, n8, fontMetrics);
                    if (n6 != 0 && n6 + n9 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n9;
                    ++n8;
                }
                n4 = SynthTabbedPaneUI.this.calculateTabAreaHeight(n, n5, n7);
            }
            return n4;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            FontMetrics fontMetrics = SynthTabbedPaneUI.this.getFontMetrics();
            int n3 = SynthTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = fontMetrics.getHeight();
                SynthTabbedPaneUI.this.maxTabWidth = SynthTabbedPaneUI.this.calculateMaxTabWidth(n);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = SynthTabbedPaneUI.this.calculateTabHeight(n, n8, n7);
                    if (n6 != 0 && n6 + n9 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n9;
                    ++n8;
                }
                n4 = SynthTabbedPaneUI.this.calculateTabAreaWidth(n, n5, SynthTabbedPaneUI.this.maxTabWidth);
            }
            return n4;
        }

        public void layoutContainer(Container container) {
            SynthTabbedPaneUI.this.setMouseOverTab(-1);
            int n = SynthTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = SynthTabbedPaneUI.this.tabPane.getInsets();
            int n2 = SynthTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = SynthTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n2 < 0) {
                if (component != null) {
                    SynthTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                int n3 = 0;
                int n4 = 0;
                Insets insets2 = SynthTabbedPaneUI.this.getContentBorderInsets(n);
                Component component2 = SynthTabbedPaneUI.this.tabPane.getComponentAt(n2);
                boolean bl = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    SynthTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Rectangle rectangle = SynthTabbedPaneUI.this.tabPane.getBounds();
                int n5 = SynthTabbedPaneUI.this.tabPane.getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    switch (n) {
                        case 2: {
                            n3 = SynthTabbedPaneUI.this.calculateTabAreaWidth(n, SynthTabbedPaneUI.this.runCount, SynthTabbedPaneUI.this.maxTabWidth);
                            n7 = insets.left + n3 + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        case 4: {
                            n3 = SynthTabbedPaneUI.this.calculateTabAreaWidth(n, SynthTabbedPaneUI.this.runCount, SynthTabbedPaneUI.this.maxTabWidth);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        case 3: {
                            n4 = SynthTabbedPaneUI.this.calculateTabAreaHeight(n, SynthTabbedPaneUI.this.runCount, SynthTabbedPaneUI.this.maxTabHeight);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        default: {
                            n4 = SynthTabbedPaneUI.this.calculateTabAreaHeight(n, SynthTabbedPaneUI.this.runCount, SynthTabbedPaneUI.this.maxTabHeight);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + n4 + insets2.top;
                        }
                    }
                    int n8 = rectangle.width - n3 - insets.left - insets.right - insets2.left - insets2.right;
                    int n9 = rectangle.height - n4 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                    int n10 = 0;
                    while (n10 < n5) {
                        Component component3 = SynthTabbedPaneUI.this.tabPane.getComponent(n10);
                        component3.setBounds(n7, n6, n8, n9);
                        ++n10;
                    }
                }
                if (bl && !SynthTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    SynthTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void calculateLayoutInfo() {
            int n = SynthTabbedPaneUI.this.tabPane.getTabCount();
            SynthTabbedPaneUI.this.assureRectsCreated(n);
            this.calculateTabRects(SynthTabbedPaneUI.this.tabPane.getTabPlacement(), n);
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            FontMetrics fontMetrics = SynthTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = SynthTabbedPaneUI.this.tabPane.getSize();
            Insets insets = SynthTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = SynthTabbedPaneUI.this.getTabAreaInsets(n);
            int n7 = fontMetrics.getHeight();
            int n8 = SynthTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = SynthLookAndFeel.isLeftToRight(SynthTabbedPaneUI.this.tabPane);
            switch (n) {
                case 2: {
                    SynthTabbedPaneUI.this.maxTabWidth = SynthTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    SynthTabbedPaneUI.this.maxTabWidth = SynthTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = dimension.width - insets.right - insets2.right - SynthTabbedPaneUI.this.maxTabWidth;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    SynthTabbedPaneUI.this.maxTabHeight = SynthTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = dimension.height - insets.bottom - insets2.bottom - SynthTabbedPaneUI.this.maxTabHeight;
                    n4 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    SynthTabbedPaneUI.this.maxTabHeight = SynthTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n9 = SynthTabbedPaneUI.this.getTabRunOverlay(n);
            SynthTabbedPaneUI.this.runCount = 0;
            SynthTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            int n10 = 0;
            while (n10 < n2) {
                rectangle = SynthTabbedPaneUI.this.rects[n10];
                if (!bl) {
                    if (n10 > 0) {
                        rectangle.x = SynthTabbedPaneUI.this.rects[n10 - 1].x + SynthTabbedPaneUI.this.rects[n10 - 1].width;
                    } else {
                        SynthTabbedPaneUI.this.tabRuns[0] = 0;
                        SynthTabbedPaneUI.this.runCount = 1;
                        SynthTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n6;
                    }
                    rectangle.width = SynthTabbedPaneUI.this.calculateTabWidth(n, n10, fontMetrics);
                    SynthTabbedPaneUI.this.maxTabWidth = Math.max(SynthTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n4) {
                        if (SynthTabbedPaneUI.this.runCount > SynthTabbedPaneUI.this.tabRuns.length - 1) {
                            SynthTabbedPaneUI.this.expandTabRunsArray();
                        }
                        SynthTabbedPaneUI.this.tabRuns[SynthTabbedPaneUI.this.runCount] = n10;
                        ++SynthTabbedPaneUI.this.runCount;
                        rectangle.x = n6;
                    }
                    rectangle.y = n5;
                    rectangle.height = SynthTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n10 > 0) {
                        rectangle.y = SynthTabbedPaneUI.this.rects[n10 - 1].y + SynthTabbedPaneUI.this.rects[n10 - 1].height;
                    } else {
                        SynthTabbedPaneUI.this.tabRuns[0] = 0;
                        SynthTabbedPaneUI.this.runCount = 1;
                        SynthTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n5;
                    }
                    rectangle.height = SynthTabbedPaneUI.this.calculateTabHeight(n, n10, n7);
                    SynthTabbedPaneUI.this.maxTabHeight = Math.max(SynthTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n4) {
                        if (SynthTabbedPaneUI.this.runCount > SynthTabbedPaneUI.this.tabRuns.length - 1) {
                            SynthTabbedPaneUI.this.expandTabRunsArray();
                        }
                        SynthTabbedPaneUI.this.tabRuns[SynthTabbedPaneUI.this.runCount] = n10;
                        ++SynthTabbedPaneUI.this.runCount;
                        rectangle.y = n5;
                    }
                    rectangle.x = n6;
                    rectangle.width = SynthTabbedPaneUI.this.maxTabWidth;
                }
                if (n10 == n8) {
                    SynthTabbedPaneUI.this.selectedRun = SynthTabbedPaneUI.this.runCount - 1;
                }
                ++n10;
            }
            if (SynthTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n, n2, bl ? n5 : n6, n4);
                SynthTabbedPaneUI.this.selectedRun = SynthTabbedPaneUI.this.getRunForTab(n2, n8);
                if (SynthTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, SynthTabbedPaneUI.this.selectedRun);
                }
            }
            n10 = SynthTabbedPaneUI.this.runCount - 1;
            while (n10 >= 0) {
                int n11;
                int n12;
                n3 = SynthTabbedPaneUI.this.tabRuns[n10];
                int n13 = SynthTabbedPaneUI.this.tabRuns[n10 == SynthTabbedPaneUI.this.runCount - 1 ? 0 : n10 + 1];
                int n14 = n12 = n13 != 0 ? n13 - 1 : n2 - 1;
                if (!bl) {
                    n11 = n3;
                    while (n11 <= n12) {
                        rectangle = SynthTabbedPaneUI.this.rects[n11];
                        rectangle.y = n5;
                        rectangle.x += SynthTabbedPaneUI.this.getTabRunIndent(n, n10);
                        ++n11;
                    }
                    if (SynthTabbedPaneUI.this.shouldPadTabRun(n, n10)) {
                        this.padTabRun(n, n3, n12, n4);
                    }
                    n5 = n == 3 ? (n5 -= SynthTabbedPaneUI.this.maxTabHeight - n9) : (n5 += SynthTabbedPaneUI.this.maxTabHeight - n9);
                } else {
                    n11 = n3;
                    while (n11 <= n12) {
                        rectangle = SynthTabbedPaneUI.this.rects[n11];
                        rectangle.x = n6;
                        rectangle.y += SynthTabbedPaneUI.this.getTabRunIndent(n, n10);
                        ++n11;
                    }
                    if (SynthTabbedPaneUI.this.shouldPadTabRun(n, n10)) {
                        this.padTabRun(n, n3, n12, n4);
                    }
                    n6 = n == 4 ? (n6 -= SynthTabbedPaneUI.this.maxTabWidth - n9) : (n6 += SynthTabbedPaneUI.this.maxTabWidth - n9);
                }
                --n10;
            }
            this.padSelectedTab(n, n8);
            if (!bl2 && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                n10 = 0;
                while (n10 < n2) {
                    SynthTabbedPaneUI.this.rects[n10].x = n3 - SynthTabbedPaneUI.this.rects[n10].x - SynthTabbedPaneUI.this.rects[n10].width;
                    ++n10;
                }
            }
        }

        protected void rotateTabRuns(int n, int n2) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = SynthTabbedPaneUI.this.tabRuns[0];
                int n5 = 1;
                while (n5 < SynthTabbedPaneUI.this.runCount) {
                    SynthTabbedPaneUI.this.tabRuns[n5 - 1] = SynthTabbedPaneUI.this.tabRuns[n5];
                    ++n5;
                }
                SynthTabbedPaneUI.this.tabRuns[SynthTabbedPaneUI.this.runCount - 1] = n4;
                ++n3;
            }
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            boolean bl = n == 2 || n == 4;
            int n5 = SynthTabbedPaneUI.this.runCount - 1;
            boolean bl2 = true;
            double d = 1.25;
            while (bl2) {
                int n6;
                int n7;
                int n8 = SynthTabbedPaneUI.this.lastTabInRun(n2, n5);
                int n9 = SynthTabbedPaneUI.this.lastTabInRun(n2, n5 - 1);
                if (!bl) {
                    n7 = SynthTabbedPaneUI.this.rects[n8].x + SynthTabbedPaneUI.this.rects[n8].width;
                    n6 = (int)((double)SynthTabbedPaneUI.this.maxTabWidth * d);
                } else {
                    n7 = SynthTabbedPaneUI.this.rects[n8].y + SynthTabbedPaneUI.this.rects[n8].height;
                    n6 = (int)((double)SynthTabbedPaneUI.this.maxTabHeight * d * 2.0);
                }
                if (n4 - n7 > n6) {
                    SynthTabbedPaneUI.this.tabRuns[n5] = n9;
                    if (!bl) {
                        SynthTabbedPaneUI.this.rects[n9].x = n3;
                    } else {
                        SynthTabbedPaneUI.this.rects[n9].y = n3;
                    }
                    int n10 = n9 + 1;
                    while (n10 <= n8) {
                        if (!bl) {
                            SynthTabbedPaneUI.this.rects[n10].x = SynthTabbedPaneUI.this.rects[n10 - 1].x + SynthTabbedPaneUI.this.rects[n10 - 1].width;
                        } else {
                            SynthTabbedPaneUI.this.rects[n10].y = SynthTabbedPaneUI.this.rects[n10 - 1].y + SynthTabbedPaneUI.this.rects[n10 - 1].height;
                        }
                        ++n10;
                    }
                } else if (n5 == SynthTabbedPaneUI.this.runCount - 1) {
                    bl2 = false;
                }
                if (n5 - 1 > 0) {
                    --n5;
                    continue;
                }
                n5 = SynthTabbedPaneUI.this.runCount - 1;
                d += 0.25;
            }
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            Rectangle rectangle = SynthTabbedPaneUI.this.rects[n3];
            if (n == 1 || n == 3) {
                int n5 = rectangle.x + rectangle.width - SynthTabbedPaneUI.this.rects[n2].x;
                int n6 = n4 - (rectangle.x + rectangle.width);
                float f = (float)n6 / (float)n5;
                int n7 = n2;
                while (n7 <= n3) {
                    Rectangle rectangle2 = SynthTabbedPaneUI.this.rects[n7];
                    if (n7 > n2) {
                        rectangle2.x = SynthTabbedPaneUI.this.rects[n7 - 1].x + SynthTabbedPaneUI.this.rects[n7 - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f);
                    ++n7;
                }
                rectangle.width = n4 - rectangle.x;
            } else {
                int n8 = rectangle.y + rectangle.height - SynthTabbedPaneUI.this.rects[n2].y;
                int n9 = n4 - (rectangle.y + rectangle.height);
                float f = (float)n9 / (float)n8;
                int n10 = n2;
                while (n10 <= n3) {
                    Rectangle rectangle3 = SynthTabbedPaneUI.this.rects[n10];
                    if (n10 > n2) {
                        rectangle3.y = SynthTabbedPaneUI.this.rects[n10 - 1].y + SynthTabbedPaneUI.this.rects[n10 - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f);
                    ++n10;
                }
                rectangle.height = n4 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n, int n2) {
            if (n2 >= 0) {
                Rectangle rectangle = SynthTabbedPaneUI.this.rects[n2];
                Insets insets = SynthTabbedPaneUI.this.getSelectedTabPadInsets(n);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            if (synthTabbedPaneUI.scrollableTabLayoutEnabled()) {
                synthTabbedPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            if (synthTabbedPaneUI.scrollableTabLayoutEnabled()) {
                synthTabbedPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class SelectFocusIndexAction
    extends AbstractAction {
        private SelectFocusIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            int n = synthTabbedPaneUI.getFocusIndex();
            if (n != -1) {
                jTabbedPane.setSelectedIndex(n);
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof SynthTabbedPaneUI) {
                SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n;
                    int n2 = actionEvent.getActionCommand().charAt(0);
                    if (n2 >= 97 && n2 <= 122) {
                        n2 -= 32;
                    }
                    if ((n = (Integer)synthTabbedPaneUI.mnemonicToIndexMap.get(new Integer(n2))) != null && jTabbedPane.isEnabledAt(n)) {
                        jTabbedPane.setSelectedIndex(n);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.requestFocus();
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                synthTabbedPaneUI.navigateSelectedTab(3);
            } else {
                synthTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                synthTabbedPaneUI.navigateSelectedTab(7);
            } else {
                synthTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(3);
        }
    }
}

