/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsFileChooserUI;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;

public class WindowsFileChooserUI
extends BasicFileChooserUI {
    private static final String[] OS_NAMES = new String[]{"Windows 3.1", "Windows 95", "Windows NT", "Windows 98", "Windows 2000", "Windows Me", "Windows XP"};
    private static int WIN_31 = 0;
    private static int WIN_95 = 1;
    private static int WIN_NT = 2;
    private static int WIN_98 = 3;
    private static int WIN_2k = 4;
    private static int WIN_Me = 5;
    private static int WIN_XP = 6;
    private static String osName = System.getProperty("os.name");
    private static String osVersion = System.getProperty("os.version");
    private static final String OS_NAME = osName.equals(OS_NAMES[WIN_98]) && osVersion.startsWith("4.9") ? "Windows Me" : osName;
    private static final int OS_LEVEL = Arrays.asList(OS_NAMES).indexOf(OS_NAME);
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private ActionListener directoryComboBoxAction = new DirectoryComboBoxAction();
    private Action changeDirectoryAction = new ChangeDirectoryAction();
    private Action startEditFileName = new startEditFileName();
    ActionMap actionMap;
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField filenameTextField;
    private ShortCutPanel shortCutPanel;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                WindowsFileChooserUI.this.applyEdit();
            }
        }
    };
    private boolean smallIconsView = false;
    private Border listViewBorder;
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension hstrut25 = new Dimension(25, 1);
    private static final Dimension vstrut1 = new Dimension(1, 1);
    private static final Dimension vstrut4 = new Dimension(1, 4);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Dimension vstrut6 = new Dimension(1, 6);
    private static final Dimension vstrut8 = new Dimension(1, 8);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 425;
    private static int PREF_HEIGHT = 245;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 425;
    private static int MIN_HEIGHT = 245;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 444;
    private static int LIST_PREF_HEIGHT = 138;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int COLUMN_INSETS = 4;
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    private Action newFolderAction = new WindowsNewFolderAction();
    private File newFolderFile;
    private BasicFileChooserUI.BasicFileView fileView = new WindowsFileView();
    private static Hashtable pclHash = new Hashtable();
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Object;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsFileChooserUI((JFileChooser)jComponent);
    }

    public WindowsFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        Component component = SwingUtilities.findFocusOwner(jFileChooser);
        if (component != null) {
            jFileChooser.requestFocus();
        }
        jFileChooser.removeAll();
    }

    public void installComponents(JFileChooser jFileChooser) {
        Object object;
        JButton jButton;
        Object object2;
        Serializable serializable;
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        XPStyle xPStyle = XPStyle.getXP();
        this.listViewBorder = xPStyle != null ? xPStyle.getBorder("listview") : new BevelBorder(1, UIManager.getColor("ToolBar.highlight"), UIManager.getColor("ToolBar.background"), UIManager.getColor("ToolBar.darkShadow"), UIManager.getColor("ToolBar.shadow"));
        jFileChooser.setBorder(new EmptyBorder(4, 10, 10, 10));
        jFileChooser.setLayout(new BorderLayout(8, 8));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        if (OS_LEVEL >= WIN_2k) {
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        jFileChooser.add((Component)jToolBar, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.lookInLabel.setAlignmentX(0.0f);
        this.lookInLabel.setAlignmentY(0.5f);
        jToolBar.add(Box.createRigidArea(new Dimension(14, 0)));
        jToolBar.add(this.lookInLabel);
        jToolBar.add(Box.createRigidArea(new Dimension(29, 0)));
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        this.directoryComboBox.setMaximumRowCount(8);
        jToolBar.add(this.directoryComboBox);
        jToolBar.add(Box.createRigidArea(hstrut10));
        class ButtonFocusListener
        implements FocusListener {
            private final /* synthetic */ WindowsFileChooserUI this$0;

            ButtonFocusListener(WindowsFileChooserUI windowsFileChooserUI) {
                this.this$0 = windowsFileChooserUI;
            }

            public void focusGained(FocusEvent focusEvent) {
                JButton jButton;
                JButton jButton2 = (JButton)focusEvent.getSource();
                JRootPane jRootPane = jButton2.getRootPane();
                if (jRootPane != null && (jButton = jRootPane.getDefaultButton()) != jButton2) {
                    jRootPane.putClientProperty("temporaryDefaultButton", jButton2);
                    jRootPane.setDefaultButton(jButton2);
                    jRootPane.putClientProperty("temporaryDefaultButton", null);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                JButton jButton;
                JButton jButton2 = (JButton)focusEvent.getSource();
                JRootPane jRootPane = jButton2.getRootPane();
                if (jRootPane != null && jButton2 != (jButton = (JButton)jRootPane.getClientProperty("initialDefaultButton"))) {
                    jRootPane.setDefaultButton(jButton);
                }
            }
        }
        ButtonFocusListener buttonFocusListener = new ButtonFocusListener(this);
        JButton jButton2 = new JButton(this.getChangeToParentDirectoryAction());
        jButton2.setText(null);
        jButton2.setIcon(this.upFolderIcon);
        jButton2.setToolTipText(this.upFolderToolTipText);
        jButton2.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.setFocusPainted(true);
        jToolBar.add(jButton2);
        if (OS_LEVEL < WIN_2k) {
            jToolBar.add(Box.createRigidArea(hstrut10));
            jButton2.addFocusListener(buttonFocusListener);
        }
        if (OS_LEVEL == WIN_98) {
            serializable = fileSystemView.getHomeDirectory();
            object2 = this.homeFolderToolTipText;
            if (fileSystemView.isRoot((File)serializable)) {
                object2 = this.getFileView(jFileChooser).getName((File)serializable);
            }
            jButton = new JButton(this.getFileView(jFileChooser).getIcon((File)serializable));
            jButton.setToolTipText((String)object2);
            jButton.getAccessibleContext().setAccessibleName((String)object2);
            jButton.setAlignmentX(0.0f);
            jButton.setAlignmentY(0.5f);
            jButton.setMargin(shrinkwrap);
            jButton.setFocusPainted(false);
            jButton.addActionListener(this.getGoHomeAction());
            jToolBar.add(jButton);
            jToolBar.add(Box.createRigidArea(hstrut10));
            jButton.addFocusListener(buttonFocusListener);
        }
        jButton = new JButton(this.getNewFolderAction());
        jButton.setText(null);
        jButton.setIcon(this.newFolderIcon);
        jButton.setToolTipText(this.newFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.setFocusPainted(true);
        jToolBar.add(jButton);
        if (OS_LEVEL < WIN_2k) {
            jToolBar.add(Box.createRigidArea(hstrut10));
            jButton.addFocusListener(buttonFocusListener);
        }
        serializable = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;
            private final /* synthetic */ WindowsFileChooserUI this$0;

            ViewButtonListener(WindowsFileChooserUI windowsFileChooserUI, JFileChooser jFileChooser) {
                this.this$0 = windowsFileChooserUI;
                this.fc = jFileChooser;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                JPanel jPanel = WindowsFileChooserUI.access$200(this.this$0);
                if (jToggleButton == WindowsFileChooserUI.access$300(this.this$0)) {
                    if (WindowsFileChooserUI.access$400(this.this$0) == null) {
                        WindowsFileChooserUI.access$402(this.this$0, this.this$0.createDetailsView(this.fc));
                        WindowsFileChooserUI.access$400(this.this$0).setPreferredSize(WindowsFileChooserUI.access$500());
                    }
                    WindowsFileChooserUI.access$202(this.this$0, WindowsFileChooserUI.access$400(this.this$0));
                } else {
                    WindowsFileChooserUI.access$202(this.this$0, WindowsFileChooserUI.access$600(this.this$0));
                }
                if (WindowsFileChooserUI.access$200(this.this$0) != jPanel) {
                    WindowsFileChooserUI.access$700(this.this$0).remove(jPanel);
                    WindowsFileChooserUI.access$700(this.this$0).add((Component)WindowsFileChooserUI.access$200(this.this$0), "Center");
                    WindowsFileChooserUI.access$700(this.this$0).revalidate();
                    WindowsFileChooserUI.access$700(this.this$0).repaint();
                }
            }
        }
        object2 = new ViewButtonListener(this, jFileChooser);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setFocusPainted(true);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener((ActionListener)object2);
        jToolBar.add(this.listViewButton);
        ((ButtonGroup)serializable).add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setFocusPainted(true);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener((ActionListener)object2);
        jToolBar.add(this.detailsViewButton);
        ((ButtonGroup)serializable).add(this.detailsViewButton);
        this.useShellFolder = false;
        Object object3 = fileSystemView.getRoots();
        if (object3 != null && ((File[])object3).length == 1 && (object = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && ((File[])object).length > 0 && object3[0] == object[0]) {
            this.useShellFolder = true;
        }
        if (OS_LEVEL >= WIN_2k && this.useShellFolder) {
            this.shortCutPanel = new ShortCutPanel();
            jFileChooser.add((Component)this.shortCutPanel, "Before");
        }
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(jFileChooser);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        object3 = jFileChooser.getAccessory();
        if (object3 != null) {
            this.getAccessoryPanel().add((Component)object3);
        }
        jFileChooser.add((Component)this.centerPanel, "Center");
        this.getBottomPanel().setLayout(new BoxLayout(this.getBottomPanel(), 2));
        this.centerPanel.add((Component)this.getBottomPanel(), "South");
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 3));
        ((Container)object).add(Box.createRigidArea(vstrut4));
        JLabel jLabel = new JLabel(this.fileNameLabelText);
        jLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jLabel.setAlignmentY(0.0f);
        ((Container)object).add(jLabel);
        ((Container)object).add(Box.createRigidArea(new Dimension(1, 12)));
        JLabel jLabel2 = new JLabel(this.filesOfTypeLabelText);
        jLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        ((Container)object).add(jLabel2);
        this.getBottomPanel().add((Component)object);
        this.getBottomPanel().add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createRigidArea(vstrut8));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.filenameTextField = new JTextField(35){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        jLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!WindowsFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    WindowsFileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        jPanel.add(this.filenameTextField);
        jPanel.add(Box.createRigidArea(vstrut8));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        jLabel2.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel.add(this.filterComboBox);
        this.getBottomPanel().add(jPanel);
        this.getBottomPanel().add(Box.createRigidArea(hstrut10));
        this.getButtonPanel().setLayout(new BoxLayout(this.getButtonPanel(), 1));
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser)){

            public Dimension getMaximumSize() {
                return ((WindowsFileChooserUI)WindowsFileChooserUI.this).approveButton.getPreferredSize().width > ((WindowsFileChooserUI)WindowsFileChooserUI.this).cancelButton.getPreferredSize().width ? WindowsFileChooserUI.this.approveButton.getPreferredSize() : WindowsFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.getButtonPanel().add(Box.createRigidArea(vstrut4));
        this.getButtonPanel().add(this.approveButton);
        this.getButtonPanel().add(Box.createRigidArea(vstrut6));
        this.cancelButton = new JButton(this.cancelButtonText){

            public Dimension getMaximumSize() {
                return ((WindowsFileChooserUI)WindowsFileChooserUI.this).approveButton.getPreferredSize().width > ((WindowsFileChooserUI)WindowsFileChooserUI.this).cancelButton.getPreferredSize().width ? WindowsFileChooserUI.this.approveButton.getPreferredSize() : WindowsFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", locale);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", locale);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", locale);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", locale);
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", locale);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", locale);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", locale);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", locale);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", locale);
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this.actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, this.actionMap);
        BorderWidthPropertyChangeListener borderWidthPropertyChangeListener = new BorderWidthPropertyChangeListener(jFileChooser);
        pclHash.put(jFileChooser, borderWidthPropertyChangeListener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.frame.sizingBorderWidth", borderWidthPropertyChangeListener);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)pclHash.remove(jFileChooser);
        Toolkit.getDefaultToolkit().removePropertyChangeListener("win.frame.sizingBorderWidth", propertyChangeListener);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowsFileChooserUI.this.actionMap.put("changeDirectory", WindowsFileChooserUI.this.changeDirectoryAction);
                if (WindowsFileChooserUI.this.editFile != null) {
                    WindowsFileChooserUI.this.cancelEdit();
                } else {
                    WindowsFileChooserUI.this.getFileChooser().cancelSelection();
                }
            }

            public boolean isEnabled() {
                return WindowsFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        actionMapUIResource.put("changeDirectory", this.changeDirectoryAction);
        actionMapUIResource.put("editFileName", this.startEditFileName);
        return actionMapUIResource;
    }

    private void updateListRowCount() {
        if (this.smallIconsView) {
            this.list.setVisibleRowCount(this.getModel().getSize() / 3);
        } else {
            this.list.setVisibleRowCount(-1);
        }
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        Color color;
        JPanel jPanel = new JPanel(new BorderLayout());
        final JFileChooser jFileChooser2 = jFileChooser;
        this.list = new JList(){

            public int getNextMatch(String string, int n, Position.Bias bias) {
                ListModel listModel = this.getModel();
                int n2 = listModel.getSize();
                if (string == null || n < 0 || n >= n2) {
                    throw new IllegalArgumentException();
                }
                boolean bl = bias == Position.Bias.Backward;
                int n3 = n;
                while (!bl ? n3 < n2 : n3 >= 0) {
                    String string2 = jFileChooser2.getName((File)listModel.getElementAt(n3));
                    if (string2.regionMatches(true, 0, string, 0, string.length())) {
                        return n3;
                    }
                    n3 += bl ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.updateListRowCount();
        this.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                WindowsFileChooserUI.this.updateListRowCount();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                WindowsFileChooserUI.this.updateListRowCount();
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                WindowsFileChooserUI.this.updateListRowCount();
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        this.list.addMouseListener(this.createSingleClickListener(jFileChooser, this.list));
        this.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                File file;
                int n;
                int n2 = listDataEvent.getIndex0();
                if (n2 == (n = listDataEvent.getIndex1()) && (file = (File)WindowsFileChooserUI.this.getModel().getElementAt(n2)).equals(WindowsFileChooserUI.this.newFolderFile)) {
                    new DelayedSelectionUpdater(file);
                    WindowsFileChooserUI.this.newFolderFile = null;
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null && (color = xPStyle.getColor("listview.fillcolor", null)) != null) {
            this.list.setBackground(color);
        }
        if (this.listViewBorder != null) {
            jScrollPane.setBorder(this.listViewBorder);
        }
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        Color color;
        Object object;
        Object object2;
        final JFileChooser jFileChooser2 = jFileChooser;
        JPanel jPanel = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(jFileChooser2);
        this.detailsTable = new JTable(detailsTableModel){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (keyEvent.getKeyCode() == 27 && this.getCellEditor() == null) {
                    jFileChooser2.dispatchEvent(keyEvent);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
        };
        this.detailsTable.setComponentOrientation(jFileChooser2.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.detailsTable.addFocusListener(new FocusHandler());
        Font font = this.detailsTable.getFont();
        this.detailsTable.setRowHeight(Math.max(font.getSize(), 19) + 3);
        TableColumnModel tableColumnModel = this.detailsTable.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[5];
        int n = 0;
        while (n < 5) {
            tableColumnArray[n] = tableColumnModel.getColumn(n);
            object2 = detailsTableModel.getColumnName(n);
            object = this.detailsTable.getTableHeader().getDefaultRenderer();
            int n2 = object.getTableCellRendererComponent((JTable)this.detailsTable, (Object)object2, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
            tableColumnArray[n].setPreferredWidth(Math.max(this.COLUMN_WIDTHS[n], n2 + this.COLUMN_INSETS));
            ++n;
        }
        object2 = new DetailsTableCellRenderer(jFileChooser2);
        this.detailsTable.setDefaultRenderer(class$java$io$File == null ? (class$java$io$File = WindowsFileChooserUI.class$("java.io.File")) : class$java$io$File, (TableCellRenderer)object2);
        this.detailsTable.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = WindowsFileChooserUI.class$("java.util.Date")) : class$java$util$Date, (TableCellRenderer)object2);
        this.detailsTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = WindowsFileChooserUI.class$("java.lang.Object")) : class$java$lang$Object, (TableCellRenderer)object2);
        object = new JTextField();
        ((Component)object).addFocusListener(this.editorFocusListener);
        tableColumnArray[0].setCellEditor(new DefaultCellEditor((JTextField)object, (JTextField)object, jFileChooser2){
            private final /* synthetic */ JTextField val$tf;
            private final /* synthetic */ JFileChooser val$chooser;
            {
                this.val$tf = jTextField2;
                this.val$chooser = jFileChooser;
                super(jTextField);
            }

            public boolean isCellEditable(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    int n = WindowsFileChooserUI.this.detailsTable.rowAtPoint(mouseEvent.getPoint());
                    return mouseEvent.getClickCount() == 1 && WindowsFileChooserUI.this.detailsTable.isRowSelected(n);
                }
                return super.isCellEditable(eventObject);
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                if (object instanceof File) {
                    this.val$tf.setText(this.val$chooser.getName((File)object));
                    this.val$tf.requestFocus();
                    this.val$tf.selectAll();
                }
                return component;
            }
        });
        JList jList = new JList(detailsTableModel.listModel){
            JTable table;
            {
                this.table = WindowsFileChooserUI.this.detailsTable;
            }

            public int locationToIndex(Point point) {
                return this.table.rowAtPoint(point);
            }

            public Rectangle getCellBounds(int n, int n2) {
                Rectangle rectangle = this.table.getCellRect(n, 0, false);
                Rectangle rectangle2 = this.table.getCellRect(n2, 0, false);
                return rectangle.union(rectangle2);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            public Component add(Component component) {
                if (component instanceof JTextField) {
                    return this.table.add(component);
                }
                return super.add(component);
            }

            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            public TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            public void setTransferHandler(TransferHandler transferHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(transferHandler);
                } else {
                    super.setTransferHandler(transferHandler);
                }
            }

            public boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            public void setDragEnabled(boolean bl) {
                if (this.table != null) {
                    this.table.setDragEnabled(bl);
                } else {
                    super.setDragEnabled(bl);
                }
            }
        };
        jList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(jFileChooser2, jList));
        JScrollPane jScrollPane = new JScrollPane(this.detailsTable);
        jScrollPane.setComponentOrientation(jFileChooser2.getComponentOrientation());
        LookAndFeel.installColors(jScrollPane.getViewport(), "Table.background", "Table.foreground");
        jScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                WindowsFileChooserUI.this.fixNameColumnWidth(jScrollPane.getViewport().getSize().width);
                jScrollPane.removeComponentListener(this);
            }
        });
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null && (color = xPStyle.getColor("listview.fillcolor", null)) != null) {
            this.list.setBackground(color);
        }
        if (this.listViewBorder != null) {
            jScrollPane.setBorder(this.listViewBorder);
        }
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void fixNameColumnWidth(int n) {
        TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
        int n2 = this.detailsTable.getPreferredSize().width;
        if (n2 < n) {
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n - n2);
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new BasicFileChooserUI.SelectionListener(){

            /*
             * Unable to fully structure code
             */
            public void valueChanged(ListSelectionEvent var1_1) {
                block10: {
                    block11: {
                        block12: {
                            if (var1_1.getValueIsAdjusting()) break block10;
                            var2_2 = WindowsFileChooserUI.this.getFileChooser();
                            var3_3 = var2_2.getFileSystemView();
                            var4_4 = (JList)var1_1.getSource();
                            if (!var2_2.isMultiSelectionEnabled()) break block11;
                            var5_5 = null;
                            var6_7 = var4_4.getSelectedValues();
                            if (var6_7 == null) break block12;
                            if (var6_7.length != 1 || !((File)var6_7[0]).isDirectory() || !var2_2.isTraversable((File)var6_7[0])) ** GOTO lbl-1000
                            if (var2_2.getFileSelectionMode() == 0 || !var3_3.isFileSystem((File)var6_7[0])) {
                                WindowsFileChooserUI.this.setDirectorySelected(true);
                                WindowsFileChooserUI.access$2500(WindowsFileChooserUI.this, (File)var6_7[0]);
                            } else lbl-1000:
                            // 2 sources

                            {
                                var5_5 = new File[var6_7.length];
                                var7_8 = 0;
                                var8_9 = 0;
                                while (var8_9 < var6_7.length) {
                                    var9_10 = (File[])var6_7[var8_9];
                                    var10_11 = var9_10.isDirectory();
                                    v0 = ShellFolder.disableFileChooserSpeedFix() != false ? var9_10.isFile() : (var11_12 = var10_11 == false);
                                    if (var2_2.isFileSelectionEnabled() && var11_12 || var2_2.isDirectorySelectionEnabled() && var3_3.isFileSystem((File)var9_10) && var10_11) {
                                        var5_5[var7_8++] = var9_10;
                                    }
                                    ++var8_9;
                                }
                                if (var7_8 == 0) {
                                    var5_5 = null;
                                } else if (var7_8 < var6_7.length) {
                                    var9_10 = new File[var7_8];
                                    System.arraycopy(var5_5, 0, var9_10, 0, var7_8);
                                    var5_5 = var9_10;
                                }
                                WindowsFileChooserUI.this.setDirectorySelected(false);
                            }
                        }
                        var2_2.setSelectedFiles(var5_5);
                        break block10;
                    }
                    var5_6 = (File)var4_4.getSelectedValue();
                    if (var5_6 == null || !var5_6.isDirectory() || !var2_2.isTraversable(var5_6)) ** GOTO lbl-1000
                    if (var2_2.getFileSelectionMode() == 0 || !var3_3.isFileSystem(var5_6)) {
                        WindowsFileChooserUI.this.setDirectorySelected(true);
                        WindowsFileChooserUI.access$2600(WindowsFileChooserUI.this, var5_6);
                        var2_2.setSelectedFile(null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        WindowsFileChooserUI.this.setDirectorySelected(false);
                        if (var5_6 != null) {
                            var2_2.setSelectedFile(var5_6);
                        }
                    }
                }
            }
        };
    }

    private MouseListener createSingleClickListener(JFileChooser jFileChooser, JList jList) {
        return new SingleClickListener(jList);
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int n) {
        this.lastIndex = n;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int n) {
        this.actionMap.remove("changeDirectory");
        this.ensureIndexIsVisible(n);
        if (this.listViewPanel.isVisible()) {
            this.editFile = (File)this.getModel().getElementAt(n);
            Rectangle rectangle = this.list.getCellBounds(n, n);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            this.editCell.setText(this.getFileChooser().getName(this.editFile));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            } else {
                this.editCell.setBounds(rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(n, 0);
        }
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    private void applyEdit() {
        this.actionMap.put("changeDirectory", this.changeDirectoryAction);
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser jFileChooser = this.getFileChooser();
            String string = jFileChooser.getName(this.editFile);
            String string2 = this.editFile.getName();
            String string3 = this.editCell.getText().trim();
            if (!string3.equals(string)) {
                FileSystemView fileSystemView;
                File file;
                int n;
                String string4 = string3;
                int n2 = string2.length();
                if (n2 > (n = string.length()) && string2.charAt(n) == '.') {
                    string4 = string3 + string2.substring(n);
                }
                if (!(file = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), string4)).exists() && this.getModel().renameFile(this.editFile, file) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file)) {
                    if (jFileChooser.isMultiSelectionEnabled()) {
                        jFileChooser.setSelectedFiles(new File[]{file});
                    } else {
                        jFileChooser.setSelectedFile(file);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = WindowsFileChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n ? n : dimension.width, dimension.height < WindowsFileChooserUI.PREF_SIZE.height ? WindowsFileChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n, WindowsFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] objectArray = this.getFileChooser().getSelectedFiles();
            Object[] objectArray2 = this.list.getSelectedValues();
            if (ShellFolder.disableFileChooserSpeedFix()) {
                int n;
                int n2;
                int n3;
                int n4 = 0;
                while (n4 < objectArray2.length) {
                    n3 = 0;
                    n2 = 0;
                    while (n2 < objectArray.length) {
                        if (((File)objectArray[n2]).equals(objectArray2[n4])) {
                            n3 = 1;
                            break;
                        }
                        ++n2;
                    }
                    if (n3 == 0 && (n = this.getModel().indexOf(objectArray2[n4])) >= 0) {
                        this.listSelectionModel.removeSelectionInterval(n, n);
                    }
                    ++n4;
                }
                n3 = 0;
                while (n3 < objectArray.length) {
                    int n5;
                    n2 = 0;
                    n = 0;
                    while (n < objectArray2.length) {
                        if (((File)objectArray[n3]).equals(objectArray2[n])) {
                            n2 = 1;
                            break;
                        }
                        ++n;
                    }
                    if (n2 == 0 && (n5 = this.getModel().indexOf(objectArray[n3])) >= 0) {
                        this.listSelectionModel.addSelectionInterval(n5, n5);
                    }
                    ++n3;
                }
            } else {
                this.listSelectionModel.setValueIsAdjusting(true);
                try {
                    int n;
                    Arrays.sort(objectArray);
                    Arrays.sort(objectArray2);
                    int n6 = 0;
                    int n7 = 0;
                    while (n6 < objectArray.length && n7 < objectArray2.length) {
                        int n8;
                        n = ((File)objectArray[n6]).compareTo(objectArray2[n7]);
                        if (n < 0) {
                            n8 = this.getModel().indexOf(objectArray[n6]);
                            this.listSelectionModel.addSelectionInterval(n8, n8);
                            ++n6;
                            continue;
                        }
                        if (n > 0) {
                            n8 = this.getModel().indexOf(objectArray2[n7]);
                            this.listSelectionModel.removeSelectionInterval(n8, n8);
                            ++n7;
                            continue;
                        }
                        ++n6;
                        ++n7;
                    }
                    while (n6 < objectArray.length) {
                        n = this.getModel().indexOf(objectArray[n6]);
                        this.listSelectionModel.addSelectionInterval(n, n);
                        ++n6;
                    }
                    while (n7 < objectArray2.length) {
                        n = this.getModel().indexOf(objectArray2[n7]);
                        this.listSelectionModel.removeSelectionInterval(n, n);
                        ++n7;
                    }
                    Object var9_15 = null;
                    this.listSelectionModel.setValueIsAdjusting(false);
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    this.listSelectionModel.setValueIsAdjusting(false);
                    throw throwable;
                }
            }
        } else {
            int n;
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && (n = this.getModel().indexOf(file)) >= 0) {
                this.listSelectionModel.setSelectionInterval(n, n);
                this.ensureIndexIsVisible(n);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            if (n > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[n]));
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File file = jFileChooser.getCurrentDirectory();
        if (this.shortCutPanel != null) {
            this.shortCutPanel.doDirectoryChanged(file);
        }
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            this.getNewFolderAction().setEnabled(file.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fileSystemView.isRoot(file));
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(file.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    WindowsFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    WindowsFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    WindowsFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    WindowsFileChooserUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    WindowsFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    WindowsFileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    WindowsFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    WindowsFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    WindowsFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    WindowsFileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    WindowsFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                    if (WindowsFileChooserUI.this.detailsTable != null) {
                        WindowsFileChooserUI.this.detailsTable.setComponentOrientation(componentOrientation);
                        WindowsFileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(componentOrientation);
                    }
                } else if (string.equals("ancestor")) {
                    if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                        WindowsFileChooserUI.this.filenameTextField.selectAll();
                        WindowsFileChooserUI.this.filenameTextField.requestFocus();
                    }
                } else if (string.equals("UI") && propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getOldValue() != propertyChangeEvent.getNewValue()) {
                    Component component;
                    Object object = propertyChangeEvent.getSource();
                    JFileChooser jFileChooser = object instanceof JFileChooser ? (JFileChooser)object : null;
                    Component component2 = component = jFileChooser != null ? SwingUtilities.findFocusOwner(jFileChooser) : null;
                    if (component == null || !component.isShowing()) {
                        WindowsFileChooserUI.this.filenameTextField.requestFocus();
                    }
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private void ensureIndexIsVisible(int n) {
        if (n >= 0) {
            this.list.ensureIndexIsVisible(n);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(n, 0, true));
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.ensureIndexIsVisible(this.getModel().indexOf(file));
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    protected void setDirectorySelected(boolean bl) {
        super.setDirectorySelected(bl);
        JFileChooser jFileChooser = this.getFileChooser();
        if (bl) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            this.approveButton.setMnemonic(this.directoryOpenButtonMnemonic);
        } else {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.fileNameString(file));
        }
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    static /* synthetic */ JPanel access$200(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.currentViewPanel;
    }

    static /* synthetic */ JToggleButton access$300(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.detailsViewButton;
    }

    static /* synthetic */ JPanel access$400(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.detailsViewPanel;
    }

    static /* synthetic */ JPanel access$402(WindowsFileChooserUI windowsFileChooserUI, JPanel jPanel) {
        windowsFileChooserUI.detailsViewPanel = jPanel;
        return windowsFileChooserUI.detailsViewPanel;
    }

    static /* synthetic */ Dimension access$500() {
        return LIST_PREF_SIZE;
    }

    static /* synthetic */ JPanel access$202(WindowsFileChooserUI windowsFileChooserUI, JPanel jPanel) {
        windowsFileChooserUI.currentViewPanel = jPanel;
        return windowsFileChooserUI.currentViewPanel;
    }

    static /* synthetic */ JPanel access$600(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.listViewPanel;
    }

    static /* synthetic */ JPanel access$700(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.centerPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$2500(WindowsFileChooserUI windowsFileChooserUI, File file) {
        windowsFileChooserUI.setDirectory(file);
    }

    static /* synthetic */ void access$2600(WindowsFileChooserUI windowsFileChooserUI, File file) {
        windowsFileChooserUI.setDirectory(file);
    }

    protected class WindowsFileView
    extends BasicFileChooserUI.BasicFileView {
        protected WindowsFileView() {
            super(WindowsFileChooserUI.this);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                icon = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(file);
            }
            if (icon == null) {
                icon = super.getIcon(file);
            }
            this.cacheIcon(file, icon);
            return icon;
        }
    }

    private class ChangeDirectoryAction
    extends AbstractAction {
        protected ChangeDirectoryAction() {
            super("changeDirectory");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            JFileChooser jFileChooser = WindowsFileChooserUI.this.getFileChooser();
            file = WindowsFileChooserUI.this.isDirectorySelected() ? WindowsFileChooserUI.this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && file.isDirectory()) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                jFileChooser.setCurrentDirectory(file);
                return;
            }
        }
    }

    private class startEditFileName
    extends AbstractAction {
        private startEditFileName() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = WindowsFileChooserUI.this.getFileChooser();
            WindowsFileChooserUI.this.editFile = WindowsFileChooserUI.this.isDirectorySelected() ? WindowsFileChooserUI.this.getDirectory() : jFileChooser.getSelectedFile();
            if (WindowsFileChooserUI.this.editFile != null) {
                WindowsFileChooserUI.this.editFileName(WindowsFileChooserUI.this.getModel().indexOf(WindowsFileChooserUI.this.editFile));
            }
        }
    }

    protected class DirectoryComboBoxAction
    implements ActionListener {
        protected DirectoryComboBoxAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)WindowsFileChooserUI.this.directoryComboBox.getSelectedItem();
            WindowsFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = WindowsFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                WindowsFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this.filters.length) {
                    if (this.filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    WindowsFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = WindowsFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = WindowsFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directories.clear();
            File[] fileArray = WindowsFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(fileArray));
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                ShellFolder shellFolder;
                File file3 = shellFolder = ShellFolder.getShellFolder(file2);
                Vector<ShellFolder> vector = new Vector<ShellFolder>(10);
                do {
                    vector.addElement((ShellFolder)file3);
                } while ((file3 = ((File)file3).getParentFile()) != null);
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    file3 = (File)vector.get(n2);
                    if (this.directories.contains(file3)) {
                        int n3 = this.directories.indexOf(file3);
                        int n4 = n2 - 1;
                        while (n4 >= 0) {
                            this.directories.insertElementAt(vector.get(n4), n3 + n2 - n4);
                            --n4;
                        }
                        break;
                    }
                    ++n2;
                }
                this.calculateDepths();
                this.setSelectedItem(shellFolder);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            int n = 0;
            while (n < this.depths.length) {
                File file = (File)this.directories.get(n);
                File file2 = file.getParentFile();
                this.depths[n] = 0;
                if (file2 != null) {
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        if (file2.equals((File)this.directories.get(n2))) {
                            this.depths[n] = this.depths[n2] + 1;
                            break;
                        }
                        --n2;
                    }
                }
                ++n;
            }
        }

        public int getDepth(int n) {
            return this.depths != null && n >= 0 && n < this.depths.length ? this.depths[n] : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
            } else {
                this.icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(WindowsFileChooserUI.this.getFileChooser().getName(file));
            this.ii.icon = icon = WindowsFileChooserUI.this.getFileChooser().getIcon(file);
            this.ii.depth = WindowsFileChooserUI.this.directoryComboBoxModel.getDepth(n);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, Math.min(n3, this.getPreferredSize().width + 4), n4);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            File file = (File)object;
            String string = WindowsFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = WindowsFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl) {
                WindowsFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowsFileChooserUI.this.applyEdit();
        }
    }

    protected class WindowsNewFolderAction
    extends BasicFileChooserUI.NewFolderAction {
        protected WindowsNewFolderAction() {
            super(WindowsFileChooserUI.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = WindowsFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getSelectedFile();
            super.actionPerformed(actionEvent);
            File file2 = jFileChooser.getSelectedFile();
            if (file2 != null && !file2.equals(file) && file2.isDirectory()) {
                WindowsFileChooserUI.this.newFolderFile = file2;
            }
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 1) {
                    JFileChooser jFileChooser = WindowsFileChooserUI.this.getFileChooser();
                    int n = this.list.locationToIndex(mouseEvent.getPoint());
                    if ((!jFileChooser.isMultiSelectionEnabled() || jFileChooser.getSelectedFiles().length <= 1) && n >= 0 && this.list.isSelectedIndex(n) && WindowsFileChooserUI.this.getEditIndex() == n && WindowsFileChooserUI.this.editFile == null) {
                        WindowsFileChooserUI.this.editFileName(n);
                    } else if (n >= 0) {
                        WindowsFileChooserUI.this.setEditIndex(n);
                    } else {
                        WindowsFileChooserUI.this.resetEditIndex();
                    }
                } else {
                    WindowsFileChooserUI.this.resetEditIndex();
                }
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        File editFile;

        DelayedSelectionUpdater() {
            this(null);
        }

        DelayedSelectionUpdater(File file) {
            this.editFile = file;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            WindowsFileChooserUI.this.setFileSelected();
            if (this.editFile != null) {
                WindowsFileChooserUI.this.editFileName(WindowsFileChooserUI.this.getModel().indexOf(this.editFile));
                this.editFile = null;
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        ActionMap actionMap = null;
        Action tableAction = null;

        public void focusGained(FocusEvent focusEvent) {
            this.actionMap = SwingUtilities.getUIActionMap(WindowsFileChooserUI.this.detailsTable);
            this.tableAction = this.actionMap.get("selectNextRowCell");
            if (this.actionMap != null) {
                this.actionMap.remove("selectNextRowCell");
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.actionMap = SwingUtilities.getUIActionMap(WindowsFileChooserUI.this.detailsTable);
            if (this.actionMap != null && this.tableAction != null) {
                this.actionMap.put("selectNextRowCell", this.tableAction);
            }
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, Math.min(n3, this.getPreferredSize().width + 4), n4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 1 || n2 == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            if (n2 == 0 && jTable.isRowSelected(n) && jTable.isFocusOwner()) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            this.setValue(object);
            return this;
        }

        public void setValue(Object object) {
            this.setIcon(null);
            if (object instanceof File) {
                File file = (File)object;
                String string = this.chooser.getName(file);
                this.setText(string);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (object instanceof Date) {
                this.setText(object == null ? "" : this.df.format((Date)object));
            } else {
                super.setValue(object);
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        DetailsTableModel(JFileChooser jFileChooser) {
            this.columnNames = new String[]{WindowsFileChooserUI.this.fileNameHeaderText, WindowsFileChooserUI.this.fileSizeHeaderText, WindowsFileChooserUI.this.fileTypeHeaderText, WindowsFileChooserUI.this.fileDateHeaderText, WindowsFileChooserUI.this.fileAttrHeaderText};
            this.chooser = jFileChooser;
            this.listModel = WindowsFileChooserUI.this.getModel();
            this.listModel.addListDataListener(this);
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$io$File == null ? (class$java$io$File = WindowsFileChooserUI.class$("java.io.File")) : class$java$io$File;
                }
                case 3: {
                    return class$java$util$Date == null ? (class$java$util$Date = WindowsFileChooserUI.class$("java.util.Date")) : class$java$util$Date;
                }
            }
            return super.getColumnClass(n);
        }

        public Object getValueAt(int n, int n2) {
            File file = (File)this.listModel.getElementAt(n);
            switch (n2) {
                case 0: {
                    return file;
                }
                case 1: {
                    if (!file.exists() || file.isDirectory()) {
                        return null;
                    }
                    return file.length() / 1024L + 1L + "KB";
                }
                case 2: {
                    if (!file.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(file);
                }
                case 3: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    long l = file.lastModified();
                    return l == 0L ? null : new Date(l);
                }
                case 4: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    String string = "";
                    if (!file.canWrite()) {
                        string = string + "R";
                    }
                    if (file.isHidden()) {
                        string = string + "H";
                    }
                    return string;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                JFileChooser jFileChooser = WindowsFileChooserUI.this.getFileChooser();
                File file = (File)this.getValueAt(n, n2);
                String string = jFileChooser.getName(file);
                String string2 = file.getName();
                String string3 = ((String)object).trim();
                if (!string3.equals(string)) {
                    FileSystemView fileSystemView;
                    File file2;
                    int n3;
                    String string4 = string3;
                    int n4 = string2.length();
                    if (n4 > (n3 = string.length()) && string2.charAt(n3) == '.') {
                        string4 = string3 + string2.substring(n3);
                    }
                    if (!(file2 = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(file.getParentFile(), string4)).exists() && WindowsFileChooserUI.this.getModel().renameFile(file, file2) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file2)) {
                        if (jFileChooser.isMultiSelectionEnabled()) {
                            jFileChooser.setSelectedFiles(new File[]{file2});
                        } else {
                            jFileChooser.setSelectedFile(file2);
                        }
                    }
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }
    }

    class ShortCutPanel
    extends JToolBar
    implements ActionListener {
        JToggleButton[] buttons;
        File[] files;
        XPStyle xp;
        final Dimension buttonSize;

        ShortCutPanel() {
            super(1);
            this.xp = XPStyle.getXP();
            this.buttonSize = new Dimension(83, this.xp != null ? 69 : 54);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            if (this.xp != null) {
                this.putClientProperty("XPStyle.subClass", "placesbar");
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            } else {
                this.setBorder(WindowsFileChooserUI.this.listViewBorder);
            }
            Color color = new Color(UIManager.getColor("ToolBar.shadow").getRGB());
            this.setBackground(color);
            JFileChooser jFileChooser = WindowsFileChooserUI.this.getFileChooser();
            FileSystemView fileSystemView = jFileChooser.getFileSystemView();
            this.files = (File[])ShellFolder.get("fileChooserShortcutPanelFolders");
            this.buttons = new JToggleButton[this.files.length];
            ButtonGroup buttonGroup = new ButtonGroup();
            int n = 0;
            while (n < this.files.length) {
                Serializable serializable;
                String string;
                int n2;
                if (fileSystemView.isFileSystemRoot(this.files[n])) {
                    this.files[n] = fileSystemView.createFileObject(this.files[n].getAbsolutePath());
                }
                if ((n2 = (string = fileSystemView.getSystemDisplayName(this.files[n])).lastIndexOf(File.separatorChar)) >= 0 && n2 < string.length() - 1) {
                    string = string.substring(n2 + 1);
                }
                Icon icon = null;
                if (this.files[n] instanceof ShellFolder) {
                    serializable = (ShellFolder)this.files[n];
                    icon = new ImageIcon(serializable.getIcon(true), serializable.getFolderType());
                } else {
                    icon = fileSystemView.getSystemIcon(this.files[n]);
                }
                this.buttons[n] = new JToggleButton(string, icon);
                if (this.xp != null) {
                    this.buttons[n].setIconTextGap(2);
                    this.buttons[n].setMargin(new Insets(2, 2, 2, 2));
                    this.buttons[n].setText("<html><center>" + string + "</center></html>");
                } else {
                    serializable = new Color(UIManager.getColor("List.selectionForeground").getRGB());
                    this.buttons[n].setBackground(color);
                    this.buttons[n].setForeground((Color)serializable);
                }
                this.buttons[n].setHorizontalTextPosition(0);
                this.buttons[n].setVerticalTextPosition(3);
                this.buttons[n].setAlignmentX(0.5f);
                this.buttons[n].setPreferredSize(this.buttonSize);
                this.buttons[n].setMaximumSize(this.buttonSize);
                this.buttons[n].addActionListener(this);
                this.add(this.buttons[n]);
                if (n < this.files.length - 1 && this.xp != null) {
                    this.add(Box.createRigidArea(vstrut1));
                }
                buttonGroup.add(this.buttons[n]);
                ++n;
            }
            this.doDirectoryChanged(jFileChooser.getCurrentDirectory());
        }

        void doDirectoryChanged(File file) {
            int n = 0;
            while (n < this.buttons.length) {
                this.buttons[n].setSelected(this.files[n].equals(file));
                ++n;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            int n = 0;
            while (n < this.buttons.length) {
                if (jToggleButton == this.buttons[n]) {
                    WindowsFileChooserUI.this.getFileChooser().setCurrentDirectory(this.files[n]);
                    break;
                }
                ++n;
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getMinimumSize();
            Dimension dimension2 = super.getPreferredSize();
            if (dimension.height > dimension2.height) {
                dimension2 = new Dimension(dimension2.width, dimension.height);
            }
            return dimension2;
        }
    }

    private class BorderWidthPropertyChangeListener
    implements PropertyChangeListener {
        JFileChooser fc;

        public BorderWidthPropertyChangeListener(JFileChooser jFileChooser) {
            this.fc = jFileChooser;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ BorderWidthPropertyChangeListener this$1;
                {
                    this.this$1 = borderWidthPropertyChangeListener;
                }

                public void run() {
                    Window window = SwingUtilities.windowForComponent(this.this$1.fc);
                    if (window != null && window.isShowing()) {
                        window.setSize(window.getPreferredSize());
                        window.pack();
                    }
                }
            });
        }
    }
}

