/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsGraphicsUtils {
    public static void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, int n) {
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = abstractButton.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            n2 = -1;
        }
        Color color = abstractButton.getForeground();
        if (buttonModel.isEnabled()) {
            graphics.setColor(color);
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x + n, rectangle.y + fontMetrics.getAscent() + n);
        } else {
            color = UIManager.getColor("Button.disabledForeground");
            Color color2 = UIManager.getColor("Button.disabledShadow");
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                color = xPStyle.getColor("button.pushbutton(disabled).textcolor", color);
            } else {
                if (color2 == null) {
                    color2 = abstractButton.getBackground().darker();
                }
                graphics.setColor(color2);
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
            if (color == null) {
                color = abstractButton.getBackground().brighter();
            }
            graphics.setColor(color);
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }
}

