/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class WindowsMenuBarUI
extends BasicMenuBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuBarUI();
    }

    protected void installDefaults() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            Color color = xPStyle.getColor("sysmetrics.menubar", null);
            if (color != null) {
                uIDefaults.put("MenuBar.background", new ColorUIResource(color));
            }
        } else {
            Object object = uIDefaults.get("MenuBar.classicBackground");
            if (object instanceof Object[] && ((Object[])object).length > 0) {
                uIDefaults.put("MenuBar.background", ((Object[])object)[0]);
            }
        }
        super.installDefaults();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.menuBar);
        if (actionMap == null) {
            actionMap = new ActionMapUIResource();
            SwingUtilities.replaceUIActionMap(this.menuBar, actionMap);
        }
        actionMap.put("takeFocus", new TakeFocus());
    }

    private static class TakeFocus
    extends AbstractAction {
        private TakeFocus() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            JComponent jComponent;
            JComponent jComponent2 = (JMenuBar)actionEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0 && menuElementArray[0] instanceof JMenuBar) {
                jComponent = null;
                object = jComponent2.getParent().getParent();
                while (object != null) {
                    jComponent = this.findMenuBar((Component)object);
                    if (jComponent != null) break;
                    object = object.getParent();
                }
                if (jComponent != null) {
                    jComponent2 = jComponent;
                }
            }
            if ((jComponent = jComponent2.getMenu(0)) != null) {
                object = new MenuElement[]{jComponent2, jComponent};
                menuSelectionManager.setSelectedPath((MenuElement[])object);
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsLookAndFeel.repaintRootPane(jComponent2);
            }
        }

        private JMenuBar findMenuBar(Component component) {
            JMenuBar jMenuBar = null;
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JMenuBar) {
                    jMenuBar = (JMenuBar)componentArray[n];
                    break;
                }
                ++n;
            }
            return jMenuBar;
        }
    }
}

