/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WindowsScrollBarUI
extends BasicScrollBarUI {
    private Grid thumbGrid;
    private Grid highlightGrid;
    private Color thumbFocusColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() != null) {
            this.scrollbar.setBorder(null);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            if (this.scrollbar.getOrientation() == 1) {
                dimension.width = xPStyle.getInt("sysmetrics.scrollbarwidth", 17);
            } else {
                dimension.height = xPStyle.getInt("sysmetrics.scrollbarheight", 17);
            }
        }
        return dimension;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.highlightGrid = null;
        this.thumbGrid = null;
    }

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        Color color = UIManager.getColor("ScrollBar.trackForeground");
        if (color != null && this.trackColor != null) {
            this.thumbGrid = Grid.getGrid(color, this.trackColor);
        }
        if ((color = UIManager.getColor("ScrollBar.trackHighlightForeground")) != null && this.trackHighlightColor != null) {
            this.highlightGrid = Grid.getGrid(color, this.trackHighlightColor);
        }
        this.thumbFocusColor = UIManager.getColor("ScrollBar.focus");
    }

    protected JButton createDecreaseButton(int n) {
        return new WindowsArrowButton(n, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected JButton createIncreaseButton(int n) {
        return new WindowsArrowButton(n, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        boolean bl = this.scrollbar.getOrientation() == 1;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            JScrollBar jScrollBar = (JScrollBar)jComponent;
            int n = 0;
            if (!jScrollBar.isEnabled()) {
                n = 3;
            }
            String string = bl ? "scrollbar.lowertrackvert" : "scrollbar.lowertrackhorz";
            xPStyle.getSkin(string).paintSkin(graphics, rectangle, n);
        } else if (this.thumbGrid == null) {
            super.paintTrack(graphics, jComponent, rectangle);
        } else {
            this.thumbGrid.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.trackHighlight == 1) {
                this.paintDecreaseHighlight(graphics);
            } else if (this.trackHighlight == 2) {
                this.paintIncreaseHighlight(graphics);
            }
        }
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        boolean bl = this.scrollbar.getOrientation() == 1;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            JScrollBar jScrollBar = (JScrollBar)jComponent;
            int n = 0;
            if (!jScrollBar.isEnabled()) {
                n = 3;
            } else if (this.isDragging) {
                n = 2;
            }
            XPStyle.Skin skin = xPStyle.getSkin(bl ? "scrollbar.thumbbtnvert" : "scrollbar.thumbbtnhorz");
            skin.paintSkin(graphics, rectangle, n);
            skin = xPStyle.getSkin(bl ? "scrollbar.grippervert" : "scrollbar.gripperhorz");
            skin.paintSkin(graphics, rectangle.x + (rectangle.width - skin.getWidth()) / 2, rectangle.y + (rectangle.height - skin.getHeight()) / 2, skin.getWidth(), skin.getHeight(), n);
            if (this.scrollbar.hasFocus()) {
                graphics.setColor(this.thumbFocusColor);
                graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            }
        } else {
            super.paintThumb(graphics, jComponent, rectangle);
        }
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(graphics);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            Insets insets = this.scrollbar.getInsets();
            Rectangle rectangle = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                n4 = insets.left;
                n3 = this.decrButton.getY() + this.decrButton.getHeight();
                n2 = this.scrollbar.getWidth() - (insets.left + insets.right);
                n = rectangle.y - n3;
            } else {
                n4 = this.decrButton.getX() + this.decrButton.getHeight();
                n3 = insets.top;
                n2 = rectangle.x - n4;
                n = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(graphics, n4, n3, n2, n);
        }
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(graphics);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            Insets insets = this.scrollbar.getInsets();
            Rectangle rectangle = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                n4 = insets.left;
                n3 = rectangle.y + rectangle.height;
                n2 = this.scrollbar.getWidth() - (insets.left + insets.right);
                n = this.incrButton.getY() - n3;
            } else {
                n4 = rectangle.x + rectangle.width;
                n3 = insets.top;
                n2 = this.incrButton.getX() - n4;
                n = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(graphics, n4, n3, n2, n);
        }
    }

    private static class Grid {
        private static final int BUFFER_SIZE = 64;
        private static HashMap map = new HashMap();
        private BufferedImage image;

        public static Grid getGrid(Color color, Color color2) {
            Grid grid;
            String string = color.getRGB() + " " + color2.getRGB();
            WeakReference weakReference = (WeakReference)map.get(string);
            Grid grid2 = grid = weakReference == null ? null : (Grid)weakReference.get();
            if (grid == null) {
                grid = new Grid(color, color2);
                map.put(string, new WeakReference<Grid>(grid));
            }
            return grid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Grid(Color color, Color color2) {
            int[] nArray = new int[]{color.getRGB(), color2.getRGB()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 2, nArray, 0, false, -1, 0);
            this.image = new BufferedImage(64, 64, 13, indexColorModel);
            Graphics graphics = this.image.getGraphics();
            try {
                graphics.setClip(0, 0, 64, 64);
                this.paintGrid(graphics, color, color2);
                Object var7_6 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                graphics.dispose();
                throw throwable;
            }
        }

        public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = graphics.getClipBounds();
            int n5 = Math.max(n, rectangle.x);
            int n6 = Math.max(n2, rectangle.y);
            int n7 = Math.min(rectangle.x + rectangle.width, n + n3);
            int n8 = Math.min(rectangle.y + rectangle.height, n2 + n4);
            if (n7 <= n5 || n8 <= n6) {
                return;
            }
            int n9 = (n5 - n) % 2;
            int n10 = n5;
            while (n10 < n7) {
                int n11 = (n6 - n2) % 2;
                int n12 = Math.min(64 - n9, n7 - n10);
                int n13 = n6;
                while (n13 < n8) {
                    int n14 = Math.min(64 - n11, n8 - n13);
                    graphics.drawImage(this.image, n10, n13, n10 + n12, n13 + n14, n9, n11, n9 + n12, n11 + n14, null);
                    if (n11 != 0) {
                        n13 -= n11;
                        n11 = 0;
                    }
                    n13 += 64;
                }
                if (n9 != 0) {
                    n10 -= n9;
                    n9 = 0;
                }
                n10 += 64;
            }
        }

        private void paintGrid(Graphics graphics, Color color, Color color2) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            graphics.translate(rectangle.x, rectangle.y);
            int n = rectangle.width;
            int n2 = rectangle.height;
            int n3 = rectangle.x % 2;
            int n4 = n - n2;
            while (n3 < n4) {
                graphics.drawLine(n3, 0, n3 + n2, n2);
                n3 += 2;
            }
            int n5 = n;
            while (n3 < n5) {
                graphics.drawLine(n3, 0, n, n - n3);
                n3 += 2;
            }
            int n6 = rectangle.x % 2 == 0 ? 2 : 1;
            int n7 = n2 - n;
            while (n6 < n7) {
                graphics.drawLine(0, n6, n, n6 + n);
                n6 += 2;
            }
            int n8 = n2;
            while (n6 < n8) {
                graphics.drawLine(0, n6, n2 - n6, n2);
                n6 += 2;
            }
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    private class WindowsArrowButton
    extends BasicArrowButton {
        public WindowsArrowButton(int n, Color color, Color color2, Color color3, Color color4) {
            super(n, color, color2, color3, color4);
        }

        public WindowsArrowButton(int n) {
            super(n);
        }

        public void paint(Graphics graphics) {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                XPStyle.Skin skin = xPStyle.getSkin("scrollbar.arrowbtn");
                int n = 0;
                switch (this.direction) {
                    case 1: {
                        n = 0;
                        break;
                    }
                    case 5: {
                        n = 4;
                        break;
                    }
                    case 7: {
                        n = 8;
                        break;
                    }
                    case 3: {
                        n = 12;
                    }
                }
                skin.paintSkin(graphics, 0, 0, this.getSize().width, this.getSize().height, n);
            } else {
                super.paint(graphics);
            }
        }

        public Dimension getPreferredSize() {
            int n = 16;
            if (WindowsScrollBarUI.this.scrollbar != null) {
                switch (WindowsScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        n = WindowsScrollBarUI.this.scrollbar.getWidth();
                        break;
                    }
                    case 0: {
                        n = WindowsScrollBarUI.this.scrollbar.getHeight();
                    }
                }
                n = Math.max(n, 5);
            }
            return new Dimension(n, n);
        }
    }
}

