/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12NewEventDispatcherAction;
import com.sun.media.sound.JDK12TopmostThreadGroupAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

class EventDispatcher
implements Runnable {
    private static final int AUTO_CLOSE_TIME = 5000;
    private long lastProcessEventTime = System.currentTimeMillis();
    private Vector eventQueue = new Vector();
    private boolean done = false;
    Thread thread = null;
    static boolean creatingThread = false;
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private static ThreadGroup topmostThreadGroup = null;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private ArrayList autoClosingClips = new ArrayList();

    EventDispatcher() {
    }

    private static void initSecurity() {
        securityPrivilege = true;
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
        }
        catch (SecurityException securityException) {
            securityPrivilege = false;
        }
        if (securityPrivilege) {
            if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        Constructor constructor = JDK12TopmostThreadGroupAction.cons;
                        topmostThreadGroup = (ThreadGroup)JDK12.doPrivM.invoke((Object)JDK12.ac, constructor.newInstance(new Object[0]));
                    }
                    catch (Exception exception) {
                        topmostThreadGroup = EventDispatcher.getTopmostThreadGroup();
                    }
                } else {
                    topmostThreadGroup = EventDispatcher.getTopmostThreadGroup();
                }
            }
        } else {
            topmostThreadGroup = Thread.currentThread().getThreadGroup();
        }
    }

    void start() {
        block14: {
            if ((this.thread != null || creatingThread) && !this.done) break block14;
            EventDispatcher.initSecurity();
            EventDispatcher eventDispatcher = this;
            this.done = false;
            if (securityPrivilege && jsSecurity != null) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        creatingThread = true;
                        Constructor constructor = JDK12NewEventDispatcherAction.cons;
                        Object[] objectArray = new Object[]{topmostThreadGroup, eventDispatcher};
                        this.thread = (Thread)JDK12.doPrivM.invoke((Object)JDK12.ac, constructor.newInstance(objectArray));
                        creatingThread = false;
                    }
                    catch (InstantiationException instantiationException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                } else {
                    try {
                        jsSecurity.requestPermission(this.m, this.cl, this.args, 16);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    this.thread = new Thread(topmostThreadGroup, this);
                    this.thread.start();
                }
            } else {
                this.thread = new Thread(topmostThreadGroup, this);
                this.thread.start();
            }
            if (this.thread != null) {
                try {
                    this.thread.setName("Java Sound event dispatcher");
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    protected void processEvent(EventInfo eventInfo) {
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent lineEvent = (LineEvent)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            int n = 0;
            while (n < vector.size()) {
                ((LineListener)vector.elementAt(n)).update(lineEvent);
                ++n;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            int n = 0;
            while (n < vector.size()) {
                ((MetaEventListener)vector.elementAt(n)).meta(metaMessage);
                ++n;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)eventInfo.getEvent();
            int n = shortMessage.getStatus();
            if (n >> 4 == 11) {
                Vector vector = eventInfo.getListeners();
                int n2 = 0;
                while (n2 < vector.size()) {
                    ((ControllerEventListener)vector.elementAt(n2)).controlChange(shortMessage);
                    ++n2;
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                if (!this.done && this.eventQueue.size() == 0) {
                    if (this.autoClosingClips.size() > 0) {
                        this.wait(5100L);
                    } else {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.done = true;
                this.notifyAll();
            }
            if (!this.done && this.eventQueue.size() > 0) {
                eventInfo = (EventInfo)this.eventQueue.elementAt(0);
                this.eventQueue.removeElementAt(0);
            }
        }
        if (!this.done) {
            if (eventInfo != null) {
                this.lastProcessEventTime = System.currentTimeMillis();
                this.processEvent(eventInfo);
            } else {
                long l = System.currentTimeMillis() - this.lastProcessEventTime;
                if (l >= 5000L) {
                    this.closeAutoClosingClips();
                }
            }
        }
    }

    synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.addElement(eventInfo);
        this.notifyAll();
    }

    synchronized void kill() {
        this.done = true;
        this.notifyAll();
    }

    public void run() {
        while (!this.done) {
            try {
                this.dispatchEvents();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void sendAudioEvents(Object object, Vector vector) {
        this.start();
        Vector vector2 = (Vector)vector.clone();
        EventInfo eventInfo = new EventInfo(object, vector2);
        this.postEvent(eventInfo);
    }

    private static ThreadGroup getTopmostThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAutoClosingClips() {
        ArrayList arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            int n = this.autoClosingClips.size() - 1;
            while (n >= 0) {
                AutoClosingClip autoClosingClip = (AutoClosingClip)this.autoClosingClips.get(n);
                if (!autoClosingClip.isOpen() || !autoClosingClip.isAutoClosing()) {
                    this.autoClosingClips.remove(n);
                } else if (!autoClosingClip.isRunning() && !autoClosingClip.isActive() && autoClosingClip.isAutoClosing()) {
                    autoClosingClip.close();
                }
                --n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoClosingClipOpened(AutoClosingClip autoClosingClip) {
        int n = 0;
        ArrayList arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            n = this.autoClosingClips.indexOf(autoClosingClip);
            if (n == -1) {
                this.autoClosingClips.add(autoClosingClip);
            }
        }
        if (n == -1) {
            EventDispatcher eventDispatcher = this;
            synchronized (eventDispatcher) {
                this.notifyAll();
            }
        }
    }

    void autoClosingClipClosed(AutoClosingClip autoClosingClip) {
    }

    class EventInfo {
        private Object event;
        private Vector listeners;

        EventInfo(Object object, Vector vector) {
            this.event = object;
            this.listeners = vector;
        }

        Object getEvent() {
            return this.event;
        }

        Vector getListeners() {
            return this.listeners;
        }
    }
}

