/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import sun.awt.NativeLibLoader;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable,
Accessible {
    boolean state = false;
    transient ItemListener itemListener;
    private static final String base = "chkmenuitem";
    private static int nameCounter;
    private static final long serialVersionUID = 6190621106981774043L;
    private int checkboxMenuItemSerializedDataVersion = 1;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public CheckboxMenuItem() throws HeadlessException {
        this("", false);
    }

    public CheckboxMenuItem(String string) throws HeadlessException {
        this(string, false);
    }

    public CheckboxMenuItem(String string, boolean bl) throws HeadlessException {
        super(string);
        this.state = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createCheckboxMenuItem(this);
            }
            super.addNotify();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean bl) {
        this.state = bl;
        CheckboxMenuItemPeer checkboxMenuItemPeer = (CheckboxMenuItemPeer)this.peer;
        if (checkboxMenuItemPeer != null) {
            checkboxMenuItemPeer.setState(bl);
        }
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.state) {
            Object[] objectArray = new Object[]{this.label};
            return objectArray;
        }
        return null;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = CheckboxMenuItem.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public EventListener[] getListeners(Class clazz) {
        ItemListener itemListener = null;
        if (clazz != (class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = CheckboxMenuItem.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener)) {
            return super.getListeners(clazz);
        }
        itemListener = this.itemListener;
        return AWTEventMulticaster.getListeners(itemListener, clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        ItemListener itemListener = this.itemListener;
        if (itemListener != null) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    void doMenuEvent(long l, int n) {
        this.setState(!this.state);
        Toolkit.getEventQueue().postEvent(new ItemEvent(this, 701, this.getLabel(), this.state ? 1 : 2));
    }

    public String paramString() {
        return super.paramString() + ",state=" + this.state;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCheckboxMenuItem();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NativeLibLoader.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            CheckboxMenuItem.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTCheckboxMenuItem
    extends MenuItem.AccessibleAWTMenuItem
    implements AccessibleAction,
    AccessibleValue {
        protected AccessibleAWTCheckboxMenuItem() {
            super(CheckboxMenuItem.this);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int n) {
            return null;
        }

        public boolean doAccessibleAction(int n) {
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }
    }
}

