/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import sun.awt.font.Decoration;
import sun.awt.font.FontResolver;

final class StyledParagraph {
    private int length;
    private Decoration decoration;
    private Object font;
    private Vector decorations;
    int[] decorationStarts;
    private Vector fonts;
    int[] fontStarts;
    private static int INITIAL_SIZE = 8;

    public StyledParagraph(AttributedCharacterIterator attributedCharacterIterator, char[] cArray) {
        int n;
        int n2 = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        this.length = n3 - n2;
        int n4 = n2;
        attributedCharacterIterator.first();
        do {
            n = attributedCharacterIterator.getRunLimit();
            int n5 = n4 - n2;
            Map map = attributedCharacterIterator.getAttributes();
            map = StyledParagraph.addInputMethodAttrs(map);
            Decoration decoration = Decoration.getDecoration(map);
            this.addDecoration(decoration, n5);
            Object object = StyledParagraph.getGraphicOrFont(map);
            if (object == null) {
                this.addFonts(cArray, map, n5, n - n2);
            } else {
                this.addFont(object, n5);
            }
            attributedCharacterIterator.setIndex(n);
        } while ((n4 = n) < n3);
        if (this.decorations != null) {
            this.decorationStarts = StyledParagraph.addToVector(this, this.length, this.decorations, this.decorationStarts);
        }
        if (this.fonts != null) {
            this.fontStarts = StyledParagraph.addToVector(this, this.length, this.fonts, this.fontStarts);
        }
    }

    private static void insertInto(int n, int[] nArray, int n2) {
        while (nArray[--n2] > n) {
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
    }

    public static StyledParagraph insertChar(AttributedCharacterIterator attributedCharacterIterator, char[] cArray, int n, StyledParagraph styledParagraph) {
        char c = attributedCharacterIterator.setIndex(n);
        int n2 = Math.max(n - attributedCharacterIterator.getBeginIndex() - 1, 0);
        Map map = StyledParagraph.addInputMethodAttrs(attributedCharacterIterator.getAttributes());
        Decoration decoration = Decoration.getDecoration(map);
        if (!styledParagraph.getDecorationAt(n2).equals(decoration)) {
            return new StyledParagraph(attributedCharacterIterator, cArray);
        }
        Object object = StyledParagraph.getGraphicOrFont(map);
        if (object == null) {
            FontResolver fontResolver = FontResolver.getInstance();
            int n3 = fontResolver.getFontIndex(c);
            object = fontResolver.getFont(n3, map);
        }
        if (!styledParagraph.getFontOrGraphicAt(n2).equals(object)) {
            return new StyledParagraph(attributedCharacterIterator, cArray);
        }
        ++styledParagraph.length;
        if (styledParagraph.decorations != null) {
            StyledParagraph.insertInto(n2, styledParagraph.decorationStarts, styledParagraph.decorations.size());
        }
        if (styledParagraph.fonts != null) {
            StyledParagraph.insertInto(n2, styledParagraph.fontStarts, styledParagraph.fonts.size());
        }
        return styledParagraph;
    }

    private static void deleteFrom(int n, int[] nArray, int n2) {
        while (nArray[--n2] > n) {
            int n3 = n2;
            nArray[n3] = nArray[n3] - 1;
        }
    }

    public static StyledParagraph deleteChar(AttributedCharacterIterator attributedCharacterIterator, char[] cArray, int n, StyledParagraph styledParagraph) {
        n -= attributedCharacterIterator.getBeginIndex();
        if (styledParagraph.decorations == null && styledParagraph.fonts == null) {
            --styledParagraph.length;
            return styledParagraph;
        }
        if (styledParagraph.getRunLimit(n) == n + 1 && (n == 0 || styledParagraph.getRunLimit(n - 1) == n)) {
            return new StyledParagraph(attributedCharacterIterator, cArray);
        }
        --styledParagraph.length;
        if (styledParagraph.decorations != null) {
            StyledParagraph.deleteFrom(n, styledParagraph.decorationStarts, styledParagraph.decorations.size());
        }
        if (styledParagraph.fonts != null) {
            StyledParagraph.deleteFrom(n, styledParagraph.fontStarts, styledParagraph.fonts.size());
        }
        return styledParagraph;
    }

    public int getRunLimit(int n) {
        int n2;
        if (n < 0 || n >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        int n3 = this.length;
        if (this.decorations != null) {
            n2 = StyledParagraph.findRunContaining(n, this.decorationStarts);
            n3 = this.decorationStarts[n2 + 1];
        }
        n2 = this.length;
        if (this.fonts != null) {
            int n4 = StyledParagraph.findRunContaining(n, this.fontStarts);
            n2 = this.fontStarts[n4 + 1];
        }
        return Math.min(n3, n2);
    }

    public Decoration getDecorationAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.decorations == null) {
            return this.decoration;
        }
        int n2 = StyledParagraph.findRunContaining(n, this.decorationStarts);
        return (Decoration)this.decorations.elementAt(n2);
    }

    public Object getFontOrGraphicAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.fonts == null) {
            return this.font;
        }
        int n2 = StyledParagraph.findRunContaining(n, this.fontStarts);
        return this.fonts.elementAt(n2);
    }

    private static int findRunContaining(int n, int[] nArray) {
        int n2 = 1;
        while (nArray[n2] <= n) {
            ++n2;
        }
        return n2 - 1;
    }

    private static int[] addToVector(Object object, int n, Vector vector, int[] nArray) {
        if (!vector.lastElement().equals(object)) {
            vector.addElement(object);
            int n2 = vector.size();
            if (nArray.length == n2) {
                int[] nArray2 = new int[nArray.length * 2];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
            }
            nArray[n2 - 1] = n;
        }
        return nArray;
    }

    private void addDecoration(Decoration decoration, int n) {
        if (this.decorations != null) {
            this.decorationStarts = StyledParagraph.addToVector(decoration, n, this.decorations, this.decorationStarts);
        } else if (this.decoration == null) {
            this.decoration = decoration;
        } else if (!this.decoration.equals(decoration)) {
            this.decorations = new Vector(INITIAL_SIZE);
            this.decorations.addElement(this.decoration);
            this.decorations.addElement(decoration);
            this.decorationStarts = new int[INITIAL_SIZE];
            this.decorationStarts[0] = 0;
            this.decorationStarts[1] = n;
        }
    }

    private void addFont(Object object, int n) {
        if (this.fonts != null) {
            this.fontStarts = StyledParagraph.addToVector(object, n, this.fonts, this.fontStarts);
        } else if (this.font == null) {
            this.font = object;
        } else if (!this.font.equals(object)) {
            this.fonts = new Vector(INITIAL_SIZE);
            this.fonts.addElement(this.font);
            this.fonts.addElement(object);
            this.fontStarts = new int[INITIAL_SIZE];
            this.fontStarts[0] = 0;
            this.fontStarts[1] = n;
        }
    }

    private void addFonts(char[] cArray, Map map, int n, int n2) {
        FontResolver fontResolver = FontResolver.getInstance();
        do {
            int n3 = n;
            int n4 = fontResolver.getFontIndex(cArray[n]);
            ++n;
            while (n < n2) {
                if (fontResolver.getFontIndex(cArray[n]) != n4) break;
                ++n;
            }
            this.addFont(fontResolver.getFont(n4, map), n3);
        } while (n < n2);
    }

    static Map addInputMethodAttrs(Map map) {
        block7: {
            Object object = map.get(TextAttribute.INPUT_METHOD_HIGHLIGHT);
            try {
                Object object2;
                if (object == null) break block7;
                if (object instanceof Annotation) {
                    object = ((Annotation)object).getValue();
                }
                InputMethodHighlight inputMethodHighlight = (InputMethodHighlight)object;
                Map map2 = null;
                try {
                    map2 = inputMethodHighlight.getStyle();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                if (map2 == null) {
                    object2 = Toolkit.getDefaultToolkit();
                    map2 = ((Toolkit)object2).mapInputMethodHighlight(inputMethodHighlight);
                }
                if (map2 != null) {
                    object2 = new Hashtable(5, 0.9f);
                    ((Hashtable)object2).putAll(map);
                    ((Hashtable)object2).putAll(map2);
                    return object2;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        return map;
    }

    private static Object getGraphicOrFont(Map map) {
        Object v = map.get(TextAttribute.CHAR_REPLACEMENT);
        if (v != null) {
            return v;
        }
        v = map.get(TextAttribute.FONT);
        if (v != null) {
            return v;
        }
        if (map.get(TextAttribute.FAMILY) != null) {
            return Font.getFont(map);
        }
        return null;
    }
}

