/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;

public class MidiSystem {
    private static final String defaultServicesClassName = "com.sun.media.sound.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.media.sound.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MidiSystem.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$sound$midi$MidiDevice;
    static /* synthetic */ Class class$javax$sound$midi$Receiver;
    static /* synthetic */ Class class$javax$sound$midi$Transmitter;
    static /* synthetic */ Class class$javax$sound$midi$Synthesizer;
    static /* synthetic */ Class class$javax$sound$midi$Sequencer;

    private MidiSystem() {
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        return MidiSystem.getGenericDeviceInfo(class$javax$sound$midi$MidiDevice == null ? (class$javax$sound$midi$MidiDevice = MidiSystem.class$("javax.sound.midi.MidiDevice")) : class$javax$sound$midi$MidiDevice);
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        return (MidiDevice)MidiSystem.getGenericDevice(null, info);
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        return ((MidiDevice)MidiSystem.getGenericDevice(class$javax$sound$midi$Receiver == null ? (class$javax$sound$midi$Receiver = MidiSystem.class$("javax.sound.midi.Receiver")) : class$javax$sound$midi$Receiver, null)).getReceiver();
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        return ((MidiDevice)MidiSystem.getGenericDevice(class$javax$sound$midi$Transmitter == null ? (class$javax$sound$midi$Transmitter = MidiSystem.class$("javax.sound.midi.Transmitter")) : class$javax$sound$midi$Transmitter, null)).getTransmitter();
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        return (Synthesizer)MidiSystem.getGenericDevice(class$javax$sound$midi$Synthesizer == null ? (class$javax$sound$midi$Synthesizer = MidiSystem.class$("javax.sound.midi.Synthesizer")) : class$javax$sound$midi$Synthesizer, null);
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        return (Sequencer)MidiSystem.getGenericDevice(class$javax$sound$midi$Sequencer == null ? (class$javax$sound$midi$Sequencer = MidiSystem.class$("javax.sound.midi.Sequencer")) : class$javax$sound$midi$Sequencer, null);
    }

    public static Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        Vector vector = MidiSystem.getSoundbankReaders();
        int n = vector.size() - 1;
        while (n >= 0) {
            soundbankReader = (SoundbankReader)vector.elementAt(n);
            soundbank = soundbankReader.getSoundbank(inputStream);
            if (soundbank != null) {
                return soundbank;
            }
            --n;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        Vector vector = MidiSystem.getSoundbankReaders();
        int n = vector.size() - 1;
        while (n >= 0) {
            soundbankReader = (SoundbankReader)vector.elementAt(n);
            soundbank = soundbankReader.getSoundbank(uRL);
            if (soundbank != null) {
                return soundbank;
            }
            --n;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return MidiSystem.getSoundbank(fileInputStream);
    }

    public static MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        int n = midiFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                midiFileFormat = midiFileReaderArray[n].getMidiFileFormat(inputStream);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                --n;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("input stream is not a supported file type");
        }
        return midiFileFormat;
    }

    public static MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        int n = midiFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                midiFileFormat = midiFileReaderArray[n].getMidiFileFormat(uRL);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                --n;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("url is not a supported file type");
        }
        return midiFileFormat;
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        int n = midiFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                midiFileFormat = midiFileReaderArray[n].getMidiFileFormat(file);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                --n;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("file is not a supported file type");
        }
        return midiFileFormat;
    }

    public static Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        int n = midiFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                sequence = midiFileReaderArray[n].getSequence(inputStream);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                --n;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from input stream");
        }
        return sequence;
    }

    public static Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        int n = midiFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                sequence = midiFileReaderArray[n].getSequence(uRL);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                --n;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from URL");
        }
        return sequence;
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        int n = midiFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                sequence = midiFileReaderArray[n].getSequence(file);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                --n;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from file");
        }
        return sequence;
    }

    public static int[] getMidiFileTypes() {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        Vector<int[]> vector = new Vector<int[]>();
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        int n3 = 0;
        while (n3 < midiFileWriterArray.length) {
            nArray = midiFileWriterArray[n3].getMidiFileTypes();
            n += nArray.length;
            vector.addElement(nArray);
            ++n3;
        }
        int[] nArray2 = new int[n];
        int n4 = 0;
        while (n4 < vector.size()) {
            nArray = (int[])vector.elementAt(n4);
            int n5 = 0;
            while (n5 < nArray.length) {
                nArray2[n2++] = nArray[n5];
                ++n5;
            }
            ++n4;
        }
        return nArray2;
    }

    public static boolean isFileTypeSupported(int n) {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int n2 = 0;
        while (n2 < midiFileWriterArray.length) {
            if (midiFileWriterArray[n2].isFileTypeSupported(n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int[][] nArrayArray = new int[midiFileWriterArray.length][];
        int[] nArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < midiFileWriterArray.length) {
            nArrayArray[n3] = midiFileWriterArray[n3].getMidiFileTypes(sequence);
            n += nArrayArray[n3].length;
            ++n3;
        }
        nArray = new int[n];
        int n4 = 0;
        while (n4 < midiFileWriterArray.length) {
            int n5 = 0;
            while (n5 < nArrayArray[n4].length) {
                nArray[n2] = nArrayArray[n4][n5];
                ++n2;
                ++n5;
            }
            ++n4;
        }
        return nArray;
    }

    public static boolean isFileTypeSupported(int n, Sequence sequence) {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int n2 = 0;
        while (n2 < midiFileWriterArray.length) {
            if (midiFileWriterArray[n2].isFileTypeSupported(n, sequence)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int n2 = -2;
        int n3 = midiFileWriterArray.length - 1;
        while (n3 >= 0) {
            if (midiFileWriterArray[n3].isFileTypeSupported(n, sequence)) {
                n2 = midiFileWriterArray[n3].write(sequence, n, outputStream);
                break;
            }
            --n3;
        }
        if (n2 == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return n2;
    }

    public static int write(Sequence sequence, int n, File file) throws IOException {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int n2 = -2;
        int n3 = midiFileWriterArray.length - 1;
        while (n3 >= 0) {
            if (midiFileWriterArray[n3].isFileTypeSupported(n, sequence)) {
                n2 = midiFileWriterArray[n3].write(sequence, n, file);
                break;
            }
            --n3;
        }
        if (n2 == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return n2;
    }

    private static synchronized boolean isA(Class clazz, Class clazz2) {
        return clazz2.isAssignableFrom(clazz);
    }

    private static Vector getMidiDeviceProviders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiDeviceProvider");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiDeviceProvider");
        }
        return vector;
    }

    private static Vector getSoundbankReaders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.SoundbankReader");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.SoundbankReader");
        }
        return vector;
    }

    private static MidiFileWriter[] getMidiFileWriters() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiFileWriter");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiFileWriter");
        }
        MidiFileWriter[] midiFileWriterArray = new MidiFileWriter[vector.size()];
        int n = 0;
        while (n < midiFileWriterArray.length) {
            midiFileWriterArray[n] = (MidiFileWriter)vector.elementAt(n);
            ++n;
        }
        return midiFileWriterArray;
    }

    private static MidiFileReader[] getMidiFileReaders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiFileReader");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiFileReader");
        }
        MidiFileReader[] midiFileReaderArray = new MidiFileReader[vector.size()];
        int n = 0;
        while (n < midiFileReaderArray.length) {
            midiFileReaderArray[n] = (MidiFileReader)vector.elementAt(n);
            ++n;
        }
        return midiFileReaderArray;
    }

    private static MidiDevice.Info[] getGenericDeviceInfo(Class clazz) {
        Vector<MidiDevice.Info> vector = new Vector<MidiDevice.Info>();
        Vector vector2 = MidiSystem.getMidiDeviceProviders();
        int n = 0;
        while (n < vector2.size()) {
            MidiDevice.Info[] infoArray = ((MidiDeviceProvider)vector2.elementAt(n)).getDeviceInfo();
            int n2 = 0;
            while (n2 < infoArray.length) {
                MidiDevice midiDevice = ((MidiDeviceProvider)vector2.elementAt(n)).getDevice(infoArray[n2]);
                if (MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver)) {
                    if (midiDevice.getMaxReceivers() != 0) {
                        vector.addElement(infoArray[n2]);
                    }
                } else if (MidiSystem.isA(clazz, class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter)) {
                    if (midiDevice.getMaxTransmitters() != 0) {
                        vector.addElement(infoArray[n2]);
                    }
                } else if (clazz.isInstance(midiDevice)) {
                    vector.addElement(infoArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        MidiDevice.Info[] infoArray = new MidiDevice.Info[vector.size()];
        n = 0;
        while (n < infoArray.length) {
            infoArray[n] = (MidiDevice.Info)vector.elementAt(n);
            ++n;
        }
        return infoArray;
    }

    private static Object getGenericDevice(Class clazz, MidiDevice.Info info) {
        Object var4_2 = null;
        MidiDevice.Info[] infoArray = null;
        Vector vector = new Vector();
        vector = MidiSystem.getMidiDeviceProviders();
        int n = 0;
        while (n < vector.size()) {
            MidiDevice midiDevice;
            int n2;
            infoArray = ((MidiDeviceProvider)vector.elementAt(n)).getDeviceInfo();
            if (info == null) {
                n2 = 0;
                while (n2 < infoArray.length) {
                    midiDevice = ((MidiDeviceProvider)vector.elementAt(n)).getDevice(infoArray[n2]);
                    if (MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver)) {
                        if (midiDevice.getMaxReceivers() != 0) {
                            return midiDevice;
                        }
                    } else {
                        Class clazz2 = class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter;
                        if (MidiSystem.isA(clazz, clazz2) ? midiDevice.getMaxTransmitters() != 0 : clazz.isInstance(midiDevice)) {
                            return midiDevice;
                        }
                    }
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < infoArray.length) {
                    if (infoArray[n2].equals(info)) {
                        midiDevice = ((MidiDeviceProvider)vector.elementAt(n)).getDevice(infoArray[n2]);
                        if (clazz == null) {
                            return midiDevice;
                        }
                        if (MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver) ? midiDevice.getMaxReceivers() != 0 : MidiSystem.isA(clazz, class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter) && midiDevice.getMaxTransmitters() != 0) {
                            return midiDevice;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        throw new IllegalArgumentException("Requested device not installed: " + info);
    }

    private static Vector getJDK13Services(String string) {
        Vector vector = null;
        try {
            Class<?> clazz = Class.forName(jdk13ServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    private static Vector getDefaultServices(String string) {
        Vector vector = null;
        try {
            Class<?> clazz = Class.forName(defaultServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

