/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.Spring;

public class SpringLayout
implements LayoutManager2 {
    private Map componentConstraints = new HashMap();
    private Spring cyclicReference = Spring.constant(Integer.MIN_VALUE);
    private Set cyclicSprings;
    private Set acyclicSprings;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    static /* synthetic */ Class class$javax$swing$SpringLayout;

    private void resetCyclicStatuses() {
        this.cyclicSprings = new HashSet();
        this.acyclicSprings = new HashSet();
    }

    private void setParent(Container container) {
        this.resetCyclicStatuses();
        Constraints constraints = this.getConstraints(container);
        constraints.setX(Spring.constant(0));
        constraints.setY(Spring.constant(0));
        constraints.setWidth(null);
        constraints.setHeight(null);
        if (constraints.getEast() == null) {
            constraints.setEast(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        if (constraints.getSouth() == null) {
            constraints.setSouth(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
    }

    boolean isCyclic(Spring spring) {
        if (spring == null) {
            return false;
        }
        if (this.cyclicSprings.contains(spring)) {
            return true;
        }
        if (this.acyclicSprings.contains(spring)) {
            return false;
        }
        this.cyclicSprings.add(spring);
        boolean bl = spring.isCyclic(this);
        if (!bl) {
            this.acyclicSprings.add(spring);
            this.cyclicSprings.remove(spring);
        } else {
            System.err.println(spring + " is cyclic. ");
        }
        return bl;
    }

    private Spring abandonCycles(Spring spring) {
        return this.isCyclic(spring) ? this.cyclicReference : spring;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        this.componentConstraints.remove(component);
    }

    private static Dimension addInsets(int n, int n2, Container container) {
        Insets insets = container.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getMinimumValue(), this.abandonCycles(constraints.getHeight()).getMinimumValue(), container);
    }

    public Dimension preferredLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getPreferredValue(), this.abandonCycles(constraints.getHeight()).getPreferredValue(), container);
    }

    public Dimension maximumLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getMaximumValue(), this.abandonCycles(constraints.getHeight()).getMaximumValue(), container);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof Constraints) {
            this.putConstraints(component, (Constraints)object);
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void putConstraint(String string, Component component, int n, String string2, Component component2) {
        this.putConstraint(string, component, Spring.constant(n), string2, component2);
    }

    public void putConstraint(String string, Component component, Spring spring, String string2, Component component2) {
        this.putConstraint(string, component, Spring.sum(spring, this.getConstraint(string2, component2)));
    }

    private void putConstraint(String string, Component component, Spring spring) {
        if (spring != null) {
            this.getConstraints(component).setConstraint(string, spring);
        }
    }

    private Constraints applyDefaults(Component component, Constraints constraints) {
        if (constraints == null) {
            constraints = new Constraints();
        }
        if (constraints.getWidth() == null) {
            constraints.setWidth(new WidthSpring(component));
        }
        if (constraints.getHeight() == null) {
            constraints.setHeight(new HeightSpring(component));
        }
        if (constraints.getX() == null) {
            constraints.setX(Spring.constant(0));
        }
        if (constraints.getY() == null) {
            constraints.setY(Spring.constant(0));
        }
        return constraints;
    }

    private void putConstraints(Component component, Constraints constraints) {
        this.componentConstraints.put(component, this.applyDefaults(component, constraints));
    }

    public Constraints getConstraints(Component component) {
        Constraints constraints = (Constraints)this.componentConstraints.get(component);
        if (constraints == null) {
            Object object;
            if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(class$javax$swing$SpringLayout == null ? (class$javax$swing$SpringLayout = SpringLayout.class$("javax.swing.SpringLayout")) : class$javax$swing$SpringLayout)) instanceof Constraints) {
                return this.applyDefaults(component, (Constraints)object);
            }
            constraints = new Constraints();
            this.putConstraints(component, constraints);
        }
        return constraints;
    }

    public Spring getConstraint(String string, Component component) {
        string = string.intern();
        return new SpringProxy(string, component, this);
    }

    public void layoutContainer(Container container) {
        this.setParent(container);
        int n = container.getComponentCount();
        this.getConstraints(container).reset();
        int n2 = 0;
        while (n2 < n) {
            this.getConstraints(container.getComponent(n2)).reset();
            ++n2;
        }
        Insets insets = container.getInsets();
        Constraints constraints = this.getConstraints(container);
        this.abandonCycles(constraints.getX()).setValue(0);
        this.abandonCycles(constraints.getY()).setValue(0);
        this.abandonCycles(constraints.getWidth()).setValue(container.getWidth() - insets.left - insets.right);
        this.abandonCycles(constraints.getHeight()).setValue(container.getHeight() - insets.top - insets.bottom);
        int n3 = 0;
        while (n3 < n) {
            Component component = container.getComponent(n3);
            Constraints constraints2 = this.getConstraints(component);
            int n4 = this.abandonCycles(constraints2.getX()).getValue();
            int n5 = this.abandonCycles(constraints2.getY()).getValue();
            int n6 = this.abandonCycles(constraints2.getWidth()).getValue();
            int n7 = this.abandonCycles(constraints2.getHeight()).getValue();
            component.setBounds(insets.left + n4, insets.top + n5, n6, n7);
            ++n3;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SpringProxy
    extends Spring {
        private String edgeName;
        private Component c;
        private SpringLayout l;

        public SpringProxy(String string, Component component, SpringLayout springLayout) {
            this.edgeName = string;
            this.c = component;
            this.l = springLayout;
        }

        private Spring getConstraint() {
            return this.l.getConstraints(this.c).getConstraint(this.edgeName);
        }

        public int getMinimumValue() {
            return this.getConstraint().getMinimumValue();
        }

        public int getPreferredValue() {
            return this.getConstraint().getPreferredValue();
        }

        public int getMaximumValue() {
            return this.getConstraint().getMaximumValue();
        }

        public int getValue() {
            return this.getConstraint().getValue();
        }

        public void setValue(int n) {
            this.getConstraint().setValue(n);
        }

        boolean isCyclic(SpringLayout springLayout) {
            return springLayout.isCyclic(this.getConstraint());
        }

        public String toString() {
            return "SpringProxy for " + this.edgeName + " edge of " + this.c.getName() + ".";
        }
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring width;
        private Spring height;
        private Spring east;
        private Spring south;
        private Spring verticalDerived = null;
        private Spring horizontalDerived = null;

        public Constraints() {
            this(null, null, null, null);
        }

        public Constraints(Spring spring, Spring spring2) {
            this(spring, spring2, null, null);
        }

        public Constraints(Spring spring, Spring spring2, Spring spring3, Spring spring4) {
            this.x = spring;
            this.y = spring2;
            this.width = spring3;
            this.height = spring4;
        }

        private boolean overConstrainedHorizontally() {
            return this.x != null && this.width != null && this.east != null;
        }

        private boolean overConstrainedVertically() {
            return this.y != null && this.height != null && this.south != null;
        }

        private Spring sum(Spring spring, Spring spring2) {
            return spring == null || spring2 == null ? null : Spring.sum(spring, spring2);
        }

        private Spring difference(Spring spring, Spring spring2) {
            return spring == null || spring2 == null ? null : Spring.difference(spring, spring2);
        }

        public void setX(Spring spring) {
            this.x = spring;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.width = null;
            }
        }

        public Spring getX() {
            if (this.x != null) {
                return this.x;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.difference(this.east, this.width);
            }
            return this.horizontalDerived;
        }

        public void setY(Spring spring) {
            this.y = spring;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.height = null;
            }
        }

        public Spring getY() {
            if (this.y != null) {
                return this.y;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.difference(this.south, this.height);
            }
            return this.verticalDerived;
        }

        public void setWidth(Spring spring) {
            this.width = spring;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.east = null;
            }
        }

        public Spring getWidth() {
            if (this.width != null) {
                return this.width;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.difference(this.east, this.x);
            }
            return this.horizontalDerived;
        }

        public void setHeight(Spring spring) {
            this.height = spring;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.south = null;
            }
        }

        public Spring getHeight() {
            if (this.height != null) {
                return this.height;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.difference(this.south, this.y);
            }
            return this.verticalDerived;
        }

        private void setEast(Spring spring) {
            this.east = spring;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.x = null;
            }
        }

        private Spring getEast() {
            if (this.east != null) {
                return this.east;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.sum(this.x, this.width);
            }
            return this.horizontalDerived;
        }

        private void setSouth(Spring spring) {
            this.south = spring;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.y = null;
            }
        }

        private Spring getSouth() {
            if (this.south != null) {
                return this.south;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.sum(this.y, this.height);
            }
            return this.verticalDerived;
        }

        public void setConstraint(String string, Spring spring) {
            if ((string = string.intern()) == SpringLayout.WEST) {
                this.setX(spring);
            } else if (string == SpringLayout.NORTH) {
                this.setY(spring);
            } else if (string == SpringLayout.EAST) {
                this.setEast(spring);
            } else if (string == SpringLayout.SOUTH) {
                this.setSouth(spring);
            }
        }

        public Spring getConstraint(String string) {
            return (string = string.intern()) == SpringLayout.WEST ? this.getX() : (string == SpringLayout.NORTH ? this.getY() : (string == SpringLayout.EAST ? this.getEast() : (string == SpringLayout.SOUTH ? this.getSouth() : null)));
        }

        void reset() {
            if (this.x != null) {
                this.x.setValue(Integer.MIN_VALUE);
            }
            if (this.y != null) {
                this.y.setValue(Integer.MIN_VALUE);
            }
            if (this.width != null) {
                this.width.setValue(Integer.MIN_VALUE);
            }
            if (this.height != null) {
                this.height.setValue(Integer.MIN_VALUE);
            }
            if (this.east != null) {
                this.east.setValue(Integer.MIN_VALUE);
            }
            if (this.south != null) {
                this.south.setValue(Integer.MIN_VALUE);
            }
            if (this.horizontalDerived != null) {
                this.horizontalDerived.setValue(Integer.MIN_VALUE);
            }
            if (this.verticalDerived != null) {
                this.verticalDerived.setValue(Integer.MIN_VALUE);
            }
        }
    }

    private static class HeightSpring
    extends Spring.AbstractSpring {
        private Component c;

        public HeightSpring(Component component) {
            this.c = component;
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().height;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().height;
        }

        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().height);
        }
    }

    private static class WidthSpring
    extends Spring.AbstractSpring {
        private Component c;

        public WidthSpring(Component component) {
            this.c = component;
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().width;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().width;
        }

        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().width);
        }
    }
}

