/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import javax.swing.SwingUtilities;
import javax.swing.SystemEventQueueUtilities;
import javax.swing.Timer;

class TimerQueue
implements Runnable {
    private static final Object sharedInstanceKey = new StringBuffer("TimerQueue.sharedInstanceKey");
    private static final Object expiredTimersKey = new StringBuffer("TimerQueue.expiredTimersKey");
    Timer firstTimer;
    boolean running;
    private static final Object classLock = new Object();

    public TimerQueue() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue sharedInstance() {
        Object object = classLock;
        synchronized (object) {
            TimerQueue timerQueue = (TimerQueue)SwingUtilities.appContextGet(sharedInstanceKey);
            if (timerQueue == null) {
                timerQueue = new TimerQueue();
                SwingUtilities.appContextPut(sharedInstanceKey, timerQueue);
            }
            return timerQueue;
        }
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        SwingUtilities.doPrivileged(new Runnable(){

            public void run() {
                Thread thread = new Thread((Runnable)TimerQueue.this, "TimerQueue");
                thread.setDaemon(true);
                thread.setPriority(5);
                thread.start();
            }
        });
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    synchronized void addTimer(Timer timer, long l) {
        if (timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        while (timer3 != null) {
            if (timer3.expirationTime > l) break;
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (timer2 == null) {
            this.firstTimer = timer;
        } else {
            timer2.nextTimer = timer;
        }
        timer.expirationTime = l;
        timer.nextTimer = timer3;
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        boolean bl = false;
        while (timer3 != null) {
            if (timer3 == timer) {
                bl = true;
                break;
            }
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (!bl) {
            return;
        }
        if (timer2 == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            timer2.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long l;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long l2 = System.currentTimeMillis();
            l = timer.expirationTime - l2;
            if (l > 0L) continue;
            try {
                timer.post();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.removeTimer(timer);
            if (timer.isRepeats()) {
                this.addTimer(timer, l2 + (long)timer.getDelay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (l <= 0L);
        return l;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        while (true) {
            while (true) {
                if (!this.running) {
                    return;
                }
                var1_1 = this.postExpiredTimers();
                try {
                    this.wait(var1_1);
                }
                catch (InterruptedException var3_2) {
                    // empty catch block
                }
            }
            break;
        }
        catch (ThreadDeath var3_3) {
            this.running = false;
            var4_4 = this.firstTimer;
            ** while (var4_4 != null)
        }
lbl-1000:
        // 1 sources

        {
            var4_4.cancelEvent();
            var4_4 = var4_4.nextTimer;
            continue;
        }
lbl20:
        // 1 sources

        SystemEventQueueUtilities.restartTimerQueueThread();
        throw var3_3;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimerQueue (");
        Timer timer = this.firstTimer;
        while (timer != null) {
            stringBuffer.append(timer.toString());
            timer = timer.nextTimer;
            if (timer == null) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

