/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class UIDefaults
extends Hashtable {
    private static final Object PENDING = new String("Pending");
    private SwingPropertyChangeSupport changeSupport;
    private Vector resourceBundles;
    private Locale defaultLocale = Locale.getDefault();
    private Map resourceCache;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$java$awt$Color;

    public UIDefaults() {
        this.resourceCache = new HashMap();
    }

    public UIDefaults(Object[] objectArray) {
        super(objectArray.length / 2);
        int n = 0;
        while (n < objectArray.length) {
            super.put(objectArray[n], objectArray[n + 1]);
            n += 2;
        }
    }

    public Object get(Object object) {
        Object object2 = this.getFromHashtable(object);
        return object2 != null ? object2 : this.getFromResourceBundle(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromHashtable(Object object) {
        Object object2 = super.get(object);
        if (object2 != PENDING && !(object2 instanceof ActiveValue) && !(object2 instanceof LazyValue)) {
            return object2;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            object2 = super.get(object);
            if (object2 == PENDING) {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((object2 = super.get(object)) == PENDING);
                return object2;
            }
            if (object2 instanceof LazyValue) {
                super.put(object, PENDING);
            } else if (!(object2 instanceof ActiveValue)) {
                return object2;
            }
        }
        if (object2 instanceof LazyValue) {
            try {
                object2 = ((LazyValue)object2).createValue(this);
            }
            finally {
                UIDefaults uIDefaults2 = this;
                synchronized (uIDefaults2) {
                    if (object2 == null) {
                        super.remove(object);
                    } else {
                        super.put(object, object2);
                    }
                    this.notifyAll();
                }
            }
        }
        object2 = ((ActiveValue)object2).createValue(this);
        return object2;
    }

    public Object get(Object object, Locale locale) {
        Object object2 = this.getFromHashtable(object);
        return object2 != null ? object2 : this.getFromResourceBundle(object, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromResourceBundle(Object object, Locale locale) {
        if (this.resourceBundles == null || this.resourceBundles.isEmpty() || !(object instanceof String)) {
            return null;
        }
        if (locale == null) {
            if (this.defaultLocale == null) {
                return null;
            }
            locale = this.defaultLocale;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            return this.getResourceCache(locale).get((String)object);
        }
    }

    private Map getResourceCache(Locale locale) {
        HashMap<String, Object> hashMap = (HashMap<String, Object>)this.resourceCache.get(locale);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            int n = this.resourceBundles.size() - 1;
            while (n >= 0) {
                String string = (String)this.resourceBundles.get(n);
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
                    Enumeration<String> enumeration = resourceBundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = enumeration.nextElement();
                        if (hashMap.get(string2) != null) continue;
                        Object object = resourceBundle.getObject(string2);
                        hashMap.put(string2, object);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                --n;
            }
            this.resourceCache.put(locale, hashMap);
        }
        return hashMap;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        Object object4 = object3 = object2 == null ? super.remove(object) : super.put(object, object2);
        if (object instanceof String) {
            this.firePropertyChange((String)object, object3, object2);
        }
        return object3;
    }

    public void putDefaults(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n + 1];
            if (object == null) {
                super.remove(objectArray[n]);
            } else {
                super.put(objectArray[n], object);
            }
            n += 2;
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    public Font getFont(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public Font getFont(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public Color getColor(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public Color getColor(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public Icon getIcon(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public Icon getIcon(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public Border getBorder(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public Border getBorder(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public String getString(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof String ? (String)object2 : null;
    }

    public String getString(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof String ? (String)object2 : null;
    }

    public int getInt(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            String string = (String)object2;
            int n = 0;
            if (string.length() == 1 && ((n = (int)Character.toUpperCase(string.charAt(0))) < 65 || n > 90)) {
                n = 0;
            }
            return n;
        }
        return 0;
    }

    public int getInt(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            String string = (String)object2;
            int n = 0;
            if (string.length() == 1 && ((n = (int)Character.toUpperCase(string.charAt(0))) < 65 || n > 90)) {
                n = 0;
            }
            return n;
        }
        return 0;
    }

    public boolean getBoolean(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Boolean ? (Boolean)object2 : false;
    }

    public boolean getBoolean(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Boolean ? (Boolean)object2 : false;
    }

    public Insets getInsets(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public Insets getInsets(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public Dimension getDimension(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public Dimension getDimension(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public Class getUIClass(String string, ClassLoader classLoader) {
        try {
            String string2 = (String)this.get(string);
            if (string2 != null) {
                Class<Object> clazz = (Class<?>)this.get(string2);
                if (clazz == null && (clazz = classLoader == null ? SwingUtilities.loadSystemClass(string2) : classLoader.loadClass(string2)) != null) {
                    this.put(string2, clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return null;
    }

    public Class getUIClass(String string) {
        return this.getUIClass(string, null);
    }

    protected void getUIError(String string) {
        System.err.println("UIDefaults.getUI() failed: " + string);
        try {
            throw new Error();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public ComponentUI getUI(JComponent jComponent) {
        Object object = this.get("ClassLoader");
        ClassLoader classLoader = object != null ? (ClassLoader)object : jComponent.getClass().getClassLoader();
        Class clazz = this.getUIClass(jComponent.getUIClassID(), classLoader);
        Object object2 = null;
        if (clazz == null) {
            this.getUIError("no ComponentUI class for: " + jComponent);
        } else {
            try {
                Method method = (Method)this.get(clazz);
                if (method == null) {
                    Class clazz2 = class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = UIDefaults.class$("javax.swing.JComponent")) : class$javax$swing$JComponent;
                    method = clazz.getMethod("createUI", clazz2);
                    this.put(clazz, method);
                }
                object2 = method.invoke(null, jComponent);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getUIError("static createUI() method not found in " + clazz);
            }
            catch (Exception exception) {
                this.getUIError("createUI() failed for " + jComponent + " " + exception);
            }
        }
        return (ComponentUI)object2;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public synchronized void addResourceBundle(String string) {
        if (string == null) {
            return;
        }
        if (this.resourceBundles == null) {
            this.resourceBundles = new Vector(5);
        }
        this.resourceBundles.add(string);
        this.resourceCache.clear();
    }

    public synchronized void removeResourceBundle(String string) {
        if (this.resourceBundles != null) {
            this.resourceBundles.remove(string);
        }
        this.resourceCache.clear();
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LazyInputMap
    implements LazyValue {
        private Object[] bindings;

        public LazyInputMap(Object[] objectArray) {
            this.bindings = objectArray;
        }

        public Object createValue(UIDefaults uIDefaults) {
            if (this.bindings != null) {
                InputMap inputMap = LookAndFeel.makeInputMap(this.bindings);
                return inputMap;
            }
            return null;
        }
    }

    public static class ProxyLazyValue
    implements LazyValue {
        private AccessControlContext acc = AccessController.getContext();
        private String className;
        private String methodName;
        private Object[] args;

        public ProxyLazyValue(String string) {
            this(string, (String)null);
        }

        public ProxyLazyValue(String string, String string2) {
            this(string, string2, null);
        }

        public ProxyLazyValue(String string, Object[] objectArray) {
            this(string, null, objectArray);
        }

        public ProxyLazyValue(String string, String string2, Object[] objectArray) {
            this.className = string;
            this.methodName = string2;
            if (objectArray != null) {
                this.args = (Object[])objectArray.clone();
            }
        }

        public Object createValue(UIDefaults uIDefaults) {
            return AccessController.doPrivileged(new PrivilegedAction(this, uIDefaults){
                private final /* synthetic */ UIDefaults val$table;
                private final /* synthetic */ ProxyLazyValue this$0;
                {
                    this.this$0 = proxyLazyValue;
                    this.val$table = uIDefaults;
                }

                public Object run() {
                    try {
                        Object object;
                        if (!(this.val$table != null && (object = this.val$table.get("ClassLoader")) instanceof ClassLoader || (object = Thread.currentThread().getContextClassLoader()) != null)) {
                            object = ClassLoader.getSystemClassLoader();
                        }
                        Class<?> clazz = Class.forName(ProxyLazyValue.access$000(this.this$0), true, (ClassLoader)object);
                        if (ProxyLazyValue.access$100(this.this$0) != null) {
                            Class[] classArray = ProxyLazyValue.access$300(this.this$0, ProxyLazyValue.access$200(this.this$0));
                            Method method = clazz.getMethod(ProxyLazyValue.access$100(this.this$0), classArray);
                            return method.invoke(clazz, ProxyLazyValue.access$200(this.this$0));
                        }
                        Class[] classArray = ProxyLazyValue.access$300(this.this$0, ProxyLazyValue.access$200(this.this$0));
                        Constructor<?> constructor = clazz.getConstructor(classArray);
                        return constructor.newInstance(ProxyLazyValue.access$200(this.this$0));
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }, this.acc);
        }

        private Class[] getClassArray(Object[] objectArray) {
            Class[] classArray = null;
            if (objectArray != null) {
                classArray = new Class[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    classArray[n] = objectArray[n] instanceof Integer ? Integer.TYPE : (objectArray[n] instanceof Boolean ? Boolean.TYPE : (objectArray[n] instanceof ColorUIResource ? (class$java$awt$Color == null ? UIDefaults.class$("java.awt.Color") : class$java$awt$Color) : objectArray[n].getClass()));
                    ++n;
                }
            }
            return classArray;
        }

        private String printArgs(Object[] objectArray) {
            String string = "{";
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length - 1) {
                    string = string.concat(objectArray[n] + ",");
                    ++n;
                }
                string = string.concat(objectArray[objectArray.length - 1] + "}");
            } else {
                string = string.concat("}");
            }
            return string;
        }

        static /* synthetic */ String access$000(ProxyLazyValue proxyLazyValue) {
            return proxyLazyValue.className;
        }

        static /* synthetic */ String access$100(ProxyLazyValue proxyLazyValue) {
            return proxyLazyValue.methodName;
        }

        static /* synthetic */ Object[] access$200(ProxyLazyValue proxyLazyValue) {
            return proxyLazyValue.args;
        }

        static /* synthetic */ Class[] access$300(ProxyLazyValue proxyLazyValue, Object[] objectArray) {
            return proxyLazyValue.getClassArray(objectArray);
        }
    }

    public static interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }

    public static interface LazyValue {
        public Object createValue(UIDefaults var1);
    }
}

