/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

class UnixFileSystemView
extends FileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");
    private static final String newFolderNextString = UIManager.getString("FileChooser.other.newFolder.subsequent");

    UnixFileSystemView() {
    }

    public File createNewFolder(File file) throws IOException {
        if (file == null) {
            throw new IOException("Containing directory is null:");
        }
        File file2 = null;
        file2 = this.createFileObject(file, newFolderString);
        int n = 1;
        while (file2.exists() && n < 100) {
            file2 = this.createFileObject(file, MessageFormat.format(newFolderNextString, new Integer(n)));
            ++n;
        }
        if (file2.exists()) {
            throw new IOException("Directory already exists:" + file2.getAbsolutePath());
        }
        file2.mkdirs();
        return file2;
    }

    public boolean isFileSystemRoot(File file) {
        return file != null && file.getAbsolutePath().equals("/");
    }

    public boolean isDrive(File file) {
        return this.isFloppyDrive(file);
    }

    public boolean isFloppyDrive(File file) {
        return false;
    }

    public boolean isComputerNode(File file) {
        String string;
        return file != null && (string = file.getParent()) != null && string.equals("/net");
    }
}

