/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected Color darkShadow;
    protected Color focus;
    private Color selectedColor;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int tabCount;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
    }

    protected void uninstallDefaults() {
        this.highlight = null;
        this.lightHighlight = null;
        this.shadow = null;
        this.darkShadow = null;
        this.focus = null;
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
            } else {
                this.tabPane.addMouseListener(this.mouseListener);
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, actionMap);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.scrollForwardButton.setAction(actionMap.get("scrollTabsForwardAction"));
            this.tabScroller.scrollBackwardButton.setAction(actionMap.get("scrollTabsBackwardAction"));
        }
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("TabbedPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateNext", new NextAction());
        actionMapUIResource.put("navigatePrevious", new PreviousAction());
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        actionMapUIResource.put("navigatePageUp", new PageUpAction());
        actionMapUIResource.put("navigatePageDown", new PageDownAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        actionMapUIResource.put("setSelectedIndex", new SetSelectedIndexAction());
        actionMapUIResource.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        actionMapUIResource.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        int n = this.tabPane.getTabCount() - 1;
        while (n >= 0) {
            int n2 = this.tabPane.getMnemonicAt(n);
            if (n2 > 0) {
                this.addMnemonic(n, n2);
            }
            --n;
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n, int n2) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n2, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(n2), new Integer(n));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getTabCount();
        if (this.tabCount != n) {
            this.tabCount = n;
            this.updateMnemonics();
        }
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n3, n2);
        }
        this.paintContentBorder(graphics, n3, n2);
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        int n4 = this.runCount - 1;
        while (n4 >= 0) {
            int n5 = this.tabRuns[n4];
            int n6 = this.tabRuns[n4 == this.runCount - 1 ? 0 : n4 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n3 - 1;
            int n8 = n5;
            while (n8 <= n7) {
                if (this.rects[n8].intersects(rectangle3)) {
                    this.paintTab(graphics, n, this.rects, n8, rectangle, rectangle2);
                }
                ++n8;
            }
            --n4;
        }
        if (n2 >= 0 && this.getRunForTab(n3, n2) == 0 && this.rects[n2].intersects(rectangle3)) {
            this.paintTab(graphics, n, this.rects, n2, rectangle, rectangle2);
        }
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n4 = 0;
        int n5 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            switch (n) {
                case 2: 
                case 4: {
                    int n6 = ((Rectangle)object).y + ((Rectangle)object).height;
                    if (rectangle3.y >= n6 || rectangle3.y + rectangle3.height <= n6) break;
                    polygon = this.createCroppedTabClip(n, rectangle3, n6);
                    n4 = rectangle3.x;
                    n5 = n6 - 1;
                    break;
                }
                default: {
                    int n6 = ((Rectangle)object).x + ((Rectangle)object).width;
                    if (rectangle3.x >= n6 || rectangle3.x + rectangle3.width <= n6) break;
                    polygon = this.createCroppedTabClip(n, rectangle3, n6);
                    n4 = n6 - 1;
                    n5 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics2D.getClip();
                graphics2D.clip(polygon);
            }
        }
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        object = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, (String)object, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, font, fontMetrics, n2, (String)object, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n, n2, bl, n4, n5);
            graphics2D.setClip(shape);
        }
    }

    private Polygon createCroppedTabClip(int n, Rectangle rectangle, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n) {
            case 2: 
            case 4: {
                n3 = rectangle.width;
                n4 = rectangle.x;
                n5 = rectangle.x + rectangle.width;
                n6 = rectangle.y;
                break;
            }
            default: {
                n3 = rectangle.height;
                n4 = rectangle.y;
                n5 = rectangle.y + rectangle.height;
                n6 = rectangle.x;
            }
        }
        int n7 = n3 / 12;
        if (n3 % 12 > 0) {
            ++n7;
        }
        int n8 = 2 + n7 * 8;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        int n9 = 0;
        nArray[n9] = n6;
        nArray2[n9++] = n5;
        nArray[n9] = n6;
        nArray2[n9++] = n4;
        int n10 = 0;
        while (n10 < n7) {
            int n11 = 0;
            while (n11 < this.xCropLen.length) {
                nArray[n9] = n2 - this.xCropLen[n11];
                nArray2[n9] = n4 + n10 * 12 + this.yCropLen[n11];
                if (nArray2[n9] >= n5) {
                    nArray2[n9] = n5;
                    ++n9;
                    break;
                }
                ++n9;
                ++n11;
            }
            ++n10;
        }
        if (n == 1 || n == 3) {
            return new Polygon(nArray, nArray2, n9);
        }
        return new Polygon(nArray2, nArray, n9);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n, int n2, boolean bl, int n3, int n4) {
        switch (n) {
            case 2: 
            case 4: {
                int n5 = n3;
                graphics.setColor(this.shadow);
                while (n5 <= n3 + this.rects[n2].width) {
                    int n6 = 0;
                    while (n6 < this.xCropLen.length) {
                        graphics.drawLine(n5 + this.yCropLen[n6], n4 - this.xCropLen[n6], n5 + this.yCropLen[n6 + 1] - 1, n4 - this.xCropLen[n6 + 1]);
                        n6 += 2;
                    }
                    n5 += 12;
                }
                break;
            }
            default: {
                int n7 = n4;
                graphics.setColor(this.shadow);
                while (n7 <= n4 + this.rects[n2].height) {
                    int n8 = 0;
                    while (n8 < this.xCropLen.length) {
                        graphics.drawLine(n3 - this.xCropLen[n8], n7 + this.yCropLen[n8], n3 - this.xCropLen[n8 + 1], n7 + this.yCropLen[n8 + 1] - 1);
                        n8 += 2;
                    }
                    n7 += 12;
                }
                break block0;
            }
        }
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                graphics.setColor(this.tabPane.getForegroundAt(n2));
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = bl ? -1 : 1;
                break;
            }
            case 4: {
                n3 = bl ? 1 : -1;
                break;
            }
            default: {
                n3 = rectangle.width % 2;
            }
        }
        return n3;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 3: {
                n3 = bl ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n3 = rectangle.height % 2;
                break;
            }
            default: {
                n3 = bl ? -1 : 1;
            }
        }
        return n3;
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = rectangleArray[n2];
        if (this.tabPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            graphics.setColor(this.focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n6, n5, n4, n3);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(this.lightHighlight);
        switch (n) {
            case 2: {
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                break;
            }
            case 4: {
                graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4 + n6 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                break;
            }
            default: {
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 3, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(!bl || this.selectedColor == null ? this.tabPane.getBackgroundAt(n2) : this.selectedColor);
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 2, n6 - 3);
                break;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 2, n6 - 3);
                break;
            }
            case 3: {
                graphics.fillRect(n3 + 1, n4, n5 - 3, n6 - 1);
                break;
            }
            default: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 3, n6 - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.selectedColor == null) {
            graphics.setColor(this.tabPane.getBackground());
        } else {
            graphics.setColor(this.selectedColor);
        }
        graphics.fillRect(n5, n6, n7, n8);
        this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n != 1 || n2 < 0 || rectangle.y + rectangle.height + 1 < n4 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
        } else {
            graphics.drawLine(n3, n4, rectangle.x - 1, n4);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n != 2 || n2 < 0 || rectangle.x + rectangle.width + 1 < n3 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            graphics.drawLine(n3, n4, n3, n4 + n6 - 2);
        } else {
            graphics.drawLine(n3, n4, n3, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.drawLine(n3, rectangle.y + rectangle.height, n3, n4 + n6 - 2);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.shadow);
        if (n != 3 || n2 < 0 || rectangle.y - 1 > n6 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3 + 1, n4 + n6 - 2, rectangle.x - 1, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, rectangle.x - 1, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.shadow);
        if (n != 4 || n2 < 0 || rectangle.x - 1 > n5 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + n6 - 3);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, rectangle.y - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, rectangle.y + rectangle.height, n3 + n5 - 2, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height, n3 + n5 - 1, n4 + n6 - 2);
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid() || this.tabPane.getTabCount() > this.rects.length) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n, rectangle);
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        Point point = new Point(n, n2);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n, n2, point);
        }
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        while (n4 < n3) {
            if (this.rects[n4].contains(point.x, point.y)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.width = this.rects[n].width;
        rectangle.height = this.rects[n].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n].x + point.x - point2.x;
            rectangle.y = this.rects[n].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n].x;
            rectangle.y = this.rects[n].y;
        }
        return rectangle;
    }

    private int getTabAtLocation(int n, int n2) {
        this.ensureCurrentLayout();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        while (n4 < n3) {
            if (this.rects[n4].contains(n, n2)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private int getClosestTab(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n3 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n6 = this.tabPane.getTabPlacement();
        boolean bl = n6 == 1 || n6 == 3;
        int n7 = bl ? n : n2;
        while (n4 != n5) {
            int n8;
            int n9;
            int n10 = (n5 + n4) / 2;
            if (bl) {
                n9 = this.rects[n10].x;
                n8 = n9 + this.rects[n10].width;
            } else {
                n9 = this.rects[n10].y;
                n8 = n9 + this.rects[n10].height;
            }
            if (n7 < n9) {
                n5 = n10;
                if (n4 != n5) continue;
                return Math.max(0, n10 - 1);
            }
            if (n7 >= n8) {
                n4 = n10;
                if (n5 - n4 > 1) continue;
                return Math.max(n10 + 1, n3 - 1);
            }
            return n10;
        }
        return n4;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n + point2.x + point3.x;
        point.y = n2 + point2.y + point3.y;
        return point;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n) {
        int n2 = this.rects.length;
        if (n != n2) {
            Rectangle[] rectangleArray = new Rectangle[n];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n2, n));
            this.rects = rectangleArray;
            int n3 = n2;
            while (n3 < n) {
                this.rects[n3] = new Rectangle();
                ++n3;
            }
        }
    }

    protected void expandTabRunsArray() {
        int n = this.tabRuns.length;
        int[] nArray = new int[n + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    protected int getRunForTab(int n, int n2) {
        int n3 = 0;
        while (n3 < this.runCount) {
            int n4 = this.tabRuns[n3];
            int n5 = this.lastTabInRun(n, n3);
            if (n2 >= n4 && n2 <= n5) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    protected int lastTabInRun(int n, int n2) {
        int n3;
        if (this.runCount == 1) {
            return n - 1;
        }
        int n4 = n3 = n2 == this.runCount - 1 ? 0 : n2 + 1;
        if (this.tabRuns[n3] == 0) {
            return n - 1;
        }
        return this.tabRuns[n3] - 1;
    }

    protected int getTabRunOverlay(int n) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected Icon getIconForTab(int n) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n) ? this.tabPane.getDisabledIconAt(n) : this.tabPane.getIconAt(n);
    }

    protected View getTextViewForTab(int n) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(n);
        }
        return null;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        int n4 = 0;
        View view = this.getTextViewForTab(n2);
        n4 = view != null ? (n4 += (int)view.getPreferredSpan(1)) : (n4 += n3);
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        if (icon != null) {
            n4 = Math.max(n4, icon.getIconHeight());
        }
        return n4 += insets.top + insets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = fontMetrics.getHeight();
        int n5 = 0;
        while (n5 < n2) {
            n3 = Math.max(this.calculateTabHeight(n, n5, n4), n3);
            ++n5;
        }
        return n3;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        View view;
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n3 = insets.left + insets.right + 3;
        if (icon != null) {
            n3 += icon.getIconWidth() + this.textIconGap;
        }
        if ((view = this.getTextViewForTab(n2)) != null) {
            n3 += (int)view.getPreferredSpan(0);
        } else {
            String string = this.tabPane.getTitleAt(n2);
            n3 += SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        return n3;
    }

    protected int calculateMaxTabWidth(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = Math.max(this.calculateTabWidth(n, n4, fontMetrics), n3);
            ++n4;
        }
        return n3;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.left + insets.right : 0;
    }

    protected Insets getTabInsets(int n, int n2) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, n);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n) {
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, n);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int n) {
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n) {
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getSelectedIndex();
        int n4 = this.tabPane.getTabCount();
        boolean bl = BasicGraphicsUtils.isLeftToRight(this.tabPane);
        if (n4 <= 0) {
            return;
        }
        block0 : switch (n2) {
            case 12: {
                this.selectNextTab(n3);
                break;
            }
            case 13: {
                this.selectPreviousTab(n3);
                break;
            }
            case 2: 
            case 4: {
                switch (n) {
                    case 1: {
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        int n5 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n5);
                        break block0;
                    }
                    case 3: {
                        int n6 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n6);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n) {
                    case 1: {
                        int n7 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n7);
                        break block0;
                    }
                    case 5: {
                        int n8 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n8);
                        break block0;
                    }
                    case 3: {
                        if (bl) {
                            this.selectNextTabInRun(n3);
                            break block0;
                        }
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        if (bl) {
                            this.selectPreviousTabInRun(n3);
                            break block0;
                        }
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int n) {
        int n2 = this.tabPane.getTabCount();
        int n3 = this.getNextTabIndexInRun(n2, n);
        while (n3 != n && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndexInRun(n2, n3);
        }
        this.tabPane.setSelectedIndex(n3);
    }

    protected void selectPreviousTabInRun(int n) {
        int n2 = this.tabPane.getTabCount();
        int n3 = this.getPreviousTabIndexInRun(n2, n);
        while (n3 != n && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndexInRun(n2, n3);
        }
        this.tabPane.setSelectedIndex(n3);
    }

    protected void selectNextTab(int n) {
        int n2 = this.getNextTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getNextTabIndex(n2);
        }
        this.tabPane.setSelectedIndex(n2);
    }

    protected void selectPreviousTab(int n) {
        int n2 = this.getPreviousTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getPreviousTabIndex(n2);
        }
        this.tabPane.setSelectedIndex(n2);
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n2];
        switch (n) {
            case 2: 
            case 4: {
                n4 = this.getTabAtLocation(rectangle.x + rectangle.width / 2 + n3, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n4 = this.getTabAtLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n3);
            }
        }
        if (n4 != -1) {
            while (!this.tabPane.isEnabledAt(n4) && n4 != n2) {
                n4 = this.getNextTabIndex(n4);
            }
            this.tabPane.setSelectedIndex(n4);
        }
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.getRunForTab(n2, n3);
        switch (n) {
            case 2: {
                if (n5 == 0) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n4 = bl ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n4 = n5 == 0 ? (bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n5 == this.runCount - 1 ? (bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n4;
    }

    protected int getPreviousTabIndex(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.tabPane.getTabCount() - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabIndex(int n) {
        return (n + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        int n4 = this.getNextTabIndex(n2);
        if (n4 == this.tabRuns[this.getNextTabRun(n3)]) {
            return this.tabRuns[n3];
        }
        return n4;
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        if (n2 == this.tabRuns[n3]) {
            int n4 = this.tabRuns[this.getNextTabRun(n3)] - 1;
            return n4 != -1 ? n4 : n - 1;
        }
        return this.getPreviousTabIndex(n2);
    }

    protected int getPreviousTabRun(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.runCount - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabRun(int n) {
        return (n + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector<View> vector = new Vector<View>();
        int n = this.tabPane.getTabCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                String string = this.tabPane.getTitleAt(n2);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                } else {
                    vector.addElement(null);
                }
                ++n2;
            }
        }
        return vector;
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n = jTabbedPane.indexOfComponent(component);
            String string = jTabbedPane.getTitleAt(n);
            boolean bl = BasicHTML.isHTMLString(string);
            if (bl) {
                if (BasicTabbedPaneUI.this.htmlViews == null) {
                    BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    BasicTabbedPaneUI.this.htmlViews.insertElementAt(view, n);
                }
            } else if (BasicTabbedPaneUI.this.htmlViews != null) {
                BasicTabbedPaneUI.this.htmlViews.insertElementAt(null, n);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            Integer n = (Integer)jTabbedPane.getClientProperty("__index_to_remove__");
            if (n != null) {
                int n2 = n;
                if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.size() >= n2) {
                    BasicTabbedPaneUI.this.htmlViews.removeElementAt(n2);
                }
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.getTabBounds(jTabbedPane, n2));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.getTabBounds(jTabbedPane, n2));
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = BasicTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && BasicTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                if (n == BasicTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (BasicTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        BasicTabbedPaneUI.this.tabPane.requestFocus();
                        BasicTabbedPaneUI.this.tabPane.repaint(BasicTabbedPaneUI.this.getTabBounds(BasicTabbedPaneUI.this.tabPane, n));
                    }
                } else {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                    BasicTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                }
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (BasicTabbedPaneUI.this.tabScroller != null && jTabbedPane.getTabLayoutPolicy() == 1) {
                int n = jTabbedPane.getSelectedIndex();
                if (n >= 0 && n < ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.leadingTabIndex) {
                    BasicTabbedPaneUI.this.tabScroller.setLeadingTabIndex(jTabbedPane.getTabPlacement(), n);
                }
                if (n < BasicTabbedPaneUI.this.rects.length && n != -1) {
                    ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.scrollRectToVisible(BasicTabbedPaneUI.this.rects[n]);
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("mnemonicAt".equals(string)) {
                BasicTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(string)) {
                jTabbedPane.repaint();
            } else if (string.equals("indexForTitle")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                String string2 = BasicTabbedPaneUI.this.tabPane.getTitleAt(n);
                if (BasicHTML.isHTMLString(string2)) {
                    if (BasicTabbedPaneUI.this.htmlViews == null) {
                        BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View view = BasicHTML.createHTMLView(BasicTabbedPaneUI.this.tabPane, string2);
                        BasicTabbedPaneUI.this.htmlViews.setElementAt(view, n);
                    }
                } else if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.elementAt(n) != null) {
                    BasicTabbedPaneUI.this.htmlViews.setElementAt(null, n);
                }
                BasicTabbedPaneUI.this.updateMnemonics();
            } else if (string.equals("tabLayoutPolicy")) {
                BasicTabbedPaneUI.this.uninstallUI(jTabbedPane);
                BasicTabbedPaneUI.this.installUI(jTabbedPane);
            }
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n) {
            super(n, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }

        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            BasicTabbedPaneUI.this.paintTabArea(graphics, BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (n == 1 || n == 3) {
                this.scrollForwardButton = new ScrollableTabButton(3);
                this.scrollBackwardButton = new ScrollableTabButton(7);
            } else {
                this.scrollForwardButton = new ScrollableTabButton(5);
                this.scrollBackwardButton = new ScrollableTabButton(1);
            }
        }

        public void scrollForward(int n) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n == 1 || n == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int n, int n2) {
            this.leadingTabIndex = n2;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n) {
                case 1: 
                case 3: {
                    int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n4 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = BasicTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n2) {
                switch (n) {
                    case 1: 
                    case 3: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = BasicTabbedPaneUI.this.getContentBorderInsets(n);
            switch (n) {
                case 2: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            return BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            return BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
        }

        public void layoutContainer(Container container) {
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n3 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n3);
                boolean bl = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n);
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n4 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n4 > 0) {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    switch (n) {
                        case 2: {
                            n12 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n11 = rectangle.height - insets.top - insets.bottom;
                            n10 = insets.left;
                            n9 = insets.top;
                            n8 = n10 + n12 + insets2.left;
                            n7 = n9 + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - n12 - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n12 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n11 = rectangle.height - insets.top - insets.bottom;
                            n10 = rectangle.width - insets.right - n12;
                            n9 = insets.top;
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - n12 - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n12 = rectangle.width - insets.left - insets.right;
                            n11 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n10 = insets.left;
                            n9 = rectangle.height - insets.bottom - n11;
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - n11 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n12 = rectangle.width - insets.left - insets.right;
                            n11 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n10 = insets.left;
                            n9 = insets.top;
                            n8 = n10 + insets2.left;
                            n7 = n9 + n11 + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - n11 - insets2.top - insets2.bottom;
                        }
                    }
                    int n13 = 0;
                    while (n13 < n4) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        Cloneable cloneable;
                        JComponent jComponent;
                        Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(n13);
                        if (component3 instanceof ScrollableTabViewport) {
                            jComponent = (JViewport)component3;
                            cloneable = ((JViewport)jComponent).getViewRect();
                            n17 = n12;
                            n16 = n11;
                            switch (n) {
                                case 2: 
                                case 4: {
                                    n15 = BasicTabbedPaneUI.this.rects[n2 - 1].y + BasicTabbedPaneUI.this.rects[n2 - 1].height;
                                    if (n15 <= n11 || n15 - cloneable.y > (n16 = Math.max(n11 - 36, 36))) break;
                                    n16 = n15 - cloneable.y;
                                    break;
                                }
                                default: {
                                    n14 = BasicTabbedPaneUI.this.rects[n2 - 1].x + BasicTabbedPaneUI.this.rects[n2 - 1].width;
                                    if (n14 <= n12 || n14 - cloneable.x > (n17 = Math.max(n12 - 36, 36))) break;
                                    n17 = n14 - cloneable.x;
                                }
                            }
                            component3.setBounds(n10, n9, n17, n16);
                        } else if (component3 instanceof ScrollableTabButton) {
                            jComponent = (ScrollableTabButton)component3;
                            cloneable = ((BasicArrowButton)jComponent).getPreferredSize();
                            n17 = 0;
                            n16 = 0;
                            n15 = ((Dimension)cloneable).width;
                            n14 = ((Dimension)cloneable).height;
                            boolean bl2 = false;
                            switch (n) {
                                case 2: 
                                case 4: {
                                    int n18 = BasicTabbedPaneUI.this.rects[n2 - 1].y + BasicTabbedPaneUI.this.rects[n2 - 1].height;
                                    if (n18 <= n11) break;
                                    int n19 = ((ScrollableTabButton)jComponent).scrollsForward() ? 5 : 1;
                                    ((BasicArrowButton)jComponent).setDirection(n19);
                                    bl2 = true;
                                    n17 = n == 2 ? n10 + n12 - ((Dimension)cloneable).width : n10;
                                    n16 = n19 == 5 ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                    break;
                                }
                                default: {
                                    int n19 = BasicTabbedPaneUI.this.rects[n2 - 1].x + BasicTabbedPaneUI.this.rects[n2 - 1].width;
                                    if (n19 <= n12) break;
                                    int n20 = ((ScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                    ((BasicArrowButton)jComponent).setDirection(n20);
                                    bl2 = true;
                                    n17 = n20 == 3 ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                    n16 = n == 1 ? n9 + n11 - ((Dimension)cloneable).height : n9;
                                }
                            }
                            component3.setVisible(bl2);
                            if (bl2) {
                                component3.setBounds(n17, n16, n15, n14);
                            }
                        } else {
                            component3.setBounds(n8, n7, n6, n5);
                        }
                        ++n13;
                    }
                    if (bl && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                        BasicTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        protected void calculateTabRects(int n, int n2) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            int n3 = fontMetrics.getHeight();
            int n4 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            int n5 = insets2.left;
            int n6 = insets2.top;
            int n7 = 0;
            int n8 = 0;
            switch (n) {
                case 2: 
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                }
            }
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            BasicTabbedPaneUI.this.selectedRun = 0;
            BasicTabbedPaneUI.this.runCount = 1;
            int n9 = 0;
            while (n9 < n2) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n9];
                if (!bl) {
                    if (n9 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n9 - 1].x + BasicTabbedPaneUI.this.rects[n9 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        n8 += BasicTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n5;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n, n9, fontMetrics);
                    n7 = rectangle.x + rectangle.width;
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n6;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n9 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n9 - 1].y + BasicTabbedPaneUI.this.rects[n9 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        n7 = BasicTabbedPaneUI.this.maxTabWidth;
                        rectangle.y = n6;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n, n9, n3);
                    n8 = rectangle.y + rectangle.height;
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    rectangle.x = n5;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                }
                ++n9;
            }
            if (!bl2 && !bl) {
                int n10 = dimension.width - (insets.right + insets2.right);
                n9 = 0;
                while (n9 < n2) {
                    BasicTabbedPaneUI.this.rects[n9].x = n10 - BasicTabbedPaneUI.this.rects[n9].x - BasicTabbedPaneUI.this.rects[n9].width;
                    ++n9;
                }
            }
            ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(n7, n8));
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean bl) {
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n);
            Insets insets3 = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            Dimension dimension = new Dimension(0, 0);
            int n2 = insets2.top + insets2.bottom;
            int n3 = insets2.left + insets2.right;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                Component component = BasicTabbedPaneUI.this.tabPane.getComponentAt(n6);
                if (component != null) {
                    Dimension dimension2 = dimension;
                    Dimension dimension3 = dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
                    if (dimension2 != null) {
                        n5 = Math.max(dimension2.height, n5);
                        n4 = Math.max(dimension2.width, n4);
                    }
                }
                ++n6;
            }
            n3 += n4;
            n2 += n5;
            int n7 = 0;
            switch (n) {
                case 2: 
                case 4: {
                    n2 = Math.max(n2, BasicTabbedPaneUI.this.calculateMaxTabHeight(n) + insets3.top + insets3.bottom);
                    n7 = this.preferredTabAreaWidth(n, n2);
                    n3 += n7;
                    break;
                }
                default: {
                    n3 = Math.max(n3, BasicTabbedPaneUI.this.calculateMaxTabWidth(n) + insets3.left + insets3.right);
                    n7 = this.preferredTabAreaHeight(n, n3);
                    n2 += n7;
                }
            }
            return new Dimension(n3 + insets.left + insets.right, n2 + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = BasicTabbedPaneUI.this.calculateTabWidth(n, n8, fontMetrics);
                    if (n6 != 0 && n6 + n9 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n9;
                    ++n8;
                }
                n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, n5, n7);
            }
            return n4;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = fontMetrics.getHeight();
                BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = BasicTabbedPaneUI.this.calculateTabHeight(n, n8, n7);
                    if (n6 != 0 && n6 + n9 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n9;
                    ++n8;
                }
                n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, n5, BasicTabbedPaneUI.this.maxTabWidth);
            }
            return n4;
        }

        public void layoutContainer(Container container) {
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n2 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n2 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                int n3 = 0;
                int n4 = 0;
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n);
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n2);
                boolean bl = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n5 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    switch (n) {
                        case 2: {
                            n3 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n7 = insets.left + n3 + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        case 4: {
                            n3 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        case 3: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        default: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + n4 + insets2.top;
                        }
                    }
                    int n8 = rectangle.width - n3 - insets.left - insets.right - insets2.left - insets2.right;
                    int n9 = rectangle.height - n4 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                    int n10 = 0;
                    while (n10 < n5) {
                        Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(n10);
                        component3.setBounds(n7, n6, n8, n9);
                        ++n10;
                    }
                }
                if (bl && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void calculateLayoutInfo() {
            int n = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(n);
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), n);
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            int n7 = fontMetrics.getHeight();
            int n8 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            switch (n) {
                case 2: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = dimension.width - insets.right - insets2.right - BasicTabbedPaneUI.this.maxTabWidth;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = dimension.height - insets.bottom - insets2.bottom - BasicTabbedPaneUI.this.maxTabHeight;
                    n4 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n9 = BasicTabbedPaneUI.this.getTabRunOverlay(n);
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            int n10 = 0;
            while (n10 < n2) {
                rectangle = BasicTabbedPaneUI.this.rects[n10];
                if (!bl) {
                    if (n10 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n10 - 1].x + BasicTabbedPaneUI.this.rects[n10 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n6;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n, n10, fontMetrics);
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n4) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n10;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.x = n6;
                    }
                    rectangle.y = n5;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n10 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n10 - 1].y + BasicTabbedPaneUI.this.rects[n10 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n5;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n, n10, n7);
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n4) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n10;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.y = n5;
                    }
                    rectangle.x = n6;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                }
                if (n10 == n8) {
                    BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
                }
                ++n10;
            }
            if (BasicTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n, n2, bl ? n5 : n6, n4);
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(n2, n8);
                if (BasicTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, BasicTabbedPaneUI.this.selectedRun);
                }
            }
            n10 = BasicTabbedPaneUI.this.runCount - 1;
            while (n10 >= 0) {
                int n11;
                int n12;
                n3 = BasicTabbedPaneUI.this.tabRuns[n10];
                int n13 = BasicTabbedPaneUI.this.tabRuns[n10 == BasicTabbedPaneUI.this.runCount - 1 ? 0 : n10 + 1];
                int n14 = n12 = n13 != 0 ? n13 - 1 : n2 - 1;
                if (!bl) {
                    n11 = n3;
                    while (n11 <= n12) {
                        rectangle = BasicTabbedPaneUI.this.rects[n11];
                        rectangle.y = n5;
                        rectangle.x += BasicTabbedPaneUI.this.getTabRunIndent(n, n10);
                        ++n11;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n, n10)) {
                        this.padTabRun(n, n3, n12, n4);
                    }
                    n5 = n == 3 ? (n5 -= BasicTabbedPaneUI.this.maxTabHeight - n9) : (n5 += BasicTabbedPaneUI.this.maxTabHeight - n9);
                } else {
                    n11 = n3;
                    while (n11 <= n12) {
                        rectangle = BasicTabbedPaneUI.this.rects[n11];
                        rectangle.x = n6;
                        rectangle.y += BasicTabbedPaneUI.this.getTabRunIndent(n, n10);
                        ++n11;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n, n10)) {
                        this.padTabRun(n, n3, n12, n4);
                    }
                    n6 = n == 4 ? (n6 -= BasicTabbedPaneUI.this.maxTabWidth - n9) : (n6 += BasicTabbedPaneUI.this.maxTabWidth - n9);
                }
                --n10;
            }
            this.padSelectedTab(n, n8);
            if (!bl2 && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                n10 = 0;
                while (n10 < n2) {
                    BasicTabbedPaneUI.this.rects[n10].x = n3 - BasicTabbedPaneUI.this.rects[n10].x - BasicTabbedPaneUI.this.rects[n10].width;
                    ++n10;
                }
            }
        }

        protected void rotateTabRuns(int n, int n2) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = BasicTabbedPaneUI.this.tabRuns[0];
                int n5 = 1;
                while (n5 < BasicTabbedPaneUI.this.runCount) {
                    BasicTabbedPaneUI.this.tabRuns[n5 - 1] = BasicTabbedPaneUI.this.tabRuns[n5];
                    ++n5;
                }
                BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount - 1] = n4;
                ++n3;
            }
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            boolean bl = n == 2 || n == 4;
            int n5 = BasicTabbedPaneUI.this.runCount - 1;
            boolean bl2 = true;
            double d = 1.25;
            while (bl2) {
                int n6;
                int n7;
                int n8 = BasicTabbedPaneUI.this.lastTabInRun(n2, n5);
                int n9 = BasicTabbedPaneUI.this.lastTabInRun(n2, n5 - 1);
                if (!bl) {
                    n7 = BasicTabbedPaneUI.this.rects[n8].x + BasicTabbedPaneUI.this.rects[n8].width;
                    n6 = (int)((double)BasicTabbedPaneUI.this.maxTabWidth * d);
                } else {
                    n7 = BasicTabbedPaneUI.this.rects[n8].y + BasicTabbedPaneUI.this.rects[n8].height;
                    n6 = (int)((double)BasicTabbedPaneUI.this.maxTabHeight * d * 2.0);
                }
                if (n4 - n7 > n6) {
                    BasicTabbedPaneUI.this.tabRuns[n5] = n9;
                    if (!bl) {
                        BasicTabbedPaneUI.this.rects[n9].x = n3;
                    } else {
                        BasicTabbedPaneUI.this.rects[n9].y = n3;
                    }
                    int n10 = n9 + 1;
                    while (n10 <= n8) {
                        if (!bl) {
                            BasicTabbedPaneUI.this.rects[n10].x = BasicTabbedPaneUI.this.rects[n10 - 1].x + BasicTabbedPaneUI.this.rects[n10 - 1].width;
                        } else {
                            BasicTabbedPaneUI.this.rects[n10].y = BasicTabbedPaneUI.this.rects[n10 - 1].y + BasicTabbedPaneUI.this.rects[n10 - 1].height;
                        }
                        ++n10;
                    }
                } else if (n5 == BasicTabbedPaneUI.this.runCount - 1) {
                    bl2 = false;
                }
                if (n5 - 1 > 0) {
                    --n5;
                    continue;
                }
                n5 = BasicTabbedPaneUI.this.runCount - 1;
                d += 0.25;
            }
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            Rectangle rectangle = BasicTabbedPaneUI.this.rects[n3];
            if (n == 1 || n == 3) {
                int n5 = rectangle.x + rectangle.width - BasicTabbedPaneUI.this.rects[n2].x;
                int n6 = n4 - (rectangle.x + rectangle.width);
                float f = (float)n6 / (float)n5;
                int n7 = n2;
                while (n7 <= n3) {
                    Rectangle rectangle2 = BasicTabbedPaneUI.this.rects[n7];
                    if (n7 > n2) {
                        rectangle2.x = BasicTabbedPaneUI.this.rects[n7 - 1].x + BasicTabbedPaneUI.this.rects[n7 - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f);
                    ++n7;
                }
                rectangle.width = n4 - rectangle.x;
            } else {
                int n8 = rectangle.y + rectangle.height - BasicTabbedPaneUI.this.rects[n2].y;
                int n9 = n4 - (rectangle.y + rectangle.height);
                float f = (float)n9 / (float)n8;
                int n10 = n2;
                while (n10 <= n3) {
                    Rectangle rectangle3 = BasicTabbedPaneUI.this.rects[n10];
                    if (n10 > n2) {
                        rectangle3.y = BasicTabbedPaneUI.this.rects[n10 - 1].y + BasicTabbedPaneUI.this.rects[n10 - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f);
                    ++n10;
                }
                rectangle.height = n4 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n, int n2) {
            if (n2 >= 0) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n2];
                Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(n);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            if (basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                basicTabbedPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            if (basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                basicTabbedPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof BasicTabbedPaneUI) {
                BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n;
                    int n2 = actionEvent.getActionCommand().charAt(0);
                    if (n2 >= 97 && n2 <= 122) {
                        n2 -= 32;
                    }
                    if ((n = (Integer)basicTabbedPaneUI.mnemonicToIndexMap.get(new Integer(n2))) != null && jTabbedPane.isEnabledAt(n)) {
                        jTabbedPane.setSelectedIndex(n);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.requestFocus();
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                basicTabbedPaneUI.navigateSelectedTab(3);
            } else {
                basicTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                basicTabbedPaneUI.navigateSelectedTab(7);
            } else {
                basicTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(3);
        }
    }
}

