/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableHeaderUI
extends TableHeaderUI {
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    protected JTableHeader header;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        int n4 = tableColumnModel.getColumnMargin();
        Rectangle rectangle2 = this.header.getHeaderRect(n2);
        if (bl) {
            n = n2;
            while (n <= n3) {
                int n5;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                rectangle2.width = n5 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n5;
                ++n;
            }
        } else {
            int n6;
            TableColumn tableColumn3 = tableColumnModel.getColumn(n2);
            if (tableColumn3 != tableColumn) {
                rectangle2.width = n6 = tableColumn3.getWidth();
                this.paintCell(graphics, rectangle2, n2);
            }
            n = n2 + 1;
            while (n <= n3) {
                tableColumn3 = tableColumnModel.getColumn(n);
                rectangle2.width = n6 = tableColumn3.getWidth();
                rectangle2.x -= n6;
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                ++n;
            }
        }
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        Component component = this.getHeaderRenderer(n);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            if (tableColumnModel.getColumn(n) == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getHeaderHeight() {
        int n = 0;
        boolean bl = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = 0;
        while (n2 < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            if (tableColumn.getHeaderRenderer() != null || !bl) {
                Component component = this.getHeaderRenderer(n2);
                int n3 = component.getPreferredSize().height;
                n = Math.max(n, n3);
                if (component instanceof JComponent) {
                    Insets insets = ((JComponent)component).getInsets();
                    n3 -= insets.top + insets.bottom;
                }
                if (n3 > 0) {
                    bl = true;
                }
            }
            ++n2;
        }
        return n;
    }

    private Dimension createHeaderSize(long l) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSize(l);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createHeaderSize(l);
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int mouseXOffset;
        private Cursor otherCursor = BasicTableHeaderUI.access$000();

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private boolean canResize(TableColumn tableColumn) {
            return tableColumn != null && BasicTableHeaderUI.this.header.getResizingAllowed() && tableColumn.getResizable();
        }

        private TableColumn getResizingColumn(Point point) {
            return this.getResizingColumn(point, BasicTableHeaderUI.this.header.columnAtPoint(point));
        }

        private TableColumn getResizingColumn(Point point, int n) {
            int n2;
            if (n == -1) {
                return null;
            }
            Rectangle rectangle = BasicTableHeaderUI.this.header.getHeaderRect(n);
            rectangle.grow(-3, 0);
            if (rectangle.contains(point)) {
                return null;
            }
            int n3 = rectangle.x + rectangle.width / 2;
            if (BasicTableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                n2 = point.x < n3 ? n - 1 : n;
            } else {
                int n4 = n2 = point.x < n3 ? n : n - 1;
            }
            if (n2 == -1) {
                return null;
            }
            return BasicTableHeaderUI.this.header.getColumnModel().getColumn(n2);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            BasicTableHeaderUI.this.header.setDraggedDistance(0);
            Point point = mouseEvent.getPoint();
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n = BasicTableHeaderUI.this.header.columnAtPoint(point);
            if (n != -1) {
                TableColumn tableColumn = this.getResizingColumn(point, n);
                if (this.canResize(tableColumn)) {
                    BasicTableHeaderUI.this.header.setResizingColumn(tableColumn);
                    this.mouseXOffset = BasicTableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? point.x - tableColumn.getWidth() : point.x + tableColumn.getWidth();
                } else if (BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                    BasicTableHeaderUI.this.header.setDraggedColumn(tableColumn2);
                    this.mouseXOffset = point.x;
                }
            }
        }

        private void swapCursor() {
            Cursor cursor = BasicTableHeaderUI.this.header.getCursor();
            BasicTableHeaderUI.this.header.setCursor(this.otherCursor);
            this.otherCursor = cursor;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.canResize(this.getResizingColumn(mouseEvent.getPoint())) != (BasicTableHeaderUI.this.header.getCursor() == resizeCursor)) {
                this.swapCursor();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            TableColumn tableColumn = BasicTableHeaderUI.this.header.getResizingColumn();
            TableColumn tableColumn2 = BasicTableHeaderUI.this.header.getDraggedColumn();
            boolean bl = BasicTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            if (tableColumn != null) {
                JTable jTable;
                Container container;
                int n2 = tableColumn.getWidth();
                int n3 = bl ? n - this.mouseXOffset : this.mouseXOffset - n;
                tableColumn.setWidth(n3);
                if (BasicTableHeaderUI.this.header.getParent() == null || (container = BasicTableHeaderUI.this.header.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                    return;
                }
                if (!container.getComponentOrientation().isLeftToRight() && !bl && (jTable = BasicTableHeaderUI.this.header.getTable()) != null) {
                    JViewport jViewport = ((JScrollPane)container).getViewport();
                    int n4 = jViewport.getWidth();
                    int n5 = n3 - n2;
                    int n6 = jTable.getWidth() + n5;
                    Dimension dimension = jTable.getSize();
                    dimension.width += n5;
                    jTable.setSize(dimension);
                    if (n6 >= n4 && jTable.getAutoResizeMode() == 0) {
                        Point point = jViewport.getViewPosition();
                        point.x = Math.max(0, Math.min(n6 - n4, point.x + n5));
                        jViewport.setViewPosition(point);
                        this.mouseXOffset += n5;
                    }
                }
            } else if (tableColumn2 != null) {
                TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
                int n7 = n - this.mouseXOffset;
                int n8 = n7 < 0 ? -1 : 1;
                int n9 = BasicTableHeaderUI.this.viewIndexForColumn(tableColumn2);
                int n10 = n9 + (bl ? n8 : -n8);
                if (0 <= n10 && n10 < tableColumnModel.getColumnCount()) {
                    int n11 = tableColumnModel.getColumn(n10).getWidth();
                    if (Math.abs(n7) > n11 / 2) {
                        this.mouseXOffset += n8 * n11;
                        BasicTableHeaderUI.this.header.setDraggedDistance(n7 - n8 * n11);
                        tableColumnModel.moveColumn(n9, n10);
                        return;
                    }
                }
                this.setDraggedDistance(n7, n9);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.setDraggedDistance(0, BasicTableHeaderUI.this.viewIndexForColumn(BasicTableHeaderUI.this.header.getDraggedColumn()));
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void setDraggedDistance(int n, int n2) {
            BasicTableHeaderUI.this.header.setDraggedDistance(n);
            if (n2 != -1) {
                BasicTableHeaderUI.this.header.getColumnModel().moveColumn(n2, n2);
            }
        }
    }
}

