/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDragGestureRecognizer;
import javax.swing.plaf.basic.BasicDropTargetListener;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableUI
extends TableUI {
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    private PropertyChangeListener propertyChangeListener;
    private static final TableDragGestureRecognizer defaultDragRecognizer = new TableDragGestureRecognizer();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TransferHandler defaultTransferHandler = new TableTransferHandler();

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        block8: {
            DropTarget dropTarget;
            TransferHandler transferHandler;
            Container container;
            Color color;
            Color color2;
            LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
            Color color3 = this.table.getSelectionBackground();
            if (color3 == null || color3 instanceof UIResource) {
                this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
            }
            if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
                this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
            }
            if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
                this.table.setGridColor(UIManager.getColor("Table.gridColor"));
            }
            if ((container = this.table.getParent()) != null && (container = container.getParent()) != null && container instanceof JScrollPane) {
                LookAndFeel.installBorder((JScrollPane)container, "Table.scrollPaneBorder");
            }
            if ((transferHandler = this.table.getTransferHandler()) == null || transferHandler instanceof UIResource) {
                this.table.setTransferHandler(defaultTransferHandler);
            }
            if (!((dropTarget = this.table.getDropTarget()) instanceof UIResource)) break block8;
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TableDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {}
        }
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(defaultDragRecognizer);
        this.table.addMouseMotionListener(defaultDragRecognizer);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.table, actionMap);
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("Table.ancestorInputMap");
            if (this.table.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)UIManager.get("Table.ancestorInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Table.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Table.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectNextColumn", new NavigationalAction(1, 0, false, false, false));
        actionMapUIResource.put("selectPreviousColumn", new NavigationalAction(-1, 0, false, false, false));
        actionMapUIResource.put("selectNextRow", new NavigationalAction(0, 1, false, false, false));
        actionMapUIResource.put("selectPreviousRow", new NavigationalAction(0, -1, false, false, false));
        actionMapUIResource.put("selectNextColumnExtendSelection", new NavigationalAction(1, 0, false, true, false));
        actionMapUIResource.put("selectPreviousColumnExtendSelection", new NavigationalAction(-1, 0, false, true, false));
        actionMapUIResource.put("selectNextRowExtendSelection", new NavigationalAction(0, 1, false, true, false));
        actionMapUIResource.put("selectPreviousRowExtendSelection", new NavigationalAction(0, -1, false, true, false));
        actionMapUIResource.put("scrollUpChangeSelection", new PagingAction(false, false, true, false));
        actionMapUIResource.put("scrollDownChangeSelection", new PagingAction(false, true, true, false));
        actionMapUIResource.put("selectFirstColumn", new PagingAction(false, false, false, true));
        actionMapUIResource.put("selectLastColumn", new PagingAction(false, true, false, true));
        actionMapUIResource.put("scrollUpExtendSelection", new PagingAction(true, false, true, false));
        actionMapUIResource.put("scrollDownExtendSelection", new PagingAction(true, true, true, false));
        actionMapUIResource.put("selectFirstColumnExtendSelection", new PagingAction(true, false, false, true));
        actionMapUIResource.put("selectLastColumnExtendSelection", new PagingAction(true, true, false, true));
        actionMapUIResource.put("selectFirstRow", new PagingAction(false, false, true, true));
        actionMapUIResource.put("selectLastRow", new PagingAction(false, true, true, true));
        actionMapUIResource.put("selectFirstRowExtendSelection", new PagingAction(true, false, true, true));
        actionMapUIResource.put("selectLastRowExtendSelection", new PagingAction(true, true, true, true));
        actionMapUIResource.put("selectNextColumnCell", new NavigationalAction(1, 0, true, false, true));
        actionMapUIResource.put("selectPreviousColumnCell", new NavigationalAction(-1, 0, true, false, true));
        actionMapUIResource.put("selectNextRowCell", new NavigationalAction(0, 1, true, false, true));
        actionMapUIResource.put("selectPreviousRowCell", new NavigationalAction(0, -1, true, false, true));
        actionMapUIResource.put("selectAll", new SelectAllAction());
        actionMapUIResource.put("cancel", new CancelEditingAction());
        actionMapUIResource.put("startEditing", new StartEditingAction());
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        if (this.table.getComponentOrientation().isLeftToRight()) {
            actionMapUIResource.put("scrollLeftChangeSelection", new PagingAction(false, false, false, false));
            actionMapUIResource.put("scrollRightChangeSelection", new PagingAction(false, true, false, false));
            actionMapUIResource.put("scrollLeftExtendSelection", new PagingAction(true, false, false, false));
            actionMapUIResource.put("scrollRightExtendSelection", new PagingAction(true, true, false, false));
        } else {
            actionMapUIResource.put("scrollLeftChangeSelection", new PagingAction(false, true, false, false));
            actionMapUIResource.put("scrollRightChangeSelection", new PagingAction(false, false, false, false));
            actionMapUIResource.put("scrollLeftExtendSelection", new PagingAction(true, true, false, false));
            actionMapUIResource.put("scrollRightExtendSelection", new PagingAction(true, false, false, false));
        }
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void uninstallDefaults() {
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(defaultDragRecognizer);
        this.table.removeMouseMotionListener(defaultDragRecognizer);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    private Dimension createTableSize(long l) {
        long l2;
        int n = 0;
        int n2 = this.table.getRowCount();
        if (n2 > 0 && this.table.getColumnCount() > 0) {
            Rectangle rectangle = this.table.getCellRect(n2 - 1, 0, true);
            n = rectangle.y + rectangle.height;
        }
        if ((l2 = Math.abs(l)) > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l2, n);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.table.columnAtPoint((bl = this.table.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n4 = this.table.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n, n2, n3, n4);
        this.paintCells(graphics, n, n2, n3, n4);
    }

    private void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        graphics.setColor(this.table.getGridColor());
        Rectangle rectangle = this.table.getCellRect(n, n3, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        if (this.table.getShowHorizontalLines()) {
            int n7 = rectangle3.x + rectangle3.width;
            n6 = rectangle3.y;
            n5 = n;
            while (n5 <= n2) {
                graphics.drawLine(rectangle3.x, (n6 += this.table.getRowHeight(n5)) - 1, n7 - 1, n6 - 1);
                ++n5;
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n5 = rectangle3.x;
                int n8 = n3;
                while (n8 <= n4) {
                    int n9 = tableColumnModel.getColumn(n8).getWidth();
                    graphics.drawLine((n5 += n9) - 1, 0, n5 - 1, n6 - 1);
                    ++n8;
                }
            } else {
                n5 = rectangle3.x + rectangle3.width;
                int n10 = n3;
                while (n10 < n4) {
                    int n11 = tableColumnModel.getColumn(n10).getWidth();
                    graphics.drawLine((n5 -= n11) - 1, 0, n5 - 1, n6 - 1);
                    ++n10;
                }
                graphics.drawLine(n5 -= tableColumnModel.getColumn(n4).getWidth(), 0, n5, n6 - 1);
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            if (tableColumnModel.getColumn(n) == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            int n6 = n;
            while (n6 <= n2) {
                Rectangle rectangle = this.table.getCellRect(n6, n3, false);
                int n7 = n3;
                while (n7 <= n4) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n7);
                    int n8 = tableColumn2.getWidth();
                    rectangle.width = n8 - n5;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, n6, n7);
                    }
                    rectangle.x += n8;
                    ++n7;
                }
                ++n6;
            }
        } else {
            int n9 = n;
            while (n9 <= n2) {
                int n10;
                Rectangle rectangle = this.table.getCellRect(n9, n3, false);
                TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
                if (tableColumn3 != tableColumn) {
                    n10 = tableColumn3.getWidth();
                    rectangle.width = n10 - n5;
                    this.paintCell(graphics, rectangle, n9, n3);
                }
                int n11 = n3 + 1;
                while (n11 <= n4) {
                    tableColumn3 = tableColumnModel.getColumn(n11);
                    n10 = tableColumn3.getWidth();
                    rectangle.width = n10 - n5;
                    rectangle.x -= n10;
                    if (tableColumn3 != tableColumn) {
                        this.paintCell(graphics, rectangle, n9, n11);
                    }
                    ++n11;
                }
                ++n9;
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n, n6, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            n4 = n7 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
            graphics.drawLine(n8, n7, n8, n4);
        }
        n5 = n;
        while (n5 <= n2) {
            Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
            rectangle4.x += n3;
            this.paintCell(graphics, rectangle4, n5, n6);
            if (this.table.getShowHorizontalLines()) {
                graphics.setColor(this.table.getGridColor());
                Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
                rectangle5.x += n3;
                n4 = rectangle5.x;
                int n9 = rectangle5.y;
                int n10 = n4 + rectangle5.width - 1;
                int n11 = n9 + rectangle5.height - 1;
                graphics.drawLine(n4, n11, n10, n11);
            }
            ++n5;
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block4: {
                DropTarget dropTarget;
                String string;
                block3: {
                    string = propertyChangeEvent.getPropertyName();
                    if (!string.equals("componentOrientation")) break block3;
                    InputMap inputMap = BasicTableUI.this.getInputMap(1);
                    SwingUtilities.replaceUIInputMap(BasicTableUI.this.table, 1, inputMap);
                    UIManager.getLookAndFeelDefaults().put("Table.actionMap", (Object)null);
                    ActionMap actionMap = BasicTableUI.this.getActionMap();
                    SwingUtilities.replaceUIActionMap(BasicTableUI.this.table, actionMap);
                    JTableHeader jTableHeader = BasicTableUI.this.table.getTableHeader();
                    if (jTableHeader == null) break block4;
                    jTableHeader.setComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
                    break block4;
                }
                if (!"transferHandler".equals(string) || !((dropTarget = BasicTableUI.this.table.getDropTarget()) instanceof UIResource)) break block4;
                if (defaultDropTargetListener == null) {
                    defaultDropTargetListener = new TableDropTargetListener();
                }
                try {
                    dropTarget.addDropTargetListener(defaultDropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {}
            }
        }
    }

    static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        TableTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                int[] nArray;
                int n;
                int[] nArray2;
                int n2;
                JTable jTable = (JTable)jComponent;
                if (!jTable.getRowSelectionAllowed() && !jTable.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!jTable.getRowSelectionAllowed()) {
                    n2 = jTable.getRowCount();
                    nArray2 = new int[n2];
                    n = 0;
                    while (n < n2) {
                        nArray2[n] = n;
                        ++n;
                    }
                } else {
                    nArray2 = jTable.getSelectedRows();
                }
                if (!jTable.getColumnSelectionAllowed()) {
                    n2 = jTable.getColumnCount();
                    nArray = new int[n2];
                    n = 0;
                    while (n < n2) {
                        nArray[n] = n;
                        ++n;
                    }
                } else {
                    nArray = jTable.getSelectedColumns();
                }
                if (nArray2 == null || nArray == null || nArray2.length == 0 || nArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<table>\n");
                int n3 = 0;
                while (n3 < nArray2.length) {
                    stringBuffer2.append("<tr>\n");
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        Object object = jTable.getValueAt(nArray2[n3], nArray[n4]);
                        String string = object == null ? "" : object.toString();
                        stringBuffer.append(string + "\t");
                        stringBuffer2.append("  <td>" + string + "</td>\n");
                        ++n4;
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                    stringBuffer2.append("</tr>\n");
                    ++n3;
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</table>\n</body>\n</html>");
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    static class TableDropTargetListener
    extends BasicDropTargetListener {
        private int[] rows;
        private int[] cols;

        TableDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            this.rows = jTable.getSelectedRows();
            this.cols = jTable.getSelectedColumns();
        }

        protected void restoreComponentState(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            jTable.clearSelection();
            int n = 0;
            while (n < this.rows.length) {
                jTable.addRowSelectionInterval(this.rows[n], this.rows[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.cols.length) {
                jTable.addColumnSelectionInterval(this.cols[n2], this.cols[n2]);
                ++n2;
            }
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTable jTable = (JTable)jComponent;
            int n = jTable.rowAtPoint(point);
            int n2 = jTable.columnAtPoint(point);
            if (n != -1) {
                jTable.setRowSelectionInterval(n, n);
            }
            if (n2 != -1) {
                jTable.setColumnSelectionInterval(n2, n2);
            }
        }
    }

    static class TableDragGestureRecognizer
    extends BasicDragGestureRecognizer {
        TableDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            JTable jTable;
            if (super.isDragPossible(mouseEvent) && (jTable = (JTable)this.getComponent(mouseEvent)).getDragEnabled()) {
                Point point = mouseEvent.getPoint();
                int n = jTable.rowAtPoint(point);
                int n2 = jTable.columnAtPoint(point);
                if (n2 != -1 && n != -1 && jTable.isCellSelected(n, n2)) {
                    return true;
                }
            }
            return false;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = BasicTableUI.this.table.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(BasicTableUI.this.table, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null || !BasicTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(BasicTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private void setValueIsAdjusting(boolean bl) {
            BasicTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl);
            BasicTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !SwingUtilities.isLeftMouseButton(mouseEvent) || !BasicTableUI.this.table.isEnabled();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(mouseEvent);
        }

        void adjustFocusAndSelection(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = BasicTableUI.this.table.rowAtPoint(point);
            int n2 = BasicTableUI.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            if (BasicTableUI.this.table.editCellAt(n, n2, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            } else if (BasicTableUI.this.table.isRequestFocusEnabled()) {
                BasicTableUI.this.table.requestFocus();
            }
            TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                boolean bl = mouseEvent.getID() == 501;
                this.setValueIsAdjusting(bl);
                BasicTableUI.this.table.changeSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                this.repostEvent(mouseEvent);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.repostEvent(mouseEvent);
            TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                int n = BasicTableUI.this.table.rowAtPoint(point);
                int n2 = BasicTableUI.this.table.columnAtPoint(point);
                if (n2 == -1 || n == -1) {
                    return;
                }
                BasicTableUI.this.table.changeSelection(n, n2, false, true);
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        private void repaintAnchorCell() {
            int n = BasicTableUI.this.table.getRowCount();
            int n2 = BasicTableUI.this.table.getColumnCount();
            int n3 = BasicTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n4 = BasicTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
                return;
            }
            Rectangle rectangle = BasicTableUI.this.table.getCellRect(n3, n4, false);
            BasicTableUI.this.table.repaint(rectangle);
        }

        public void focusGained(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)keyEvent.getKeyChar(), keyEvent.getModifiers());
            InputMap inputMap = BasicTableUI.this.table.getInputMap(0);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            inputMap = BasicTableUI.this.table.getInputMap(1);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (keyEvent.getKeyChar() == '\r') {
                return;
            }
            int n = BasicTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n2 = BasicTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n != -1 && n2 != -1 && !BasicTableUI.this.table.isEditing() && !BasicTableUI.this.table.editCellAt(n, n2)) {
                return;
            }
            Component component = BasicTableUI.this.table.getEditorComponent();
            if (BasicTableUI.this.table.isEditing() && component != null && component instanceof JComponent) {
                Object object;
                JComponent jComponent = (JComponent)component;
                inputMap = jComponent.getInputMap(0);
                Object object2 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                if (object == null) {
                    inputMap = jComponent.getInputMap(1);
                    Object object3 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                }
                if (object != null) {
                    Action action;
                    ActionMap actionMap = jComponent.getActionMap();
                    Action action2 = action = actionMap != null ? actionMap.get(object) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers())) {
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            if (!jTable.hasFocus()) {
                TableCellEditor tableCellEditor = jTable.getCellEditor();
                if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                    return;
                }
                jTable.requestFocus();
                return;
            }
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            int n = listSelectionModel.getAnchorSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            int n2 = listSelectionModel2.getAnchorSelectionIndex();
            jTable.editCellAt(n, n2);
            Component component = jTable.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    private static class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            jTable.removeEditor();
        }
    }

    private static class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            jTable.selectAll();
        }
    }

    private static class PagingAction
    extends NavigationalAction {
        private boolean forwards;
        private boolean vertically;
        private boolean toLimit;

        private PagingAction(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(0, 0, false, bl, false);
            this.forwards = bl2;
            this.vertically = bl3;
            this.toLimit = bl4;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            if (this.toLimit) {
                if (this.vertically) {
                    int n = jTable.getRowCount();
                    int n2 = jTable.getColumnCount();
                    this.dx = this.extend ? 0 : (this.forwards ? n2 : -n2);
                    this.dy = this.forwards ? n : -n;
                } else {
                    int n = jTable.getColumnCount();
                    this.dx = this.forwards ? n : -n;
                    this.dy = 0;
                }
            } else {
                int n;
                if (!(jTable.getParent().getParent() instanceof JScrollPane)) {
                    return;
                }
                Dimension dimension = jTable.getParent().getSize();
                ListSelectionModel listSelectionModel = this.vertically ? jTable.getSelectionModel() : jTable.getColumnModel().getSelectionModel();
                int n3 = n = this.extend ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel.getAnchorSelectionIndex();
                if (this.vertically) {
                    Rectangle rectangle = jTable.getCellRect(n, 0, true);
                    rectangle.y = rectangle.y + (this.forwards ? dimension.height : -dimension.height);
                    this.dx = 0;
                    int n4 = jTable.rowAtPoint(rectangle.getLocation());
                    if (n4 == -1 && this.forwards) {
                        n4 = jTable.getRowCount();
                    }
                    this.dy = n4 - n;
                } else {
                    Rectangle rectangle = jTable.getCellRect(0, n, true);
                    rectangle.x = rectangle.x + (this.forwards ? dimension.width : -dimension.width);
                    int n5 = jTable.columnAtPoint(rectangle.getLocation());
                    if (n5 == -1 && this.forwards) {
                        n5 = jTable.getColumnCount();
                    }
                    this.dx = n5 - n;
                    this.dy = 0;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean toggle;
        protected boolean extend;
        protected boolean inSelection;
        protected int anchorRow;
        protected int anchorColumn;
        protected int leadRow;
        protected int leadColumn;

        protected NavigationalAction(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            this.dx = n;
            this.dy = n2;
            this.toggle = bl;
            this.extend = bl2;
            this.inSelection = bl3;
        }

        private int clipToRange(int n, int n2, int n3) {
            return Math.min(Math.max(n, n2), n3 - 1);
        }

        private void moveWithinTableRange(JTable jTable, int n, int n2, boolean bl) {
            if (bl) {
                this.leadRow = this.clipToRange(this.leadRow + n2, 0, jTable.getRowCount());
                this.leadColumn = this.clipToRange(this.leadColumn + n, 0, jTable.getColumnCount());
            } else {
                this.anchorRow = this.clipToRange(this.anchorRow + n2, 0, jTable.getRowCount());
                this.anchorColumn = this.clipToRange(this.anchorColumn + n, 0, jTable.getColumnCount());
            }
        }

        private int selectionSpan(ListSelectionModel listSelectionModel) {
            return listSelectionModel.getMaxSelectionIndex() - listSelectionModel.getMinSelectionIndex() + 1;
        }

        private int compare(int n, ListSelectionModel listSelectionModel) {
            return this.compare(n, listSelectionModel.getMinSelectionIndex(), listSelectionModel.getMaxSelectionIndex() + 1);
        }

        private int compare(int n, int n2, int n3) {
            return n < n2 ? -1 : (n >= n3 ? 1 : 0);
        }

        private boolean moveWithinSelectedRange(JTable jTable, int n, int n2, boolean bl) {
            boolean bl2;
            if (jTable.getRowCount() < 1 || jTable.getColumnCount() < 1) {
                return false;
            }
            this.anchorRow = Math.min(this.anchorRow, jTable.getRowCount());
            this.anchorColumn = Math.min(this.anchorColumn, jTable.getColumnCount());
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            if (jTable.getSelectedRow() == -1 && jTable.getSelectedColumn() == -1) {
                listSelectionModel.setSelectionInterval(0, 0);
                listSelectionModel2.setSelectionInterval(0, 0);
            }
            int n3 = this.anchorRow + n2;
            int n4 = this.anchorColumn + n;
            int n5 = this.compare(n3, listSelectionModel);
            int n6 = this.compare(n4, listSelectionModel2);
            int n7 = this.selectionSpan(listSelectionModel);
            int n8 = this.selectionSpan(listSelectionModel2);
            if (jTable.getRowSelectionAllowed()) {
                if (!jTable.getColumnSelectionAllowed()) {
                    n8 = jTable.getColumnCount();
                    n6 = this.compare(n4, 0, n8);
                }
            } else if (jTable.getColumnSelectionAllowed()) {
                n7 = jTable.getRowCount();
                n5 = this.compare(n3, 0, n7);
            } else {
                n8 = jTable.getColumnCount();
                n6 = this.compare(n4, 0, n8);
                n7 = jTable.getRowCount();
                n5 = this.compare(n3, 0, n7);
            }
            boolean bl3 = bl2 = n7 * n8 > 1;
            if (jTable.getSelectedRowCount() == 1 && jTable.getSelectedColumnCount() == 1) {
                bl2 = false;
            }
            if (!bl2) {
                n7 = jTable.getRowCount();
                n8 = jTable.getColumnCount();
                n5 = this.compare(n3, 0, n7);
                n6 = this.compare(n4, 0, n8);
            }
            this.anchorRow = n3 - n7 * n5;
            this.anchorColumn = n4 - n8 * n6;
            if (!bl) {
                return this.moveWithinSelectedRange(jTable, n5, n6, true);
            }
            return bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            this.anchorRow = listSelectionModel.getAnchorSelectionIndex();
            this.leadRow = listSelectionModel.getLeadSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            this.anchorColumn = listSelectionModel2.getAnchorSelectionIndex();
            this.leadColumn = listSelectionModel2.getLeadSelectionIndex();
            int n = this.anchorRow;
            int n2 = this.anchorColumn;
            if (jTable.isEditing() && !jTable.getCellEditor().stopCellEditing()) {
                return;
            }
            if (!this.inSelection) {
                this.moveWithinTableRange(jTable, this.dx, this.dy, this.extend);
                if (!this.extend) {
                    jTable.changeSelection(this.anchorRow, this.anchorColumn, false, this.extend);
                } else {
                    jTable.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                }
            } else if (this.moveWithinSelectedRange(jTable, this.dx, this.dy, false)) {
                jTable.changeSelection(this.anchorRow, this.anchorColumn, true, true);
            } else {
                jTable.changeSelection(this.anchorRow, this.anchorColumn, false, false);
            }
        }
    }
}

