/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.multi;

import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.multi.MultiUIDefaults;

public class MultiLookAndFeel
extends LookAndFeel {
    public String getName() {
        return "Multiplexing Look and Feel";
    }

    public String getID() {
        return "Multiplex";
    }

    public String getDescription() {
        return "Allows multiple UI instances per component instance";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public UIDefaults getDefaults() {
        MultiUIDefaults multiUIDefaults = new MultiUIDefaults();
        String string = "javax.swing.plaf.multi.Multi";
        Object[] objectArray = new Object[]{"ButtonUI", string + "ButtonUI", "CheckBoxMenuItemUI", string + "MenuItemUI", "CheckBoxUI", string + "ButtonUI", "ColorChooserUI", string + "ColorChooserUI", "ComboBoxUI", string + "ComboBoxUI", "DesktopIconUI", string + "DesktopIconUI", "DesktopPaneUI", string + "DesktopPaneUI", "EditorPaneUI", string + "TextUI", "FileChooserUI", string + "FileChooserUI", "FormattedTextFieldUI", string + "TextUI", "InternalFrameUI", string + "InternalFrameUI", "LabelUI", string + "LabelUI", "ListUI", string + "ListUI", "MenuBarUI", string + "MenuBarUI", "MenuItemUI", string + "MenuItemUI", "MenuUI", string + "MenuItemUI", "OptionPaneUI", string + "OptionPaneUI", "PanelUI", string + "PanelUI", "PasswordFieldUI", string + "TextUI", "PopupMenuSeparatorUI", string + "SeparatorUI", "PopupMenuUI", string + "PopupMenuUI", "ProgressBarUI", string + "ProgressBarUI", "RadioButtonMenuItemUI", string + "MenuItemUI", "RadioButtonUI", string + "ButtonUI", "RootPaneUI", string + "RootPaneUI", "ScrollBarUI", string + "ScrollBarUI", "ScrollPaneUI", string + "ScrollPaneUI", "SeparatorUI", string + "SeparatorUI", "SliderUI", string + "SliderUI", "SpinnerUI", string + "SpinnerUI", "SplitPaneUI", string + "SplitPaneUI", "TabbedPaneUI", string + "TabbedPaneUI", "TableHeaderUI", string + "TableHeaderUI", "TableUI", string + "TableUI", "TextAreaUI", string + "TextUI", "TextFieldUI", string + "TextUI", "TextPaneUI", string + "TextUI", "ToggleButtonUI", string + "ButtonUI", "ToolBarSeparatorUI", string + "SeparatorUI", "ToolBarUI", string + "ToolBarUI", "ToolTipUI", string + "ToolTipUI", "TreeUI", string + "TreeUI", "ViewportUI", string + "ViewportUI"};
        multiUIDefaults.putDefaults(objectArray);
        return multiUIDefaults;
    }

    public static ComponentUI createUIs(ComponentUI componentUI, Vector vector, JComponent jComponent) {
        ComponentUI componentUI2 = UIManager.getDefaults().getUI(jComponent);
        if (componentUI2 != null) {
            vector.addElement(componentUI2);
            LookAndFeel[] lookAndFeelArray = UIManager.getAuxiliaryLookAndFeels();
            if (lookAndFeelArray != null) {
                int n = 0;
                while (n < lookAndFeelArray.length) {
                    componentUI2 = lookAndFeelArray[n].getDefaults().getUI(jComponent);
                    if (componentUI2 != null) {
                        vector.addElement(componentUI2);
                    }
                    ++n;
                }
            }
        } else {
            return null;
        }
        if (vector.size() == 1) {
            return (ComponentUI)vector.elementAt(0);
        }
        return componentUI;
    }

    protected static ComponentUI[] uisToArray(Vector vector) {
        if (vector == null) {
            return new ComponentUI[0];
        }
        int n = vector.size();
        if (n > 0) {
            ComponentUI[] componentUIArray = new ComponentUI[n];
            int n2 = 0;
            while (n2 < n) {
                componentUIArray[n2] = (ComponentUI)vector.elementAt(n2);
                ++n2;
            }
            return componentUIArray;
        }
        return null;
    }
}

