/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;

public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    JTextComponent component;
    boolean async = false;
    boolean visible;
    int dot;
    int mark;
    Object selectionTag;
    boolean selectionVisible;
    Timer flasher;
    Point magicCaretPosition;
    transient Position.Bias dotBias;
    transient Position.Bias markBias;
    boolean dotLTR;
    boolean markLTR;
    transient UpdateHandler updateHandler = new UpdateHandler();
    private transient int[] flagXPoints = new int[3];
    private transient int[] flagYPoints = new int[3];
    private transient FocusListener focusListener;
    private transient NavigationFilter.FilterBypass filterBypass;
    private transient ClipboardOwner clipboardOwner;
    private boolean ownsSelection;
    private boolean forceCaretPositionChange;
    private transient boolean shouldHandleRelease;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    boolean getAsynchronousMovement() {
        return this.async;
    }

    void setAsynchronousMovement(boolean bl) {
        this.async = bl;
    }

    protected final JTextComponent getComponent() {
        return this.component;
    }

    protected final synchronized void repaint() {
        if (this.component != null) {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }

    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            this.x = rectangle.x - 4;
            this.y = rectangle.y;
            this.width = 10;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    protected void adjustVisibility(Rectangle rectangle) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.component != null) {
                this.component.scrollRectToVisible(rectangle);
            }
        } else {
            SwingUtilities.invokeLater(new SafeScroller(rectangle));
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        int n = this.component.getUI().viewToModel(this.component, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n >= 0) {
            this.setDot(n, biasArray[0]);
        }
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        int n = this.component.getUI().viewToModel(this.component, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n >= 0) {
            this.moveDot(n, biasArray[0]);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.component.isEnabled()) {
            if (this.component.isEditable()) {
                this.setVisible(true);
            }
            this.setSelectionVisible(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
        this.setSelectionVisible(this.ownsSelection || focusEvent.isTemporary());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        block5: {
            JTextComponent jTextComponent;
            int n;
            block6: {
                block7: {
                    if (mouseEvent.isConsumed()) break block5;
                    n = mouseEvent.getClickCount();
                    if (!SwingUtilities.isLeftMouseButton(mouseEvent)) break block6;
                    if (mouseEvent.getClickCount() != 2) break block7;
                    DefaultEditorKit.SelectWordAction selectWordAction = new DefaultEditorKit.SelectWordAction();
                    selectWordAction.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                    break block5;
                }
                if (mouseEvent.getClickCount() != 3) break block5;
                DefaultEditorKit.SelectLineAction selectLineAction = new DefaultEditorKit.SelectLineAction();
                selectLineAction.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                break block5;
            }
            if (!SwingUtilities.isMiddleMouseButton(mouseEvent) || n != 1 || !this.component.isEditable() || !this.component.isEnabled() || (jTextComponent = (JTextComponent)mouseEvent.getSource()) == null) break block5;
            try {
                Toolkit toolkit = jTextComponent.getToolkit();
                Clipboard clipboard = toolkit.getSystemSelection();
                if (clipboard != null) {
                    Transferable transferable;
                    this.adjustCaret(mouseEvent);
                    TransferHandler transferHandler = jTextComponent.getTransferHandler();
                    if (transferHandler != null && (transferable = clipboard.getContents(null)) != null) {
                        if (jTextComponent.getInputContext() != null) {
                            jTextComponent.getInputContext().endComposition();
                        }
                        transferHandler.importData(jTextComponent, transferable);
                    }
                    this.adjustFocus(true);
                }
            }
            catch (HeadlessException headlessException) {}
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.isConsumed()) {
                this.shouldHandleRelease = true;
            } else {
                this.shouldHandleRelease = false;
                this.adjustCaretAndFocus(mouseEvent);
            }
        }
    }

    void adjustCaretAndFocus(MouseEvent mouseEvent) {
        this.adjustCaret(mouseEvent);
        this.adjustFocus(false);
    }

    private void adjustCaret(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(mouseEvent);
        } else {
            this.positionCaret(mouseEvent);
        }
    }

    private void adjustFocus(boolean bl) {
        if (this.component != null && this.component.isEnabled() && this.component.isRequestFocusEnabled()) {
            if (bl) {
                this.component.requestFocusInWindow();
            } else {
                this.component.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.shouldHandleRelease && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.adjustCaretAndFocus(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.moveCaret(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        block6: {
            try {
                Element element;
                Object object;
                TextUI textUI = this.component.getUI();
                Rectangle rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                if (rectangle == null || rectangle.width == 0 && rectangle.height == 0) {
                    return;
                }
                if (this.width > 0 && this.height > 0 && !this._contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                    object = graphics.getClipBounds();
                    if (object != null && !((Rectangle)object).contains(this)) {
                        this.repaint();
                    }
                    this.damage(rectangle);
                }
                if (!this.isVisible()) break block6;
                graphics.setColor(this.component.getCaretColor());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                object = this.component.getDocument();
                if (object instanceof AbstractDocument && (element = ((AbstractDocument)object).getBidiRootElement()) != null && element.getElementCount() > 1) {
                    this.flagXPoints[0] = rectangle.x;
                    this.flagYPoints[0] = rectangle.y;
                    this.flagXPoints[1] = rectangle.x;
                    this.flagYPoints[1] = rectangle.y + 4;
                    this.flagYPoints[2] = rectangle.y;
                    this.flagXPoints[2] = this.dotLTR ? rectangle.x + 5 : rectangle.x - 4;
                    graphics.fillPolygon(this.flagXPoints, this.flagYPoints, 3);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        Document document = jTextComponent.getDocument();
        this.mark = 0;
        this.dot = 0;
        this.markLTR = true;
        this.dotLTR = true;
        this.dotBias = this.markBias = Position.Bias.Forward;
        if (document != null) {
            document.addDocumentListener(this.updateHandler);
        }
        jTextComponent.addPropertyChangeListener(this.updateHandler);
        this.focusListener = new FocusHandler(this);
        jTextComponent.addFocusListener(this.focusListener);
        jTextComponent.addMouseListener(this);
        jTextComponent.addMouseMotionListener(this);
        if (this.component.hasFocus()) {
            this.focusGained(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(JTextComponent jTextComponent) {
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeMouseMotionListener(this);
        if (this.focusListener != null) {
            jTextComponent.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        jTextComponent.removePropertyChangeListener(this.updateHandler);
        Document document = jTextComponent.getDocument();
        if (document != null) {
            document.removeDocumentListener(this.updateHandler);
        }
        DefaultCaret defaultCaret = this;
        synchronized (defaultCaret) {
            this.component = null;
        }
        if (this.flasher != null) {
            this.flasher.stop();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? DefaultCaret.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public void setSelectionVisible(boolean bl) {
        if (bl != this.selectionVisible) {
            this.selectionVisible = bl;
            if (this.selectionVisible) {
                Highlighter highlighter = this.component.getHighlighter();
                if (this.dot != this.mark && highlighter != null && this.selectionTag == null) {
                    int n = Math.min(this.dot, this.mark);
                    int n2 = Math.max(this.dot, this.mark);
                    Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                    try {
                        this.selectionTag = highlighter.addHighlight(n, n2, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {
                        this.selectionTag = null;
                    }
                }
            } else if (this.selectionTag != null) {
                Highlighter highlighter = this.component.getHighlighter();
                highlighter.removeHighlight(this.selectionTag);
                this.selectionTag = null;
            }
        }
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.component != null) {
            TextUI textUI = this.component.getUI();
            if (this.visible != bl) {
                this.visible = bl;
                try {
                    Rectangle rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                    this.damage(rectangle);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (this.flasher != null) {
            if (this.visible) {
                this.flasher.start();
            } else {
                this.flasher.stop();
            }
        }
    }

    public void setBlinkRate(int n) {
        if (n != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(n, this.updateHandler);
            }
            this.flasher.setDelay(n);
        } else if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.updateHandler);
            this.flasher = null;
        }
    }

    public int getBlinkRate() {
        return this.flasher == null ? 0 : this.flasher.getDelay();
    }

    public int getDot() {
        return this.dot;
    }

    public int getMark() {
        return this.mark;
    }

    public void setDot(int n) {
        this.setDot(n, Position.Bias.Forward);
    }

    public void moveDot(int n) {
        this.moveDot(n, Position.Bias.Forward);
    }

    void moveDot(int n, Position.Bias bias) {
        if (!this.component.isEnabled()) {
            this.setDot(n, bias);
            return;
        }
        if (n != this.dot) {
            NavigationFilter navigationFilter = this.component.getNavigationFilter();
            if (navigationFilter != null) {
                navigationFilter.moveDot(this.getFilterBypass(), n, bias);
            } else {
                this.handleMoveDot(n, bias);
            }
        }
    }

    void handleMoveDot(int n, Position.Bias bias) {
        Highlighter highlighter;
        this.changeCaretPosition(n, bias);
        if (this.selectionVisible && (highlighter = this.component.getHighlighter()) != null) {
            int n2;
            int n3 = Math.min(n, this.mark);
            if (n3 == (n2 = Math.max(n, this.mark))) {
                if (this.selectionTag != null) {
                    highlighter.removeHighlight(this.selectionTag);
                    this.selectionTag = null;
                }
            } else {
                try {
                    if (this.selectionTag != null) {
                        highlighter.changeHighlight(this.selectionTag, n3, n2);
                    } else {
                        Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                        this.selectionTag = highlighter.addHighlight(n3, n2, highlightPainter);
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new StateInvariantError("Bad caret position");
                }
            }
        }
    }

    void setDot(int n, Position.Bias bias) {
        NavigationFilter navigationFilter = this.component.getNavigationFilter();
        if (navigationFilter != null) {
            navigationFilter.setDot(this.getFilterBypass(), n, bias);
        } else {
            this.handleSetDot(n, bias);
        }
    }

    void handleSetDot(int n, Position.Bias bias) {
        Document document = this.component.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
        }
        if ((n = Math.max(n, 0)) == 0) {
            bias = Position.Bias.Forward;
        }
        this.mark = n;
        if (this.dot != n || this.dotBias != bias || this.selectionTag != null || this.forceCaretPositionChange) {
            this.changeCaretPosition(n, bias);
        }
        this.markBias = this.dotBias;
        this.markLTR = this.dotLTR;
        Highlighter highlighter = this.component.getHighlighter();
        if (highlighter != null && this.selectionTag != null) {
            highlighter.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    Position.Bias getDotBias() {
        return this.dotBias;
    }

    Position.Bias getMarkBias() {
        return this.markBias;
    }

    boolean isDotLeftToRight() {
        return this.dotLTR;
    }

    boolean isMarkLeftToRight() {
        return this.markLTR;
    }

    boolean isPositionLTR(int n, Position.Bias bias) {
        Document document = this.component.getDocument();
        if (document instanceof AbstractDocument) {
            if (bias == Position.Bias.Backward && --n < 0) {
                n = 0;
            }
            return ((AbstractDocument)document).isLeftToRight(n, n);
        }
        return true;
    }

    Position.Bias guessBiasForOffset(int n, Position.Bias bias, boolean bl) {
        block6: {
            if (bl != this.isPositionLTR(n, bias)) {
                bias = Position.Bias.Backward;
            } else if (bias != Position.Bias.Backward && bl != this.isPositionLTR(n, Position.Bias.Backward)) {
                bias = Position.Bias.Backward;
            }
            if (bias != Position.Bias.Backward || n <= 0) break block6;
            try {
                Segment segment = new Segment();
                this.component.getDocument().getText(n - 1, 1, segment);
                if (segment.count > 0 && segment.array[segment.offset] == '\n') {
                    bias = Position.Bias.Forward;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return bias;
    }

    void changeCaretPosition(int n, Position.Bias bias) {
        this.repaint();
        if (this.flasher != null && this.flasher.isRunning()) {
            this.visible = true;
            this.flasher.restart();
        }
        this.dot = n;
        this.dotBias = bias;
        this.dotLTR = this.isPositionLTR(n, bias);
        this.fireStateChanged();
        this.updateSystemSelection();
        this.setMagicCaretPosition(null);
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultCaret.this.repaintNewCaret();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void repaintNewCaret() {
        if (this.component != null) {
            TextUI textUI = this.component.getUI();
            Document document = this.component.getDocument();
            if (textUI != null && document != null) {
                Rectangle rectangle;
                try {
                    rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                if (rectangle != null) {
                    this.adjustVisibility(rectangle);
                    if (this.getMagicCaretPosition() == null) {
                        this.setMagicCaretPosition(new Point(rectangle.x, rectangle.y));
                    }
                }
                this.damage(rectangle);
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clipboard;
        if (this.dot != this.mark && this.component != null && (clipboard = this.getSystemSelection()) != null) {
            clipboard.setContents(new StringSelection(this.component.getSelectedText()), this.getClipboardOwner());
            this.ownsSelection = true;
        }
    }

    private Clipboard getSystemSelection() {
        try {
            return this.component.getToolkit().getSystemSelection();
        }
        catch (HeadlessException headlessException) {
        }
        catch (SecurityException securityException) {
        }
        return null;
    }

    private ClipboardOwner getClipboardOwner() {
        if (this.clipboardOwner == null) {
            this.clipboardOwner = new ClipboardHandler();
        }
        return this.clipboardOwner;
    }

    private void ensureValidPosition() {
        int n = this.component.getDocument().getLength();
        if (this.dot > n || this.mark > n) {
            this.handleSetDot(n, Position.Bias.Forward);
        }
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        String string = "Dot=(" + this.dot + ", " + this.dotBias + ")";
        string = string + " Mark=(" + this.mark + ", " + this.markBias + ")";
        return string;
    }

    private NavigationFilter.FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = new DefaultFilterBypass();
        }
        return this.filterBypass;
    }

    private boolean _contains(int n, int n2, int n3, int n4) {
        int n5 = this.width;
        int n6 = this.height;
        if ((n5 | n6 | n3 | n4) < 0) {
            return false;
        }
        int n7 = this.x;
        int n8 = this.y;
        if (n < n7 || n2 < n8) {
            return false;
        }
        if (n3 > 0) {
            n5 += n7;
            if ((n3 += n) <= n ? n5 >= n7 || n3 > n5 : n5 >= n7 && n3 > n5) {
                return false;
            }
        } else if (n7 + n5 < n) {
            return false;
        }
        if (n4 > 0) {
            n6 += n8;
            if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
                return false;
            }
        } else if (n8 + n6 < n2) {
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updateHandler = new UpdateHandler();
        this.dotBias = !objectInputStream.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
        this.markBias = !objectInputStream.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeBoolean(this.dotBias == Position.Bias.Backward);
        objectOutputStream.writeBoolean(this.markBias == Position.Bias.Backward);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DefaultFilterBypass
    extends NavigationFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        public Caret getCaret() {
            return DefaultCaret.this;
        }

        public void setDot(int n, Position.Bias bias) {
            DefaultCaret.this.handleSetDot(n, bias);
        }

        public void moveDot(int n, Position.Bias bias) {
            DefaultCaret.this.handleMoveDot(n, bias);
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener {
        UpdateHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(DefaultCaret.this.visible || DefaultCaret.this.width != 0 && DefaultCaret.this.height != 0 || DefaultCaret.this.component == null)) {
                TextUI textUI = DefaultCaret.this.component.getUI();
                try {
                    Rectangle rectangle = textUI.modelToView(DefaultCaret.this.component, DefaultCaret.this.dot, DefaultCaret.this.dotBias);
                    if (rectangle != null && rectangle.width != 0 && rectangle.height != 0) {
                        DefaultCaret.this.setVisible(true);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            DefaultCaret.this.visible = !DefaultCaret.this.visible;
            DefaultCaret.this.repaint();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (DefaultCaret.this.async || SwingUtilities.isEventDispatchThread()) {
                int n;
                boolean bl = false;
                int n2 = documentEvent.getOffset();
                int n3 = documentEvent.getLength();
                int n4 = DefaultCaret.this.dot;
                short s = 0;
                if (n4 >= n2) {
                    n4 += n3;
                    s = (short)(s | 1);
                }
                if ((n = DefaultCaret.this.mark) >= n2) {
                    n += n3;
                    s = (short)(s | 2);
                }
                if (s != 0) {
                    Position.Bias bias = DefaultCaret.this.dotBias;
                    if (DefaultCaret.this.dot == n2) {
                        boolean bl2;
                        Document document = DefaultCaret.this.component.getDocument();
                        try {
                            Segment segment = new Segment();
                            document.getText(n4 - 1, 1, segment);
                            bl2 = segment.count > 0 && segment.array[segment.offset] == '\n';
                        }
                        catch (BadLocationException badLocationException) {
                            bl2 = false;
                        }
                        bias = bl2 ? Position.Bias.Forward : Position.Bias.Backward;
                    }
                    if (n == n4) {
                        DefaultCaret.this.setDot(n4, bias);
                        DefaultCaret.this.ensureValidPosition();
                    } else {
                        DefaultCaret.this.setDot(n, DefaultCaret.this.markBias);
                        if (DefaultCaret.this.getDot() == n) {
                            DefaultCaret.this.moveDot(n4, bias);
                        }
                        DefaultCaret.this.ensureValidPosition();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent documentEvent) {
            if (DefaultCaret.this.async || SwingUtilities.isEventDispatchThread()) {
                boolean bl = false;
                int n = documentEvent.getOffset();
                int n2 = n + documentEvent.getLength();
                int n3 = DefaultCaret.this.dot;
                boolean bl2 = false;
                if (n3 >= n2) {
                    if ((n3 -= n2 - n) == n2) {
                        bl2 = true;
                    }
                } else if (n3 >= n) {
                    n3 = n;
                    bl2 = true;
                }
                int n4 = DefaultCaret.this.mark;
                boolean bl3 = false;
                if (n4 >= n2) {
                    if ((n4 -= n2 - n) == n2) {
                        bl3 = true;
                    }
                } else if (n4 >= n) {
                    n4 = n;
                    bl3 = true;
                }
                if (n4 == n3) {
                    DefaultCaret.this.forceCaretPositionChange = true;
                    try {
                        DefaultCaret.this.setDot(n3, DefaultCaret.this.guessBiasForOffset(n3, DefaultCaret.this.dotBias, DefaultCaret.this.dotLTR));
                        Object var10_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        DefaultCaret.this.forceCaretPositionChange = false;
                        throw throwable;
                    }
                    DefaultCaret.this.forceCaretPositionChange = false;
                    DefaultCaret.this.ensureValidPosition();
                } else {
                    Position.Bias bias = DefaultCaret.this.dotBias;
                    Position.Bias bias2 = DefaultCaret.this.markBias;
                    if (bl2) {
                        bias = DefaultCaret.this.guessBiasForOffset(n3, bias, DefaultCaret.this.dotLTR);
                    }
                    if (bl3) {
                        bias2 = DefaultCaret.this.guessBiasForOffset(DefaultCaret.this.mark, bias2, DefaultCaret.this.markLTR);
                    }
                    DefaultCaret.this.setDot(n4, bias2);
                    if (DefaultCaret.this.getDot() == n4) {
                        DefaultCaret.this.moveDot(n3, bias);
                    }
                    DefaultCaret.this.ensureValidPosition();
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                DefaultCaret.this.setDot(0);
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
            }
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private transient FocusListener fl;

        FocusHandler(FocusListener focusListener) {
            this.fl = focusListener;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.fl.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.fl.focusLost(focusEvent);
        }
    }

    private class ClipboardHandler
    implements ClipboardOwner {
        private ClipboardHandler() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            if (DefaultCaret.this.ownsSelection) {
                DefaultCaret.this.ownsSelection = false;
                if (DefaultCaret.this.component != null && !DefaultCaret.this.component.hasFocus()) {
                    DefaultCaret.this.setSelectionVisible(false);
                }
            }
        }
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle rectangle) {
            this.r = rectangle;
        }

        public void run() {
            if (DefaultCaret.this.component != null) {
                DefaultCaret.this.component.scrollRectToVisible(this.r);
            }
        }
    }
}

