/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GlyphView
extends View
implements TabableView,
Cloneable {
    private byte[] selections = null;
    short offset = 0;
    short length = 0;
    TabExpander expander;
    int x;
    GlyphPainter painter;
    static GlyphPainter defaultPainter;

    public GlyphView(Element element) {
        super(element);
    }

    protected final Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            object = null;
        }
        return object;
    }

    public GlyphPainter getGlyphPainter() {
        return this.painter;
    }

    public void setGlyphPainter(GlyphPainter glyphPainter) {
        this.painter = glyphPainter;
    }

    public Segment getText(int n, int n2) {
        Segment segment = SegmentCache.getSharedSegment();
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("GlyphView: Stale view: " + badLocationException);
        }
        return segment;
    }

    public Color getBackground() {
        AttributeSet attributeSet;
        Document document = this.getDocument();
        if (document instanceof StyledDocument && (attributeSet = this.getAttributes()).isDefined(StyleConstants.Background)) {
            return ((StyledDocument)document).getBackground(attributeSet);
        }
        return null;
    }

    public Color getForeground() {
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            AttributeSet attributeSet = this.getAttributes();
            return ((StyledDocument)document).getForeground(attributeSet);
        }
        Container container = this.getContainer();
        if (container != null) {
            return container.getForeground();
        }
        return null;
    }

    public Font getFont() {
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            AttributeSet attributeSet = this.getAttributes();
            return ((StyledDocument)document).getFont(attributeSet);
        }
        Container container = this.getContainer();
        if (container != null) {
            return container.getFont();
        }
        return null;
    }

    public boolean isUnderline() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isUnderline(attributeSet);
    }

    public boolean isStrikeThrough() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isStrikeThrough(attributeSet);
    }

    public boolean isSubscript() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isSubscript(attributeSet);
    }

    public boolean isSuperscript() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isSuperscript(attributeSet);
    }

    public TabExpander getTabExpander() {
        return this.expander;
    }

    protected void checkPainter() {
        if (this.painter == null) {
            if (defaultPainter == null) {
                String string = "javax.swing.text.GlyphPainter1";
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    Object obj = clazz.newInstance();
                    if (obj instanceof GlyphPainter) {
                        defaultPainter = (GlyphPainter)obj;
                    }
                }
                catch (Throwable throwable) {
                    throw new StateInvariantError("GlyphView: Can't load glyph painter: " + string);
                }
            }
            this.setGlyphPainter(defaultPainter.getPainter(this, this.getStartOffset(), this.getEndOffset()));
        }
    }

    public float getTabbedSpan(float f, TabExpander tabExpander) {
        this.checkPainter();
        this.expander = tabExpander;
        this.x = (int)f;
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        float f2 = this.painter.getSpan(this, n, n2, this.expander, f);
        return f2;
    }

    public float getPartialSpan(int n, int n2) {
        this.checkPainter();
        float f = this.painter.getSpan(this, n, n2, this.expander, this.x);
        return f;
    }

    public int getStartOffset() {
        Element element = this.getElement();
        return this.length > 0 ? element.getStartOffset() + this.offset : element.getStartOffset();
    }

    public int getEndOffset() {
        Element element = this.getElement();
        return this.length > 0 ? element.getStartOffset() + this.offset + this.length : element.getEndOffset();
    }

    private void initSelections(int n, int n2) {
        int n3 = n2 - n + 1;
        if (this.selections == null || n3 > this.selections.length) {
            this.selections = new byte[n3];
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            this.selections[n4++] = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void paint(Graphics var1_1, Shape var2_2) {
        block12: {
            block11: {
                this.checkPainter();
                var3_3 = false;
                var4_4 = this.getContainer();
                var5_5 = this.getStartOffset();
                var6_6 = this.getEndOffset();
                var7_7 = var2_2 instanceof Rectangle != false ? (Rectangle)var2_2 : var2_2.getBounds();
                var8_8 = this.getBackground();
                var9_9 = this.getForeground();
                if (var8_8 != null) {
                    var1_1.setColor(var8_8);
                    var1_1.fillRect(var7_7.x, var7_7.y, var7_7.width, var7_7.height);
                }
                if (var4_4 instanceof JTextComponent && (var11_11 = (var10_10 = (JTextComponent)var4_4).getHighlighter()) instanceof LayeredHighlighter) {
                    ((LayeredHighlighter)var11_11).paintLayeredHighlights(var1_1, var5_5, var6_6, var2_2, var10_10, this);
                }
                if (!Utilities.isComposedTextElement(this.getElement())) break block11;
                Utilities.paintComposedText(var1_1, var2_2.getBounds(), this);
                var3_3 = true;
                break block12;
            }
            if (!(var4_4 instanceof JTextComponent) || (var11_11 = (var10_10 = (JTextComponent)var4_4).getSelectedTextColor()) == null || var11_11.equals(var9_9) || (var12_12 = var10_10.getHighlighter().getHighlights()).length == 0) break block12;
            var13_13 = false;
            var14_14 = 0;
            var15_15 = 0;
            while (var15_15 < var12_12.length) {
                var16_16 = var12_12[var15_15];
                var17_18 = var16_16.getStartOffset();
                var18_19 = var16_16.getEndOffset();
                if (var17_18 <= var6_6 && var18_19 >= var5_5) {
                    if (var17_18 <= var5_5 && var18_19 >= var6_6) {
                        this.paintTextUsingColor(var1_1, var2_2, (Color)var11_11, var5_5, var6_6);
                        var3_3 = true;
                        break;
                    }
                    if (!var13_13) {
                        this.initSelections(var5_5, var6_6);
                        var13_13 = true;
                    }
                    var17_18 = Math.max(var5_5, var17_18);
                    var18_19 = Math.min(var6_6, var18_19);
                    this.paintTextUsingColor(var1_1, var2_2, (Color)var11_11, var17_18, var18_19);
                    v0 = var17_18 - var5_5;
                    this.selections[v0] = (byte)(this.selections[v0] + 1);
                    v1 = var18_19 - var5_5;
                    this.selections[v1] = (byte)(this.selections[v1] - 1);
                    ++var14_14;
                }
                ++var15_15;
            }
            if (var3_3 || var14_14 <= 0) break block12;
            var16_17 = -1;
            var17_18 = 0;
            var18_19 = var6_6 - var5_5;
            ** GOTO lbl60
            {
                ++var16_17;
                do {
                    if (var16_17 < var18_19 && this.selections[var16_17] == 0) continue block1;
                    if (var17_18 != var16_17) {
                        this.paintTextUsingColor(var1_1, var2_2, var9_9, var5_5 + var17_18, var5_5 + var16_17);
                    }
                    var19_20 = 0;
                    while (var16_17 < var18_19 && (var19_20 += this.selections[var16_17]) != 0) {
                        ++var16_17;
                    }
                    var17_18 = var16_17;
lbl60:
                    // 2 sources

                } while (var16_17++ < var18_19);
            }
            var3_3 = true;
        }
        if (!var3_3) {
            this.paintTextUsingColor(var1_1, var2_2, var9_9, var5_5, var6_6);
        }
    }

    final void paintTextUsingColor(Graphics graphics, Shape shape, Color color, int n, int n2) {
        graphics.setColor(color);
        this.painter.paint(this, graphics, shape, n, n2);
        boolean bl = this.isUnderline();
        boolean bl2 = this.isStrikeThrough();
        if (bl || bl2) {
            int n3;
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            View view = this.getParent();
            if (view != null && view.getEndOffset() == n2) {
                Segment segment = this.getText(n, n2);
                while (segment.count > 0 && Character.isWhitespace(segment.array[segment.count - 1])) {
                    --n2;
                    --segment.count;
                }
                SegmentCache.releaseSharedSegment(segment);
            }
            int n4 = rectangle.x;
            int n5 = this.getStartOffset();
            if (n5 != n) {
                n4 += (int)this.painter.getSpan(this, n5, n, this.getTabExpander(), n4);
            }
            int n6 = n4 + (int)this.painter.getSpan(this, n, n2, this.getTabExpander(), n4);
            int n7 = (int)this.painter.getDescent(this);
            int n8 = rectangle.y + rectangle.height - (int)this.painter.getDescent(this);
            if (bl) {
                n3 = n8;
                graphics.drawLine(n4, ++n3, n6, n3);
            }
            if (bl2) {
                n3 = n8;
                graphics.drawLine(n4, n3 -= (int)(this.painter.getAscent(this) * 0.3f), n6, n3);
            }
        }
    }

    public float getPreferredSpan(int n) {
        this.checkPainter();
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        switch (n) {
            case 0: {
                float f = this.painter.getSpan(this, n2, n3, this.expander, this.x);
                return Math.max(f, 1.0f);
            }
            case 1: {
                float f = this.painter.getHeight(this);
                if (this.isSuperscript()) {
                    f += f / 3.0f;
                }
                return f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        this.checkPainter();
        if (n == 1) {
            boolean bl = this.isSuperscript();
            boolean bl2 = this.isSubscript();
            float f = this.painter.getHeight(this);
            float f2 = this.painter.getDescent(this);
            float f3 = this.painter.getAscent(this);
            float f4 = bl ? 1.0f : (bl2 ? (f > 0.0f ? (f - (f2 + f3 / 2.0f)) / f : 0.0f) : (f > 0.0f ? (f - f2) / f : 0.0f));
            return f4;
        }
        return super.getAlignment(n);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.checkPainter();
        return this.painter.modelToView(this, n, bias, shape);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.checkPainter();
        return this.painter.viewToModel(this, f, f2, shape, biasArray);
    }

    public int getBreakWeight(int n, float f, float f2) {
        if (n == 0) {
            this.checkPainter();
            int n2 = this.getStartOffset();
            int n3 = this.painter.getBoundedPosition(this, n2, f, f2);
            if (n3 == n2) {
                return 0;
            }
            if (this.getBreakSpot(n2, n3) != -1) {
                return 2000;
            }
            return 1000;
        }
        return super.getBreakWeight(n, f, f2);
    }

    public View breakView(int n, int n2, float f, float f2) {
        if (n == 0) {
            this.checkPainter();
            int n3 = this.painter.getBoundedPosition(this, n2, f, f2);
            int n4 = this.getBreakSpot(n2, n3);
            if (n4 != -1) {
                n3 = n4;
            }
            if (n2 == this.getStartOffset() && n3 == this.getEndOffset()) {
                return this;
            }
            GlyphView glyphView = (GlyphView)this.createFragment(n2, n3);
            glyphView.x = (int)f;
            return glyphView;
        }
        return this;
    }

    private int getBreakSpot(int n, int n2) {
        Document document = this.getDocument();
        if (document != null && Boolean.TRUE.equals(document.getProperty(AbstractDocument.MultiByteProperty))) {
            return this.getBreakSpotUseBreakIterator(n, n2);
        }
        return this.getBreakSpotUseWhitespace(n, n2);
    }

    private int getBreakSpotUseWhitespace(int n, int n2) {
        Segment segment = this.getText(n, n2);
        char c = segment.last();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                SegmentCache.releaseSharedSegment(segment);
                return segment.getIndex() - segment.getBeginIndex() + 1 + n;
            }
            c = segment.previous();
        }
        SegmentCache.releaseSharedSegment(segment);
        return -1;
    }

    private int getBreakSpotUseBreakIterator(int n, int n2) {
        int n3;
        int n4;
        int n5;
        Element element = this.getElement().getParentElement();
        Container container = this.getContainer();
        if (element == null) {
            n5 = n;
            n4 = n2;
        } else {
            n5 = element.getStartOffset();
            n4 = element.getEndOffset();
        }
        BreakIterator breakIterator = container != null ? BreakIterator.getLineInstance(container.getLocale()) : BreakIterator.getLineInstance();
        Segment segment = this.getText(n5, n4);
        segment.first();
        breakIterator.setText(segment);
        if (n2 == n4) {
            n3 = breakIterator.last();
        } else if (n2 + 1 == n4) {
            n3 = breakIterator.next(segment.offset + segment.count - 2);
            if (n3 >= segment.count + segment.offset) {
                n3 = breakIterator.preceding(segment.offset + segment.count - 1);
            }
        } else {
            n3 = breakIterator.preceding(n2 - n5 + segment.offset + 1);
        }
        int n6 = -1;
        if (n3 != -1 && (n3 = n3 - segment.offset + n5) > n) {
            if (n == n5 && n3 == n) {
                n6 = -1;
            } else if (n3 <= n2) {
                n6 = n3;
            }
        }
        SegmentCache.releaseSharedSegment(segment);
        return n6;
    }

    public View createFragment(int n, int n2) {
        this.checkPainter();
        Element element = this.getElement();
        GlyphView glyphView = (GlyphView)this.clone();
        glyphView.offset = (short)(n - element.getStartOffset());
        glyphView.length = (short)(n2 - n);
        glyphView.painter = this.painter.getPainter(glyphView, n, n2);
        return glyphView;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return this.painter.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, false);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, false);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, true);
    }

    public static abstract class GlyphPainter {
        public abstract float getSpan(GlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public abstract float getHeight(GlyphView var1);

        public abstract float getAscent(GlyphView var1);

        public abstract float getDescent(GlyphView var1);

        public abstract void paint(GlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(GlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(GlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract int getBoundedPosition(GlyphView var1, int var2, float var3, float var4);

        public GlyphPainter getPainter(GlyphView glyphView, int n, int n2) {
            return this;
        }

        public int getNextVisualPositionFrom(GlyphView glyphView, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = glyphView.getStartOffset();
            int n4 = glyphView.getEndOffset();
            switch (n2) {
                case 1: 
                case 5: {
                    Point point;
                    if (n != -1) {
                        return -1;
                    }
                    Container container = glyphView.getContainer();
                    if (!(container instanceof JTextComponent)) break;
                    Caret caret = ((JTextComponent)container).getCaret();
                    Point point2 = point = caret != null ? caret.getMagicCaretPosition() : null;
                    if (point == null) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    int n5 = glyphView.viewToModel(point.x, 0.0f, shape, biasArray);
                    return n5;
                }
                case 3: {
                    if (n3 == glyphView.getDocument().getLength()) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        return -1;
                    }
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    if (n == n4) {
                        return -1;
                    }
                    if (++n == n4) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n;
                }
                case 7: {
                    if (n3 == glyphView.getDocument().getLength()) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        return -1;
                    }
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n4 - 1;
                    }
                    if (n == n3) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n - 1;
                }
                default: {
                    throw new IllegalArgumentException("Bad direction: " + n2);
                }
            }
            return n;
        }
    }
}

