/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;

public abstract class TableView
extends BoxView {
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements[] columnRequirements;
    Vector rows = new Vector();
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public TableView(Element element) {
        super(element, 1);
    }

    protected TableRow createTableRow(Element element) {
        return new TableRow(element);
    }

    protected TableCell createTableCell(Element element) {
        return new TableCell(element);
    }

    int getColumnCount() {
        return this.columnSpans.length;
    }

    int getColumnSpan(int n) {
        return this.columnSpans[n];
    }

    int getRowCount() {
        return this.rows.size();
    }

    int getRowSpan(int n) {
        TableRow tableRow = this.getRow(n);
        if (tableRow != null) {
            return (int)((View)tableRow).getPreferredSpan(1);
        }
        return 0;
    }

    TableRow getRow(int n) {
        if (n < this.rows.size()) {
            return (TableRow)this.rows.elementAt(n);
        }
        return null;
    }

    int getColumnsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 1;
    }

    int getRowsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 1;
    }

    void invalidateGrid() {
        this.gridValid = false;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container;
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (shape != null && (container = this.getContainer()) != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        this.invalidateGrid();
    }

    void updateGrid() {
        if (!this.gridValid) {
            this.rows.removeAllElements();
            int n = this.getViewCount();
            int n2 = 0;
            while (n2 < n) {
                View view = this.getView(n2);
                if (view instanceof TableRow) {
                    this.rows.addElement(view);
                    TableRow tableRow = (TableRow)view;
                    tableRow.clearFilledColumns();
                    tableRow.setRow(n2);
                }
                ++n2;
            }
            int n3 = 0;
            int n4 = this.rows.size();
            int n5 = 0;
            while (n5 < n4) {
                TableRow tableRow = this.getRow(n5);
                int n6 = 0;
                int n7 = 0;
                while (n7 < tableRow.getViewCount()) {
                    View view = tableRow.getView(n7);
                    while (tableRow.isFilled(n6)) {
                        ++n6;
                    }
                    int n8 = this.getRowsOccupied(view);
                    int n9 = this.getColumnsOccupied(view);
                    if (n9 > 1 || n8 > 1) {
                        int n10 = n5 + n8;
                        int n11 = n6 + n9;
                        int n12 = n5;
                        while (n12 < n10) {
                            int n13 = n6;
                            while (n13 < n11) {
                                if (n12 != n5 || n13 != n6) {
                                    this.addFill(n12, n13);
                                }
                                ++n13;
                            }
                            ++n12;
                        }
                        if (n9 > 1) {
                            n6 += n9 - 1;
                        }
                    }
                    ++n7;
                    ++n6;
                }
                n3 = Math.max(n3, n6);
                ++n5;
            }
            this.columnSpans = new int[n3];
            this.columnOffsets = new int[n3];
            this.columnRequirements = new SizeRequirements[n3];
            int n14 = 0;
            while (n14 < n3) {
                this.columnRequirements[n14] = new SizeRequirements();
                ++n14;
            }
            this.gridValid = true;
        }
    }

    void addFill(int n, int n2) {
        TableRow tableRow = this.getRow(n);
        if (tableRow != null) {
            tableRow.fillColumn(n2);
        }
    }

    protected void layoutColumns(int n, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        SizeRequirements.calculateTiledPositions(n, null, sizeRequirementsArray, nArray, nArray2);
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n3 = this.getRowCount();
        int n4 = 0;
        while (n4 < n3) {
            TableRow tableRow = this.getRow(n4);
            tableRow.layoutChanged(n2);
            ++n4;
        }
        this.layoutColumns(n, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n, n2, nArray, nArray2);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        this.updateGrid();
        this.calculateColumnRequirements(n);
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        while (n2 < this.columnRequirements.length) {
            SizeRequirements sizeRequirements2 = this.columnRequirements[n2];
            l += (long)sizeRequirements2.minimum;
            l2 += (long)sizeRequirements2.preferred;
            l3 += (long)sizeRequirements2.maximum;
            ++n2;
        }
        sizeRequirements.minimum = (int)l;
        sizeRequirements.preferred = (int)l2;
        sizeRequirements.maximum = (int)l3;
        sizeRequirements.alignment = 0.0f;
        return sizeRequirements;
    }

    void calculateColumnRequirements(int n) {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = this.getRowCount();
        int n6 = 0;
        while (n6 < n5) {
            TableRow tableRow = this.getRow(n6);
            int n7 = 0;
            n4 = tableRow.getViewCount();
            n3 = 0;
            while (n3 < n4) {
                View view = tableRow.getView(n3);
                while (tableRow.isFilled(n7)) {
                    ++n7;
                }
                int n8 = this.getRowsOccupied(view);
                n2 = this.getColumnsOccupied(view);
                if (n2 == 1) {
                    this.checkSingleColumnCell(n, n7, view);
                } else {
                    bl = true;
                    n7 += n2 - 1;
                }
                ++n3;
                ++n7;
            }
            ++n6;
        }
        if (bl) {
            int n9 = 0;
            while (n9 < n5) {
                TableRow tableRow = this.getRow(n9);
                n4 = 0;
                n3 = tableRow.getViewCount();
                int n10 = 0;
                while (n10 < n3) {
                    View view = tableRow.getView(n10);
                    while (tableRow.isFilled(n4)) {
                        ++n4;
                    }
                    n2 = this.getColumnsOccupied(view);
                    if (n2 > 1) {
                        this.checkMultiColumnCell(n, n4, n2, view);
                        n4 += n2 - 1;
                    }
                    ++n10;
                    ++n4;
                }
                ++n9;
            }
        }
    }

    void checkSingleColumnCell(int n, int n2, View view) {
        SizeRequirements sizeRequirements = this.columnRequirements[n2];
        sizeRequirements.minimum = Math.max((int)view.getMinimumSpan(n), sizeRequirements.minimum);
        sizeRequirements.preferred = Math.max((int)view.getPreferredSpan(n), sizeRequirements.preferred);
        sizeRequirements.maximum = Math.max((int)view.getMaximumSpan(n), sizeRequirements.maximum);
    }

    void checkMultiColumnCell(int n, int n2, int n3, View view) {
        int n4;
        Object object;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        while (n5 < n3) {
            SizeRequirements sizeRequirements = this.columnRequirements[n2 + n5];
            l += (long)sizeRequirements.minimum;
            l2 += (long)sizeRequirements.preferred;
            l3 += (long)sizeRequirements.maximum;
            ++n5;
        }
        int n6 = (int)view.getMinimumSpan(n);
        if ((long)n6 > l) {
            Object object2;
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n3];
            int n7 = 0;
            while (n7 < n3) {
                sizeRequirementsArray[n7] = this.columnRequirements[n2 + n7];
                object2 = sizeRequirementsArray[n7];
                object2.maximum = Math.max(object2.maximum, (int)view.getMaximumSpan(n));
                ++n7;
            }
            object2 = new int[n3];
            object = new int[n3];
            SizeRequirements.calculateTiledPositions(n6, null, sizeRequirementsArray, object, object2);
            int n8 = 0;
            while (n8 < n3) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[n8];
                sizeRequirements.minimum = Math.max(object2[n8], sizeRequirements.minimum);
                sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
                ++n8;
            }
        }
        if ((long)(n4 = (int)view.getPreferredSpan(n)) > l2) {
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n3];
            int n9 = 0;
            while (n9 < n3) {
                sizeRequirementsArray[n9] = this.columnRequirements[n2 + n9];
                object = sizeRequirementsArray[n9];
                ++n9;
            }
            object = new int[n3];
            int[] nArray = new int[n3];
            SizeRequirements.calculateTiledPositions(n4, null, sizeRequirementsArray, nArray, object);
            int n10 = 0;
            while (n10 < n3) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[n10];
                sizeRequirements.preferred = Math.max(object[n10], sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
                ++n10;
            }
        }
    }

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        View view;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            view = this.getView(n3);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n >= n4 && n < n5) {
                if (rectangle != null) {
                    this.childAllocation(n3, rectangle);
                }
                return view;
            }
            ++n3;
        }
        if (n == this.getEndOffset()) {
            view = this.getView(n2 - 1);
            if (rectangle != null) {
                this.childAllocation(n2 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    static interface GridCell {
        public void setGridLocation(int var1, int var2);

        public int getGridRow();

        public int getGridColumn();

        public int getColumnCount();

        public int getRowCount();
    }

    public class TableCell
    extends BoxView
    implements GridCell {
        int row;
        int col;

        public TableCell(Element element) {
            super(element, 1);
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        public void setGridLocation(int n, int n2) {
            this.row = n;
            this.col = n2;
        }

        public int getGridRow() {
            return this.row;
        }

        public int getGridColumn() {
            return this.col;
        }
    }

    public class TableRow
    extends BoxView {
        BitSet fillColumns;
        int row;

        public TableRow(Element element) {
            super(element, 0);
            this.fillColumns = new BitSet();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int n) {
            this.fillColumns.set(n);
        }

        boolean isFilled(int n) {
            return this.fillColumns.get(n);
        }

        int getRow() {
            return this.row;
        }

        void setRow(int n) {
            this.row = n;
        }

        int getColumnCount() {
            int n = 0;
            int n2 = this.fillColumns.size();
            int n3 = 0;
            while (n3 < n2) {
                if (this.fillColumns.get(n3)) {
                    ++n;
                }
                ++n3;
            }
            return this.getViewCount() + n;
        }

        public void replace(int n, int n2, View[] viewArray) {
            super.replace(n, n2, viewArray);
            TableView.this.invalidateGrid();
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = 0;
            while (n5 < n4) {
                View view = this.getView(n5);
                while (this.isFilled(n3)) {
                    ++n3;
                }
                int n6 = TableView.this.getColumnsOccupied(view);
                nArray2[n5] = TableView.this.columnSpans[n3];
                nArray[n5] = TableView.this.columnOffsets[n3];
                if (n6 > 1) {
                    int n7 = TableView.this.columnSpans.length;
                    int n8 = 1;
                    while (n8 < n6) {
                        if (n3 + n8 < n7) {
                            int n9 = n5;
                            nArray2[n9] = nArray2[n9] + TableView.this.columnSpans[n3 + n8];
                        }
                        ++n8;
                    }
                    n3 += n6 - 1;
                }
                ++n5;
                ++n3;
            }
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n, n2, nArray, nArray2);
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = 0;
            while (n5 < n4) {
                View view = this.getView(n5);
                while (this.isFilled(n3)) {
                    ++n3;
                }
                int n6 = TableView.this.getColumnsOccupied(view);
                int n7 = TableView.this.getRowsOccupied(view);
                if (n7 > 1) {
                    int n8 = 1;
                    while (n8 < n7) {
                        int n9 = this.getRow() + n8;
                        if (n9 < TableView.this.getViewCount()) {
                            int n10 = TableView.this.getSpan(1, this.getRow() + n8);
                            int n11 = n5;
                            nArray2[n11] = nArray2[n11] + n10;
                        }
                        ++n8;
                    }
                }
                if (n6 > 1) {
                    n3 += n6 - 1;
                }
                ++n5;
                ++n3;
            }
        }

        public int getResizeWeight(int n) {
            return 1;
        }

        protected View getViewAtPosition(int n, Rectangle rectangle) {
            View view;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                view = this.getView(n3);
                int n4 = view.getStartOffset();
                int n5 = view.getEndOffset();
                if (n >= n4 && n < n5) {
                    if (rectangle != null) {
                        this.childAllocation(n3, rectangle);
                    }
                    return view;
                }
                ++n3;
            }
            if (n == this.getEndOffset()) {
                view = this.getView(n2 - 1);
                if (rectangle != null) {
                    this.childAllocation(n2 - 1, rectangle);
                }
                return view;
            }
            return null;
        }
    }
}

