/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletPropsErrorDialog;
import sun.applet.AppletSecurity;
import sun.applet.Main;
import sun.net.www.http.HttpClient;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

class AppletProps
extends Frame {
    TextField proxyHost;
    TextField proxyPort;
    Choice accessMode;
    private static AppletMessageHandler amh = new AppletMessageHandler("appletprops");

    AppletProps() {
        this.setTitle(amh.getMessage("title"));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new Label(amh.getMessage("label.http.server", "Http proxy server:")));
        this.proxyHost = new TextField();
        panel.add(this.proxyHost);
        panel.add(new Label(amh.getMessage("label.http.proxy")));
        this.proxyPort = new TextField();
        panel.add(this.proxyPort);
        panel.add(new Label(amh.getMessage("label.class")));
        this.accessMode = new Choice();
        panel.add(this.accessMode);
        this.accessMode.addItem(amh.getMessage("choice.class.item.restricted"));
        this.accessMode.addItem(amh.getMessage("choice.class.item.unrestricted"));
        this.add("Center", panel);
        panel = new Panel();
        panel.add(new Button(amh.getMessage("button.apply")));
        panel.add(new Button(amh.getMessage("button.reset")));
        panel.add(new Button(amh.getMessage("button.cancel")));
        this.add("South", panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppletProps.this.reset();
                AppletProps.this.hide();
            }
        });
        this.move(200, 150);
        this.pack();
        this.reset();
    }

    void reset() {
        AppletSecurity appletSecurity = (AppletSecurity)System.getSecurityManager();
        if (appletSecurity != null) {
            appletSecurity.reset();
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("http.proxyPort"));
        Boolean bl = AccessController.doPrivileged(new GetBooleanAction("package.restrict.access.sun"));
        boolean bl2 = bl;
        if (bl2) {
            this.accessMode.select(amh.getMessage("choice.class.item.restricted"));
        } else {
            this.accessMode.select(amh.getMessage("choice.class.item.unrestricted"));
        }
        if (string != null) {
            this.proxyHost.setText(string);
            this.proxyPort.setText(string2);
            HttpClient.proxyPort = Integer.valueOf(string2);
        } else {
            this.proxyHost.setText("");
            this.proxyPort.setText("");
        }
    }

    void apply() {
        String string = this.proxyHost.getText().trim();
        String string2 = this.proxyPort.getText().trim();
        final Properties properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
        if (string.length() != 0) {
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                this.proxyPort.selectAll();
                this.proxyPort.requestFocus();
                new AppletPropsErrorDialog((Frame)this, amh.getMessage("title.invalidproxy"), amh.getMessage("label.invalidproxy"), amh.getMessage("button.ok")).show();
                return;
            }
            properties.put("http.proxyHost", string);
            properties.put("http.proxyPort", string2);
        } else {
            properties.put("http.proxyHost", "");
        }
        if (amh.getMessage("choice.class.item.restricted").equals(this.accessMode.getSelectedItem())) {
            properties.put("package.restrict.access.sun", "true");
        } else {
            properties.put("package.restrict.access.sun", "false");
        }
        try {
            this.reset();
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = Main.theUserPropertiesFile;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    Properties properties2 = new Properties();
                    int n = 0;
                    while (n < Main.avDefaultUserProps.length) {
                        String string = Main.avDefaultUserProps[n][0];
                        properties2.setProperty(string, properties.getProperty(string));
                        ++n;
                    }
                    properties2.store(fileOutputStream, amh.getMessage("prop.store"));
                    fileOutputStream.close();
                    return null;
                }
            });
            this.hide();
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println(amh.getMessage("apply.exception", privilegedActionException.getException()));
            privilegedActionException.printStackTrace();
            this.reset();
        }
    }

    public boolean action(Event event, Object object) {
        if (amh.getMessage("button.apply").equals(object)) {
            this.apply();
            return true;
        }
        if (amh.getMessage("button.reset").equals(object)) {
            this.reset();
            return true;
        }
        if (amh.getMessage("button.cancel").equals(object)) {
            this.reset();
            this.hide();
            return true;
        }
        return false;
    }
}

