/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.peer.FontPeer;
import java.util.Hashtable;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.FontProperties;
import sun.awt.NativeLibLoader;
import sun.awt.font.NativeFontWrapper;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.java2d.FontSupport;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected FontProperties props;
    protected FontDescriptor defaultFont;
    protected static Hashtable charsetRegistry;
    protected String familyName;
    protected String styleString;
    private Object[] fontCache;
    protected static int FONTCACHESIZE;
    protected static int FONTCACHEMASK;
    protected static String osVersion;
    protected static FontProperties fprops;

    public PlatformFont(String string, int n) {
        int n2;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof FontSupport) {
            this.props = ((FontSupport)((Object)graphicsEnvironment)).getFontProperties();
        }
        if (this.props == null && (this.props = fprops) == null) {
            return;
        }
        this.props = fprops;
        this.familyName = this.props.getProperty("alias." + string.toLowerCase());
        if (this.familyName == null) {
            this.familyName = string.toLowerCase();
        }
        if (this.props.getProperty(this.familyName + ".0") == null && this.props.getProperty(this.familyName + ".plain.0") == null) {
            if (NativeFontWrapper.isKnown(string)) {
                this.props = null;
                return;
            }
            this.familyName = "sansserif";
        }
        this.styleString = PlatformFont.styleStr(n);
        Vector<FontDescriptor> vector = new Vector<FontDescriptor>(5);
        int n3 = 0;
        while (true) {
            int[] nArray;
            String string2 = String.valueOf(n3);
            String string3 = this.props.getProperty(this.familyName + "." + this.styleString + "." + string2);
            if (string3 == null && (string3 = this.props.getProperty(this.familyName + "." + string2)) == null) break;
            String string4 = this.props.getProperty("fontcharset." + this.familyName + "." + this.styleString + "." + string2);
            if (string4 == null && (string4 = this.props.getProperty("fontcharset." + this.familyName + "." + string2)) == null) {
                string4 = "default";
            }
            CharToByteConverter charToByteConverter = this.getFontCharset(string4.trim(), string3);
            String string5 = this.props.getProperty("exclusion." + this.familyName + "." + this.styleString + "." + string2);
            if (string5 == null && (string5 = this.props.getProperty("exclusion." + this.familyName + "." + string2)) == null) {
                string5 = "none";
            }
            if (string5.equals("none")) {
                nArray = new int[]{};
            } else {
                int n4 = 1;
                int n5 = 0;
                while ((n5 = string5.indexOf(44, n5)) != -1) {
                    ++n5;
                    ++n4;
                }
                nArray = new int[n4];
                int n6 = 0;
                while (n6 < n4) {
                    String string6;
                    String string7;
                    int n7 = 0;
                    int n8 = 0;
                    try {
                        string7 = string5.substring(n6 * 10, n6 * 10 + 4);
                        string6 = string5.substring(n6 * 10 + 5, n6 * 10 + 9);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        nArray = new int[]{};
                        break;
                    }
                    try {
                        n7 = Integer.parseInt(string7, 16);
                        n8 = Integer.parseInt(string6, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = new int[]{};
                        break;
                    }
                    nArray[n6] = n7 << 16 | n8;
                    ++n6;
                }
            }
            vector.addElement(new FontDescriptor(string3, charToByteConverter, nArray));
            ++n3;
        }
        this.componentFonts = new FontDescriptor[n3];
        int n9 = 0;
        while (n9 < n3) {
            this.componentFonts[n9] = (FontDescriptor)vector.elementAt(n9);
            ++n9;
        }
        try {
            n2 = Integer.parseInt(this.props.getProperty("default.char", "003f"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 63;
        }
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        int n10 = 0;
        while (n10 < this.componentFonts.length) {
            if (!this.componentFonts[n10].isExcluded((char)n2) && this.componentFonts[n10].fontCharset.canConvert((char)n2)) {
                this.defaultFont = this.componentFonts[n10];
                this.defaultChar = (char)n2;
                break;
            }
            ++n10;
        }
    }

    public CharsetString[] makeMultiCharsetString(String string) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length(), true);
    }

    public CharsetString[] makeMultiCharsetString(String string, boolean bl) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length(), bl);
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2) {
        return this.makeMultiCharsetString(cArray, n, n2, true);
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2, boolean bl) {
        CharsetString[] charsetStringArray;
        int n3;
        Object object;
        if (n2 < 1) {
            return new CharsetString[0];
        }
        Vector<CharsetString> vector = null;
        char[] cArray2 = new char[n2];
        char c = this.defaultChar;
        Object object2 = this.defaultFont;
        int n4 = 0;
        while (n4 < this.componentFonts.length) {
            if (!this.componentFonts[n4].isExcluded(cArray[n]) && this.componentFonts[n4].fontCharset.canConvert(cArray[n])) {
                object2 = this.componentFonts[n4];
                c = cArray[n];
                break;
            }
            ++n4;
        }
        if (!bl && c == this.defaultChar) {
            return null;
        }
        cArray2[0] = c;
        int n5 = 0;
        int n6 = 1;
        while (n6 < n2) {
            char c2 = cArray[n + n6];
            object = this.defaultFont;
            c = this.defaultChar;
            n3 = 0;
            while (n3 < this.componentFonts.length) {
                if (!this.componentFonts[n3].isExcluded(c2) && this.componentFonts[n3].fontCharset.canConvert(c2)) {
                    object = this.componentFonts[n3];
                    c = c2;
                    break;
                }
                ++n3;
            }
            if (!bl && c == this.defaultChar) {
                return null;
            }
            cArray2[n6] = c;
            if (object2 != object) {
                if (vector == null) {
                    vector = new Vector<CharsetString>(3);
                }
                vector.addElement(new CharsetString(cArray2, n5, n6 - n5, (FontDescriptor)object2));
                object2 = object;
                object = this.defaultFont;
                n5 = n6;
            }
            ++n6;
        }
        object = new CharsetString(cArray2, n5, n2 - n5, (FontDescriptor)object2);
        if (vector == null) {
            charsetStringArray = new CharsetString[]{object};
        } else {
            vector.addElement((CharsetString)object);
            charsetStringArray = new CharsetString[vector.size()];
            n3 = 0;
            while (n3 < vector.size()) {
                charsetStringArray[n3] = (CharsetString)vector.elementAt(n3);
                ++n3;
            }
        }
        return charsetStringArray;
    }

    public boolean mightHaveMultiFontMetrics() {
        return this.props != null;
    }

    public Object[] makeConvertedMultiFontString(String string) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length());
    }

    public Object[] makeConvertedMultiFontString(String string, Font font) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length(), font);
    }

    public Object[] makeConvertedMultiFontChars(char[] cArray, int n, int n2) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(cArray, n, n2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object[] makeConvertedMultiFontChars(char[] var1_1, int var2_2, int var3_3, Font var4_4) throws MalformedInputException, ConversionBufferFullException {
        var5_5 = new Object[2];
        var7_6 = null;
        var8_7 = var2_2;
        var9_8 = 0;
        var10_9 = 0;
        var12_10 = null;
        var13_11 = null;
        var16_12 = var2_2 + var3_3;
        if (var2_2 < 0 || var16_12 > var1_1.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (var8_7 < var16_12) ** GOTO lbl79
        return null;
lbl-1000:
        // 1 sources

        {
            var14_14 = var1_1[var8_7];
            var11_13 = var14_14 & PlatformFont.FONTCACHEMASK;
            var15_15 = (PlatformFontCache)this.getFontCache()[var11_13];
            if (var15_15 == null || var15_15.uniChar != var14_14) {
                var12_10 = this.defaultFont;
                var14_14 = this.defaultChar;
                var17_16 = var1_1[var8_7];
                var18_18 = this.componentFonts.length;
                var19_19 = 0;
                while (var19_19 < var18_18) {
                    var20_20 /* !! */  = (char[])this.componentFonts[var19_19];
                    var20_20 /* !! */ .fontCharset.reset();
                    var20_20 /* !! */ .fontCharset.setSubstitutionMode(false);
                    if (!var20_20 /* !! */ .isExcluded(var17_16) && var20_20 /* !! */ .fontCharset.canConvert(var17_16) && (var4_4 == null || NativeFontWrapper.canDisplaySlot(var4_4, var19_19, var17_16))) {
                        var12_10 = var20_20 /* !! */ ;
                        var14_14 = var17_16;
                        break;
                    }
                    ++var19_19;
                }
                try {
                    var20_20 /* !! */  = new char[]{var14_14};
                    var15_15 = new PlatformFontCache();
                    var15_15.encodingSize = var12_10.useUnicode() != false ? (byte)var12_10.unicodeCharset.convert(var20_20 /* !! */ , 0, 1, var15_15.encoding, 0, 4) : (byte)var12_10.fontCharset.convert(var20_20 /* !! */ , 0, 1, var15_15.encoding, 0, 4);
                    var15_15.fontDescriptor = var12_10;
                    var15_15.uniChar = var1_1[var8_7];
                    this.getFontCache()[var11_13] = var15_15;
                }
                catch (Exception var20_21) {
                    System.err.println(var20_21);
                    var20_21.printStackTrace();
                    return null;
                }
            }
            if (var13_11 != var15_15.fontDescriptor) {
                if (var13_11 != null) {
                    var5_5[var10_9++] = var13_11;
                    var5_5[var10_9++] = var7_6;
                    if (var7_6 != null) {
                        var7_6[0] = (byte)((var9_8 -= 4) >> 24);
                        var7_6[1] = (byte)(var9_8 >> 16);
                        var7_6[2] = (byte)(var9_8 >> 8);
                        var7_6[3] = (byte)var9_8;
                    }
                    if (var10_9 >= var5_5.length) {
                        var17_17 = new Object[var5_5.length * 2];
                        System.arraycopy(var5_5, 0, var17_17, 0, var5_5.length);
                        var5_5 = var17_17;
                    }
                }
                var7_6 = var15_15.fontDescriptor.useUnicode() != false ? new byte[(var16_12 - var8_7 + 1) * var15_15.fontDescriptor.unicodeCharset.getMaxBytesPerChar() + 4] : new byte[(var16_12 - var8_7 + 1) * var15_15.fontDescriptor.fontCharset.getMaxBytesPerChar() + 4];
                var9_8 = 4;
                var13_11 = var15_15.fontDescriptor;
            }
            if (var15_15.encodingSize == 1) {
                var7_6[var9_8++] = var15_15.encoding[0];
            } else if (var15_15.encodingSize == 2) {
                var7_6[var9_8++] = var15_15.encoding[0];
                var7_6[var9_8++] = var15_15.encoding[1];
            } else if (var15_15.encodingSize == 3) {
                var7_6[var9_8++] = var15_15.encoding[0];
                var7_6[var9_8++] = var15_15.encoding[1];
                var7_6[var9_8++] = var15_15.encoding[2];
            } else if (var15_15.encodingSize == 4) {
                var7_6[var9_8++] = var15_15.encoding[0];
                var7_6[var9_8++] = var15_15.encoding[1];
                var7_6[var9_8++] = var15_15.encoding[2];
                var7_6[var9_8++] = var15_15.encoding[3];
            }
            ++var8_7;
lbl79:
            // 2 sources

            ** while (var8_7 < var16_12)
        }
lbl80:
        // 1 sources

        var5_5[var10_9++] = var13_11;
        var5_5[var10_9++] = var7_6;
        if (var7_6 != null) {
            var7_6[0] = (byte)((var9_8 -= 4) >> 24);
            var7_6[1] = (byte)(var9_8 >> 16);
            var7_6[2] = (byte)(var9_8 >> 8);
            var7_6[3] = (byte)var9_8;
        }
        return var5_5;
    }

    protected abstract CharToByteConverter getFontCharset(String var1, String var2);

    protected final Object[] getFontCache() {
        if (this.fontCache == null) {
            this.fontCache = new Object[FONTCACHESIZE];
        }
        return this.fontCache;
    }

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    private static native void initIDs();

    static {
        NativeLibLoader.loadLibraries();
        PlatformFont.initIDs();
        charsetRegistry = new Hashtable(5);
        FONTCACHESIZE = 256;
        FONTCACHEMASK = FONTCACHESIZE - 1;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof FontSupport) {
            fprops = ((FontSupport)((Object)graphicsEnvironment)).getFontProperties();
        }
    }

    class PlatformFontCache {
        char uniChar;
        FontDescriptor fontDescriptor;
        byte encodingSize;
        byte[] encoding = new byte[4];

        PlatformFontCache() {
        }
    }
}

