/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import sun.awt.SunGraphicsCallback;

public class RepaintArea {
    private static final int MAX_BENEFIT_RATIO = 4;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private static final int UPDATE = 2;
    private Rectangle[] paintRects = new Rectangle[3];
    private static transient SunGraphicsCallback repaintCallback;

    public RepaintArea() {
    }

    private RepaintArea(RepaintArea repaintArea) {
        int n = 0;
        while (n < this.paintRects.length) {
            this.paintRects[n] = repaintArea.paintRects[n];
            ++n;
        }
    }

    public synchronized void add(Rectangle rectangle, int n) {
        if (rectangle.isEmpty()) {
            return;
        }
        int n2 = 2;
        if (n == 800) {
            int n3 = n2 = rectangle.width > rectangle.height ? 0 : 1;
        }
        if (this.paintRects[n2] != null) {
            this.paintRects[n2].add(rectangle);
        } else {
            this.paintRects[n2] = new Rectangle(rectangle);
        }
    }

    private synchronized RepaintArea cloneAndReset() {
        RepaintArea repaintArea = new RepaintArea(this);
        int n = 0;
        while (n < this.paintRects.length) {
            this.paintRects[n] = null;
            ++n;
        }
        return repaintArea;
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.paintRects.length) {
            if (this.paintRects[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Object object, boolean bl) {
        Component component = (Component)object;
        if (this.isEmpty()) {
            return;
        }
        if (!component.isVisible()) {
            return;
        }
        RepaintArea repaintArea = this.cloneAndReset();
        if (!RepaintArea.subtract(repaintArea.paintRects[1], repaintArea.paintRects[0])) {
            RepaintArea.subtract(repaintArea.paintRects[0], repaintArea.paintRects[1]);
        }
        if (repaintArea.paintRects[0] != null && repaintArea.paintRects[1] != null) {
            Rectangle rectangle = repaintArea.paintRects[0].union(repaintArea.paintRects[1]);
            int n = rectangle.width * rectangle.height;
            int n2 = n - repaintArea.paintRects[0].width * repaintArea.paintRects[0].height - repaintArea.paintRects[1].width * repaintArea.paintRects[1].height;
            if (4 * n2 < n) {
                repaintArea.paintRects[0] = rectangle;
                repaintArea.paintRects[1] = null;
            }
        }
        int n = 0;
        while (n < this.paintRects.length) {
            Graphics graphics;
            if (repaintArea.paintRects[n] != null && !repaintArea.paintRects[n].isEmpty() && (graphics = component.getGraphics()) != null) {
                Object var9_10;
                try {
                    graphics.setClip(repaintArea.paintRects[n]);
                    if (n == 2) {
                        component.update(graphics);
                    } else {
                        if (bl) {
                            graphics.clearRect(repaintArea.paintRects[n].x, repaintArea.paintRects[n].y, repaintArea.paintRects[n].width, repaintArea.paintRects[n].height);
                        }
                        if (repaintCallback != null) {
                            repaintCallback.run(component, graphics);
                        } else {
                            component.paint(graphics);
                        }
                    }
                    var9_10 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    var9_10 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            ++n;
        }
    }

    static boolean subtract(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return true;
        }
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.isEmpty()) {
            return true;
        }
        if (rectangle.x == rectangle3.x && rectangle.y == rectangle3.y) {
            if (rectangle.width == rectangle3.width) {
                rectangle.y += rectangle3.height;
                rectangle.height -= rectangle3.height;
                return true;
            }
            if (rectangle.height == rectangle3.height) {
                rectangle.x += rectangle3.width;
                rectangle.width -= rectangle3.width;
                return true;
            }
        } else if (rectangle.x + rectangle.width == rectangle3.x + rectangle3.width && rectangle.y + rectangle.height == rectangle3.y + rectangle3.height) {
            if (rectangle.width == rectangle3.width) {
                rectangle.height -= rectangle3.height;
                return true;
            }
            if (rectangle.height == rectangle3.height) {
                rectangle.width -= rectangle3.width;
                return true;
            }
        }
        return false;
    }

    public static void setRepaintCallback(SunGraphicsCallback sunGraphicsCallback) {
        repaintCallback = sunGraphicsCallback;
    }
}

