/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.color.CMM;
import sun.awt.color.CMMImageLayout;
import sun.awt.color.ProfileDeferralMgr;
import sun.awt.color.pelArrayInfo;

public class ICC_Transform {
    long ID;
    public static final int Any = -1;
    public static final int In = 1;
    public static final int Out = 2;
    public static final int Gamut = 3;
    public static final int Simulation = 4;
    static /* synthetic */ Class class$java$awt$image$ComponentColorModel;

    public ICC_Transform() {
    }

    public ICC_Transform(ICC_Profile iCC_Profile, int n, int n2) {
        if (iCC_Profile == null) {
            CMM.checkStatus(503);
        }
        CMM.checkStatus(CMM.cmmGetTransform(iCC_Profile, n, n2, this));
    }

    public ICC_Transform(ICC_Transform[] iCC_TransformArray) {
        int n = iCC_TransformArray.length;
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = iCC_TransformArray[n2].ID;
            ++n2;
        }
        int n3 = CMM.cmmCombineTransforms(lArray, this);
        if (n3 != 0 || this.ID == 0L) {
            throw new ProfileDataException("Invalid profile sequence");
        }
    }

    long getID() {
        return this.ID;
    }

    public void finalize() {
        CMM.checkStatus(CMM.cmmFreeTransform(this.ID));
    }

    public int getNumInComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[0];
    }

    public int getNumOutComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[1];
    }

    public void colorConvert(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        CMMImageLayout cMMImageLayout;
        CMMImageLayout cMMImageLayout2 = this.getImageLayout(bufferedImage);
        if (cMMImageLayout2 != null && (cMMImageLayout = this.getImageLayout(bufferedImage2)) != null) {
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
            return;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorModel colorModel2 = bufferedImage2.getColorModel();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = colorModel.getNumColorComponents();
        int n4 = colorModel2.getNumColorComponents();
        int n5 = 8;
        float f = 255.0f;
        int n6 = 0;
        while (n6 < n3) {
            if (colorModel.getComponentSize(n6) > 8) {
                n5 = 16;
                f = 65535.0f;
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < n4) {
            if (colorModel2.getComponentSize(n7) > 8) {
                n5 = 16;
                f = 65535.0f;
            }
            ++n7;
        }
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n8 = 0;
        while (n8 < n3) {
            fArray[n8] = colorSpace.getMinValue(n8);
            fArray2[n8] = f / (colorSpace.getMaxValue(n8) - fArray[n8]);
            ++n8;
        }
        colorSpace = colorModel2.getColorSpace();
        float[] fArray3 = new float[n4];
        float[] fArray4 = new float[n4];
        int n9 = 0;
        while (n9 < n4) {
            fArray3[n9] = colorSpace.getMinValue(n9);
            fArray4[n9] = (colorSpace.getMaxValue(n9) - fArray3[n9]) / f;
            ++n9;
        }
        boolean bl = colorModel2.hasAlpha();
        boolean bl2 = colorModel.hasAlpha() && bl;
        float[] fArray5 = bl ? new float[n4 + 1] : new float[n4];
        if (n5 == 8) {
            byte[] byArray = new byte[n * n3];
            byte[] byArray2 = new byte[n * n4];
            float[] fArray6 = null;
            if (bl2) {
                fArray6 = new float[n];
            }
            pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
            cMMImageLayout2 = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
            cMMImageLayout = new CMMImageLayout(byArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
            int n10 = 0;
            while (n10 < n2) {
                int n11;
                Object object = null;
                float[] fArray7 = null;
                int n12 = 0;
                int n13 = 0;
                while (n13 < n) {
                    object = writableRaster.getDataElements(n13, n10, object);
                    fArray7 = colorModel.getNormalizedComponents(object, fArray7, 0);
                    n11 = 0;
                    while (n11 < n3) {
                        byArray[n12++] = (byte)((fArray7[n11] - fArray[n11]) * fArray2[n11] + 0.5f);
                        ++n11;
                    }
                    if (bl2) {
                        fArray6[n13] = fArray7[n3];
                    }
                    ++n13;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                object = null;
                n12 = 0;
                n11 = 0;
                while (n11 < n) {
                    int n14 = 0;
                    while (n14 < n4) {
                        fArray5[n14] = (float)(byArray2[n12++] & 0xFF) * fArray4[n14] + fArray3[n14];
                        ++n14;
                    }
                    if (bl2) {
                        fArray5[n4] = fArray6[n11];
                    } else if (bl) {
                        fArray5[n4] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n11, n10, object);
                    ++n11;
                }
                ++n10;
            }
        } else {
            short[] sArray = new short[n * n3];
            short[] sArray2 = new short[n * n4];
            float[] fArray8 = null;
            if (bl2) {
                fArray8 = new float[n];
            }
            pelArrayInfo pelArrayInfo3 = new pelArrayInfo(this, sArray, sArray2);
            cMMImageLayout2 = new CMMImageLayout(sArray, pelArrayInfo3.nPels, pelArrayInfo3.nSrc);
            cMMImageLayout = new CMMImageLayout(sArray2, pelArrayInfo3.nPels, pelArrayInfo3.nDest);
            int n15 = 0;
            while (n15 < n2) {
                int n16;
                Object object = null;
                float[] fArray9 = null;
                int n17 = 0;
                int n18 = 0;
                while (n18 < n) {
                    object = writableRaster.getDataElements(n18, n15, object);
                    fArray9 = colorModel.getNormalizedComponents(object, fArray9, 0);
                    n16 = 0;
                    while (n16 < n3) {
                        sArray[n17++] = (short)((fArray9[n16] - fArray[n16]) * fArray2[n16] + 0.5f);
                        ++n16;
                    }
                    if (bl2) {
                        fArray8[n18] = fArray9[n3];
                    }
                    ++n18;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                object = null;
                n17 = 0;
                n16 = 0;
                while (n16 < n) {
                    int n19 = 0;
                    while (n19 < n4) {
                        fArray5[n19] = (float)(sArray2[n17++] & 0xFFFF) * fArray4[n19] + fArray3[n19];
                        ++n19;
                    }
                    if (bl2) {
                        fArray5[n4] = fArray8[n16];
                    } else if (bl) {
                        fArray5[n4] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n16, n15, object);
                    ++n16;
                }
                ++n15;
            }
        }
    }

    private CMMImageLayout getImageLayout(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return new CMMImageLayout(bufferedImage);
            }
            case 5: 
            case 6: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getClass() == (class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ICC_Transform.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel) || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
            case 10: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getComponentSize(0) != 8) {
                    return null;
                }
                if (componentColorModel.getClass() == (class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ICC_Transform.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel) || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
            case 11: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getComponentSize(0) != 16) {
                    return null;
                }
                if (componentColorModel.getClass() == (class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ICC_Transform.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel) || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof DirectColorModel) {
            SampleModel sampleModel = bufferedImage.getSampleModel();
            if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
                return null;
            }
            if (colorModel.getTransferType() != 3) {
                return null;
            }
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                return null;
            }
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n = directColorModel.getRedMask();
            int n2 = directColorModel.getGreenMask();
            int n3 = directColorModel.getBlueMask();
            int n4 = directColorModel.getAlphaMask();
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            int n10 = 3;
            if (n4 != 0) {
                n10 = 4;
            }
            int n11 = 0;
            int n12 = -16777216;
            while (n11 < 4) {
                if (n == n12) {
                    n8 = n11;
                    ++n9;
                } else if (n2 == n12) {
                    n7 = n11;
                    ++n9;
                } else if (n3 == n12) {
                    n6 = n11;
                    ++n9;
                } else if (n4 == n12) {
                    n5 = n11;
                    ++n9;
                }
                ++n11;
                n12 >>>= 8;
            }
            if (n9 != n10) {
                return null;
            }
            return new CMMImageLayout(bufferedImage, (SinglePixelPackedSampleModel)sampleModel, n8, n7, n6, n5);
        }
        if (colorModel instanceof ComponentColorModel) {
            int n;
            SampleModel sampleModel = bufferedImage.getSampleModel();
            if (!(sampleModel instanceof ComponentSampleModel)) {
                return null;
            }
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                return null;
            }
            int n13 = colorModel.getNumComponents();
            if (sampleModel.getNumBands() != n13) {
                return null;
            }
            int n14 = colorModel.getTransferType();
            if (n14 == 0) {
                n = 0;
                while (n < n13) {
                    if (colorModel.getComponentSize(n) != 8) {
                        return null;
                    }
                    ++n;
                }
            } else if (n14 == 1) {
                n = 0;
                while (n < n13) {
                    if (colorModel.getComponentSize(n) != 16) {
                        return null;
                    }
                    ++n;
                }
            } else {
                return null;
            }
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            if (componentColorModel.getClass() == (class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ICC_Transform.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel) || this.checkMinMaxScaling(componentColorModel)) {
                return new CMMImageLayout(bufferedImage, (ComponentSampleModel)sampleModel);
            }
            return null;
        }
        return null;
    }

    private boolean checkMinMaxScaling(ComponentColorModel componentColorModel) {
        float f;
        float[] fArray;
        float[] fArray2;
        int n;
        Object object;
        int n2 = componentColorModel.getNumComponents();
        int n3 = componentColorModel.getNumColorComponents();
        int[] nArray = componentColorModel.getComponentSize();
        boolean bl = componentColorModel.hasAlpha();
        switch (componentColorModel.getTransferType()) {
            case 0: {
                object = new byte[n2];
                n = 0;
                while (n < n3) {
                    object[n] = 0;
                    ++n;
                }
                if (bl) {
                    object[n3] = (byte)((1 << nArray[n3]) - 1);
                }
                fArray2 = componentColorModel.getNormalizedComponents(object, null, 0);
                int n4 = 0;
                while (n4 < n3) {
                    object[n4] = (byte)((1 << nArray[n4]) - 1);
                    ++n4;
                }
                fArray = componentColorModel.getNormalizedComponents(object, null, 0);
                f = 256.0f;
                break;
            }
            case 1: {
                object = new short[n2];
                n = 0;
                while (n < n3) {
                    object[n] = 0;
                    ++n;
                }
                if (bl) {
                    object[n3] = (byte)((1 << nArray[n3]) - 1);
                }
                fArray2 = componentColorModel.getNormalizedComponents(object, null, 0);
                int n4 = 0;
                while (n4 < n3) {
                    object[n4] = (byte)((1 << nArray[n4]) - 1);
                    ++n4;
                }
                fArray = componentColorModel.getNormalizedComponents(object, null, 0);
                f = 65536.0f;
                break;
            }
            default: {
                return false;
            }
        }
        object = componentColorModel.getColorSpace();
        n = 0;
        while (n < n3) {
            float f2 = ((ColorSpace)object).getMinValue(n);
            float f3 = ((ColorSpace)object).getMaxValue(n);
            float f4 = (f3 - f2) / f;
            if ((f2 -= fArray2[n]) < 0.0f) {
                f2 = -f2;
            }
            if ((f3 -= fArray[n]) < 0.0f) {
                f3 = -f3;
            }
            if (f2 > f4 || f3 > f4) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void colorConvert(Raster raster, WritableRaster writableRaster, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n = raster.getTransferType();
        int n2 = writableRaster.getTransferType();
        boolean bl = n == 4 || n == 5;
        boolean bl2 = n2 == 4 || n2 == 5;
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = raster.getNumBands();
        int n6 = writableRaster.getNumBands();
        float[] fArray5 = new float[n5];
        float[] fArray6 = new float[n6];
        float[] fArray7 = new float[n5];
        float[] fArray8 = new float[n6];
        int n7 = 0;
        while (n7 < n5) {
            if (bl) {
                fArray5[n7] = 65535.0f / (fArray2[n7] - fArray[n7]);
                fArray7[n7] = fArray[n7];
            } else {
                fArray5[n7] = n == 2 ? 2.0000305f : 65535.0f / (float)((1 << sampleModel.getSampleSize(n7)) - 1);
                fArray7[n7] = 0.0f;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < n6) {
            if (bl2) {
                fArray6[n8] = (fArray4[n8] - fArray3[n8]) / 65535.0f;
                fArray8[n8] = fArray3[n8];
            } else {
                fArray6[n8] = n2 == 2 ? 0.49999237f : (float)((1 << sampleModel2.getSampleSize(n8)) - 1) / 65535.0f;
                fArray8[n8] = 0.0f;
            }
            ++n8;
        }
        int n9 = raster.getMinY();
        int n10 = writableRaster.getMinY();
        short[] sArray = new short[n3 * n5];
        short[] sArray2 = new short[n3 * n6];
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        CMMImageLayout cMMImageLayout = new CMMImageLayout(sArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(sArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        int n11 = 0;
        while (n11 < n4) {
            float f;
            int n12;
            int n13 = raster.getMinX();
            int n14 = 0;
            int n15 = 0;
            while (n15 < n3) {
                n12 = 0;
                while (n12 < n5) {
                    f = raster.getSampleFloat(n13, n9, n12);
                    sArray[n14++] = (short)((f - fArray7[n12]) * fArray5[n12] + 0.5f);
                    ++n12;
                }
                ++n15;
                ++n13;
            }
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
            int n16 = writableRaster.getMinX();
            n14 = 0;
            n12 = 0;
            while (n12 < n3) {
                int n17 = 0;
                while (n17 < n6) {
                    f = (float)(sArray2[n14++] & 0xFFFF) * fArray6[n17] + fArray8[n17];
                    writableRaster.setSample(n16, n10, n17, f);
                    ++n17;
                }
                ++n12;
                ++n16;
            }
            ++n11;
            ++n9;
            ++n10;
        }
    }

    public void colorConvert(Raster raster, WritableRaster writableRaster) {
        CMMImageLayout cMMImageLayout;
        CMMImageLayout cMMImageLayout2 = this.getImageLayout(raster);
        if (cMMImageLayout2 != null && (cMMImageLayout = this.getImageLayout(writableRaster)) != null) {
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
            return;
        }
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n = raster.getTransferType();
        int n2 = writableRaster.getTransferType();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = raster.getNumBands();
        int n6 = writableRaster.getNumBands();
        int n7 = 8;
        float f = 255.0f;
        int n8 = 0;
        while (n8 < n5) {
            if (sampleModel.getSampleSize(n8) > 8) {
                n7 = 16;
                f = 65535.0f;
            }
            ++n8;
        }
        int n9 = 0;
        while (n9 < n6) {
            if (sampleModel2.getSampleSize(n9) > 8) {
                n7 = 16;
                f = 65535.0f;
            }
            ++n9;
        }
        float[] fArray = new float[n5];
        float[] fArray2 = new float[n6];
        int n10 = 0;
        while (n10 < n5) {
            fArray[n10] = n == 2 ? f / 32767.0f : f / (float)((1 << sampleModel.getSampleSize(n10)) - 1);
            ++n10;
        }
        int n11 = 0;
        while (n11 < n6) {
            fArray2[n11] = n2 == 2 ? 32767.0f / f : (float)((1 << sampleModel2.getSampleSize(n11)) - 1) / f;
            ++n11;
        }
        int n12 = raster.getMinY();
        int n13 = writableRaster.getMinY();
        if (n7 == 8) {
            byte[] byArray = new byte[n3 * n5];
            byte[] byArray2 = new byte[n3 * n6];
            pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
            cMMImageLayout2 = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
            cMMImageLayout = new CMMImageLayout(byArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
            int n14 = 0;
            while (n14 < n4) {
                int n15;
                int n16;
                int n17 = raster.getMinX();
                int n18 = 0;
                int n19 = 0;
                while (n19 < n3) {
                    n16 = 0;
                    while (n16 < n5) {
                        n15 = raster.getSample(n17, n12, n16);
                        byArray[n18++] = (byte)((float)n15 * fArray[n16] + 0.5f);
                        ++n16;
                    }
                    ++n19;
                    ++n17;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                int n20 = writableRaster.getMinX();
                n18 = 0;
                n16 = 0;
                while (n16 < n3) {
                    int n21 = 0;
                    while (n21 < n6) {
                        n15 = (int)((float)(byArray2[n18++] & 0xFF) * fArray2[n21] + 0.5f);
                        writableRaster.setSample(n20, n13, n21, n15);
                        ++n21;
                    }
                    ++n16;
                    ++n20;
                }
                ++n14;
                ++n12;
                ++n13;
            }
        } else {
            short[] sArray = new short[n3 * n5];
            short[] sArray2 = new short[n3 * n6];
            pelArrayInfo pelArrayInfo3 = new pelArrayInfo(this, sArray, sArray2);
            cMMImageLayout2 = new CMMImageLayout(sArray, pelArrayInfo3.nPels, pelArrayInfo3.nSrc);
            cMMImageLayout = new CMMImageLayout(sArray2, pelArrayInfo3.nPels, pelArrayInfo3.nDest);
            int n22 = 0;
            while (n22 < n4) {
                int n23;
                int n24;
                int n25 = raster.getMinX();
                int n26 = 0;
                int n27 = 0;
                while (n27 < n3) {
                    n24 = 0;
                    while (n24 < n5) {
                        n23 = raster.getSample(n25, n12, n24);
                        sArray[n26++] = (short)((float)n23 * fArray[n24] + 0.5f);
                        ++n24;
                    }
                    ++n27;
                    ++n25;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                int n28 = writableRaster.getMinX();
                n26 = 0;
                n24 = 0;
                while (n24 < n3) {
                    int n29 = 0;
                    while (n29 < n6) {
                        n23 = (int)((float)(sArray2[n26++] & 0xFFFF) * fArray2[n29] + 0.5f);
                        writableRaster.setSample(n28, n13, n29, n23);
                        ++n29;
                    }
                    ++n24;
                    ++n28;
                }
                ++n22;
                ++n12;
                ++n13;
            }
        }
    }

    private CMMImageLayout getImageLayout(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            int n = raster.getNumBands();
            int n2 = sampleModel.getTransferType();
            if (n2 == 0) {
                int n3 = 0;
                while (n3 < n) {
                    if (sampleModel.getSampleSize(n3) != 8) {
                        return null;
                    }
                    ++n3;
                }
            } else if (n2 == 1) {
                int n4 = 0;
                while (n4 < n) {
                    if (sampleModel.getSampleSize(n4) != 16) {
                        return null;
                    }
                    ++n4;
                }
            } else {
                return null;
            }
            return new CMMImageLayout(raster, (ComponentSampleModel)sampleModel);
        }
        return null;
    }

    public short[] colorConvert(short[] sArray, short[] sArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        short[] sArray3 = sArray2 != null ? sArray2 : new short[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(sArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(sArray3, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        return sArray3;
    }

    public byte[] colorConvert(byte[] byArray, byte[] byArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
        byte[] byArray3 = byArray2 != null ? byArray2 : new byte[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(byArray3, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        return byArray3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }
}

