/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.text.CharacterIterator;
import sun.awt.font.NativeFontWrapper;

public class StandardGlyphVector
extends GlyphVector {
    private Font font;
    public int[] glyphs;
    public int[] charIndices;
    public float[] positions;
    public double[] transforms;
    public int[] txIndices;
    private int flags = -1;
    private FontRenderContext frc;
    private static final int UNINITIALIZED_FLAGS = -1;
    public double[] fontTX;
    public double[] devTX;
    private boolean haveLM;
    private int baseline;
    private float ascent;
    private float descent;
    private float leading;
    private boolean horizontal = true;
    private SoftReference lbcacheRef;
    private SoftReference vbcacheRef;
    public static final int FLAG_USES_VERTICAL_BASELINE = 128;
    public static final int FLAG_USES_VERTICAL_METRICS = 256;
    public static final int FLAG_USES_ALTERNATE_ORIENTATION = 512;

    public StandardGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateGlyphVector(this.font, string.toCharArray(), 0, string.length(), this.fontTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, char[] cArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, 0, cArray.length, this.fontTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException("start or count out of bounds");
        }
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, n, n2, this.fontTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, char[] cArray, int n, int n2, int n3, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateAndLayoutGlyphVector(this.font, cArray, n, n2, n3, this.fontTX, this.devTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, CharacterIterator characterIterator, FontRenderContext fontRenderContext) {
        char[] cArray = new char[characterIterator.getEndIndex() - characterIterator.getBeginIndex()];
        char c = characterIterator.first();
        while (c != '\uffff') {
            cArray[characterIterator.getIndex() - characterIterator.getBeginIndex()] = c;
            c = characterIterator.next();
        }
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, 0, cArray.length, this.fontTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, int[] nArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = nArray;
        this.frc = fontRenderContext;
        this.initTX();
    }

    public static StandardGlyphVector getStandardGV(GlyphVector glyphVector) {
        if (glyphVector instanceof StandardGlyphVector) {
            return (StandardGlyphVector)glyphVector;
        }
        return new StandardGlyphVector(glyphVector);
    }

    public StandardGlyphVector(GlyphVector glyphVector) {
        if (glyphVector instanceof StandardGlyphVector) {
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)glyphVector;
            this.font = standardGlyphVector.font;
            this.frc = standardGlyphVector.frc;
            this.glyphs = standardGlyphVector.glyphs;
            this.charIndices = standardGlyphVector.charIndices;
            if (standardGlyphVector.positions != null) {
                this.positions = (float[])standardGlyphVector.positions.clone();
            }
            if (standardGlyphVector.txIndices != null) {
                this.txIndices = (int[])standardGlyphVector.txIndices.clone();
                this.transforms = (double[])standardGlyphVector.transforms.clone();
            }
            this.initTX();
        } else {
            this.font = glyphVector.getFont();
            this.frc = glyphVector.getFontRenderContext();
            int n = glyphVector.getNumGlyphs();
            this.glyphs = glyphVector.getGlyphCodes(0, n, null);
            this.flags = glyphVector.getLayoutFlags() & 0xF;
            this.positions = glyphVector.getGlyphPositions(0, n + 1, null);
            if ((this.flags & 8) != 0) {
                this.charIndices = glyphVector.getGlyphCharIndices(0, n, null);
            }
            if ((this.flags & 1) != 0) {
                AffineTransform[] affineTransformArray = new AffineTransform[n];
                int n2 = 0;
                while (n2 < n) {
                    affineTransformArray[n2] = glyphVector.getGlyphTransform(n2);
                    ++n2;
                }
                this.setGlyphTransforms(affineTransformArray);
            }
            this.initTX();
        }
    }

    private void initTX() {
        float f = this.font.getSize2D();
        AffineTransform affineTransform = this.font.getTransform();
        affineTransform.scale(f, f);
        this.fontTX = new double[6];
        affineTransform.getMatrix(this.fontTX);
        AffineTransform affineTransform2 = this.frc.getTransform();
        if (!affineTransform2.isIdentity()) {
            this.devTX = new double[6];
            affineTransform2.getMatrix(this.devTX);
            this.devTX[5] = 0.0;
            this.devTX[4] = 0.0;
        }
    }

    private void initLM() {
        if (!this.haveLM) {
            float[] fArray = new float[4];
            NativeFontWrapper.getFontMetrics(this.font, this.fontTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), fArray);
            this.haveLM = true;
            this.ascent = fArray[0];
            this.descent = fArray[1];
            this.leading = fArray[2];
        }
    }

    public void performDefaultLayout() {
        this.clearCaches();
        NativeFontWrapper.layoutGlyphVector(this.font, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), this);
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    public int getGlyphCode(int n) {
        return this.glyphs[n];
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries = " + n2);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex = " + n);
        }
        if (n > this.glyphs.length - n2) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries = " + (n + n2));
        }
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = this.glyphs[n3 + n];
            ++n3;
        }
        return nArray2;
    }

    public int getGlyphCharIndex(int n) {
        return this.charIndices == null ? n : this.charIndices[n];
    }

    public int[] getGlyphCharIndices(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 + n;
            nArray2[n3] = this.charIndices == null ? n4 : this.charIndices[n4];
            ++n3;
        }
        return nArray2;
    }

    public Rectangle2D getLogicalBounds() {
        float f;
        float f2;
        float f3;
        float f4;
        this.initLM();
        if (this.horizontal) {
            f4 = 0.0f;
            f3 = -this.ascent;
            f2 = 0.0f;
            f = this.descent + this.leading;
            if (this.glyphs.length > 0) {
                this.initPositions();
                f2 = this.positions[this.positions.length - 2];
            }
        } else {
            f3 = 0.0f;
            f2 = this.ascent;
            f = 0.0f;
            f4 = -this.descent - this.leading;
            if (this.glyphs.length > 0) {
                this.initPositions();
                f = this.positions[this.positions.length - 1];
            }
        }
        return new Rectangle2D.Float(f4, f3, f2 - f4, f - f3);
    }

    public Rectangle2D getVisualBounds() {
        this.initPositions();
        return NativeFontWrapper.getVisualBounds(this.font, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f, float f2) {
        double[] dArray;
        if (fontRenderContext == null) {
            fontRenderContext = this.frc;
            dArray = this.devTX;
        } else {
            dArray = new double[6];
            AffineTransform affineTransform = fontRenderContext.getTransform();
            affineTransform.getMatrix(dArray);
        }
        this.initPositions();
        return NativeFontWrapper.getPixelBounds(this.font, f, f2, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, dArray, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public Rectangle getGlyphPixelBounds(int n, FontRenderContext fontRenderContext, float f, float f2) {
        double[] dArray;
        if (fontRenderContext == null) {
            fontRenderContext = this.frc;
            dArray = this.devTX;
        } else {
            dArray = new double[6];
            AffineTransform affineTransform = fontRenderContext.getTransform();
            affineTransform.getMatrix(dArray);
        }
        this.initPositions();
        return NativeFontWrapper.getGlyphPixelBounds(this.font, n, f, f2, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, dArray, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public void pixellate(FontRenderContext fontRenderContext, Point2D point2D, Point point) {
        if (fontRenderContext == null) {
            fontRenderContext = this.frc;
        }
        AffineTransform affineTransform = fontRenderContext.getTransform();
        affineTransform.transform(point2D, point2D);
        point.x = (int)point2D.getX();
        point.y = (int)point2D.getY();
        point2D.setLocation(point.x, point.y);
        try {
            affineTransform.inverseTransform(point2D, point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException("must be able to invert frc transform");
        }
    }

    public Shape getOutline() {
        return this.getOutline(0.0f, 0.0f);
    }

    public Shape getOutline(float f, float f2) {
        this.initPositions();
        return NativeFontWrapper.getGlyphVectorOutline(this, this.font, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), f, f2);
    }

    public Shape getGlyphOutline(int n) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n);
        }
        this.initPositions();
        return NativeFontWrapper.getGlyphOutline(this, n, this.font, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), 0.0f, 0.0f);
    }

    public Shape getGlyphOutline(int n, float f, float f2) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n);
        }
        this.initPositions();
        return NativeFontWrapper.getGlyphOutline(this, n, this.font, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), f, f2);
    }

    public Point2D getGlyphPosition(int n) {
        this.initPositions();
        return new Point2D.Float(this.positions[n * 2], this.positions[n * 2 + 1]);
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.initPositions();
        this.positions[n * 2] = (float)point2D.getX();
        this.positions[n * 2 + 1] = (float)point2D.getY();
        this.clearCaches(n);
        this.addFlags(2);
    }

    private void initPositions() {
        if (this.positions == null) {
            this.performDefaultLayout();
        }
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries = " + n2);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex = " + n);
        }
        if (n > this.glyphs.length + 1 - n2) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries = " + (n + n2));
        }
        return this.internalGetGlyphPositions(n, n2, fArray);
    }

    public float[] getGlyphPositions(float[] fArray) {
        return this.internalGetGlyphPositions(0, this.glyphs.length + 1, fArray);
    }

    float[] internalGetGlyphPositions(int n, int n2, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n2 * 2];
        }
        this.initPositions();
        int n3 = 0;
        while (n3 < n2) {
            fArray2[n3 * 2] = this.positions[(n3 + n) * 2];
            fArray2[n3 * 2 + 1] = this.positions[(n3 + n) * 2 + 1];
            ++n3;
        }
        return fArray2;
    }

    public void setGlyphPositions(float[] fArray, int n, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("numEntries = " + n3);
        }
        this.clearCaches();
        this.initPositions();
        System.arraycopy(fArray, n, this.positions, n2 * 2, n3 * 2);
    }

    public void setGlyphPositions(float[] fArray) {
        int n = this.glyphs.length * 2 + 2;
        if (fArray.length != n) {
            throw new IllegalArgumentException("srcPositions.length != " + n);
        }
        this.clearCaches();
        if (this.positions == null) {
            this.positions = (float[])fArray.clone();
        } else {
            System.arraycopy(fArray, 0, this.positions, 0, n);
        }
    }

    public Shape getGlyphLogicalBounds(int n) {
        Shape shape;
        Shape[] shapeArray;
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n);
        }
        if (this.lbcacheRef == null || (shapeArray = (Shape[])this.lbcacheRef.get()) == null) {
            shapeArray = new Shape[this.glyphs.length];
            this.lbcacheRef = new SoftReference<Shape[]>(shapeArray);
        }
        if ((shape = shapeArray[n]) == null) {
            this.initPositions();
            shapeArray[n] = shape = NativeFontWrapper.getGlyphLogicalBounds(this.font, n, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
        }
        return shape;
    }

    public Shape getGlyphVisualBounds(int n) {
        Shape shape;
        Shape[] shapeArray;
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n);
        }
        if (this.vbcacheRef == null || (shapeArray = (Shape[])this.vbcacheRef.get()) == null) {
            shapeArray = new Shape[this.glyphs.length];
            this.vbcacheRef = new SoftReference<Shape[]>(shapeArray);
        }
        if ((shape = shapeArray[n]) == null) {
            this.initPositions();
            shapeArray[n] = shape = NativeFontWrapper.getGlyphVisualBounds(this.font, n, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
        }
        return shape;
    }

    private void clearCaches(int n) {
        Shape[] shapeArray;
        if (this.lbcacheRef != null && (shapeArray = (Shape[])this.lbcacheRef.get()) != null) {
            shapeArray[n] = null;
        }
        if (this.vbcacheRef != null && (shapeArray = (Shape[])this.vbcacheRef.get()) != null) {
            shapeArray[n] = null;
        }
    }

    private void clearCaches() {
        this.lbcacheRef = null;
        this.vbcacheRef = null;
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n);
        }
        float[] fArray = new float[6];
        NativeFontWrapper.getGlyphMetrics(this.font, this.glyphs[n], this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), fArray);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float f5 = fArray[4];
        float f6 = fArray[5];
        GlyphMetrics glyphMetrics = new GlyphMetrics(this.horizontal, f, f2, new Rectangle2D.Float(f3, f4, f5, f6), 0);
        return glyphMetrics;
    }

    public AffineTransform getGlyphTransform(int n) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n);
        }
        if (this.txIndices == null || this.txIndices[n] == 0) {
            return new AffineTransform();
        }
        int n2 = (this.txIndices[n] - 1) * 6;
        return new AffineTransform(this.transforms[n2 + 0], this.transforms[n2 + 1], this.transforms[n2 + 2], this.transforms[n2 + 3], this.transforms[n2 + 4], this.transforms[n2 + 5]);
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n);
        }
        this.clearCaches(n);
        double[] dArray = new double[6];
        boolean bl = true;
        if (affineTransform == null) {
            dArray[3] = 1.0;
            dArray[0] = 1.0;
        } else {
            bl = affineTransform.isIdentity();
            affineTransform.getMatrix(dArray);
        }
        if (this.txIndices == null) {
            if (bl) {
                return;
            }
            this.txIndices = new int[this.glyphs.length];
            this.txIndices[n] = 1;
            this.transforms = dArray;
        } else {
            int n2;
            int n3;
            boolean bl2 = false;
            int n4 = -1;
            if (bl) {
                n4 = 0;
            } else {
                bl2 = true;
                n3 = 0;
                while (n3 < this.transforms.length) {
                    block23: {
                        n2 = 0;
                        while (n2 < 6) {
                            if (this.transforms[n3 + n2] == dArray[n2]) {
                                ++n2;
                                continue;
                            }
                            break block23;
                        }
                        bl2 = false;
                        break;
                    }
                    n3 += 6;
                }
                n4 = n3 / 6 + 1;
            }
            n3 = this.txIndices[n];
            if (n4 != n3) {
                int n5;
                n2 = 0;
                if (n3 != 0) {
                    n2 = 1;
                    int n6 = this.txIndices[n];
                    n5 = 0;
                    while (n5 < this.txIndices.length) {
                        if (n5 != n && this.txIndices[n5] == n6) {
                            n2 = 0;
                            break;
                        }
                        ++n5;
                    }
                }
                if (n2 != 0 && bl2) {
                    System.arraycopy(dArray, 0, this.transforms, (n4 - 1) * 6, 6);
                } else if (n2 != 0) {
                    if (this.transforms.length == 6) {
                        this.transforms = null;
                        this.txIndices = null;
                        this.clearFlags(1);
                        return;
                    }
                    double[] dArray2 = new double[this.transforms.length - 6];
                    System.arraycopy(this.transforms, 0, dArray2, 0, (n3 - 1) * 6);
                    System.arraycopy(this.transforms, n3 * 6, dArray2, (n3 - 1) * 6, this.transforms.length - n3 * 6);
                    this.transforms = dArray2;
                    n5 = 0;
                    while (n5 < this.txIndices.length) {
                        if (this.txIndices[n5] > n3) {
                            int n7 = n5;
                            this.txIndices[n7] = this.txIndices[n7] - 1;
                        }
                        ++n5;
                    }
                } else if (bl2) {
                    double[] dArray3 = new double[this.transforms.length + 6];
                    System.arraycopy(this.transforms, 0, dArray3, 0, this.transforms.length);
                    System.arraycopy(dArray, 0, dArray3, this.transforms.length, 6);
                    this.transforms = dArray3;
                }
                this.txIndices[n] = n4;
            }
        }
        this.addFlags(1);
    }

    public void setGlyphTransforms(AffineTransform[] affineTransformArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            this.setGlyphTransform(n4, affineTransformArray[n + n4]);
            ++n4;
        }
    }

    public void setGlyphTransforms(AffineTransform[] affineTransformArray) {
        this.setGlyphTransforms(affineTransformArray, 0, 0, this.glyphs.length);
    }

    public AffineTransform[] getGlyphTransforms(int n, int n2, AffineTransform[] affineTransformArray) {
        if (this.txIndices != null) {
            int n3;
            int n4;
            boolean bl = true;
            if (n != 0 || n2 != this.glyphs.length) {
                bl = false;
                n4 = n;
                n3 = n + n2;
                while (n4 < n3) {
                    if (this.txIndices[n4] != 0) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
            }
            if (bl) {
                if (affineTransformArray == null) {
                    affineTransformArray = new AffineTransform[n2];
                }
                n4 = n;
                n3 = n + n2;
                while (n4 < n3) {
                    int n5;
                    if (affineTransformArray[n4] == null && (n5 = this.txIndices[n4]) != 0) {
                        n5 = n5 * 6 - 6;
                        AffineTransform affineTransform = new AffineTransform(this.transforms[n5], this.transforms[n5 + 1], this.transforms[n5 + 2], this.transforms[n5 + 3], this.transforms[n5 + 4], this.transforms[n5 + 5]);
                        int n6 = n4;
                        while (n6 < n3) {
                            if (this.txIndices[n6] == n5) {
                                affineTransformArray[n6] = affineTransform;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                return affineTransformArray;
            }
        }
        return null;
    }

    public AffineTransform[] getGlyphTransforms() {
        return this.getGlyphTransforms(0, this.glyphs.length, null);
    }

    public int getLayoutFlags() {
        if (this.flags == -1) {
            this.flags = 0;
            if (this.charIndices != null) {
                boolean bl = true;
                boolean bl2 = true;
                int n = this.charIndices.length;
                int n2 = 0;
                while (n2 < this.charIndices.length && (bl || bl2)) {
                    int n3 = this.charIndices[n2];
                    bl = bl && n3 == n2;
                    bl2 = bl2 && n3 == --n;
                    ++n2;
                }
                if (bl2) {
                    this.flags |= 4;
                }
                if (!bl2 && !bl) {
                    this.flags |= 8;
                }
            }
        }
        return this.flags;
    }

    private void addFlags(int n) {
        this.flags = this.getLayoutFlags() | n;
    }

    private void clearFlags(int n) {
        this.flags = this.getLayoutFlags() & ~n;
    }

    public Object clone() {
        try {
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)super.clone();
            standardGlyphVector.clearCaches();
            if (this.positions != null) {
                standardGlyphVector.positions = (float[])this.positions.clone();
            }
            if (this.txIndices != null) {
                standardGlyphVector.txIndices = (int[])this.txIndices.clone();
                standardGlyphVector.transforms = (double[])this.transforms.clone();
            }
            return standardGlyphVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public float[] getGlyphInfo() {
        return NativeFontWrapper.getGlyphInfo(this.font, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        if (n < 0 || n >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n);
        }
        return null;
    }

    public int hashCode() {
        return this.font.hashCode() ^ this.glyphs.length;
    }

    public boolean equals(GlyphVector glyphVector) {
        if (this == glyphVector) {
            return true;
        }
        if (glyphVector == null) {
            return false;
        }
        try {
            int n;
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)glyphVector;
            if (this.glyphs.length != standardGlyphVector.glyphs.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.glyphs.length) {
                if (this.glyphs[n2] != standardGlyphVector.glyphs[n2]) {
                    return false;
                }
                ++n2;
            }
            if (!this.font.equals(standardGlyphVector.font)) {
                return false;
            }
            if (!this.frc.equals(standardGlyphVector.frc)) {
                return false;
            }
            if (standardGlyphVector.positions == null != (this.positions == null)) {
                if (this.positions == null) {
                    this.performDefaultLayout();
                } else {
                    standardGlyphVector.performDefaultLayout();
                }
            }
            if (this.positions != null) {
                n = 0;
                while (n < this.positions.length) {
                    if (this.positions[n] != standardGlyphVector.positions[n]) {
                        return false;
                    }
                    ++n;
                }
            }
            if (this.txIndices == null != (standardGlyphVector.txIndices == null)) {
                return false;
            }
            if (this.txIndices != null) {
                if (this.transforms.length != standardGlyphVector.transforms.length) {
                    return false;
                }
                n = 0;
                while (n < this.glyphs.length) {
                    int n3;
                    int n4 = this.txIndices[n];
                    if (n4 == 0 != ((n3 = standardGlyphVector.txIndices[n]) == 0)) {
                        return false;
                    }
                    if (n4 != 0) {
                        n4 = (n4 - 1) * 6;
                        n3 = (n3 - 1) * 6;
                        int n5 = 0;
                        while (n5 < 6) {
                            if (this.transforms[n4++] != standardGlyphVector.transforms[n3++]) {
                                return false;
                            }
                            ++n5;
                        }
                    }
                    ++n;
                }
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }
}

