/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.geom.ChainEnd;
import sun.awt.geom.Curve;
import sun.awt.geom.CurveLink;
import sun.awt.geom.Edge;

public abstract class AreaOp {
    public static final int CTAG_LEFT = 0;
    public static final int CTAG_RIGHT = 1;
    public static final int ETAG_IGNORE = 0;
    public static final int ETAG_ENTER = 1;
    public static final int ETAG_EXIT = -1;
    public static final int RSTAG_INSIDE = 1;
    public static final int RSTAG_OUTSIDE = -1;
    private static Comparator YXTopComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            double d;
            Curve curve = ((Edge)object).getCurve();
            Curve curve2 = ((Edge)object2).getCurve();
            double d2 = curve.getYTop();
            if (d2 == (d = curve2.getYTop()) && (d2 = curve.getXTop()) == (d = curve2.getXTop())) {
                return 0;
            }
            if (d2 < d) {
                return -1;
            }
            return 1;
        }
    };
    private static CurveLink[] EmptyLinkList = new CurveLink[2];
    private static ChainEnd[] EmptyChainList = new ChainEnd[2];

    private AreaOp() {
    }

    public abstract void newRow();

    public abstract int classify(Edge var1);

    public abstract int getState();

    public Vector calculate(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        AreaOp.addEdges(vector3, vector, 0);
        AreaOp.addEdges(vector3, vector2, 1);
        vector3 = this.pruneEdges(vector3);
        return vector3;
    }

    private static void addEdges(Vector vector, Vector vector2, int n) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (curve.getOrder() <= 0) continue;
            vector.add(new Edge(curve, n));
        }
    }

    private Vector pruneEdges(Vector vector) {
        int n = vector.size();
        if (n < 2) {
            return vector;
        }
        Edge[] edgeArray = vector.toArray(new Edge[n]);
        Arrays.sort(edgeArray, YXTopComparator);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double[] dArray = new double[2];
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector<CurveLink> vector4 = new Vector<CurveLink>();
        while (n2 < n) {
            int n6;
            Edge edge;
            double d = dArray[0];
            n4 = n5 = n3 - 1;
            while (n4 >= n2) {
                edge = edgeArray[n4];
                if (edge.getCurve().getYBot() > d) {
                    if (n5 > n4) {
                        edgeArray[n5] = edge;
                    }
                    --n5;
                }
                --n4;
            }
            n2 = n5 + 1;
            if (n2 >= n3) {
                if (n3 >= n) break;
                d = edgeArray[n3].getCurve().getYTop();
                if (d > dArray[0]) {
                    AreaOp.finalizeSubCurves(vector2, vector3);
                }
                dArray[0] = d;
            }
            while (n3 < n) {
                edge = edgeArray[n3];
                if (edge.getCurve().getYTop() > d) break;
                ++n3;
            }
            dArray[1] = edgeArray[n2].getCurve().getYBot();
            if (n3 < n && dArray[1] > (d = edgeArray[n3].getCurve().getYTop())) {
                dArray[1] = d;
            }
            int n7 = 1;
            n4 = n2;
            while (n4 < n3) {
                edge = edgeArray[n4];
                edge.setEquivalence(0);
                n5 = n4;
                while (n5 > n2) {
                    Edge edge2 = edgeArray[n5 - 1];
                    int n8 = edge.compareTo(edge2, dArray);
                    if (dArray[1] <= dArray[0]) {
                        throw new InternalError("backstepping to " + dArray[1] + " from " + dArray[0]);
                    }
                    if (n8 >= 0) {
                        if (n8 != 0) break;
                        int n9 = edge2.getEquivalence();
                        if (n9 == 0) {
                            n9 = n7++;
                            edge2.setEquivalence(n9);
                        }
                        edge.setEquivalence(n9);
                        break;
                    }
                    edgeArray[n5] = edge2;
                    --n5;
                }
                edgeArray[n5] = edge;
                ++n4;
            }
            this.newRow();
            double d2 = dArray[0];
            double d3 = dArray[1];
            n4 = n2;
            while (n4 < n3) {
                edge = edgeArray[n4];
                int n10 = edge.getEquivalence();
                if (n10 != 0) {
                    int n11 = this.getState();
                    n6 = n11 == 1 ? -1 : 1;
                    Edge edge3 = null;
                    Edge edge4 = edge;
                    double d4 = d3;
                    do {
                        this.classify(edge);
                        if (edge3 == null && edge.isActiveFor(d2, n6)) {
                            edge3 = edge;
                        }
                        if (!((d = edge.getCurve().getYBot()) > d4)) continue;
                        edge4 = edge;
                        d4 = d;
                    } while (++n4 < n3 && (edge = edgeArray[n4]).getEquivalence() == n10);
                    --n4;
                    if (this.getState() == n11) {
                        n6 = 0;
                    } else {
                        edge = edge3 != null ? edge3 : edge4;
                    }
                } else {
                    n6 = this.classify(edge);
                }
                if (n6 != 0) {
                    edge.record(d3, n6);
                    vector4.add(new CurveLink(edge.getCurve(), d2, d3, n6));
                }
                ++n4;
            }
            if (this.getState() != -1) {
                System.out.println("Still inside at end of active edge list!");
                System.out.println("num curves = " + (n3 - n2));
                System.out.println("num links = " + vector4.size());
                System.out.println("y top = " + dArray[0]);
                if (n3 < n) {
                    System.out.println("y top of next curve = " + edgeArray[n3].getCurve().getYTop());
                } else {
                    System.out.println("no more curves");
                }
                n4 = n2;
                while (n4 < n3) {
                    edge = edgeArray[n4];
                    System.out.println(edge);
                    n6 = edge.getEquivalence();
                    if (n6 != 0) {
                        System.out.println("  was equal to " + n6 + "...");
                    }
                    ++n4;
                }
            }
            AreaOp.resolveLinks(vector2, vector3, vector4);
            vector4.clear();
            dArray[0] = d3;
        }
        AreaOp.finalizeSubCurves(vector2, vector3);
        Vector<Curve> vector5 = new Vector<Curve>();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            CurveLink curveLink = (CurveLink)enumeration.nextElement();
            vector5.add(curveLink.getMoveto());
            CurveLink curveLink2 = curveLink;
            while ((curveLink2 = curveLink2.getNext()) != null) {
                if (curveLink.absorb(curveLink2)) continue;
                vector5.add(curveLink.getSubCurve());
                curveLink = curveLink2;
            }
            vector5.add(curveLink.getSubCurve());
        }
        return vector5;
    }

    public static void finalizeSubCurves(Vector vector, Vector vector2) {
        int n = vector2.size();
        if (n == 0) {
            return;
        }
        if ((n & 1) != 0) {
            throw new InternalError("Odd number of chains!");
        }
        ChainEnd[] chainEndArray = new ChainEnd[n];
        vector2.toArray(chainEndArray);
        int n2 = 1;
        while (n2 < n) {
            ChainEnd chainEnd = chainEndArray[n2 - 1];
            ChainEnd chainEnd2 = chainEndArray[n2];
            CurveLink curveLink = chainEnd.linkTo(chainEnd2);
            if (curveLink != null) {
                vector.add(curveLink);
            }
            n2 += 2;
        }
        vector2.clear();
    }

    public static void resolveLinks(Vector vector, Vector vector2, Vector vector3) {
        ChainEnd[] chainEndArray;
        CurveLink[] curveLinkArray;
        int n = vector3.size();
        if (n == 0) {
            curveLinkArray = EmptyLinkList;
        } else {
            if ((n & 1) != 0) {
                throw new InternalError("Odd number of new curves!");
            }
            curveLinkArray = new CurveLink[n + 2];
            vector3.toArray(curveLinkArray);
        }
        int n2 = vector2.size();
        if (n2 == 0) {
            chainEndArray = EmptyChainList;
        } else {
            if ((n2 & 1) != 0) {
                throw new InternalError("Odd number of chains!");
            }
            chainEndArray = new ChainEnd[n2 + 2];
            vector2.toArray(chainEndArray);
        }
        int n3 = 0;
        int n4 = 0;
        vector2.clear();
        ChainEnd chainEnd = chainEndArray[0];
        ChainEnd chainEnd2 = chainEndArray[1];
        CurveLink curveLink = curveLinkArray[0];
        CurveLink curveLink2 = curveLinkArray[1];
        while (chainEnd != null || curveLink != null) {
            boolean bl;
            boolean bl2 = curveLink == null;
            boolean bl3 = bl = chainEnd == null;
            if (!bl2 && !bl) {
                bl2 = !(n3 & true) && chainEnd.getX() == chainEnd2.getX();
                boolean bl4 = bl = !(n4 & true) && curveLink.getX() == curveLink2.getX();
                if (!bl2 && !bl) {
                    double d = chainEnd.getX();
                    double d2 = curveLink.getX();
                    bl2 = chainEnd2 != null && d < d2 && AreaOp.obstructs(chainEnd2.getX(), d2, n3);
                    boolean bl5 = bl = curveLink2 != null && d2 < d && AreaOp.obstructs(curveLink2.getX(), d, n4);
                }
            }
            if (bl2) {
                CurveLink curveLink3 = chainEnd.linkTo(chainEnd2);
                if (curveLink3 != null) {
                    vector.add(curveLink3);
                }
                chainEnd = chainEndArray[n3 += 2];
                chainEnd2 = chainEndArray[n3 + 1];
            }
            if (bl) {
                ChainEnd chainEnd3 = new ChainEnd(curveLink, null);
                ChainEnd chainEnd4 = new ChainEnd(curveLink2, chainEnd3);
                chainEnd3.setOtherEnd(chainEnd4);
                vector2.add(chainEnd3);
                vector2.add(chainEnd4);
                curveLink = curveLinkArray[n4 += 2];
                curveLink2 = curveLinkArray[n4 + 1];
            }
            if (bl2 || bl) continue;
            chainEnd.addLink(curveLink);
            vector2.add(chainEnd);
            chainEnd = chainEnd2;
            chainEnd2 = chainEndArray[++n3 + 1];
            curveLink = curveLink2;
            curveLink2 = curveLinkArray[++n4 + 1];
        }
        if ((vector2.size() & 1) != 0) {
            System.out.println("Odd number of chains!");
        }
    }

    public static boolean obstructs(double d, double d2, int n) {
        return (n & 1) == 0 ? d <= d2 : d < d2;
    }

    public static class EOWindOp
    extends AreaOp {
        private boolean inside;

        public void newRow() {
            this.inside = false;
        }

        public int classify(Edge edge) {
            boolean bl;
            this.inside = bl = !this.inside;
            return bl ? 1 : -1;
        }

        public int getState() {
            return this.inside ? 1 : -1;
        }
    }

    public static class NZWindOp
    extends AreaOp {
        private int count;

        public void newRow() {
            this.count = 0;
        }

        public int classify(Edge edge) {
            int n = this.count;
            int n2 = n == 0 ? 1 : 0;
            this.count = n += edge.getCurve().getDirection();
            return n == 0 ? -1 : n2;
        }

        public int getState() {
            return this.count == 0 ? -1 : 1;
        }
    }

    public static class XorOp
    extends CAGOp {
        public boolean newClassification(boolean bl, boolean bl2) {
            return bl != bl2;
        }
    }

    public static class IntOp
    extends CAGOp {
        public boolean newClassification(boolean bl, boolean bl2) {
            return bl && bl2;
        }
    }

    public static class SubOp
    extends CAGOp {
        public boolean newClassification(boolean bl, boolean bl2) {
            return bl && !bl2;
        }
    }

    public static class AddOp
    extends CAGOp {
        public boolean newClassification(boolean bl, boolean bl2) {
            return bl || bl2;
        }
    }

    public static abstract class CAGOp
    extends AreaOp {
        boolean inLeft;
        boolean inRight;
        boolean inResult;

        public void newRow() {
            this.inLeft = false;
            this.inRight = false;
            this.inResult = false;
        }

        public int classify(Edge edge) {
            if (edge.getCurveTag() == 0) {
                this.inLeft = !this.inLeft;
            } else {
                this.inRight = !this.inRight;
            }
            boolean bl = this.newClassification(this.inLeft, this.inRight);
            if (this.inResult == bl) {
                return 0;
            }
            this.inResult = bl;
            return bl ? 1 : -1;
        }

        public int getState() {
            return this.inResult ? 1 : -1;
        }

        public abstract boolean newClassification(boolean var1, boolean var2);
    }
}

