/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.OffScreenImageSource;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;

public class OffScreenImage
extends BufferedImage {
    protected Component c;
    OffScreenImageSource osis;
    protected SurfaceData surfaceData;

    public OffScreenImage(Component component, int n, int n2) {
        super(n, n2, 6);
        this.c = component;
        this.initBackground(n, n2);
    }

    public OffScreenImage(Component component, int n, int n2, int n3) {
        super(n, n2, n3);
        this.c = component;
        this.initBackground(n, n2);
    }

    public OffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl) {
        super(colorModel, writableRaster, bl, null);
        this.c = component;
        this.initBackground(writableRaster.getWidth(), writableRaster.getHeight());
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        Font font;
        Color color;
        Color color2 = this.c.getBackground();
        if (color2 == null) {
            color2 = SystemColor.window;
        }
        if ((color = this.c.getForeground()) == null) {
            color = SystemColor.windowText;
        }
        if ((font = this.c.getFont()) == null) {
            font = new Font("Dialog", 0, 12);
        }
        return new SunGraphics2D(this.surfaceData, color, color2, font);
    }

    public SurfaceData getSourceSurfaceData(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        return this.surfaceData;
    }

    public SurfaceData restoreContents() {
        return this.surfaceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBackground(int n, int n2) {
        this.surfaceData = BufImgSurfaceData.createData(this);
        if (this.c == null) {
            return;
        }
        Graphics2D graphics2D = this.createGraphics();
        try {
            graphics2D.clearRect(0, 0, n, n2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            graphics2D.dispose();
            throw throwable;
        }
        graphics2D.dispose();
    }

    public ImageProducer getSource() {
        if (this.osis == null) {
            this.osis = new OffScreenImageSource(this);
        }
        return this.osis;
    }
}

