/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11SurfaceData;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.java2d.DisposerRecord;
import sun.java2d.DisposerTarget;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;

public class X11OffScreenImage
extends AcceleratedOffScreenImage
implements DisposerTarget {
    private long drawable;
    private Hashtable cachedHWSD = new Hashtable();
    private Hashtable bitmasks;
    private boolean transparent;
    private boolean bitmasksUpdateNeeded;
    private Object disposerReferent = new Object();

    public X11OffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl, boolean bl2) {
        this(component, colorModel, writableRaster, bl, 0L, bl2);
    }

    public X11OffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl, long l, boolean bl2) {
        super(component, colorModel, writableRaster, bl);
        this.surfaceDataSw = this.surfaceData;
        this.drawable = l;
        this.transparent = bl2;
        if (bl2) {
            this.bitmasks = new Hashtable();
        }
        this.bitmasksUpdateNeeded = bl2;
    }

    protected boolean isTransparent() {
        return this.transparent;
    }

    protected boolean isValidHWSD(GraphicsConfiguration graphicsConfiguration) {
        return this.surfaceDataHw != null && this.surfaceDataHw == this.cachedHWSD.get(graphicsConfiguration);
    }

    protected boolean operationSupported(CompositeType compositeType, Color color, boolean bl) {
        return !bl && (!this.transparent ? CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType) : CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType) && color != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAcceleratedBackground(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        block11: {
            try {
                this.bitmasksUpdateNeeded = this.surfaceDataSw.needsBackup();
                this.surfaceDataHw = (SurfaceData)this.cachedHWSD.get(graphicsConfiguration);
                if (this.surfaceDataHw != null) break block11;
                int n3 = 0;
                if (this.transparent) {
                    Integer n4 = (Integer)this.bitmasks.get(graphicsConfiguration.getDevice());
                    if (n4 == null) {
                        n3 = this.updateBitmask(this.surfaceDataSw, 0, ((X11GraphicsDevice)graphicsConfiguration.getDevice()).getScreen(), this.getWidth(), this.getHeight());
                        if (n3 != 0) {
                            Hashtable hashtable = this.bitmasks;
                            synchronized (hashtable) {
                                this.bitmasks.put(graphicsConfiguration.getDevice(), new Integer(n3));
                            }
                        }
                    } else {
                        n3 = n4;
                    }
                }
                this.surfaceDataHw = X11SurfaceData.X11PixmapSurfaceData.createData((X11GraphicsConfig)graphicsConfiguration, this.getWidth(), this.getHeight(), graphicsConfiguration.getColorModel(), this, this.drawable, n3);
                if (this.surfaceDataHw != null) {
                    this.cachedHWSD.put(graphicsConfiguration, this.surfaceDataHw);
                }
            }
            catch (NullPointerException nullPointerException) {
                this.surfaceDataHw = null;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.surfaceDataHw = null;
            }
        }
    }

    private native int updateBitmask(SurfaceData var1, int var2, int var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBitmasks() {
        Hashtable hashtable = this.bitmasks;
        synchronized (hashtable) {
            Enumeration enumeration = this.bitmasks.keys();
            while (enumeration.hasMoreElements()) {
                X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)enumeration.nextElement();
                int n = (Integer)this.bitmasks.get(x11GraphicsDevice);
                this.updateBitmask(this.surfaceDataSw, n, x11GraphicsDevice.getScreen(), this.getWidth(), this.getHeight());
            }
        }
    }

    protected void copyBackupToAccelerated() {
        super.copyBackupToAccelerated();
        if (this.transparent && this.surfaceDataHw != null && this.bitmasksUpdateNeeded) {
            this.updateBitmasks();
        }
        this.bitmasksUpdateNeeded = true;
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        if (this.c != null) {
            return super.createGraphics();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.createGraphics(this);
    }

    protected boolean destSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof X11SurfaceData;
    }

    public Object getDisposerReferent() {
        return this.disposerReferent;
    }

    public void setDisposerRecord(DisposerRecord disposerRecord) {
    }

    static {
        AcceleratedOffScreenImage.accelerationEnabled = X11SurfaceData.isAccelerationEnabled();
    }
}

