/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.print.AwtPrintControl;
import sun.print.PeekGraphics;
import sun.print.ProxyPrintGraphics;

public class PrintJob2D
extends PrintJob
implements Printable,
Runnable {
    private Frame frame;
    private String docTitle = "";
    private JobAttributes jobAttributes;
    private PageAttributes pageAttributes;
    private PrintRequestAttributeSet attributes;
    private AwtPrintControl printControl;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private MessageQ graphicsToBeDrawn = new MessageQ("tobedrawn");
    private MessageQ graphicsDrawn = new MessageQ("drawn");
    private Graphics2D currentGraphics;
    private int pageIndex = -1;
    private Thread printerJobThread;

    public PrintJob2D(Frame frame, String string, Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (frame == null) {
            throw new NullPointerException("Frame must not be null");
        }
        this.docTitle = string == null ? "" : this.docTitle;
        this.printControl = new AwtPrintControl(frame, string, properties);
    }

    public PrintJob2D(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (frame == null && (jobAttributes == null || jobAttributes.getDialog() == JobAttributes.DialogType.NATIVE)) {
            throw new NullPointerException("Frame must not be null");
        }
        this.docTitle = string == null ? "" : this.docTitle;
        this.jobAttributes = jobAttributes;
        this.pageAttributes = pageAttributes;
        this.printControl = new AwtPrintControl(frame, string, jobAttributes, pageAttributes);
    }

    public boolean printDialog() {
        boolean bl = this.printControl.displayDialog();
        if (bl) {
            this.jobAttributes = this.printControl.getJobAttributes();
            this.pageAttributes = this.printControl.getPageAttributes();
            this.printerJob = PrinterJob.getPrinterJob();
            if (this.printerJob == null) {
                return false;
            }
            this.copyAttributes();
            if (this.pageFormat == null) {
                this.pageFormat = this.printerJob.defaultPage();
            }
            this.printerJob.setPrintable(this, this.pageFormat);
        }
        return bl;
    }

    private PrintService findNamedPrintService(String string) {
        PrintService printService = this.printerJob.getPrintService();
        if (printService != null && string.equals(printService.getName())) {
            return printService;
        }
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        int n = 0;
        while (n < printServiceArray.length) {
            if (string.equals(printServiceArray[n].getName())) {
                return printServiceArray[n];
            }
            ++n;
        }
        return null;
    }

    private void copyAttributes() {
        Object object;
        Object object2;
        this.attributes = new HashPrintRequestAttributeSet();
        this.printerJob.setJobName(this.docTitle);
        this.attributes.add(new JobName(this.docTitle, null));
        JobAttributes.DestinationType destinationType = this.jobAttributes.getDestination();
        if (destinationType == JobAttributes.DestinationType.PRINTER) {
            object2 = this.jobAttributes.getPrinter();
            if (object2 != null && object2 != "" && (object = this.findNamedPrintService((String)object2)) != null) {
                try {
                    this.printerJob.setPrintService((PrintService)object);
                }
                catch (PrinterException printerException) {}
            }
        } else {
            object2 = this.jobAttributes.getFileName();
            if (object2 == null) {
                object2 = "out.prn";
            }
            object = new File((String)object2).toURI();
            this.attributes.add(new Destination((URI)object));
        }
        if ((object2 = this.jobAttributes.getSides()) == JobAttributes.SidesType.TWO_SIDED_LONG_EDGE) {
            this.attributes.add(Sides.TWO_SIDED_LONG_EDGE);
        } else if (object2 == JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE) {
            this.attributes.add(Sides.TWO_SIDED_SHORT_EDGE);
        } else if (object2 == JobAttributes.SidesType.ONE_SIDED) {
            this.attributes.add(Sides.ONE_SIDED);
        }
        object = this.jobAttributes.getMultipleDocumentHandling();
        if (object == JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_COLLATED_COPIES) {
            this.attributes.add(SheetCollate.COLLATED);
        } else {
            this.attributes.add(SheetCollate.UNCOLLATED);
        }
        this.attributes.add(new Copies(this.jobAttributes.getCopies()));
        if (this.pageAttributes.getColor() == PageAttributes.ColorType.COLOR) {
            this.attributes.add(Chromaticity.COLOR);
        } else {
            this.attributes.add(Chromaticity.MONOCHROME);
        }
        this.pageFormat = this.printerJob.defaultPage();
        if (this.pageAttributes.getOrientationRequested() == PageAttributes.OrientationRequestedType.LANDSCAPE) {
            this.pageFormat.setOrientation(0);
        }
        int[] nArray = AwtPrintControl.getSize(this.pageAttributes.getMedia());
        Paper paper = new Paper();
        paper.setSize(nArray[0], nArray[1]);
        if (this.pageAttributes.getOrigin() == PageAttributes.OriginType.PRINTABLE) {
            paper.setImageableArea(18.0, 18.0, paper.getWidth() - 36.0, paper.getHeight() - 36.0);
        } else {
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        }
        this.pageFormat.setPaper(paper);
        PageAttributes.PrintQualityType printQualityType = this.pageAttributes.getPrintQuality();
        if (printQualityType == PageAttributes.PrintQualityType.DRAFT) {
            this.attributes.add(PrintQuality.DRAFT);
        } else if (printQualityType == PageAttributes.PrintQualityType.NORMAL) {
            this.attributes.add(PrintQuality.NORMAL);
        } else if (printQualityType == PageAttributes.PrintQualityType.HIGH) {
            this.attributes.add(PrintQuality.HIGH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphics getGraphics() {
        ProxyPrintGraphics proxyPrintGraphics = null;
        PrintJob2D printJob2D = this;
        synchronized (printJob2D) {
            ++this.pageIndex;
            if (this.pageIndex == 0) {
                this.startPrinterJobThread();
            }
            this.notify();
        }
        if (this.currentGraphics != null) {
            this.graphicsDrawn.append(this.currentGraphics);
            this.currentGraphics = null;
        }
        this.currentGraphics = this.graphicsToBeDrawn.pop();
        if (this.currentGraphics instanceof PeekGraphics) {
            ((PeekGraphics)this.currentGraphics).setAWTDrawingOnly();
            this.graphicsDrawn.append(this.currentGraphics);
            this.currentGraphics = this.graphicsToBeDrawn.pop();
        }
        if (this.currentGraphics != null) {
            this.currentGraphics.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
            double d = 72.0 / this.getPageResolutionInternal();
            this.currentGraphics.scale(d, d);
            proxyPrintGraphics = new ProxyPrintGraphics(this.currentGraphics.create(), this);
        }
        return proxyPrintGraphics;
    }

    public Dimension getPageDimension() {
        double d;
        double d2;
        if (this.pageAttributes != null && this.pageAttributes.getOrigin() == PageAttributes.OriginType.PRINTABLE) {
            d2 = this.pageFormat.getImageableWidth();
            d = this.pageFormat.getImageableHeight();
        } else {
            d2 = this.pageFormat.getWidth();
            d = this.pageFormat.getHeight();
        }
        double d3 = this.getPageResolutionInternal() / 72.0;
        return new Dimension((int)(d2 * d3), (int)(d * d3));
    }

    private double getPageResolutionInternal() {
        if (this.pageAttributes != null) {
            int[] nArray = this.pageAttributes.getPrinterResolution();
            if (nArray[2] == 3) {
                return nArray[0];
            }
            return (double)nArray[0] * 2.54;
        }
        return 72.0;
    }

    public int getPageResolution() {
        return (int)this.getPageResolutionInternal();
    }

    public boolean lastPageFirst() {
        return false;
    }

    public void end() {
        if (this.currentGraphics != null) {
            this.graphicsDrawn.append(this.currentGraphics);
        }
        this.graphicsToBeDrawn.close();
        this.graphicsDrawn.closeWhenEmpty();
    }

    public void finalize() {
        this.end();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.graphicsToBeDrawn.append((Graphics2D)graphics);
        int n2 = this.graphicsDrawn.pop() != null ? 0 : 1;
        return n2;
    }

    private void startPrinterJobThread() {
        this.printerJobThread = new Thread((Runnable)this, "printerJobThread");
        this.printerJobThread.start();
    }

    public void run() {
        try {
            this.printerJob.print(this.attributes);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        this.graphicsToBeDrawn.closeWhenEmpty();
        this.graphicsDrawn.close();
    }

    private class MessageQ {
        private String qid = "noname";
        private ArrayList queue = new ArrayList();

        MessageQ(String string) {
            this.qid = string;
        }

        synchronized void closeWhenEmpty() {
            while (this.queue != null && this.queue.size() > 0) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.queue = null;
            this.notifyAll();
        }

        synchronized void close() {
            this.queue = null;
            this.notifyAll();
        }

        synchronized boolean append(Graphics2D graphics2D) {
            boolean bl = false;
            if (this.queue != null) {
                this.queue.add(graphics2D);
                bl = true;
                this.notify();
            }
            return bl;
        }

        synchronized Graphics2D pop() {
            Graphics2D graphics2D = null;
            while (graphics2D == null && this.queue != null) {
                if (this.queue.size() > 0) {
                    graphics2D = (Graphics2D)this.queue.remove(0);
                    this.notify();
                    continue;
                }
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return graphics2D;
        }
    }
}

