/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.image.ByteInterleavedRaster;
import sun.print.OpenBook;
import sun.print.PageableDoc;
import sun.print.PathGraphics;
import sun.print.PeekGraphics;
import sun.print.ProxyGraphics2D;
import sun.print.ServiceDialog;
import sun.print.SunPrinterJobService;

public abstract class RasterPrinterJob
extends PrinterJob {
    protected static final int PRINTER = 0;
    protected static final int FILE = 1;
    protected static final int STREAM = 2;
    private static final int MAX_BAND_SIZE = 0x400000;
    private int cachedBandWidth = 0;
    private int cachedBandHeight = 0;
    private BufferedImage cachedBand = null;
    private int mNumCopies = 1;
    private boolean mCollate = false;
    private int mFirstPage = -1;
    private int mLastPage = -1;
    private Pageable mDocument = new Book();
    private String mDocName = new String("Java Printing");
    private boolean performingPrinting = false;
    private boolean userCancelled = false;
    private FilePermission printToFilePermission;
    private ArrayList redrawList = new ArrayList();
    private static String OSName = "";
    private int copiesAttr;
    private String jobNameAttr;
    private String userNameAttr;
    private PageRanges pageRangesAttr;
    protected Sides sidesAttr;
    protected String destinationAttr;
    protected boolean noJobSheet = false;
    protected int mDestType = 1;
    protected String mDestination = "";
    protected boolean collateAttReq = false;
    protected Chromaticity mChromAttr;
    protected PrintRequestAttributeSet attributes = null;
    private PrintService myService;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$sun$print$SunAlternateMedia;
    static /* synthetic */ Class class$javax$print$attribute$standard$OrientationRequested;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobName;
    static /* synthetic */ Class class$javax$print$attribute$standard$Copies;
    static /* synthetic */ Class class$javax$print$attribute$standard$Destination;
    static /* synthetic */ Class class$javax$print$attribute$standard$Fidelity;
    static /* synthetic */ Class class$javax$print$attribute$standard$Chromaticity;
    static /* synthetic */ Class class$javax$print$attribute$standard$SheetCollate;
    static /* synthetic */ Class class$javax$print$attribute$standard$Sides;
    static /* synthetic */ Class class$javax$print$attribute$standard$PageRanges;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobSheets;
    static /* synthetic */ Class class$javax$print$attribute$standard$RequestingUserName;

    protected abstract double getXRes();

    protected abstract double getYRes();

    protected abstract double getPhysicalPrintableX(Paper var1);

    protected abstract double getPhysicalPrintableY(Paper var1);

    protected abstract double getPhysicalPrintableWidth(Paper var1);

    protected abstract double getPhysicalPrintableHeight(Paper var1);

    protected abstract double getPhysicalPageWidth(Paper var1);

    protected abstract double getPhysicalPageHeight(Paper var1);

    protected abstract void startPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected abstract void endPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected abstract void printBand(byte[] var1, int var2, int var3, int var4, int var5) throws PrinterException;

    public void saveState(AffineTransform affineTransform, Shape shape, Rectangle2D rectangle2D, double d, double d2, Rectangle2D rectangle2D2, AffineTransform affineTransform2) {
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.theTransform = affineTransform;
        graphicsState.theClip = shape;
        graphicsState.region = rectangle2D;
        graphicsState.sx = d;
        graphicsState.sy = d2;
        graphicsState.imageTransform = affineTransform2;
        graphicsState.imageSrcRect = rectangle2D2;
        this.redrawList.add(graphicsState);
    }

    protected static PrintService lookupDefaultPrintService() {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService != null && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
            return printService;
        }
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (printServiceArray.length > 0) {
            return printServiceArray[0];
        }
        return null;
    }

    public PrintService getPrintService() {
        block6: {
            PrintService[] printServiceArray;
            if (this.myService != null) break block6;
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService != null && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE)) {
                try {
                    this.setPrintService(printService);
                    this.myService = printService;
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
            if (this.myService == null && (printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)).length > 0) {
                try {
                    this.setPrintService(printServiceArray[0]);
                    this.myService = printServiceArray[0];
                }
                catch (PrinterException printerException) {}
            }
        }
        return this.myService;
    }

    public void setPrintService(PrintService printService) throws PrinterException {
        if (printService == null) {
            throw new PrinterException("Service cannot be null");
        }
        if (!printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || !printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
            throw new PrinterException("Not a 2D print service: " + printService);
        }
        this.myService = printService;
    }

    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        OrientationRequested orientationRequested;
        float f;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        PrintService printService = this.getPrintService();
        if (printService == null) {
            ServiceDialog.showNoPrintService(graphicsConfiguration);
            return pageFormat;
        }
        float f2 = (float)Math.rint(pageFormat.getPaper().getWidth() * 25400.0 / 72.0) / 25400.0f;
        Media media = MediaSize.findMedia(f2, f = (float)Math.rint(pageFormat.getPaper().getHeight() * 25400.0 / 72.0) / 25400.0f, 25400);
        if (media == null || !printService.isAttributeValueSupported(media, null, null)) {
            media = (Media)printService.getDefaultAttributeValue(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = RasterPrinterJob.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        }
        switch (pageFormat.getOrientation()) {
            case 0: {
                orientationRequested = OrientationRequested.LANDSCAPE;
                break;
            }
            case 2: {
                orientationRequested = OrientationRequested.REVERSE_LANDSCAPE;
                break;
            }
            default: {
                orientationRequested = OrientationRequested.PORTRAIT;
            }
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        this.attributes.add(media);
        this.attributes.add(orientationRequested);
        PageFormat pageFormat2 = this.pageDialog(this.attributes);
        if (pageFormat2 == null) {
            return pageFormat;
        }
        return pageFormat2;
    }

    public PageFormat pageDialog(final PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        PageFormat pageFormat = (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                int n = rectangle.x + rectangle.width / 3;
                int n2 = rectangle.y + rectangle.height / 3;
                PrintService printService = RasterPrinterJob.this.getPrintService();
                if (printService == null) {
                    ServiceDialog.showNoPrintService(graphicsConfiguration);
                    return null;
                }
                ServiceDialog serviceDialog = new ServiceDialog(graphicsConfiguration, n, n2, printService, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
                serviceDialog.show();
                if (serviceDialog.getStatus() == 1) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    MediaSize mediaSize;
                    Class clazz;
                    PrintRequestAttributeSet printRequestAttributeSet2 = serviceDialog.getAttributes();
                    Class clazz2 = clazz = class$sun$print$SunAlternateMedia == null ? (class$sun$print$SunAlternateMedia = RasterPrinterJob.class$("sun.print.SunAlternateMedia")) : class$sun$print$SunAlternateMedia;
                    if (printRequestAttributeSet.containsKey(clazz) && printRequestAttributeSet2.containsKey(clazz)) {
                        printRequestAttributeSet.remove(clazz);
                    }
                    printRequestAttributeSet.addAll(printRequestAttributeSet2);
                    PageFormat pageFormat = RasterPrinterJob.this.defaultPage();
                    OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = RasterPrinterJob.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested);
                    int n3 = 1;
                    if (orientationRequested != null) {
                        if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                            n3 = 2;
                        } else if (orientationRequested == OrientationRequested.LANDSCAPE) {
                            n3 = 0;
                        }
                    }
                    pageFormat.setOrientation(n3);
                    Media media = (Media)printRequestAttributeSet.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = RasterPrinterJob.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
                    if (media == null) {
                        media = (Media)printService.getDefaultAttributeValue(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = RasterPrinterJob.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
                    }
                    if (!(media instanceof MediaSizeName)) {
                        media = MediaSizeName.NA_LETTER;
                    }
                    if ((mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media)) == null) {
                        mediaSize = MediaSize.NA.LETTER;
                    }
                    int n4 = 352;
                    Paper paper = new Paper();
                    float[] fArray = mediaSize.getSize(n4);
                    double d5 = Math.rint(fArray[0]);
                    double d6 = Math.rint(fArray[1]);
                    paper.setSize(d5, d6);
                    MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = RasterPrinterJob.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea);
                    if (mediaPrintableArea != null) {
                        d4 = Math.rint(mediaPrintableArea.getX(n4));
                        d3 = Math.rint(mediaPrintableArea.getY(n4));
                        d2 = Math.rint(mediaPrintableArea.getWidth(n4));
                        d = Math.rint(mediaPrintableArea.getHeight(n4));
                    } else {
                        if (d5 >= 432.0) {
                            d4 = 72.0;
                            d2 = d5 - 144.0;
                        } else {
                            d4 = d5 / 6.0;
                            d2 = d5 * 0.75;
                        }
                        if (d6 >= 432.0) {
                            d3 = 72.0;
                            d = d6 - 144.0;
                        } else {
                            d3 = d6 / 6.0;
                            d = d6 * 0.75;
                        }
                    }
                    paper.setImageableArea(d4, d3, d2, d);
                    pageFormat.setPaper(paper);
                    return pageFormat;
                }
                return null;
            }
        });
        return pageFormat;
    }

    public boolean printDialog(final PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block8: {
                    PrintService[] printServiceArray;
                    GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                    PrintService printService = RasterPrinterJob.this.getPrintService();
                    if (printService == null) {
                        ServiceDialog.showNoPrintService(graphicsConfiguration);
                        return Boolean.FALSE;
                    }
                    StreamPrintServiceFactory[] streamPrintServiceFactoryArray = null;
                    if (printService instanceof StreamPrintService) {
                        streamPrintServiceFactoryArray = PrinterJob.lookupStreamPrintServices(null);
                        printServiceArray = new StreamPrintService[streamPrintServiceFactoryArray.length];
                        int n = 0;
                        while (n < streamPrintServiceFactoryArray.length) {
                            printServiceArray[n] = streamPrintServiceFactoryArray[n].getPrintService(null);
                            ++n;
                        }
                    } else {
                        printServiceArray = PrinterJob.lookupPrintServices();
                        if (printServiceArray == null || printServiceArray.length == 0) {
                            printServiceArray = new PrintService[]{printService};
                        }
                    }
                    Rectangle rectangle = graphicsConfiguration.getBounds();
                    int n = rectangle.x + rectangle.width / 3;
                    int n2 = rectangle.y + rectangle.height / 3;
                    PrintService printService2 = ServiceUI.printDialog(graphicsConfiguration, n, n2, printServiceArray, printService, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
                    if (printService2 == null) {
                        return Boolean.FALSE;
                    }
                    if (printService.equals(printService2)) break block8;
                    try {
                        RasterPrinterJob.this.setPrintService(printService2);
                    }
                    catch (PrinterException printerException) {}
                }
                return Boolean.TRUE;
            }
        });
        return bl;
    }

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(new Copies(this.getCopies()));
        hashPrintRequestAttributeSet.add(new JobName(this.getJobName(), null));
        boolean bl = this.printDialog(hashPrintRequestAttributeSet);
        if (bl) {
            Destination destination;
            Copies copies;
            JobName jobName = (JobName)hashPrintRequestAttributeSet.get(class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = RasterPrinterJob.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)hashPrintRequestAttributeSet.get(class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = RasterPrinterJob.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((destination = (Destination)hashPrintRequestAttributeSet.get(class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = RasterPrinterJob.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(destination.getURI()).getPath();
                }
                catch (Exception exception) {
                    this.mDestination = "out.prn";
                }
            } else {
                this.mDestType = 0;
                this.mDestination = this.getPrintService().getName();
            }
        }
        return bl;
    }

    public void setPrintable(Printable printable) {
        this.setPageable(new OpenBook(this.defaultPage(new PageFormat()), printable));
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.setPageable(new OpenBook(pageFormat, printable));
    }

    public void setPageable(Pageable pageable) throws NullPointerException {
        if (pageable == null) {
            throw new NullPointerException();
        }
        this.mDocument = pageable;
    }

    protected void initPrinter() {
    }

    protected boolean isSupportedValue(Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        return attribute != null && this.getPrintService().isAttributeValueSupported(attribute, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
    }

    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        JobName jobName;
        JobSheets jobSheets;
        Copies copies;
        SheetCollate sheetCollate;
        Object object;
        this.setCollated(false);
        this.sidesAttr = null;
        this.pageRangesAttr = null;
        this.copiesAttr = 0;
        this.jobNameAttr = null;
        this.userNameAttr = null;
        this.destinationAttr = null;
        this.collateAttReq = false;
        this.mChromAttr = Chromaticity.COLOR;
        if (printRequestAttributeSet == null) {
            return;
        }
        PrintService printService = this.getPrintService();
        boolean bl = false;
        Fidelity fidelity = (Fidelity)printRequestAttributeSet.get(class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = RasterPrinterJob.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity);
        if (fidelity != null && fidelity == Fidelity.FIDELITY_TRUE) {
            bl = true;
        }
        if (bl && (object = printService.getUnsupportedAttributes(DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet)) != null) {
            throw new PrinterException("Fidelity cannot be satisfied");
        }
        object = (Chromaticity)printRequestAttributeSet.get(class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = RasterPrinterJob.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity);
        if (this.isSupportedValue((Attribute)object, printRequestAttributeSet)) {
            this.setChrom((Chromaticity)object);
        }
        if (this.isSupportedValue(sheetCollate = (SheetCollate)printRequestAttributeSet.get(class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = RasterPrinterJob.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate), printRequestAttributeSet)) {
            this.setCollated(sheetCollate == SheetCollate.COLLATED);
        }
        this.sidesAttr = (Sides)printRequestAttributeSet.get(class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = RasterPrinterJob.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides);
        if (!this.isSupportedValue(this.sidesAttr, printRequestAttributeSet)) {
            this.sidesAttr = Sides.ONE_SIDED;
        }
        this.pageRangesAttr = (PageRanges)printRequestAttributeSet.get(class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = RasterPrinterJob.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges);
        if (!this.isSupportedValue(this.pageRangesAttr, printRequestAttributeSet)) {
            this.pageRangesAttr = null;
        }
        this.copiesAttr = this.isSupportedValue(copies = (Copies)printRequestAttributeSet.get(class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = RasterPrinterJob.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies), printRequestAttributeSet) || !bl & copies != null ? copies.getValue() : this.getCopies();
        Destination destination = (Destination)printRequestAttributeSet.get(class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = RasterPrinterJob.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination);
        if (this.isSupportedValue(destination, printRequestAttributeSet)) {
            this.destinationAttr = "out.prn";
            try {
                this.destinationAttr = new File(destination.getURI()).getPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((jobSheets = (JobSheets)printRequestAttributeSet.get(class$javax$print$attribute$standard$JobSheets == null ? (class$javax$print$attribute$standard$JobSheets = RasterPrinterJob.class$("javax.print.attribute.standard.JobSheets")) : class$javax$print$attribute$standard$JobSheets)) != null) {
            this.noJobSheet = jobSheets == JobSheets.NONE;
        }
        this.jobNameAttr = this.isSupportedValue(jobName = (JobName)printRequestAttributeSet.get(class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = RasterPrinterJob.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName), printRequestAttributeSet) || !bl & jobName != null ? jobName.getValue() : this.getJobName();
        RequestingUserName requestingUserName = (RequestingUserName)printRequestAttributeSet.get(class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = RasterPrinterJob.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName);
        if (this.isSupportedValue(requestingUserName, printRequestAttributeSet) || !bl & requestingUserName != null) {
            this.userNameAttr = requestingUserName.getValue();
        } else {
            try {
                this.userNameAttr = this.getUserName();
            }
            catch (SecurityException securityException) {
                this.userNameAttr = "";
            }
        }
        Media media = (Media)printRequestAttributeSet.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = RasterPrinterJob.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = RasterPrinterJob.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = RasterPrinterJob.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea);
        if ((orientationRequested != null || media != null || mediaPrintableArea != null) && this.getPageable() instanceof OpenBook) {
            Pageable pageable = this.getPageable();
            Printable printable = pageable.getPrintable(0);
            PageFormat pageFormat = (PageFormat)pageable.getPageFormat(0).clone();
            Paper paper = pageFormat.getPaper();
            if (this.isSupportedValue(orientationRequested, printRequestAttributeSet) || !bl & orientationRequested != null) {
                int n = orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (orientationRequested.equals(OrientationRequested.LANDSCAPE) ? 0 : 1);
                pageFormat.setOrientation(n);
            }
            if (this.isSupportedValue(mediaPrintableArea, printRequestAttributeSet) || !bl & mediaPrintableArea != null) {
                float[] fArray = mediaPrintableArea.getPrintableArea(25400);
                int n = 0;
                while (n < fArray.length) {
                    fArray[n] = fArray[n] * 72.0f;
                    ++n;
                }
                paper.setImageableArea(fArray[0], fArray[1], fArray[2], fArray[3]);
            }
            if ((this.isSupportedValue(media, printRequestAttributeSet) || !bl & media != null) && media instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)media;
                MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                if (mediaSize == null && mediaSizeName == MediaSizeName.TABLOID) {
                    mediaSize = MediaSize.Other.LEDGER;
                }
                if (mediaSize != null) {
                    float f = mediaSize.getX(25400) * 72.0f;
                    float f2 = mediaSize.getY(25400) * 72.0f;
                    paper.setSize(f, f2);
                }
            }
            pageFormat.setPaper(paper);
            pageFormat = this.validatePage(pageFormat);
            this.setPrintable(printable, pageFormat);
        }
    }

    private void spoolToService(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        DocPrintJob docPrintJob = this.getPrintService().createPrintJob();
        PageableDoc pageableDoc = new PageableDoc(this.getPageable());
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        try {
            docPrintJob.print(pageableDoc, printRequestAttributeSet);
        }
        catch (PrintException printException) {
            throw new PrinterException(printException.toString());
        }
    }

    public void print() throws PrinterException {
        this.print(this.attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        RasterPrinterJob rasterPrinterJob;
        int n;
        PrintService printService = this.getPrintService();
        if (printService == null) {
            throw new PrinterException("No print service found.");
        }
        if (!(printService instanceof SunPrinterJobService) || !((SunPrinterJobService)((Object)printService)).usesClass(this.getClass())) {
            this.spoolToService(printRequestAttributeSet);
            return;
        }
        this.setAttributes(printRequestAttributeSet);
        this.initPrinter();
        int n2 = this.getCollatedCopies();
        int n3 = this.getNoncollatedCopies();
        int n4 = this.mDocument.getNumberOfPages();
        int n5 = this.getFirstPage();
        int n6 = this.getLastPage();
        if (n6 == -1 && (n = this.mDocument.getNumberOfPages()) != -1) {
            n6 = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            rasterPrinterJob = this;
            synchronized (rasterPrinterJob) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            this.startDoc();
            if (this.isCancelled()) {
                this.cancelDoc();
            }
            int n7 = 0;
            while (n7 < n2) {
                int n8 = n5;
                int n9 = 0;
                while ((n8 <= n6 || n6 == -1) && n9 == 0) {
                    block28: {
                        int n10;
                        block27: {
                            if (this.pageRangesAttr == null) break block27;
                            n10 = this.pageRangesAttr.next(n8);
                            if (n10 == -1) break;
                            if (n10 != n8 + 1) break block28;
                        }
                        n10 = 0;
                        while (n10 < n3 && n9 == 0) {
                            if (this.isCancelled()) {
                                this.cancelDoc();
                            }
                            n9 = this.printPage(this.mDocument, n8);
                            ++n10;
                        }
                    }
                    ++n8;
                }
                ++n7;
            }
            if (this.isCancelled()) {
                this.cancelDoc();
            }
        }
        finally {
            rasterPrinterJob = this;
            synchronized (rasterPrinterJob) {
                if (this.performingPrinting) {
                    this.endDoc();
                }
                this.performingPrinting = false;
                this.notify();
            }
        }
    }

    protected void validatePaper(Paper paper, Paper paper2) {
        if (paper == null || paper2 == null) {
            return;
        }
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        double d3 = paper.getImageableX();
        double d4 = paper.getImageableY();
        double d5 = paper.getImageableWidth();
        double d6 = paper.getImageableHeight();
        Paper paper3 = new Paper();
        d = d > 0.0 ? d : paper3.getWidth();
        d2 = d2 > 0.0 ? d2 : paper3.getHeight();
        d3 = d3 > 0.0 ? d3 : paper3.getImageableX();
        d4 = d4 > 0.0 ? d4 : paper3.getImageableY();
        d5 = d5 > 0.0 ? d5 : paper3.getImageableWidth();
        double d7 = d6 = d6 > 0.0 ? d6 : paper3.getImageableHeight();
        if (d5 > d) {
            d5 = d;
        }
        if (d6 > d2) {
            d6 = d2;
        }
        if (d3 + d5 > d) {
            d3 = d - d5;
        }
        if (d4 + d6 > d2) {
            d4 = d2 - d6;
        }
        paper2.setSize(d, d2);
        paper2.setImageableArea(d3, d4, d5, d6);
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        pageFormat2.setOrientation(1);
        Paper paper = new Paper();
        String string = Locale.getDefault().getCountry();
        if (string != null && !string.equals(Locale.US.getCountry()) && !string.equals(Locale.CANADA.getCountry())) {
            double d = 25.4;
            double d2 = 72.0;
            double d3 = Math.rint(210.0 * d2 / d);
            double d4 = Math.rint(297.0 * d2 / d);
            paper.setSize(d3, d4);
            paper.setImageableArea(d2, d2, d3 - 2.0 * d2, d4 - 2.0 * d2);
        }
        pageFormat2.setPaper(paper);
        return pageFormat2;
    }

    public PageFormat validatePage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        Paper paper = new Paper();
        this.validatePaper(pageFormat2.getPaper(), paper);
        pageFormat2.setPaper(paper);
        return pageFormat2;
    }

    public void setChrom(Chromaticity chromaticity) {
        if (chromaticity != null) {
            this.mChromAttr = chromaticity;
        }
    }

    public Chromaticity getChrom() {
        return this.mChromAttr;
    }

    public void setCopies(int n) {
        this.mNumCopies = n > 0 ? n : 1;
    }

    public int getCopies() {
        return this.mNumCopies;
    }

    protected int getCopiesInt() {
        return this.copiesAttr > 0 ? this.copiesAttr : this.getCopies();
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    protected String getUserNameInt() {
        if (this.userNameAttr != null) {
            return this.userNameAttr;
        }
        try {
            return this.getUserName();
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public void setJobName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.mDocName = string;
    }

    public String getJobName() {
        return this.mDocName;
    }

    protected String getJobNameInt() {
        return this.jobNameAttr != null ? this.jobNameAttr : this.getJobName();
    }

    protected void setPageRange(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            this.mFirstPage = n;
            this.mLastPage = n2;
            if (this.mLastPage < this.mFirstPage) {
                this.mLastPage = this.mFirstPage;
            }
        } else {
            this.mFirstPage = -1;
            this.mLastPage = -1;
        }
    }

    protected int getFirstPage() {
        return this.mFirstPage == -1 ? 0 : this.mFirstPage;
    }

    protected int getLastPage() {
        return this.mLastPage;
    }

    protected void setCollated(boolean bl) {
        this.mCollate = bl;
        this.collateAttReq = true;
    }

    protected boolean isCollated() {
        return this.mCollate;
    }

    protected abstract void startDoc() throws PrinterException;

    protected abstract void endDoc() throws PrinterException;

    protected abstract void abortDoc();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelDoc() throws PrinterAbortException {
        this.abortDoc();
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            this.userCancelled = false;
            this.performingPrinting = false;
            this.notify();
        }
        throw new PrinterAbortException();
    }

    protected int getCollatedCopies() {
        return this.isCollated() ? this.getCopiesInt() : 1;
    }

    protected int getNoncollatedCopies() {
        return this.isCollated() ? 1 : this.getCopiesInt();
    }

    protected int printPage(Pageable pageable, int n) throws PrinterException {
        Printable printable;
        PageFormat pageFormat;
        try {
            pageFormat = pageable.getPageFormat(n);
            printable = pageable.getPrintable(n);
        }
        catch (Exception exception) {
            throw new PrinterException("No page or printable exists.");
        }
        Paper paper = pageFormat.getPaper();
        double d = this.getXRes() / 72.0;
        double d2 = this.getYRes() / 72.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(paper.getImageableX() * d, paper.getImageableY() * d2, paper.getImageableWidth() * d, paper.getImageableHeight() * d2);
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.scale(d, d2);
        int n2 = (int)((RectangularShape)double_).getWidth();
        int n3 = 0;
        if (n2 % 4 != 0) {
            n2 += 4 - n2 % 4;
        }
        if (OSName == "") {
            OSName = System.getProperty("os.name");
        }
        int n4 = (int)((RectangularShape)double_).getHeight();
        n3 = OSName.equals("OS/2") ? 0x400000 / (n2 * 3) : 0x400000 / n4 / 3;
        int n5 = (int)(paper.getImageableX() * d);
        int n6 = (int)(paper.getImageableY() * d2);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(-n5, n6);
        affineTransform3.translate(0.0, n3);
        affineTransform3.scale(1.0, -1.0);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 5);
        PeekGraphics peekGraphics = this.createPeekGraphics(bufferedImage.createGraphics(), this);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.initPrinterGraphics(peekGraphics, double_2);
        int n7 = printable.print(peekGraphics, pageFormat, n);
        if (n7 == 0) {
            this.startPage(pageFormat, printable, n);
            Graphics2D graphics2D = this.createPathGraphics(peekGraphics, this, printable, pageFormat, n);
            if (graphics2D != null) {
                if (OSName == "") {
                    OSName = System.getProperty("os.name");
                }
                if (OSName.equals("OS/2")) {
                    graphics2D.translate(-this.getPhysicalPrintableX(paper), -this.getPhysicalPrintableY(paper));
                    graphics2D.transform(affineTransform2);
                } else {
                    graphics2D.transform(affineTransform2);
                    graphics2D.translate(-this.getPhysicalPrintableX(paper) / d, -this.getPhysicalPrintableY(paper) / d2);
                }
                graphics2D.transform(new AffineTransform(pageFormat.getMatrix()));
                this.initPrinterGraphics(graphics2D, double_2);
                this.redrawList.clear();
                printable.print(graphics2D, pageFormat, n);
                int n8 = 0;
                while (n8 < this.redrawList.size()) {
                    GraphicsState graphicsState = (GraphicsState)this.redrawList.get(n8);
                    graphics2D.setTransform(graphicsState.theTransform);
                    graphics2D.setClip(graphicsState.theClip);
                    ((PathGraphics)graphics2D).redrawRegion(graphicsState.region, graphicsState.sx, graphicsState.sy, graphicsState.imageSrcRect, graphicsState.imageTransform);
                    ++n8;
                }
            } else {
                BufferedImage bufferedImage2 = this.cachedBand;
                if (this.cachedBand == null || n2 != this.cachedBandWidth || n3 != this.cachedBandHeight) {
                    this.cachedBand = bufferedImage2 = new BufferedImage(n2, n3, 5);
                    this.cachedBandWidth = n2;
                    this.cachedBandHeight = n3;
                }
                Graphics2D graphics2D2 = bufferedImage2.createGraphics();
                Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, n2, n3);
                this.initPrinterGraphics(graphics2D2, double_3);
                ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D2, this);
                Graphics2D graphics2D3 = bufferedImage2.createGraphics();
                graphics2D3.setColor(Color.white);
                ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage2.getRaster();
                byte[] byArray = byteInterleavedRaster.getDataStorage();
                int n9 = n6 + n4;
                int n10 = (int)this.getPhysicalPrintableX(paper);
                int n11 = (int)this.getPhysicalPrintableY(paper);
                int n12 = 0;
                while (n12 <= n4) {
                    graphics2D3.fillRect(0, 0, n2, n3);
                    graphics2D2.setTransform(affineTransform);
                    graphics2D2.transform(affineTransform3);
                    affineTransform3.translate(0.0, -n3);
                    graphics2D2.transform(affineTransform2);
                    graphics2D2.transform(new AffineTransform(pageFormat.getMatrix()));
                    Rectangle rectangle = graphics2D2.getClipBounds();
                    if (rectangle == null || peekGraphics.hitsDrawingArea(rectangle) && n2 > 0 && n3 > 0) {
                        int n13;
                        int n14 = n5 - n10;
                        if (n14 < 0) {
                            graphics2D2.translate((double)n14 / d, 0.0);
                            n14 = 0;
                        }
                        if ((n13 = n6 + n12 - n11) < 0) {
                            graphics2D2.translate(0.0, (double)n13 / d2);
                            n13 = 0;
                        }
                        proxyGraphics2D.setDelegate((Graphics2D)graphics2D2.create());
                        printable.print(proxyGraphics2D, pageFormat, n);
                        proxyGraphics2D.dispose();
                        if (OSName == "") {
                            OSName = System.getProperty("os.name");
                        }
                        if (OSName.equals("OS/2")) {
                            this.printBand(byArray, 0, n12, n2, n3);
                        } else {
                            this.printBand(byArray, n5, n6 + n12, n2, n3);
                        }
                    }
                    n12 += n3;
                }
                graphics2D3.dispose();
                graphics2D2.dispose();
            }
            this.endPage(pageFormat, printable, n);
        }
        return n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            if (this.performingPrinting) {
                this.userCancelled = true;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        boolean bl = false;
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            bl = this.performingPrinting && this.userCancelled;
            this.notify();
        }
        return bl;
    }

    protected Pageable getPageable() {
        return this.mDocument;
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        return null;
    }

    protected PeekGraphics createPeekGraphics(Graphics2D graphics2D, PrinterJob printerJob) {
        return new PeekGraphics(graphics2D, printerJob);
    }

    void initPrinterGraphics(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setClip(rectangle2D);
        graphics2D.setPaint(Color.black);
    }

    public boolean checkAllowedToPrintToFile() {
        try {
            this.throwPrintToFile();
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private void throwPrintToFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.printToFilePermission == null) {
                this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
            }
            securityManager.checkPermission(this.printToFilePermission);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class GraphicsState {
        Rectangle2D region;
        Shape theClip;
        AffineTransform theTransform;
        double sx;
        double sy;
        Rectangle2D imageSrcRect;
        AffineTransform imageTransform;

        private GraphicsState() {
        }
    }
}

