/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.callback;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DialogCallbackHandler
implements CallbackHandler {
    private Component parentComponent;
    private static final int JPasswordFieldLen = 8;

    public DialogCallbackHandler() {
    }

    public DialogCallbackHandler(Component component) {
        this.parentComponent = component;
    }

    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        ArrayList<Action> arrayList2 = new ArrayList<Action>(2);
        ConfirmationInfo confirmationInfo = new ConfirmationInfo();
        int n = 0;
        while (n < callbackArray.length) {
            Object object2;
            JTextField jTextField;
            Callback callback;
            if (callbackArray[n] instanceof TextOutputCallback) {
                callback = (TextOutputCallback)callbackArray[n];
                switch (((TextOutputCallback)callback).getMessageType()) {
                    case 0: {
                        confirmationInfo.messageType = 1;
                        break;
                    }
                    case 1: {
                        confirmationInfo.messageType = 2;
                        break;
                    }
                    case 2: {
                        confirmationInfo.messageType = 0;
                        break;
                    }
                    default: {
                        throw new UnsupportedCallbackException(callbackArray[n], "Unrecognized message type");
                    }
                }
                arrayList.add(((TextOutputCallback)callback).getMessage());
            } else if (callbackArray[n] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[n];
                object = new JLabel(((NameCallback)callback).getPrompt());
                jTextField = new JTextField();
                object2 = ((NameCallback)callback).getDefaultName();
                if (object2 != null) {
                    jTextField.setText((String)object2);
                }
                Box box = Box.createHorizontalBox();
                box.add((Component)object);
                box.add(jTextField);
                arrayList.add(box);
                arrayList2.add(new Action((NameCallback)callback, jTextField){
                    private final /* synthetic */ NameCallback val$nc;
                    private final /* synthetic */ JTextField val$name;
                    {
                        this.val$nc = nameCallback;
                        this.val$name = jTextField;
                    }

                    public void perform() {
                        this.val$nc.setName(this.val$name.getText());
                    }
                });
            } else if (callbackArray[n] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[n];
                object = new JLabel(((PasswordCallback)callback).getPrompt());
                jTextField = new JPasswordField(8);
                if (!((PasswordCallback)callback).isEchoOn()) {
                    ((JPasswordField)jTextField).setEchoChar('*');
                }
                object2 = Box.createHorizontalBox();
                ((Container)object2).add((Component)object);
                ((Container)object2).add(jTextField);
                arrayList.add(object2);
                arrayList2.add(new Action((PasswordCallback)callback, (JPasswordField)jTextField){
                    private final /* synthetic */ PasswordCallback val$pc;
                    private final /* synthetic */ JPasswordField val$password;
                    {
                        this.val$pc = passwordCallback;
                        this.val$password = jPasswordField;
                    }

                    public void perform() {
                        this.val$pc.setPassword(this.val$password.getPassword());
                    }
                });
            } else if (callbackArray[n] instanceof ConfirmationCallback) {
                callback = (ConfirmationCallback)callbackArray[n];
                confirmationInfo.setCallback((ConfirmationCallback)callback);
                if (((ConfirmationCallback)callback).getPrompt() != null) {
                    arrayList.add(((ConfirmationCallback)callback).getPrompt());
                }
            } else {
                throw new UnsupportedCallbackException(callbackArray[n], "Unrecognized Callback");
            }
            ++n;
        }
        int n2 = JOptionPane.showOptionDialog(this.parentComponent, arrayList.toArray(), "Confirmation", confirmationInfo.optionType, confirmationInfo.messageType, null, confirmationInfo.options, confirmationInfo.initialValue);
        if (n2 == 0 || n2 == 0) {
            object = arrayList2.iterator();
            while (object.hasNext()) {
                ((Action)object.next()).perform();
            }
        }
        confirmationInfo.handleResult(n2);
    }

    private static class ConfirmationInfo {
        private int[] translations;
        int optionType = 2;
        Object[] options = null;
        Object initialValue = null;
        int messageType = 3;
        private ConfirmationCallback callback;

        private ConfirmationInfo() {
        }

        void setCallback(ConfirmationCallback confirmationCallback) throws UnsupportedCallbackException {
            this.callback = confirmationCallback;
            int n = confirmationCallback.getOptionType();
            switch (n) {
                case 0: {
                    this.optionType = 0;
                    this.translations = new int[]{0, 0, 1, 1, -1, 1};
                    break;
                }
                case 1: {
                    this.optionType = 1;
                    this.translations = new int[]{0, 0, 1, 1, 2, 2, -1, 2};
                    break;
                }
                case 2: {
                    this.optionType = 2;
                    this.translations = new int[]{0, 3, 2, 2, -1, 2};
                    break;
                }
                case -1: {
                    this.options = confirmationCallback.getOptions();
                    this.translations = new int[]{-1, confirmationCallback.getDefaultOption()};
                    break;
                }
                default: {
                    throw new UnsupportedCallbackException(confirmationCallback, "Unrecognized option type: " + n);
                }
            }
            int n2 = confirmationCallback.getMessageType();
            switch (n2) {
                case 1: {
                    this.messageType = 2;
                    break;
                }
                case 2: {
                    this.messageType = 0;
                    break;
                }
                case 0: {
                    this.messageType = 1;
                    break;
                }
                default: {
                    throw new UnsupportedCallbackException(confirmationCallback, "Unrecognized message type: " + n2);
                }
            }
        }

        void handleResult(int n) {
            if (this.callback == null) {
                return;
            }
            int n2 = 0;
            while (n2 < this.translations.length) {
                if (this.translations[n2] == n) {
                    n = this.translations[n2 + 1];
                    break;
                }
                n2 += 2;
            }
            this.callback.setSelectedIndex(n);
        }
    }

    private static interface Action {
        public void perform();
    }
}

