/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.ibm.security.util.ResourcesMgr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.SubjectDomainCombiner;
import sun.security.action.GetPropertyAction;

public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    Set principals;
    transient Set pubCredentials;
    transient Set privCredentials;
    private boolean readOnly = false;
    private static Constructor combiner_constructor;
    private static ClassLoader sysClassLoader;
    private static Method getSub;
    private static Method doAsPA;
    private static Method doAsPEA;
    private static Method doAsPPA;
    private static Method doAsPPEA;
    private static boolean overrideActive;
    private static final int PRINCIPAL_SET = 1;
    private static final int PUB_CREDENTIAL_SET = 2;
    private static final int PRIV_CREDENTIAL_SET = 3;
    static /* synthetic */ Class class$javax$security$auth$Subject;
    static /* synthetic */ Class class$java$util$LinkedList;

    public Subject() {
        this.principals = new SecureSet(this, 1);
        this.pubCredentials = new SecureSet(this, 2);
        this.privCredentials = new SecureSet(this, 3);
    }

    public Subject(boolean bl, Set set, Set set2, Set set3) {
        if (set == null || set2 == null || set3 == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null input(s)"));
        }
        this.principals = new SecureSet(this, 1, set);
        this.pubCredentials = new SecureSet(this, 2, set2);
        this.privCredentials = new SecureSet(this, 3, set3);
        this.readOnly = bl;
    }

    public void setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static Subject getSubject(final AccessControlContext accessControlContext) {
        if (overrideActive) {
            try {
                return (Subject)getSub.invoke(null, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubject"));
        }
        if (accessControlContext == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null AccessControlContext provided"));
        }
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DomainCombiner domainCombiner = accessControlContext.getDomainCombiner();
                if (!(domainCombiner instanceof SubjectDomainCombiner)) {
                    return null;
                }
                SubjectDomainCombiner subjectDomainCombiner = (SubjectDomainCombiner)domainCombiner;
                return subjectDomainCombiner.getSubject();
            }
        });
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        if (overrideActive) {
            try {
                return doAsPA.invoke(null, subject, privilegedAction);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAs"));
        }
        if (privilegedAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (overrideActive) {
            try {
                return doAsPEA.invoke(null, subject, privilegedExceptionAction);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    if (throwable instanceof PrivilegedActionException) {
                        throw (PrivilegedActionException)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAs"));
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        if (overrideActive) {
            try {
                return doAsPPA.invoke(null, subject, privilegedAction, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (privilegedAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext2));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        if (overrideActive) {
            try {
                return doAsPPEA.invoke(null, subject, privilegedExceptionAction, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    if (throwable instanceof PrivilegedActionException) {
                        throw (PrivilegedActionException)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext2));
    }

    private static AccessControlContext createContext(final Subject subject, final AccessControlContext accessControlContext) {
        return (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (subject == null) {
                    return new AccessControlContext(accessControlContext, null);
                }
                try {
                    Object[] objectArray = new Object[]{subject};
                    DomainCombiner domainCombiner = (DomainCombiner)combiner_constructor.newInstance(objectArray);
                    return new AccessControlContext(accessControlContext, domainCombiner);
                }
                catch (Exception exception) {
                    throw new SecurityException(exception.toString());
                }
            }
        });
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public Set getPrincipals(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(1, clazz);
    }

    public Set getPublicCredentials() {
        return this.pubCredentials;
    }

    public Set getPrivateCredentials() {
        return this.privCredentials;
    }

    public Set getPublicCredentials(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(2, clazz);
    }

    public Set getPrivateCredentials(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(3, clazz);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Subject) {
            Subject subject = (Subject)object;
            return this.getPrincipals().equals(subject.getPrincipals()) && this.getPublicCredentials().equals(subject.getPublicCredentials()) && this.getPrivateCredentials().equals(subject.getPrivateCredentials());
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    /*
     * Unable to fully structure code
     */
    String toString(boolean var1_1) {
        block8: {
            var2_2 = new String(ResourcesMgr.getString("Subject:\n"));
            var3_3 = new String();
            var4_4 = this.getPrincipals().iterator();
            var5_5 = this.getPublicCredentials().iterator();
            var6_6 = null;
            if (var1_1) {
                try {
                    var6_6 = this.getPrivateCredentials().iterator();
                }
                catch (SecurityException var7_7) {}
            }
            while (var4_4.hasNext()) {
                var7_8 = (Principal)var4_4.next();
                var3_3 = var3_3 + ResourcesMgr.getString("\tPrincipal: ") + var7_8.toString() + ResourcesMgr.getString("\n");
            }
            while (var5_5.hasNext()) {
                var7_8 = var5_5.next();
                var3_3 = var3_3 + ResourcesMgr.getString("\tPublic Credential: ") + var7_8.toString() + ResourcesMgr.getString("\n");
            }
            if (var6_6 != null) ** GOTO lbl29
            var3_3 = var3_3 + ResourcesMgr.getString("\tPrivate Credentials inaccessible\n");
            break block8;
lbl-1000:
            // 1 sources

            {
                try {
                    var7_8 = var6_6.next();
                    var3_3 = var3_3 + ResourcesMgr.getString("\tPrivate Credential: ") + var7_8.toString() + ResourcesMgr.getString("\n");
                    continue;
                }
                catch (SecurityException var7_9) {
                    var3_3 = var3_3 + ResourcesMgr.getString("\tPrivate Credential inaccessible\n");
                    break;
                }
lbl29:
                // 2 sources

                ** while (var6_6.hasNext())
            }
        }
        return var2_2 + var3_3;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.getPrincipals().iterator();
        Iterator iterator2 = this.getPublicCredentials().iterator();
        Iterator iterator3 = this.getPrivateCredentials().iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            n ^= principal.hashCode();
        }
        while (iterator2.hasNext()) {
            n ^= this.getCredHashCode(iterator2.next());
        }
        return n;
    }

    private int getCredHashCode(Object object) {
        try {
            return object.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            return object.getClass().toString().hashCode();
        }
    }

    private void sort(int[] nArray) {
        int n = 0;
        boolean bl = true;
        int n2 = nArray.length - 1;
        while (bl) {
            n = 0;
            bl = false;
            while (n < n2) {
                if (nArray[n] < nArray[n + 1]) {
                    bl = true;
                    int n3 = nArray[n];
                    nArray[n] = nArray[n + 1];
                    nArray[n + 1] = n3;
                }
                ++n;
            }
            --n2;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pubCredentials = new SecureSet(this, 2);
        this.privCredentials = new SecureSet(this, 3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        overrideActive = false;
        Object object = AccessController.doPrivileged(new GetPropertyAction("com.ibm.SubjectOverrideClassName"));
        if (object != null) {
            AccessController.doPrivileged(new PrivilegedAction((String)object){
                private final /* synthetic */ String val$overrideName;
                {
                    this.val$overrideName = string;
                }

                public Object run() {
                    try {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        Class<?> clazz = Class.forName(this.val$overrideName, true, classLoader);
                        Class<?> clazz2 = Class.forName("java.security.AccessControlContext", true, classLoader);
                        Class<?> clazz3 = Class.forName("java.security.PrivilegedAction", true, classLoader);
                        Class<?> clazz4 = Class.forName("java.security.PrivilegedExceptionAction", true, classLoader);
                        Class<?> clazz5 = Class.forName("javax.security.auth.Subject", true, classLoader);
                        getSub = clazz.getMethod("getSubject", clazz2);
                        doAsPA = clazz.getMethod("doAs", clazz5, clazz3);
                        doAsPEA = clazz.getMethod("doAs", clazz5, clazz4);
                        doAsPPA = clazz.getMethod("doAsPrivileged", clazz5, clazz3, clazz2);
                        doAsPPEA = clazz.getMethod("doAsPrivileged", clazz5, clazz4, clazz2);
                        return null;
                    }
                    catch (Throwable throwable) {
                        throw new InternalError("Could not initialize Subject overrides from " + this.val$overrideName + " because " + throwable.getMessage());
                    }
                }
            });
            overrideActive = true;
        }
        if (sysClassLoader == null) {
            object = class$javax$security$auth$Subject == null ? (class$javax$security$auth$Subject = Subject.class$("javax.security.auth.Subject")) : class$javax$security$auth$Subject;
            synchronized (object) {
                if (sysClassLoader == null) {
                    Object object2;
                    sysClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return ClassLoader.getSystemClassLoader();
                        }
                    });
                    Class[] classArray = new Class[]{class$javax$security$auth$Subject == null ? (class$javax$security$auth$Subject = Subject.class$("javax.security.auth.Subject")) : class$javax$security$auth$Subject};
                    String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Security.getProperty("combiner.provider");
                        }
                    });
                    if (string == null) {
                        string = "javax.security.auth.SubjectDomainCombiner";
                    } else {
                        object2 = System.getSecurityManager();
                        if (object2 != null) {
                            ((SecurityManager)object2).checkPermission(new AuthPermission("specifyDomainCombiner"));
                        }
                    }
                    try {
                        object2 = Class.forName(string, true, sysClassLoader);
                        combiner_constructor = ((Class)object2).getConstructor(classArray);
                    }
                    catch (Exception exception) {
                        throw new SecurityException(exception.toString());
                    }
                }
            }
        }
    }

    private class ClassSet
    extends AbstractSet {
        private int which;
        private Set set;
        private Class c;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassSet(int n, Class clazz) {
            ClassSet classSet = this;
            synchronized (classSet) {
                this.which = n;
                this.c = clazz;
                Iterator iterator = null;
                switch (n) {
                    case 1: {
                        iterator = Subject.this.principals.iterator();
                        break;
                    }
                    case 2: {
                        iterator = Subject.this.pubCredentials.iterator();
                        break;
                    }
                    default: {
                        iterator = Subject.this.privCredentials.iterator();
                    }
                }
                Iterator iterator2 = iterator;
                SecurityManager securityManager = System.getSecurityManager();
                this.set = new HashSet();
                while (iterator2.hasNext()) {
                    Object t = AccessController.doPrivileged(new PrivilegedAction(this, iterator2){
                        private final /* synthetic */ Iterator val$iterator_copy;
                        private final /* synthetic */ ClassSet this$1;
                        {
                            this.this$1 = classSet;
                            this.val$iterator_copy = iterator;
                        }

                        public Object run() {
                            return this.val$iterator_copy.next();
                        }
                    });
                    if (!clazz.isAssignableFrom(t.getClass())) continue;
                    if (n != 3) {
                        this.set.add(t);
                        continue;
                    }
                    if (securityManager != null) {
                        if (Subject.this.getPrincipals() == null || Subject.this.getPrincipals().size() == 0) {
                            securityManager.checkPermission(new PrivateCredentialPermission(t.getClass().getName(), new HashSet()));
                        } else {
                            securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(t.getClass().getName(), Subject.this.getPrincipals()), "read"));
                        }
                    }
                    this.set.add(t);
                }
            }
        }

        public synchronized int size() {
            return this.set.size();
        }

        public Iterator iterator() {
            return this.set.iterator();
        }

        public synchronized boolean add(Object object) {
            if (!object.getClass().isAssignableFrom(this.c)) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("attempting to add an object which is not an instance of class"));
                Object[] objectArray = new Object[]{this.c.toString()};
                throw new SecurityException(messageFormat.format(objectArray));
            }
            return this.set.add(object);
        }
    }

    private static class SecureSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("this$0", class$javax$security$auth$Subject == null ? (class$javax$security$auth$Subject = Subject.class$("javax.security.auth.Subject")) : class$javax$security$auth$Subject), new ObjectStreamField("elements", class$java$util$LinkedList == null ? (class$java$util$LinkedList = Subject.class$("java.util.LinkedList")) : class$java$util$LinkedList), new ObjectStreamField("which", Integer.TYPE)};
        Subject subject;
        LinkedList elements;
        private int which;

        SecureSet(Subject subject, int n) {
            this.subject = subject;
            this.which = n;
            this.elements = new LinkedList();
        }

        SecureSet(Subject subject, int n, Set set) {
            this.subject = subject;
            this.which = n;
            this.elements = new LinkedList(set);
        }

        public synchronized int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            LinkedList linkedList = this.elements;
            return new Iterator(this, linkedList){
                ListIterator i;
                private final /* synthetic */ LinkedList val$list;
                private final /* synthetic */ SecureSet this$0;
                {
                    this.this$0 = secureSet;
                    this.val$list = linkedList;
                    this.i = this.val$list.listIterator(0);
                }

                public synchronized boolean hasNext() {
                    return this.i.hasNext();
                }

                public synchronized Object next() {
                    if (SecureSet.access$600(this.this$0) != 3) {
                        return this.i.next();
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            if (this.this$0.subject.getPrincipals() == null || this.this$0.subject.getPrincipals().size() == 0) {
                                securityManager.checkPermission(new PrivateCredentialPermission(this.val$list.get(this.i.nextIndex()).getClass().getName(), new HashSet<E>()));
                            } else {
                                securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(this.val$list.get(this.i.nextIndex()).getClass().getName(), this.this$0.subject.getPrincipals()), "read"));
                            }
                        }
                        catch (SecurityException securityException) {
                            this.i.next();
                            throw securityException;
                        }
                    }
                    return this.i.next();
                }

                public synchronized void remove() {
                    if (this.this$0.subject.isReadOnly()) {
                        throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        switch (SecureSet.access$600(this.this$0)) {
                            case 1: {
                                securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                                break;
                            }
                            case 2: {
                                securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                                break;
                            }
                            default: {
                                securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                            }
                        }
                    }
                    this.i.remove();
                }
            };
        }

        public synchronized boolean add(Object object) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                switch (this.which) {
                    case 1: {
                        securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                        break;
                    }
                    case 2: {
                        securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                        break;
                    }
                    default: {
                        securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    }
                }
            }
            switch (this.which) {
                case 1: {
                    if (object instanceof Principal) break;
                    throw new SecurityException(ResourcesMgr.getString("attempting to add an object which is not an instance of java.security.Principal to a Subject's Principal Set"));
                }
            }
            if (!this.elements.contains(object)) {
                return this.elements.add(object);
            }
            return false;
        }

        public synchronized boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                if (object2 == null) {
                    if (object != null) continue;
                    iterator.remove();
                    return true;
                }
                if (!object2.equals(object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public synchronized boolean contains(Object object) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && this.which == 3) {
                if (this.subject.getPrincipals() == null || this.subject.getPrincipals().size() == 0) {
                    securityManager.checkPermission(new PrivateCredentialPermission(object.getClass().getName(), new HashSet()));
                } else {
                    securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(object.getClass().getName(), this.subject.getPrincipals()), "read"));
                }
            }
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                if (!(object2 == null ? object == null : object2.equals(object))) continue;
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            block0: while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (object == null) {
                        if (e != null) continue;
                        iterator.remove();
                        bl = true;
                        continue block0;
                    }
                    if (!object.equals(e)) continue;
                    iterator.remove();
                    bl = true;
                    continue block0;
                }
            }
            return bl;
        }

        public boolean retainAll(Collection collection) {
            boolean bl = false;
            boolean bl2 = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                bl2 = false;
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (object == null) {
                        if (e != null) continue;
                        bl2 = true;
                        break;
                    }
                    if (!object.equals(e)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                iterator.remove();
                bl2 = false;
                bl = true;
            }
            return bl;
        }

        public void clear() {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                iterator.remove();
            }
        }

        private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object;
            if (this.which == 3) {
                object = this.iterator();
                while (object.hasNext()) {
                    object.next();
                }
            }
            object = objectOutputStream.putFields();
            ((ObjectOutputStream.PutField)object).put("this$0", this.subject);
            ((ObjectOutputStream.PutField)object).put("elements", this.elements);
            ((ObjectOutputStream.PutField)object).put("which", this.which);
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.subject = (Subject)getField.get("this$0", null);
            this.elements = (LinkedList)getField.get("elements", null);
            this.which = getField.get("which", 0);
        }

        static /* synthetic */ int access$600(SecureSet secureSet) {
            return secureSet.which;
        }
    }
}

