/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.net.InetAddress;
import java.util.Arrays;

public class ChannelBinding {
    private InetAddress initiatorAddress = null;
    private InetAddress acceptorAddress = null;
    private byte[] appData = null;

    public ChannelBinding(InetAddress initiatorAddress, InetAddress acceptorAddress, byte[] appData) {
        this.initiatorAddress = initiatorAddress;
        this.acceptorAddress = acceptorAddress;
        if (appData != null) {
            this.appData = new byte[appData.length];
            System.arraycopy(appData, 0, this.appData, 0, appData.length);
        }
    }

    public ChannelBinding(byte[] appData) {
        if (appData != null) {
            this.appData = new byte[appData.length];
            System.arraycopy(appData, 0, this.appData, 0, appData.length);
        }
    }

    public InetAddress getInitiatorAddress() {
        return this.initiatorAddress;
    }

    public InetAddress getAcceptorAddress() {
        return this.acceptorAddress;
    }

    public byte[] getApplicationData() {
        return this.appData;
    }

    public boolean equals(Object obj) {
        try {
            boolean acceptorsMatch;
            boolean initiatorsMatch;
            if (obj == null || !(obj instanceof ChannelBinding)) {
                return false;
            }
            ChannelBinding cb = (ChannelBinding)obj;
            byte[] data = cb.getApplicationData();
            if (!Arrays.equals(this.appData, data)) {
                return false;
            }
            InetAddress init = cb.getInitiatorAddress();
            boolean bl = initiatorsMatch = this.initiatorAddress == null && init == null || this.initiatorAddress != null && this.initiatorAddress.equals(init);
            if (!initiatorsMatch) {
                return false;
            }
            InetAddress accept = cb.getAcceptorAddress();
            boolean bl2 = acceptorsMatch = this.acceptorAddress == null && accept == null || this.acceptorAddress != null && this.acceptorAddress.equals(accept);
            return acceptorsMatch;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public int hashCode() {
        if (this.initiatorAddress != null) {
            return this.initiatorAddress.hashCode();
        }
        if (this.acceptorAddress != null) {
            return this.acceptorAddress.hashCode();
        }
        if (this.appData != null) {
            return new String(this.appData).hashCode();
        }
        return 1;
    }
}

