/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Vector;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;

public class PKCS7 {
    private ObjectIdentifier contentType;
    private BigInteger version = null;
    private AlgorithmId[] digestAlgorithmIds = null;
    private ContentInfo contentInfo = null;
    private X509Certificate[] certificates = null;
    private X509CRL[] crls = null;
    private SignerInfo[] signerInfos = null;
    private boolean oldStyle = false;
    private Principal[] certIssuerNames;
    static final Debug debug = Debug.getInstance("jar");

    public PKCS7(InputStream inputStream) throws ParsingException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        this.parse(byArray);
    }

    public PKCS7(DerInputStream derInputStream) throws ParsingException {
        this.parse(derInputStream.toByteArray());
    }

    public PKCS7(byte[] byArray) throws ParsingException {
        this.parse(byArray);
    }

    private void parse(byte[] byArray) throws ParsingException {
        try {
            this.parse(byArray, false);
        }
        catch (IOException iOException) {
            try {
                if (debug != null) {
                    debug.println("PKCS#7 Block not in 1.2 format, trying to parse as 1.1.");
                }
                this.parse(byArray, true);
                this.oldStyle = true;
            }
            catch (IOException iOException2) {
                ParsingException parsingException = new ParsingException(iOException2.getMessage());
                parsingException.initCause(iOException2);
                throw parsingException;
            }
        }
    }

    private void parse(byte[] byArray, boolean bl) throws IOException {
        this.contentInfo = new ContentInfo(new DerInputStream(byArray), bl);
        this.contentType = this.contentInfo.contentType;
        DerValue derValue = this.contentInfo.getContent();
        if (this.contentType.equals(PKCSOID.SIGNED_DATA_OID)) {
            this.parseSignedData(derValue);
        } else if (this.contentType.equals(ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(derValue);
        } else if (this.contentType.equals(PKCSOID.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(derValue);
        } else {
            throw new ParsingException("content type " + this.contentType + " not supported.");
        }
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Certificate[] x509CertificateArray, SignerInfo[] signerInfoArray) {
        this.version = BigInteger.ONE;
        this.digestAlgorithmIds = algorithmIdArray;
        this.contentInfo = contentInfo;
        this.certificates = x509CertificateArray;
        this.signerInfos = signerInfoArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseNetscapeCertChain(DerValue derValue) throws ParsingException, IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        this.certificates = new X509Certificate[derValueArray.length];
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        int n = 0;
        while (true) {
            block13: {
                Object var11_10;
                if (n >= derValueArray.length) {
                    return;
                }
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    try {
                        if (certificateFactory == null) {
                            this.certificates[n] = new X509CertImpl(derValueArray[n]);
                        } else {
                            byte[] byArray = derValueArray[n].toByteArray();
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            this.certificates[n] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                            byteArrayInputStream.close();
                            byteArrayInputStream = null;
                        }
                    }
                    catch (CertificateException certificateException) {
                        ParsingException parsingException = new ParsingException(certificateException.getMessage());
                        parsingException.initCause(certificateException);
                        throw parsingException;
                    }
                    catch (IOException iOException) {
                        ParsingException parsingException = new ParsingException(iOException.getMessage());
                        parsingException.initCause(iOException);
                        throw parsingException;
                    }
                    var11_10 = null;
                    if (byteArrayInputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    throw throwable;
                }
                byteArrayInputStream.close();
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSignedData(DerValue derValue) throws ParsingException, IOException {
        byte[] byArray;
        Object object;
        int n;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n2 = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n2];
        try {
            int n3 = 0;
            while (n3 < n2) {
                derValueArray = derValueArray2[n3];
                this.digestAlgorithmIds[n3] = AlgorithmId.parse((DerValue)derValueArray);
                ++n3;
            }
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Error parsing digest AlgorithmId IDs: " + iOException.getMessage());
            parsingException.initCause(iOException);
            throw parsingException;
        }
        this.contentInfo = new ContentInfo(derInputStream);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if ((byte)derInputStream.peekByte() == -96) {
            derValueArray = derInputStream.getSet(2, true);
            n2 = derValueArray.length;
            this.certificates = new X509Certificate[n2];
            n = 0;
            while (n < n2) {
                block27: {
                    Object var13_16;
                    object = null;
                    try {
                        try {
                            if (certificateFactory == null) {
                                this.certificates[n] = new X509CertImpl(derValueArray[n]);
                            } else {
                                byArray = derValueArray[n].toByteArray();
                                object = new ByteArrayInputStream(byArray);
                                this.certificates[n] = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                                ((ByteArrayInputStream)object).close();
                                object = null;
                            }
                        }
                        catch (CertificateException certificateException) {
                            ParsingException parsingException = new ParsingException(certificateException.getMessage());
                            parsingException.initCause(certificateException);
                            throw parsingException;
                        }
                        catch (IOException iOException) {
                            ParsingException parsingException = new ParsingException(iOException.getMessage());
                            parsingException.initCause(iOException);
                            throw parsingException;
                        }
                        var13_16 = null;
                        if (object == null) break block27;
                    }
                    catch (Throwable throwable) {
                        var13_16 = null;
                        if (object != null) {
                            ((ByteArrayInputStream)object).close();
                        }
                        throw throwable;
                    }
                    ((ByteArrayInputStream)object).close();
                }
                ++n;
            }
        }
        if ((byte)derInputStream.peekByte() == -95) {
            derValueArray = derInputStream.getSet(1, true);
            n2 = derValueArray.length;
            this.crls = new X509CRL[n2];
            n = 0;
            while (n < n2) {
                block29: {
                    Object var15_22;
                    object = null;
                    try {
                        try {
                            if (certificateFactory == null) {
                                this.crls[n] = new X509CRLImpl(derValueArray[n]);
                            } else {
                                byArray = derValueArray[n].toByteArray();
                                object = new ByteArrayInputStream(byArray);
                                this.crls[n] = (X509CRL)certificateFactory.generateCRL((InputStream)object);
                                ((ByteArrayInputStream)object).close();
                                object = null;
                            }
                        }
                        catch (CRLException cRLException) {
                            ParsingException parsingException = new ParsingException(cRLException.getMessage());
                            parsingException.initCause(cRLException);
                            throw parsingException;
                        }
                        var15_22 = null;
                        if (object == null) break block29;
                    }
                    catch (Throwable throwable) {
                        var15_22 = null;
                        if (object != null) {
                            ((ByteArrayInputStream)object).close();
                        }
                        throw throwable;
                    }
                    ((ByteArrayInputStream)object).close();
                }
                ++n;
            }
        }
        derValueArray = derInputStream.getSet(1);
        n2 = derValueArray.length;
        this.signerInfos = new SignerInfo[n2];
        n = 0;
        while (n < n2) {
            object = derValueArray[n].toDerInputStream();
            this.signerInfos[n] = new SignerInfo((DerInputStream)object);
            ++n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseOldSignedData(DerValue derValue) throws ParsingException, IOException {
        Object object;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                derValueArray = derValueArray2[n2];
                this.digestAlgorithmIds[n2] = AlgorithmId.parse((DerValue)derValueArray);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new ParsingException("Error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(derInputStream, true);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        derValueArray = derInputStream.getSet(2);
        n = derValueArray.length;
        this.certificates = new X509Certificate[n];
        int n3 = 0;
        while (true) {
            block17: {
                Object var13_15;
                if (n3 >= n) break;
                object = null;
                try {
                    try {
                        if (certificateFactory == null) {
                            this.certificates[n3] = new X509CertImpl(derValueArray[n3]);
                        } else {
                            byte[] byArray = derValueArray[n3].toByteArray();
                            object = new ByteArrayInputStream(byArray);
                            this.certificates[n3] = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                            ((ByteArrayInputStream)object).close();
                            object = null;
                        }
                    }
                    catch (CertificateException certificateException) {
                        ParsingException parsingException = new ParsingException(certificateException.getMessage());
                        parsingException.initCause(certificateException);
                        throw parsingException;
                    }
                    catch (IOException iOException) {
                        ParsingException parsingException = new ParsingException(iOException.getMessage());
                        parsingException.initCause(iOException);
                        throw parsingException;
                    }
                    var13_15 = null;
                    if (object == null) break block17;
                }
                catch (Throwable throwable) {
                    var13_15 = null;
                    if (object != null) {
                        ((ByteArrayInputStream)object).close();
                    }
                    throw throwable;
                }
                ((ByteArrayInputStream)object).close();
            }
            ++n3;
        }
        derInputStream.getSet(0);
        object = derInputStream.getSet(1);
        n = ((DerValue[])object).length;
        this.signerInfos = new SignerInfo[n];
        int n4 = 0;
        while (n4 < n) {
            DerInputStream derInputStream2 = object[n4].toDerInputStream();
            this.signerInfos[n4] = new SignerInfo(derInputStream2, true);
            ++n4;
        }
        return;
    }

    public void encodeSignedData(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encodeSignedData(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void encodeSignedData(DerOutputStream derOutputStream) throws IOException {
        DerValue derValue;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        derOutputStream2.putOrderedSetOf((byte)49, (DerEncoder[])this.digestAlgorithmIds);
        this.contentInfo.encode(derOutputStream2);
        if (this.certificates != null && this.certificates.length != 0) {
            derValue = new X509CertImpl[this.certificates.length];
            int n = 0;
            while (n < this.certificates.length) {
                if (this.certificates[n] instanceof X509CertImpl) {
                    derValue[n] = (X509CertImpl)this.certificates[n];
                } else {
                    try {
                        byte[] byArray = this.certificates[n].getEncoded();
                        derValue[n] = new X509CertImpl(byArray);
                    }
                    catch (CertificateException certificateException) {
                        IOException iOException = new IOException(certificateException.getMessage());
                        iOException.initCause(certificateException);
                        throw iOException;
                    }
                }
                ++n;
            }
            derOutputStream2.putOrderedSetOf((byte)-96, (DerEncoder[])derValue);
        }
        derOutputStream2.putOrderedSetOf((byte)49, (DerEncoder[])this.signerInfos);
        derValue = new DerValue(48, derOutputStream2.toByteArray());
        ContentInfo contentInfo = new ContentInfo(PKCSOID.SIGNED_DATA_OID, derValue);
        contentInfo.encode(derOutputStream);
    }

    public SignerInfo verify(SignerInfo signerInfo, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        return signerInfo.verify(this, byArray);
    }

    public SignerInfo[] verify(byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < this.signerInfos.length) {
            object = this.verify(this.signerInfos[n], byArray);
            if (object != null) {
                vector.addElement((Object[])object);
            }
            ++n;
        }
        if (vector.size() != 0) {
            object = new SignerInfo[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (X509Certificate[])this.certificates.clone();
        }
        return null;
    }

    public X509CRL[] getCRLs() {
        if (this.crls != null) {
            return (X509CRL[])this.crls.clone();
        }
        return null;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInteger bigInteger, X500Name x500Name) {
        if (this.certificates != null) {
            if (this.certIssuerNames == null) {
                this.populateCertIssuerNames();
            }
            int n = 0;
            while (n < this.certificates.length) {
                X509Certificate x509Certificate = this.certificates[n];
                BigInteger bigInteger2 = x509Certificate.getSerialNumber();
                if (bigInteger.equals(bigInteger2) && x500Name.equals((Object)this.certIssuerNames[n])) {
                    return x509Certificate;
                }
                ++n;
            }
        }
        return null;
    }

    private void populateCertIssuerNames() {
        if (this.certificates == null) {
            return;
        }
        this.certIssuerNames = new Principal[this.certificates.length];
        int n = 0;
        while (n < this.certificates.length) {
            X509Certificate x509Certificate = this.certificates[n];
            Principal principal = x509Certificate.getIssuerDN();
            if (!(principal instanceof X500Name)) {
                try {
                    X509CertInfo x509CertInfo = new X509CertInfo(x509Certificate.getTBSCertificate());
                    principal = (Principal)x509CertInfo.get("issuer.dname");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.certIssuerNames[n] = principal;
            ++n;
        }
    }

    public String toString() {
        int n;
        String string = "";
        string = string + this.contentInfo + "\n";
        if (this.version != null) {
            string = string + "PKCS7 :: version: " + Debug.toHexString(this.version) + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            string = string + "PKCS7 :: digest AlgorithmIds: \n";
            n = 0;
            while (n < this.digestAlgorithmIds.length) {
                string = string + "\t" + this.digestAlgorithmIds[n] + "\n";
                ++n;
            }
        }
        if (this.certificates != null) {
            string = string + "PKCS7 :: certificates: \n";
            n = 0;
            while (n < this.certificates.length) {
                string = string + "\t" + n + ".   " + this.certificates[n] + "\n";
                ++n;
            }
        }
        if (this.crls != null) {
            string = string + "PKCS7 :: crls: \n";
            n = 0;
            while (n < this.crls.length) {
                string = string + "\t" + n + ".   " + this.crls[n] + "\n";
                ++n;
            }
        }
        if (this.signerInfos != null) {
            string = string + "PKCS7 :: signer infos: \n";
            n = 0;
            while (n < this.signerInfos.length) {
                string = string + "\t" + n + ".  " + this.signerInfos[n] + "\n";
                ++n;
            }
        }
        return string;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }
}

