/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.Debug;

public final class DSAPrivateKey
extends PKCS8Key
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    private static final long serialVersionUID = -3244453684193605938L;
    private BigInteger x;
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    public DSAPrivateKey() {
    }

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.x = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("could not DER encode x: " + iOException.getMessage());
            invalidKeyException.initCause(iOException);
            throw invalidKeyException;
        }
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        this.clearOldKey();
        this.decode(byArray);
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPrivateKey.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public BigInteger getX() {
        return this.x;
    }

    private void clearOldKey() {
        int n;
        if (this.encodedKey != null) {
            n = 0;
            while (n < this.encodedKey.length) {
                this.encodedKey[n] = 0;
                ++n;
            }
        }
        if (this.key != null) {
            n = 0;
            while (n < this.key.length) {
                this.key[n] = 0;
                ++n;
            }
        }
    }

    public String toString() {
        return "Sun DSA Private Key \nparameters:" + this.algid + "\nx: " + Debug.toHexString(this.x) + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.x = derInputStream.getBigInteger();
        }
        catch (IOException iOException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(iOException.getMessage());
            invalidKeyException.initCause(iOException);
            throw invalidKeyException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

