/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.ibm.security.util.PropertyExpander;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import sun.security.provider.PolicyParser;
import sun.security.tools.PolicyEntry;
import sun.security.tools.ToolWindow;

class PolicyTool {
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.Resources");
    static final Collator collator = Collator.getInstance();
    Vector warnings;
    boolean newWarning = false;
    boolean modified = false;
    private static final Class[] TWOPARAMS;
    private static final Class[] ONEPARAMS;
    private static final Class[] NOPARAMS;
    private static String policyFileName;
    private Vector policyEntries = new Vector();
    private PolicyParser parser = new PolicyParser();
    private KeyStore keyStore = null;
    private String keyStoreName = " ";
    private String keyStoreType = " ";
    static /* synthetic */ Class class$java$lang$String;

    private PolicyTool() {
        this.warnings = new Vector();
    }

    String getPolicyFileName() {
        return policyFileName;
    }

    void setPolicyFileName(String string) {
        policyFileName = string;
    }

    String getKeyStoreName() {
        return this.keyStoreName;
    }

    String getKeyStoreType() {
        return this.keyStoreType;
    }

    void newPolicy() {
        this.newWarning = false;
        this.policyEntries = new Vector();
        this.parser = new PolicyParser();
        this.warnings = new Vector();
        this.setPolicyFileName(null);
        this.keyStore = null;
        this.keyStoreName = "";
        this.keyStoreType = "";
        this.modified = false;
    }

    void openPolicy(ToolWindow toolWindow, String string) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, PolicyParser.ParsingException, IOException, FileNotFoundException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.newPolicy();
        this.setPolicyFileName(string);
        this.parser.read(new FileReader(string));
        this.openKeyStore(toolWindow, this.parser.getKeyStoreUrl(), this.parser.getKeyStoreType(), null);
        Enumeration enumeration = this.parser.grantElements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            Object object;
            Object object2;
            PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
            if (grantEntry.signedBy != null) {
                object2 = this.parseSigners(grantEntry.signedBy);
                int n = 0;
                while (n < ((Object)object2).length) {
                    object = this.getPublicKeyAlias((String)object2[n]);
                    if (object == null) {
                        this.newWarning = true;
                        stringArray = new MessageFormat(rb.getString("Warning: A public key for alias 'signers[i]' does not exist."));
                        Object[] objectArray = new Object[]{object2[n]};
                        this.warnings.addElement(stringArray.format(objectArray));
                    }
                    ++n;
                }
            }
            object2 = grantEntry.principals.listIterator(0);
            while (object2.hasNext()) {
                PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object2.next();
                try {
                    this.verifyPrincipal(principalEntry);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.newWarning = true;
                    this.warnings.addElement(rb.getString("Warning: Class not found: ") + principalEntry.getPrincipalClass());
                }
            }
            Enumeration enumeration2 = grantEntry.permissionElements();
            while (enumeration2.hasMoreElements()) {
                object = (PolicyParser.PermissionEntry)enumeration2.nextElement();
                try {
                    this.verifyPermission((PolicyParser.PermissionEntry)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.newWarning = true;
                    this.warnings.addElement(rb.getString("Warning: Class not found: ") + ((PolicyParser.PermissionEntry)object).permission);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.newWarning = true;
                    this.warnings.addElement(rb.getString("Warning: Invalid argument(s) for constructor: ") + ((PolicyParser.PermissionEntry)object).permission);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.newWarning = true;
                    this.warnings.addElement(rb.getString("Warning: Invalid argument(s) for constructor: ") + ((PolicyParser.PermissionEntry)object).permission);
                }
                if (((PolicyParser.PermissionEntry)object).signedBy == null) continue;
                stringArray = this.parseSigners(((PolicyParser.PermissionEntry)object).signedBy);
                int n = 0;
                while (n < stringArray.length) {
                    PublicKey publicKey = this.getPublicKeyAlias(stringArray[n]);
                    if (publicKey == null) {
                        this.newWarning = true;
                        MessageFormat messageFormat = new MessageFormat(rb.getString("Warning: A public key for alias 'signers[i]' does not exist."));
                        Object[] objectArray = new Object[]{stringArray[n]};
                        this.warnings.addElement(messageFormat.format(objectArray));
                    }
                    ++n;
                }
            }
            object = new PolicyEntry(this, grantEntry);
            this.policyEntries.addElement(object);
        }
        if (!this.newWarning) {
            this.warnings.addElement(rb.getString("Policy File opened successfully"));
        }
        this.modified = false;
    }

    void savePolicy(String string) throws FileNotFoundException, IOException {
        this.parser.setKeyStoreUrl(this.keyStoreName);
        this.parser.setKeyStoreType(this.keyStoreType);
        this.parser.write(new FileWriter(string));
        this.modified = false;
    }

    void openKeyStore(ToolWindow toolWindow, String string, String string2, String string3) {
        char[] cArray = null;
        this.keyStoreName = string;
        this.keyStoreType = string2;
        if (string == null || string.length() == 0) {
            return;
        }
        if (string3 != null) {
            cArray = string3.toCharArray();
        }
        URL uRL = null;
        try {
            string = PropertyExpander.expand(string).replace(File.separatorChar, '/');
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(policyFileName);
                URL uRL2 = new URL("file:" + file.getCanonicalPath());
                uRL = new URL(uRL2, string);
            }
            InputStream inputStream = uRL.openStream();
            this.keyStore = KeyStore.getInstance(string2);
            this.keyStore.load(inputStream, cArray);
            inputStream.close();
        }
        catch (KeyStoreException keyStoreException) {
            toolWindow.displayErrorDialog(toolWindow, rb.getString("Unknown keystore type, ") + string2);
            this.newWarning = true;
            this.warnings.addElement(rb.getString("Unknown keystore type, ") + string2);
        }
        catch (IOException iOException) {
            toolWindow.displayWarningDialog(toolWindow, rb.getString("Unable to read keystore from ") + uRL);
            this.newWarning = true;
            this.warnings.addElement(rb.getString("Unable to read keystore from ") + uRL);
        }
        catch (Exception exception) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Unexpected exception while reading keystore keyStoreName. View the Warning Log for details."));
            Object[] objectArray = new Object[]{string};
            toolWindow.displayErrorDialog(toolWindow, messageFormat.format(objectArray));
            this.newWarning = true;
            this.warnings.addElement(rb.getString("Warning: Unable to open Keystore: ") + string);
            this.warnings.addElement(rb.getString("\tdue to unexpected exception: ") + exception);
        }
    }

    boolean addEntry(PolicyEntry policyEntry, int n) {
        if (n < 0) {
            this.policyEntries.addElement(policyEntry);
            this.parser.add(policyEntry.getGrantEntry());
        } else {
            PolicyEntry policyEntry2 = (PolicyEntry)this.policyEntries.elementAt(n);
            this.parser.replace(policyEntry2.getGrantEntry(), policyEntry.getGrantEntry());
            this.policyEntries.setElementAt(policyEntry, n);
        }
        return true;
    }

    boolean addPrinEntry(PolicyEntry policyEntry, PolicyParser.PrincipalEntry principalEntry, int n) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        if (grantEntry.contains(principalEntry)) {
            return false;
        }
        LinkedList linkedList = grantEntry.principals;
        if (n != -1) {
            linkedList.set(n, principalEntry);
        } else {
            linkedList.add(principalEntry);
        }
        this.modified = true;
        return true;
    }

    boolean addPermEntry(PolicyEntry policyEntry, PolicyParser.PermissionEntry permissionEntry, int n) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        if (grantEntry.contains(permissionEntry)) {
            return false;
        }
        Vector vector = grantEntry.permissionEntries;
        if (n != -1) {
            vector.setElementAt(permissionEntry, n);
        } else {
            vector.addElement(permissionEntry);
        }
        this.modified = true;
        return true;
    }

    boolean removePermEntry(PolicyEntry policyEntry, PolicyParser.PermissionEntry permissionEntry) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        this.modified = grantEntry.remove(permissionEntry);
        return this.modified;
    }

    boolean removeEntry(PolicyEntry policyEntry) {
        this.parser.remove(policyEntry.getGrantEntry());
        this.modified = true;
        return this.policyEntries.removeElement(policyEntry);
    }

    PolicyEntry[] getEntry() {
        if (this.policyEntries.size() > 0) {
            PolicyEntry[] policyEntryArray = new PolicyEntry[this.policyEntries.size()];
            int n = 0;
            while (n < this.policyEntries.size()) {
                policyEntryArray[n] = (PolicyEntry)this.policyEntries.elementAt(n);
                ++n;
            }
            return policyEntryArray;
        }
        return null;
    }

    PublicKey getPublicKeyAlias(String string) {
        try {
            if (this.keyStore == null) {
                return null;
            }
            Certificate certificate = this.keyStore.getCertificate(string);
            if (certificate == null) {
                return null;
            }
            return certificate.getPublicKey();
        }
        catch (KeyStoreException keyStoreException) {
            this.newWarning = true;
            this.warnings.addElement(rb.getString("Warning: Unable to retrieve public key from keystore: ") + this.keyStoreName);
            this.warnings.addElement(rb.getString("\tdue to unexpected exception: ") + keyStoreException);
            return null;
        }
    }

    String[] getPublicKeyAlias() {
        try {
            int n = 0;
            String[] stringArray = null;
            if (this.keyStore == null) {
                return null;
            }
            Enumeration<String> enumeration = this.keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            if (n > 0) {
                stringArray = new String[n];
                n = 0;
                enumeration = this.keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    stringArray[n] = new String(enumeration.nextElement());
                    ++n;
                }
            }
            return stringArray;
        }
        catch (KeyStoreException keyStoreException) {
            this.newWarning = true;
            this.warnings.addElement(rb.getString("Warning: Unable to retrieve public key from keystore: ") + this.keyStoreName);
            this.warnings.addElement(rb.getString("\tdue to unexpected exception: ") + keyStoreException);
            return null;
        }
    }

    String[] parseSigners(String string) {
        String[] stringArray = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 >= 0) {
            n3 = string.indexOf(44, n2);
            if (n3 < 0) continue;
            ++n;
            n2 = n3 + 1;
        }
        stringArray = new String[n];
        n3 = 0;
        n2 = 0;
        while (n3 >= 0) {
            n3 = string.indexOf(44, n2);
            if (n3 >= 0) {
                stringArray[n4] = string.substring(n2, n3).trim();
                ++n4;
                n2 = n3 + 1;
                continue;
            }
            stringArray[n4] = string.substring(n2).trim();
        }
        return stringArray;
    }

    void verifyPrincipal(PolicyParser.PrincipalEntry principalEntry) throws ClassNotFoundException, InstantiationException {
        Class<?> clazz;
        String string = principalEntry.getPrincipalClass();
        if (string.equals("WILDCARD_PRINCIPAL_CLASS") || string.equals("PolicyParser.REPLACE_NAME")) {
            return;
        }
        Class<?> clazz2 = Class.forName("java.security.Principal");
        if (!clazz2.isAssignableFrom(clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader()))) {
            throw new InstantiationException(rb.getString("Illegal Principal Type"));
        }
    }

    void verifyPermission(PolicyParser.PermissionEntry permissionEntry) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String string = permissionEntry.permission;
        String string2 = permissionEntry.name;
        String string3 = permissionEntry.action;
        Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        Constructor<?> constructor = null;
        Vector<String> vector = new Vector<String>(2);
        if (string2 != null) {
            vector.add(string2);
        }
        if (string3 != null) {
            vector.add(string3);
        }
        switch (vector.size()) {
            case 0: {
                try {
                    constructor = clazz.getConstructor(NOPARAMS);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    vector.add(null);
                }
            }
            case 1: {
                try {
                    constructor = clazz.getConstructor(ONEPARAMS);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    vector.add(null);
                }
            }
            case 2: {
                constructor = clazz.getConstructor(TWOPARAMS);
            }
        }
        Object[] objectArray = vector.toArray();
        Permission permission = (Permission)constructor.newInstance(objectArray);
    }

    static void parseArgs(String[] stringArray) {
        int n = 0;
        n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n];
            if (collator.compare(string, "-file") == 0) {
                if (++n == stringArray.length) {
                    PolicyTool.usage();
                }
                policyFileName = stringArray[n];
            } else {
                System.err.println(rb.getString("Illegal option: ") + string);
                PolicyTool.usage();
            }
            ++n;
        }
    }

    static void usage() {
        System.out.println(rb.getString("Usage: policytool [options]"));
        System.out.println();
        System.out.println(rb.getString("  [-file <file>]    policy file location"));
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        PolicyTool.parseArgs(stringArray);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        ToolWindow toolWindow = new ToolWindow(new PolicyTool());
        toolWindow.displayToolWindow();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        collator.setStrength(0);
        TWOPARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyTool.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PolicyTool.class$("java.lang.String")) : class$java$lang$String};
        ONEPARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyTool.class$("java.lang.String")) : class$java$lang$String};
        NOPARAMS = new Class[0];
        policyFileName = null;
    }
}

