/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import sun.security.provider.PolicyParser;
import sun.security.tools.AddEntryDoneButtonListener;
import sun.security.tools.AddPermButtonListener;
import sun.security.tools.AddPrinButtonListener;
import sun.security.tools.BadParameterException;
import sun.security.tools.CancelButtonListener;
import sun.security.tools.ChangeKeyStoreOKButtonListener;
import sun.security.tools.ChildWindowListener;
import sun.security.tools.ConfirmRemovePolicyEntryOKButtonListener;
import sun.security.tools.EditPermButtonListener;
import sun.security.tools.EditPolicyPermOKButtonListener;
import sun.security.tools.EditPolicyPrinOKButtonListener;
import sun.security.tools.EditPrinButtonListener;
import sun.security.tools.FocusTextField;
import sun.security.tools.LegacyList;
import sun.security.tools.NewPolicyPermOKButtonListener;
import sun.security.tools.NewPolicyPrinOKButtonListener;
import sun.security.tools.OverWriteFileOKButtonListener;
import sun.security.tools.PermissionActionsMenuListener;
import sun.security.tools.PermissionMenuListener;
import sun.security.tools.PermissionNameMenuListener;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyListListener;
import sun.security.tools.PolicyTool;
import sun.security.tools.PrincipalTypeMenuListener;
import sun.security.tools.RemovePermButtonListener;
import sun.security.tools.RemovePrinButtonListener;
import sun.security.tools.ToolWindow;
import sun.security.tools.UserSaveCancelButtonListener;
import sun.security.tools.UserSaveNoButtonListener;
import sun.security.tools.UserSaveYesButtonListener;

class ToolDialog
extends JDialog {
    private static final long serialVersionUID = -372244357011301190L;
    public static final int NOACTION = 0;
    public static final int QUIT = 1;
    public static final int NEW = 2;
    public static final int OPEN = 3;
    public static final String ALL_PERM_CLASS = "java.security.AllPermission";
    public static final String AUDIO_PERM_CLASS = "javax.sound.sampled.AudioPermission";
    public static final String AUTH_PERM_CLASS = "javax.security.auth.AuthPermission";
    public static final String AWT_PERM_CLASS = "java.awt.AWTPermission";
    public static final String DELEGATION_PERM_CLASS = "javax.security.auth.kerberos.DelegationPermission";
    public static final String FILE_PERM_CLASS = "java.io.FilePermission";
    public static final String LOG_PERM_CLASS = "java.util.logging.LoggingPermission";
    public static final String NET_PERM_CLASS = "java.net.NetPermission";
    public static final String PRIVCRED_PERM_CLASS = "javax.security.auth.PrivateCredentialPermission";
    public static final String PROP_PERM_CLASS = "java.util.PropertyPermission";
    public static final String REFLECT_PERM_CLASS = "java.lang.reflect.ReflectPermission";
    public static final String RUNTIME_PERM_CLASS = "java.lang.RuntimePermission";
    public static final String SECURITY_PERM_CLASS = "java.security.SecurityPermission";
    public static final String SERIAL_PERM_CLASS = "java.io.SerializablePermission";
    public static final String SERVICE_PERM_CLASS = "javax.security.auth.kerberos.ServicePermission";
    public static final String SOCK_PERM_CLASS = "java.net.SocketPermission";
    public static final String SQL_PERM_CLASS = "java.sql.SQLPermission";
    public static final String SSL_PERM_CLASS = "javax.net.ssl.SSLPermission";
    public static final String[] PRIN_CLASSES = new String[]{"javax.security.auth.kerberos.KerberosPrincipal", "javax.security.auth.x500.X500Principal", "com.ibm.security.auth.UsernamePrincipal", "com.ibm.security.auth.UserIDPrincipal", "com.ibm.security.auth.GroupIDPrincipal", "com.ibm.security.auth.PrimaryGroupIDPrincipal", "com.ibm.security.auth.DomainPrincipal", "com.ibm.security.auth.ServerPrincipal", "com.ibm.security.auth.WkstationPrincipal", "com.ibm.security.auth.DomainIDPrincipal", "com.ibm.security.auth.NTDomainPrincipal", "com.ibm.security.auth.NTSidDomainPrincipal", "com.ibm.security.auth.NTSidGroupPrincipal", "com.ibm.security.auth.NTSidPrimaryGroupPrincipal", "com.ibm.security.auth.NTSidUserPrincipal", "com.ibm.security.auth.NTUserPrincipal", "com.ibm.security.auth.AIXNumericGroupPrincipal", "com.ibm.security.auth.AIXNumericUserPrincipal", "com.ibm.security.auth.AIXPrincipal", "com.ibm.security.auth.LinuxNumericGroupPrincipal", "com.ibm.security.auth.LinuxNumericUserPrincipal", "com.ibm.security.auth.LinuxPrincipal", "com.ibm.security.auth.OS390UserPrincipal"};
    public static final String PERM = PolicyTool.rb.getString("Permission:                                                       ");
    public static final String ALL_PERM = "AllPermission";
    public static final String AUDIO_PERM = "AudioPermission";
    public static final String AUTH_PERM = "AuthPermission";
    public static final String AWT_PERM = "AWTPermission";
    public static final String DELEGATION_PERM = "DelegationPermission";
    public static final String FILE_PERM = "FilePermission";
    public static final String LOG_PERM = "LoggingPermission";
    public static final String NET_PERM = "NetPermission";
    public static final String PRIVCRED_PERM = "PrivateCredentialPermission";
    public static final String PROPERTY_PERM = "PropertyPermission";
    public static final String REFLECT_PERM = "ReflectPermission";
    public static final String RUNTIME_PERM = "RuntimePermission";
    public static final String SECURITY_PERM = "SecurityPermission";
    public static final String SERIAL_PERM = "SerializablePermission";
    public static final String SERVICE_PERM = "ServicePermission";
    public static final String SOCKET_PERM = "SocketPermission";
    public static final String SQL_PERM = "SQLPermission";
    public static final String SSL_PERM = "SSLPermission";
    public static final String PRIN_TYPE = PolicyTool.rb.getString("Principal Type:");
    public static final String PRIN_NAME = PolicyTool.rb.getString("Principal Name:");
    public static final String[] ALL_PRIN_NAMES;
    public static final String PERM_NAME;
    public static final String[] AUDIO_TARGETS;
    public static final String[] AUTH_TARGETS;
    public static final String[] AWT_TARGETS;
    public static final String[] FILE_TARGETS;
    public static final String[] LOG_TARGETS;
    public static final String[] NET_TARGETS;
    public static final String[] REF_TARGETS;
    public static final String[] RUN_TARGETS;
    public static final String[] SEC_TARGETS;
    public static final String[] SER_TARGETS;
    public static final String[] SQL_TARGETS;
    public static final String[] SSL_TARGETS;
    public static final String PERM_ACTIONS;
    public static final String FILE_PERM_READ = "read";
    public static final String FILE_PERM_WRITE = "write";
    public static final String FILE_PERM_DELETE = "delete";
    public static final String FILE_PERM_EXECUTE = "execute";
    public static final String FILE_PERM_ALL = "read, write, delete, execute";
    public static final String PRIVCRED_PERM_READ = "read";
    public static final String SERVICE_PERM_INIT = "initiate";
    public static final String SERVICE_PERM_ACCEPT = "accept";
    public static final String SERVICE_PERM_ALL = "initiate, accept";
    public static final String PROP_PERM_READ = "read";
    public static final String PROP_PERM_WRITE = "write";
    public static final String PROP_PERM_ALL = "read, write";
    public static final String SOCKET_PERM_ACCEPT = "accept";
    public static final String SOCKET_PERM_CONNECT = "connect";
    public static final String SOCKET_PERM_LISTEN = "listen";
    public static final String SOCKET_PERM_RESOLVE = "resolve";
    public static final String SOCKET_PERM_ALL = "accept, connect, listen, resolve";
    public static final int OW_LABEL = 0;
    public static final int OW_OK_BUTTON = 1;
    public static final int OW_CANCEL_BUTTON = 2;
    public static final int PE_CODEBASE_LABEL = 0;
    public static final int PE_CODEBASE_TEXTFIELD = 1;
    public static final int PE_SIGNEDBY_LABEL = 2;
    public static final int PE_SIGNEDBY_TEXTFIELD = 3;
    public static final int PE_PANEL0 = 4;
    public static final int PE_ADD_PRIN_BUTTON = 0;
    public static final int PE_EDIT_PRIN_BUTTON = 1;
    public static final int PE_REMOVE_PRIN_BUTTON = 2;
    public static final int PE_PRIN_LABEL = 5;
    public static final int PE_PRIN_LIST = 6;
    public static final int PE_PANEL1 = 7;
    public static final int PE_ADD_PERM_BUTTON = 0;
    public static final int PE_EDIT_PERM_BUTTON = 1;
    public static final int PE_REMOVE_PERM_BUTTON = 2;
    public static final int PE_PERM_LIST = 8;
    public static final int PE_PANEL2 = 9;
    public static final int PE_CANCEL_BUTTON = 0;
    public static final int PE_DONE_BUTTON = 1;
    public static final int PRD_DESC_LABEL = 0;
    public static final int PRD_PRIN_CHOICE = 1;
    public static final int PRD_PRIN_TEXTFIELD = 2;
    public static final int PRD_NAME_LABEL = 3;
    public static final int PRD_NAME_TEXTFIELD = 4;
    public static final int PRD_CANCEL_BUTTON = 5;
    public static final int PRD_OK_BUTTON = 6;
    public static final int PD_DESC_LABEL = 0;
    public static final int PD_PERM_CHOICE = 1;
    public static final int PD_PERM_TEXTFIELD = 2;
    public static final int PD_NAME_CHOICE = 3;
    public static final int PD_NAME_TEXTFIELD = 4;
    public static final int PD_ACTIONS_CHOICE = 5;
    public static final int PD_ACTIONS_TEXTFIELD = 6;
    public static final int PD_SIGNEDBY_LABEL = 7;
    public static final int PD_SIGNEDBY_TEXTFIELD = 8;
    public static final int PD_CANCEL_BUTTON = 9;
    public static final int PD_OK_BUTTON = 10;
    public static final int CHANGE_KEYSTORE = 0;
    public static final int KSD_NAME_LABEL = 0;
    public static final int KSD_NAME_TEXTFIELD = 1;
    public static final int KSD_TYPE_LABEL = 2;
    public static final int KSD_TYPE_TEXTFIELD = 3;
    public static final int KSD_CANCEL_BUTTON = 4;
    public static final int KSD_OK_BUTTON = 5;
    public static final int USC_LABEL = 0;
    public static final int USC_PANEL = 1;
    public static final int USC_YES_BUTTON = 0;
    public static final int USC_NO_BUTTON = 1;
    public static final int USC_CANCEL_BUTTON = 2;
    public static final int CRPE_LABEL1 = 0;
    public static final int CRPE_LABEL2 = 1;
    private static final int PERMISSION = 0;
    private static final int PERMISSION_NAME = 1;
    private static final int PERMISSION_ACTIONS = 2;
    private static final int PERMISSION_SIGNEDBY = 3;
    private static final int PRINCIPAL_TYPE = 4;
    private static final int PRINCIPAL_NAME = 5;
    PolicyTool tool;
    ToolWindow tw;

    ToolDialog(String string, PolicyTool policyTool, ToolWindow toolWindow, JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.init(string, policyTool, toolWindow);
    }

    ToolDialog(String string, PolicyTool policyTool, ToolWindow toolWindow, JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.init(string, policyTool, toolWindow);
    }

    private void init(String string, PolicyTool policyTool, ToolWindow toolWindow) {
        this.setTitle(string);
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tool = policyTool;
        this.tw = toolWindow;
        this.addWindowListener(new ChildWindowListener(this));
    }

    void displayOverWriteFileDialog(String string, int n) {
        Point point = this.tw.getLocationOnScreen();
        this.setLocation(point.x + 75, point.y + 100);
        this.getContentPane().setLayout(new GridBagLayout());
        MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("OK to overwrite existing file filename?"));
        Object[] objectArray = new Object[]{string};
        JLabel jLabel = new JLabel(messageFormat.format(objectArray));
        this.tw.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.TOP_PADDING);
        JButton jButton = new JButton(PolicyTool.rb.getString("OK"));
        jButton.setMnemonic((Integer)PolicyTool.rb.getObject("OK Mnemonic"));
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new OverWriteFileOKButtonListener(this.tool, this.tw, this, string, n));
        this.tw.addNewComponent(this.getContentPane(), jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        jButton.getAccessibleContext().setAccessibleName(jLabel.getText() + ". " + jButton.getText());
        jButton = new JButton(PolicyTool.rb.getString("Cancel"));
        jButton.setMnemonic((Integer)PolicyTool.rb.getObject("Cancel Mnemonic"));
        jButton.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this.getContentPane(), jButton, 2, 1, 1, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        this.getRootPane().registerKeyboardAction(new CancelButtonListener(this), KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setVisible(true);
    }

    void displayPolicyEntryDialog(boolean bl) {
        Object object;
        Serializable serializable;
        JComponent jComponent;
        int n = 0;
        PolicyEntry[] policyEntryArray = null;
        LegacyList legacyList = new LegacyList();
        legacyList.addActionListener(new EditPrinButtonListener(this.tool, this.tw, this, bl));
        LegacyList legacyList2 = new LegacyList();
        legacyList2.addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl));
        Point point = this.tw.getLocationOnScreen();
        this.setLocation(point.x + 75, point.y + 100);
        this.getContentPane().setLayout(new GridBagLayout());
        if (bl) {
            Object object2;
            Object object3;
            policyEntryArray = this.tool.getEntry();
            jComponent = (LegacyList)this.tw.getContentPane().getComponent(5);
            n = ((LegacyList)jComponent).getSelectedIndex();
            serializable = policyEntryArray[n].getGrantEntry().principals;
            int n2 = 0;
            while (n2 < ((LinkedList)serializable).size()) {
                object = null;
                PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)((LinkedList)serializable).get(n2);
                object3 = new StringWriter();
                object2 = new PrintWriter((Writer)object3);
                principalEntry.write((PrintWriter)object2);
                object = ((StringWriter)object3).toString();
                legacyList.add((String)object);
                ++n2;
            }
            object = policyEntryArray[n].getGrantEntry().permissionEntries;
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                object3 = null;
                object2 = (PolicyParser.PermissionEntry)((Vector)object).elementAt(n3);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                ((PolicyParser.PermissionEntry)object2).write(printWriter);
                if (File.separatorChar == '\\' && ((PolicyParser.PermissionEntry)object2).permission.equals(FILE_PERM_CLASS)) {
                    ((PolicyParser.PermissionEntry)object2).name = this.addSingleBackSlash(((PolicyParser.PermissionEntry)object2).name);
                    object3 = this.addSingleBackSlash(stringWriter.toString());
                } else {
                    object3 = stringWriter.toString();
                }
                object3 = ((String)object3).substring(0, ((String)object3).indexOf(";") + 1);
                legacyList2.add((String)object3);
                ++n3;
            }
        }
        jComponent = new JLabel(PolicyTool.rb.getString("CodeBase:"));
        this.tw.addNewComponent(this.getContentPane(), jComponent, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        serializable = bl ? new FocusTextField(policyEntryArray[n].getGrantEntry().codeBase, 40) : new FocusTextField(40);
        this.tw.addNewComponent(this.getContentPane(), (Component)serializable, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
        ((JLabel)jComponent).setLabelFor((Component)serializable);
        jComponent = new JLabel(PolicyTool.rb.getString("SignedBy:"));
        this.tw.addNewComponent(this.getContentPane(), jComponent, 2, 0, 1, 1, 1, 0.0, 0.0, 1);
        serializable = bl ? new FocusTextField(policyEntryArray[n].getGrantEntry().signedBy, 40) : new FocusTextField(40);
        this.tw.addNewComponent(this.getContentPane(), (Component)serializable, 3, 1, 1, 1, 1, 0.0, 0.0, 1);
        ((JLabel)jComponent).setLabelFor((Component)serializable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        object = new JButton(PolicyTool.rb.getString("Add Principal"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription("click to " + PolicyTool.rb.getString("Add Principal"));
        ((AbstractButton)object).addActionListener(new AddPrinButtonListener(this.tool, this.tw, this, bl));
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("Add Principal Mnemonic"));
        this.tw.addNewComponent(jPanel, (Component)object, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        object = new JButton(PolicyTool.rb.getString("Edit Principal"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription("click to " + PolicyTool.rb.getString("Edit Principal"));
        ((AbstractButton)object).addActionListener(new EditPrinButtonListener(this.tool, this.tw, this, bl));
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("Edit Principal Mnemonic"));
        this.tw.addNewComponent(jPanel, (Component)object, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        object = new JButton(PolicyTool.rb.getString("Remove Principal"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription("click to " + PolicyTool.rb.getString("Remove Principal"));
        ((AbstractButton)object).addActionListener(new RemovePrinButtonListener(this.tool, this.tw, this, bl));
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("Remove Principal Mnemonic"));
        this.tw.addNewComponent(jPanel, (Component)object, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this.getContentPane(), jPanel, 4, 1, 2, 1, 1, 0.0, 0.0, 2);
        jComponent = new JLabel(PolicyTool.rb.getString("Principals:"));
        this.tw.addNewComponent(this.getContentPane(), jComponent, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        this.tw.addNewComponent(this.getContentPane(), legacyList, 6, 1, 3, 3, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        ((JLabel)jComponent).setLabelFor(legacyList.getViewport().getView());
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        object = new JButton(PolicyTool.rb.getString("  Add Permission"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription("click to" + PolicyTool.rb.getString("  Add Permission"));
        ((AbstractButton)object).addActionListener(new AddPermButtonListener(this.tool, this.tw, this, bl));
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("Add Permission Mnemonic"));
        this.tw.addNewComponent(jPanel, (Component)object, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        object = new JButton(PolicyTool.rb.getString("  Edit Permission"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription("click to" + PolicyTool.rb.getString("  Edit Permission"));
        ((AbstractButton)object).addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl));
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("Edit Permission Mnemonic"));
        this.tw.addNewComponent(jPanel, (Component)object, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        object = new JButton(PolicyTool.rb.getString("Remove Permission"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription("click to " + PolicyTool.rb.getString("Remove Permission"));
        ((AbstractButton)object).addActionListener(new RemovePermButtonListener(this.tool, this.tw, this, bl));
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("Remove Permission Mnemonic"));
        this.tw.addNewComponent(jPanel, (Component)object, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this.getContentPane(), jPanel, 7, 0, 4, 2, 1, 0.0, 0.0, 2, ToolWindow.LITE_BOTTOM_PADDING);
        this.tw.addNewComponent(this.getContentPane(), legacyList2, 8, 0, 5, 3, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        legacyList2.getViewport().getView().getAccessibleContext().setAccessibleName("Permissions list");
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        object = new JButton(PolicyTool.rb.getString("Cancel"));
        this.getRootPane().registerKeyboardAction(new CancelButtonListener(this), KeyStroke.getKeyStroke(27, 0), 2);
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("Cancel Mnemonic"));
        ((AbstractButton)object).addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(jPanel, (Component)object, 0, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        object = new JButton(PolicyTool.rb.getString("Done"));
        this.getRootPane().setDefaultButton((JButton)object);
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("Done Mnemonic"));
        ((AbstractButton)object).addActionListener(new AddEntryDoneButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent(jPanel, (Component)object, 1, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this.getContentPane(), jPanel, 9, 0, 6, 2, 1, 0.0, 0.0, 3);
        this.pack();
        this.setVisible(true);
    }

    PolicyEntry getPolicyEntryFromDialog() throws BadParameterException, MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, Exception {
        Object object;
        Object object2;
        FocusTextField focusTextField = (FocusTextField)this.getContentPane().getComponent(1);
        String string = null;
        if (!focusTextField.getText().trim().equals("")) {
            string = new String(focusTextField.getText().trim());
        }
        focusTextField = (FocusTextField)this.getContentPane().getComponent(3);
        String string2 = null;
        if (!focusTextField.getText().trim().equals("")) {
            string2 = new String(focusTextField.getText().trim());
        }
        PolicyParser.GrantEntry grantEntry = new PolicyParser.GrantEntry(string2, string);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LegacyList legacyList = (LegacyList)this.getContentPane().getComponent(6);
        String[] stringArray = legacyList.getItems();
        int n = 0;
        while (n < stringArray.length) {
            object2 = new PolicyParser.PrincipalEntry(this.parsePrincipalString(stringArray[n], 4), this.parsePrincipalString(stringArray[n], 5));
            linkedList.add(object2);
            ++n;
        }
        grantEntry.principals = linkedList;
        object2 = new Vector();
        LegacyList legacyList2 = (LegacyList)this.getContentPane().getComponent(8);
        String[] stringArray2 = legacyList2.getItems();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            object = new PolicyParser.PermissionEntry(this.parsePermissionString(stringArray2[n2], 0), this.parsePermissionString(stringArray2[n2], 1), this.parsePermissionString(stringArray2[n2], 2));
            ((PolicyParser.PermissionEntry)object).signedBy = this.parsePermissionString(stringArray2[n2], 3);
            ((Vector)object2).addElement(object);
            ++n2;
        }
        grantEntry.permissionEntries = object2;
        object = new PolicyEntry(this.tool, grantEntry);
        return object;
    }

    void keyStoreDialog(int n) {
        Point point = this.tw.getLocationOnScreen();
        this.setLocation(point.x + 25, point.y + 100);
        this.getContentPane().setLayout(new GridBagLayout());
        if (n == 0) {
            JLabel jLabel = new JLabel(PolicyTool.rb.getString("New KeyStore URL:"));
            this.tw.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            FocusTextField focusTextField = new FocusTextField(this.tool.getKeyStoreName(), 30);
            this.tw.addNewComponent(this.getContentPane(), focusTextField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            jLabel.setLabelFor(focusTextField);
            jLabel = new JLabel(PolicyTool.rb.getString("New KeyStore Type:"));
            this.tw.addNewComponent(this.getContentPane(), jLabel, 2, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            focusTextField = new FocusTextField(this.tool.getKeyStoreType(), 30);
            this.tw.addNewComponent(this.getContentPane(), focusTextField, 3, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            jLabel.setLabelFor(focusTextField);
            JButton jButton = new JButton(PolicyTool.rb.getString("Cancel"));
            this.getRootPane().registerKeyboardAction(new CancelButtonListener(this), KeyStroke.getKeyStroke(27, 0), 2);
            jButton.setMnemonic((Integer)PolicyTool.rb.getObject("Cancel Mnemonic"));
            jButton.addActionListener(new CancelButtonListener(this));
            this.tw.addNewComponent(this.getContentPane(), jButton, 4, 1, 2, 1, 1, 0.0, 0.0, 3);
            JButton jButton2 = new JButton(PolicyTool.rb.getString("OK"));
            this.getRootPane().setDefaultButton(jButton2);
            jButton2.setMnemonic((Integer)PolicyTool.rb.getObject("OK Mnemonic"));
            jButton2.addActionListener(new ChangeKeyStoreOKButtonListener(this.tool, this.tw, this));
            this.tw.addNewComponent(this.getContentPane(), jButton2, 5, 0, 2, 1, 1, 0.0, 0.0, 3);
        }
        this.pack();
        this.setVisible(true);
    }

    void displayPrincipalDialog(boolean bl, boolean bl2) {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        PolicyParser.PrincipalEntry principalEntry = null;
        LegacyList legacyList = (LegacyList)this.getContentPane().getComponent(6);
        int n = legacyList.getSelectedIndex();
        if (!bl && bl2) {
            object3 = this.parsePrincipalString(legacyList.getItem(n), 4);
            object2 = this.parsePrincipalString(legacyList.getItem(n), 5);
            principalEntry = new PolicyParser.PrincipalEntry((String)object3, (String)object2);
        } else if (bl && bl2) {
            object3 = (LegacyList)this.tw.getContentPane().getComponent(5);
            int n2 = ((LegacyList)object3).getSelectedIndex();
            object = this.tool.getEntry();
            stringArray = object[n2].getGrantEntry().principals;
            principalEntry = (PolicyParser.PrincipalEntry)stringArray.get(n);
        }
        object3 = new ToolDialog(PolicyTool.rb.getString("Principals"), this.tool, this.tw, this, true);
        ((Window)object3).addWindowListener(new ChildWindowListener((ToolDialog)object3));
        object2 = this.getLocationOnScreen();
        ((Window)object3).setLocation(((Point)object2).x + 50, ((Point)object2).y + 100);
        ((JDialog)object3).getContentPane().setLayout(new GridBagLayout());
        ((Dialog)object3).setResizable(false);
        object = bl2 ? new JLabel(PolicyTool.rb.getString("  Edit Principal:")) : new JLabel(PolicyTool.rb.getString("  Add New Principal:"));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), (Component)object, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        stringArray = new String[ALL_PRIN_NAMES.length + 1];
        stringArray[0] = PRIN_TYPE;
        System.arraycopy(ALL_PRIN_NAMES, 0, stringArray, 1, ALL_PRIN_NAMES.length);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        jComboBox.getAccessibleContext().setAccessibleDescription("set " + PRIN_TYPE);
        ((JLabel)object).setLabelFor(jComboBox);
        if (bl2) {
            this.setPrincipals(principalEntry.getPrincipalClass(), jComboBox);
        }
        jComboBox.addItemListener(new PrincipalTypeMenuListener((ToolDialog)object3));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), jComboBox, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        FocusTextField focusTextField = bl2 ? new FocusTextField(principalEntry.getDisplayClass(), 30) : new FocusTextField(30);
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), focusTextField, 2, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        object = new JLabel(PRIN_NAME);
        focusTextField = bl2 ? new FocusTextField(principalEntry.getDisplayName(), 30) : new FocusTextField(30);
        ((JLabel)object).setLabelFor(focusTextField);
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), (Component)object, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), focusTextField, 4, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        JButton jButton = new JButton(PolicyTool.rb.getString("Cancel"));
        jButton.setMnemonic((Integer)PolicyTool.rb.getObject("Cancel Mnemonic"));
        jButton.addActionListener(new CancelButtonListener((ToolDialog)object3));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), jButton, 5, 1, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        ((JDialog)object3).getRootPane().registerKeyboardAction(new CancelButtonListener((ToolDialog)object3), KeyStroke.getKeyStroke(27, 0), 2);
        JButton jButton2 = new JButton(PolicyTool.rb.getString("OK"));
        jButton2.setMnemonic((Integer)PolicyTool.rb.getObject("OK Mnemonic"));
        ((JDialog)object3).getRootPane().setDefaultButton(jButton2);
        if (bl) {
            jButton2.addActionListener(new EditPolicyPrinOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl2));
        } else {
            jButton2.addActionListener(new NewPolicyPrinOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl2));
        }
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), jButton2, 6, 0, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        ((Window)object3).pack();
        ((Dialog)object3).setVisible(true);
    }

    void displayPermissionDialog(boolean bl, boolean bl2) {
        FocusTextField focusTextField;
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        PolicyParser.PermissionEntry permissionEntry = null;
        LegacyList legacyList = (LegacyList)this.getContentPane().getComponent(8);
        int n = legacyList.getSelectedIndex();
        if (!bl && bl2) {
            object3 = this.parsePermissionString(legacyList.getItem(n), 0);
            object2 = this.parsePermissionString(legacyList.getItem(n), 1);
            object = this.parsePermissionString(legacyList.getItem(n), 2);
            permissionEntry = new PolicyParser.PermissionEntry((String)object3, (String)object2, (String)object);
            permissionEntry.signedBy = this.parsePermissionString(legacyList.getItem(n), 3);
        } else if (bl && bl2) {
            object3 = (LegacyList)this.tw.getContentPane().getComponent(5);
            int n2 = ((LegacyList)object3).getSelectedIndex();
            object = this.tool.getEntry();
            stringArray = object[n2].getGrantEntry().permissionEntries;
            permissionEntry = (PolicyParser.PermissionEntry)stringArray.elementAt(n);
        }
        object3 = new ToolDialog(PolicyTool.rb.getString("Permissions"), this.tool, this.tw, this, true);
        ((Window)object3).addWindowListener(new ChildWindowListener((ToolDialog)object3));
        object2 = this.getLocationOnScreen();
        ((Window)object3).setLocation(((Point)object2).x + 50, ((Point)object2).y + 100);
        ((JDialog)object3).getContentPane().setLayout(new GridBagLayout());
        object = bl2 ? new JLabel(PolicyTool.rb.getString("  Edit Permission:")) : new JLabel(PolicyTool.rb.getString("  Add New Permission:"));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), (Component)object, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        stringArray = new String[]{PERM, ALL_PERM, AUTH_PERM, AWT_PERM, DELEGATION_PERM, FILE_PERM, LOG_PERM, NET_PERM, PRIVCRED_PERM, PROPERTY_PERM, REFLECT_PERM, RUNTIME_PERM, SECURITY_PERM, SERIAL_PERM, SERVICE_PERM, SOCKET_PERM, SQL_PERM, SSL_PERM};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        ((JLabel)object).setLabelFor(jComboBox);
        jComboBox.getAccessibleContext().setAccessibleDescription("set " + PERM);
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), jComboBox, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        FocusTextField focusTextField2 = focusTextField = bl2 ? new FocusTextField(permissionEntry.permission, 25) : new FocusTextField(25);
        if (bl2) {
            this.setPermissions(permissionEntry.permission, jComboBox);
        }
        jComboBox.addActionListener(new PermissionMenuListener((ToolDialog)object3));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), focusTextField, 2, 1, 1, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_PADDING);
        String[] stringArray2 = new String[]{PERM_NAME};
        jComboBox = new JComboBox<String>(stringArray2);
        jComboBox.getAccessibleContext().setAccessibleName(PERM_NAME);
        jComboBox.getAccessibleContext().setAccessibleDescription("set " + PERM_NAME);
        FocusTextField focusTextField3 = focusTextField = bl2 ? new FocusTextField(permissionEntry.name, 25) : new FocusTextField(25);
        if (bl2) {
            this.setPermissionNames(permissionEntry.permission, jComboBox, focusTextField);
        }
        jComboBox.addItemListener(new PermissionNameMenuListener((ToolDialog)object3));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), jComboBox, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), focusTextField, 4, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        String[] stringArray3 = new String[]{PERM_ACTIONS};
        jComboBox = new JComboBox<String>(stringArray3);
        jComboBox.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        jComboBox.getAccessibleContext().setAccessibleDescription("set " + PERM_ACTIONS);
        FocusTextField focusTextField4 = focusTextField = bl2 ? new FocusTextField(permissionEntry.action, 25) : new FocusTextField(25);
        if (bl2) {
            this.setPermissionActions(permissionEntry.permission, jComboBox, focusTextField);
        }
        jComboBox.addItemListener(new PermissionActionsMenuListener((ToolDialog)object3));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), jComboBox, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), focusTextField, 6, 1, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        object = new JLabel(PolicyTool.rb.getString("Signed By:"));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), (Component)object, 7, 0, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        focusTextField = bl2 ? new FocusTextField(permissionEntry.signedBy, 25) : new FocusTextField(25);
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), focusTextField, 8, 1, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        ((JLabel)object).setLabelFor(focusTextField);
        JButton jButton = new JButton(PolicyTool.rb.getString("Cancel"));
        jButton.setMnemonic((Integer)PolicyTool.rb.getObject("Cancel Mnemonic"));
        jButton.addActionListener(new CancelButtonListener((ToolDialog)object3));
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), jButton, 9, 1, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        ((JDialog)object3).getRootPane().registerKeyboardAction(new CancelButtonListener((ToolDialog)object3), KeyStroke.getKeyStroke(27, 0), 2);
        JButton jButton2 = new JButton(PolicyTool.rb.getString("OK"));
        jButton2.setMnemonic((Integer)PolicyTool.rb.getObject("OK Mnemonic"));
        ((JDialog)object3).getRootPane().setDefaultButton(jButton2);
        if (bl) {
            jButton2.addActionListener(new EditPolicyPermOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl2));
        } else {
            jButton2.addActionListener(new NewPolicyPermOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl2));
        }
        this.tw.addNewComponent(((JDialog)object3).getContentPane(), jButton2, 10, 0, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        ((Window)object3).pack();
        ((Dialog)object3).setVisible(true);
    }

    PolicyParser.PrincipalEntry getPrinFromDialog() {
        FocusTextField focusTextField = (FocusTextField)this.getContentPane().getComponent(2);
        String string = new String(focusTextField.getText().trim());
        focusTextField = (FocusTextField)this.getContentPane().getComponent(4);
        String string2 = new String(focusTextField.getText().trim());
        if (string.equals("*")) {
            string = "WILDCARD_PRINCIPAL_CLASS";
        }
        if (string2.equals("*")) {
            string2 = "WILDCARD_PRINCIPAL_NAME";
        }
        PolicyParser.PrincipalEntry principalEntry = null;
        if (string.equals("WILDCARD_PRINCIPAL_CLASS") && !string2.equals("WILDCARD_PRINCIPAL_NAME")) {
            this.tw.displayErrorDialog(this, PolicyTool.rb.getString("Cannot Specify Principal with a Wildcard Class without a Wildcard Name"));
        } else if (string.equals("")) {
            string = "PolicyParser.REPLACE_NAME";
            MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Warning: Principal name 'pname' specified without a Principal class."));
            Object[] objectArray = new Object[]{string2, "javax.security.auth.x500.X500Principal"};
            this.tool.warnings.addElement(messageFormat.format(objectArray));
            messageFormat = new MessageFormat(PolicyTool.rb.getString("'pname' will be interpreted as a key store alias. View Warning Log for details."));
            Object[] objectArray2 = new Object[]{string2};
            this.tw.displayStatusDialog(this, messageFormat.format(objectArray2));
        } else if (string2.equals("")) {
            this.tw.displayErrorDialog(this, PolicyTool.rb.getString("Cannot Specify Principal without a Name"));
        } else {
            principalEntry = new PolicyParser.PrincipalEntry(string, string2);
        }
        return principalEntry;
    }

    PolicyParser.PermissionEntry getPermFromDialog() throws BadParameterException {
        FocusTextField focusTextField = (FocusTextField)this.getContentPane().getComponent(2);
        String string = new String(focusTextField.getText().trim());
        focusTextField = (FocusTextField)this.getContentPane().getComponent(4);
        String string2 = null;
        if (!focusTextField.getText().trim().equals("")) {
            string2 = new String(focusTextField.getText().trim());
        }
        if (string.equals("") || !string.equals(ALL_PERM_CLASS) && string2 == null) {
            throw new BadParameterException(PolicyTool.rb.getString("Permission and Target Name must have a value"));
        }
        focusTextField = (FocusTextField)this.getContentPane().getComponent(6);
        String string3 = null;
        if (!focusTextField.getText().trim().equals("")) {
            string3 = new String(focusTextField.getText().trim());
        }
        focusTextField = (FocusTextField)this.getContentPane().getComponent(8);
        String string4 = null;
        if (!focusTextField.getText().trim().equals("")) {
            string4 = new String(focusTextField.getText().trim());
        }
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(string, string2, string3);
        permissionEntry.signedBy = string4;
        if (string4 != null) {
            String[] stringArray = this.tool.parseSigners(permissionEntry.signedBy);
            int n = 0;
            while (n < stringArray.length) {
                PublicKey publicKey = this.tool.getPublicKeyAlias(stringArray[n]);
                if (publicKey == null) {
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Warning: A public key for alias 'signers[i]' does not exist."));
                    Object[] objectArray = new Object[]{stringArray[n]};
                    this.tool.warnings.addElement(messageFormat.format(objectArray));
                    this.tw.displayStatusDialog(this, messageFormat.format(objectArray));
                }
                ++n;
            }
        }
        return permissionEntry;
    }

    void displayConfirmRemovePolicyEntry() {
        Object object;
        Object object2;
        LegacyList legacyList = (LegacyList)this.tw.getContentPane().getComponent(5);
        int n = legacyList.getSelectedIndex();
        PolicyEntry[] policyEntryArray = this.tool.getEntry();
        Point point = this.tw.getLocationOnScreen();
        this.setLocation(point.x + 25, point.y + 100);
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(PolicyTool.rb.getString("Remove this Policy Entry?"));
        this.tw.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        String string = jLabel.getText();
        jLabel = new JLabel("Grant " + policyEntryArray[n].codebaseToString());
        this.tw.addNewComponent(this.getContentPane(), jLabel, 1, 1, 1, 2, 1, 0.0, 0.0, 1);
        string = string + " " + jLabel.getText();
        jLabel = new JLabel(policyEntryArray[n].principalsToString());
        this.tw.addNewComponent(this.getContentPane(), jLabel, 2, 1, 2, 2, 1, 0.0, 0.0, 1);
        string = string + jLabel.getText();
        Vector vector = policyEntryArray[n].getGrantEntry().permissionEntries;
        int n2 = 0;
        while (n2 < vector.size()) {
            object2 = (PolicyParser.PermissionEntry)vector.elementAt(n2);
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            ((PolicyParser.PermissionEntry)object2).write(printWriter);
            String string2 = ((StringWriter)object).toString();
            jLabel = new JLabel("    " + string2.substring(0, string2.indexOf(";") + 1));
            if (n2 == vector.size() - 1) {
                this.tw.addNewComponent(this.getContentPane(), jLabel, 3 + n2, 1, 3 + n2, 2, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            } else {
                this.tw.addNewComponent(this.getContentPane(), jLabel, 3 + n2, 1, 3 + n2, 2, 1, 0.0, 0.0, 1);
            }
            string = string + jLabel.getText();
            ++n2;
        }
        object2 = new JButton(PolicyTool.rb.getString("Cancel"));
        ((AbstractButton)object2).setMnemonic((Integer)PolicyTool.rb.getObject("Cancel Mnemonic"));
        ((AbstractButton)object2).addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this.getContentPane(), (Component)object2, 3 + vector.size(), 2, 3 + vector.size(), 1, 1, 0.0, 0.0, 3, ToolWindow.BOTTOM_PADDING);
        this.getRootPane().registerKeyboardAction(new CancelButtonListener(this), KeyStroke.getKeyStroke(27, 0), 2);
        object = new JButton(PolicyTool.rb.getString("OK"));
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("OK Mnemonic"));
        this.getRootPane().setDefaultButton((JButton)object);
        ((AbstractButton)object).addActionListener(new ConfirmRemovePolicyEntryOKButtonListener(this.tool, this.tw, this));
        this.tw.addNewComponent(this.getContentPane(), (Component)object, 4 + vector.size(), 1, 3 + vector.size(), 1, 1, 0.0, 0.0, 3, ToolWindow.BOTTOM_PADDING);
        ((JButton)object).getAccessibleContext().setAccessibleName(string + ". " + ((AbstractButton)object).getText());
        this.pack();
        this.setVisible(true);
    }

    void displaySaveAsDialog(int n) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(PolicyTool.rb.getString("Save As Title"));
        int n2 = jFileChooser.showSaveDialog(this.tw);
        if (jFileChooser.getSelectedFile() == null || jFileChooser.getSelectedFile().equals("") || n2 == 1) {
            return;
        }
        String string = jFileChooser.getSelectedFile().toString();
        File file = new File(string);
        if (file.exists()) {
            ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Overwrite File"), this.tool, this.tw, this.tw, true);
            toolDialog.displayOverWriteFileDialog(string, n);
        } else {
            try {
                this.tool.savePolicy(string);
                MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Policy successfully written to filename"));
                Object[] objectArray = new Object[]{string};
                this.tw.displayStatusDialog(this.tw, messageFormat.format(objectArray));
                FocusTextField focusTextField = (FocusTextField)this.tw.getContentPane().getComponent(1);
                focusTextField.setText(string);
                this.tw.setVisible(true);
                this.userSaveContinue(this.tool, this.tw, n);
            }
            catch (Exception exception) {
                MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Save to filename failed. View Warning Log for details."));
                Object[] objectArray = new Object[]{string};
                this.tw.displayErrorDialog(this.tw, messageFormat.format(objectArray));
                messageFormat = new MessageFormat(PolicyTool.rb.getString("Warning: Save to filename failed due to unexpected exception: "));
                this.tool.warnings.addElement(messageFormat.format(objectArray) + exception.getMessage());
            }
        }
    }

    void displayUserSave(int n) {
        if (this.tool.modified) {
            Point point = this.tw.getLocationOnScreen();
            this.setLocation(point.x + 75, point.y + 100);
            this.getContentPane().setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(PolicyTool.rb.getString("     Save changes?"));
            this.tw.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            JButton jButton = new JButton(PolicyTool.rb.getString("Yes"));
            jButton.setMnemonic((Integer)PolicyTool.rb.getObject("Yes Mnemonic"));
            this.getRootPane().setDefaultButton(jButton);
            jButton.addActionListener(new UserSaveYesButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(jPanel, jButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
            jButton.getAccessibleContext().setAccessibleName(jLabel.getText() + ". " + jButton.getText());
            JButton jButton2 = new JButton(PolicyTool.rb.getString("No"));
            jButton2.setMnemonic((Integer)PolicyTool.rb.getObject("No Mnemonic"));
            jButton2.addActionListener(new UserSaveNoButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(jPanel, jButton2, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
            JButton jButton3 = new JButton(PolicyTool.rb.getString("Cancel"));
            jButton3.setMnemonic((Integer)PolicyTool.rb.getObject("Cancel Mnemonic"));
            jButton3.addActionListener(new UserSaveCancelButtonListener(this));
            this.tw.addNewComponent(jPanel, jButton3, 2, 2, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
            this.getRootPane().registerKeyboardAction(new CancelButtonListener(this), KeyStroke.getKeyStroke(27, 0), 2);
            this.tw.addNewComponent(this.getContentPane(), jPanel, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
            this.pack();
            this.setVisible(true);
        } else {
            this.userSaveContinue(this.tool, this.tw, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void userSaveContinue(PolicyTool var1_1, ToolWindow var2_2, int var3_3) {
        switch (var3_3) {
            case 1: {
                var2_2.setVisible(false);
                var2_2.dispose();
                System.exit(0);
            }
            case 2: {
                var1_1.newPolicy();
                var4_4 = new LegacyList();
                var4_4.addActionListener(new PolicyListListener(var1_1, var2_2));
                var2_2.replacePolicyList(var4_4);
                var5_6 = (FocusTextField)var2_2.getContentPane().getComponent(1);
                var5_6.setText("");
                var6_8 = (FocusTextField)var2_2.getContentPane().getComponent(3);
                var6_8.setText("");
                var2_2.setVisible(true);
                break;
            }
            case 3: {
                var7_10 = new JFileChooser();
                var7_10.setDialogTitle(PolicyTool.rb.getString("Open Title"));
                var8_11 = var7_10.showOpenDialog(var2_2);
                if (var7_10.getSelectedFile() == null || var7_10.getSelectedFile().equals("") || var8_11 == 1) {
                    return;
                }
                var9_12 = var7_10.getSelectedFile().toString();
                try {
                    try {
                        var1_1.openPolicy(var2_2, var9_12);
                    }
                    catch (FileNotFoundException var10_15) {
                        if (var9_12 == null || var9_12.equals("")) {
                            var2_2.displayErrorDialog(this, PolicyTool.rb.getString("null filename"));
                        } else {
                            var11_17 = new MessageFormat(PolicyTool.rb.getString("filename not found"));
                            var12_20 = new Object[]{var9_12};
                            var2_2.displayErrorDialog(var2_2, var11_17.format(var12_20));
                        }
                        var17_13 = null;
                        var1_1.modified = false;
                        ** GOTO lbl76
                    }
                    catch (PolicyParser.ParsingException var11_18) {
                        var12_20 = new MessageFormat(PolicyTool.rb.getString("Error parsing policy file policyFile. View Warning Log for details."));
                        var13_22 = new Object[]{var9_12};
                        var2_2.displayErrorDialog(var2_2, var12_20.format(var13_22));
                        var12_20 = new MessageFormat(PolicyTool.rb.getString("Error: Could not open policy file, filename, because of parsing error: pppe.getMessage()"));
                        var14_24 = new Object[]{var9_12, var11_18.getMessage()};
                        var1_1.warnings.addElement(var12_20.format(var14_24));
                        var17_13 = null;
                        var1_1.modified = false;
                        ** GOTO lbl76
                    }
                    catch (NoSuchMethodException var12_21) {
                        var2_2.displayErrorDialog(var2_2, PolicyTool.rb.getString("Permission could not be mapped to an appropriate class"));
                        var17_13 = null;
                        var1_1.modified = false;
                        ** GOTO lbl76
                    }
                    catch (Exception var13_23) {
                        var14_24 = new MessageFormat(PolicyTool.rb.getString("Error: Could not open policy file, filename. View the Warning Log for details."));
                        var15_25 = new Object[]{var9_12};
                        var2_2.displayErrorDialog(var2_2, var14_24.format(var15_25));
                        var1_1.warnings.addElement(PolicyTool.rb.getString("Warning: Could not open policy file, ") + var9_12);
                        var1_1.warnings.addElement(PolicyTool.rb.getString("\tdue to unexpected exception: ") + var13_23);
                        var17_13 = null;
                        var1_1.modified = false;
                    }
                    var17_13 = null;
                    var1_1.modified = false;
                }
                catch (Throwable var16_26) {
                    var17_14 = null;
                    var1_1.modified = false;
                    throw var16_26;
                }
lbl76:
                // 5 sources

                var4_5 = new LegacyList();
                var4_5.addActionListener(new PolicyListListener(var1_1, var2_2));
                var10_16 = var1_1.getEntry();
                if (var10_16 != null) {
                    var11_19 = 0;
                    while (var11_19 < var10_16.length) {
                        var4_5.add(var10_16[var11_19].headerToString());
                        ++var11_19;
                    }
                }
                var2_2.replacePolicyList(var4_5);
                var5_7 = (FocusTextField)var2_2.getContentPane().getComponent(1);
                var5_7.setText(var9_12);
                var6_9 = (FocusTextField)var2_2.getContentPane().getComponent(3);
                if (var1_1.getKeyStoreType() != null && var1_1.getKeyStoreType().length() > 0) {
                    var6_9.setText(var1_1.getKeyStoreName() + ", " + var1_1.getKeyStoreType());
                } else {
                    var6_9.setText(var1_1.getKeyStoreName());
                }
                var2_2.setVisible(true);
                if (!var1_1.newWarning) break;
                var2_2.displayStatusDialog(var2_2, PolicyTool.rb.getString("Errors have occurred while opening the policy configuration.  View the Warning Log for more information."));
            }
        }
    }

    void setPermissionActions(String string, JComboBox jComboBox, FocusTextField focusTextField) {
        jComboBox.removeAllItems();
        jComboBox.addItem(PERM_ACTIONS);
        focusTextField.setEditable(true);
        if (string.equals(ALL_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(AWT_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(FILE_PERM_CLASS)) {
            jComboBox.addItem("read");
            jComboBox.addItem("write");
            jComboBox.addItem(FILE_PERM_DELETE);
            jComboBox.addItem(FILE_PERM_EXECUTE);
            jComboBox.addItem(FILE_PERM_ALL);
        } else if (string.equals(NET_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(PROP_PERM_CLASS)) {
            jComboBox.addItem("read");
            jComboBox.addItem("write");
            jComboBox.addItem(PROP_PERM_ALL);
        } else if (string.equals(REFLECT_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(RUNTIME_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(SECURITY_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(SERIAL_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(SOCK_PERM_CLASS)) {
            jComboBox.addItem(SOCKET_PERM_LISTEN);
            jComboBox.addItem(SOCKET_PERM_CONNECT);
            jComboBox.addItem("accept");
            jComboBox.addItem(SOCKET_PERM_RESOLVE);
            jComboBox.addItem(SOCKET_PERM_ALL);
        } else if (string.equals(AUTH_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(PRIVCRED_PERM_CLASS)) {
            jComboBox.addItem("read");
        } else if (string.equals(SERVICE_PERM_CLASS)) {
            jComboBox.addItem(SERVICE_PERM_INIT);
            jComboBox.addItem("accept");
            jComboBox.addItem(SERVICE_PERM_ALL);
        } else if (string.equals(DELEGATION_PERM_CLASS)) {
            focusTextField.setEditable(false);
        }
    }

    void setPermissionNames(String string, JComboBox jComboBox, FocusTextField focusTextField) {
        jComboBox.removeAllItems();
        jComboBox.addItem(PERM_NAME);
        focusTextField.setEditable(true);
        String[] stringArray = null;
        if (string.equals(ALL_PERM_CLASS)) {
            focusTextField.setEditable(false);
        } else if (string.equals(AUDIO_PERM_CLASS)) {
            stringArray = AUDIO_TARGETS;
        } else if (string.equals(AUTH_PERM_CLASS)) {
            stringArray = AUTH_TARGETS;
        } else if (string.equals(AWT_PERM_CLASS)) {
            stringArray = AWT_TARGETS;
        } else if (!string.equals(DELEGATION_PERM_CLASS)) {
            if (string.equals(FILE_PERM_CLASS)) {
                stringArray = FILE_TARGETS;
            } else if (string.equals(LOG_PERM_CLASS)) {
                stringArray = LOG_TARGETS;
            } else if (string.equals(NET_PERM_CLASS)) {
                stringArray = NET_TARGETS;
            } else if (!string.equals(PRIVCRED_PERM_CLASS) && !string.equals(PROP_PERM_CLASS)) {
                if (string.equals(REFLECT_PERM_CLASS)) {
                    stringArray = REF_TARGETS;
                } else if (string.equals(RUNTIME_PERM_CLASS)) {
                    stringArray = RUN_TARGETS;
                } else if (string.equals(SECURITY_PERM_CLASS)) {
                    stringArray = SEC_TARGETS;
                } else if (string.equals(SERIAL_PERM_CLASS)) {
                    stringArray = SER_TARGETS;
                } else if (!string.equals(SERVICE_PERM_CLASS) && !string.equals(SOCK_PERM_CLASS)) {
                    if (string.equals(SQL_PERM_CLASS)) {
                        stringArray = SQL_TARGETS;
                    } else if (string.equals(SSL_PERM_CLASS)) {
                        stringArray = SSL_TARGETS;
                    }
                }
            }
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                jComboBox.addItem(stringArray[n]);
                ++n;
            }
        }
    }

    void setPrincipals(String string, JComboBox jComboBox) {
        if (string.equals("WILDCARD_PRINCIPAL_CLASS")) {
            jComboBox.setSelectedItem(PRIN_TYPE);
        } else {
            int n = 0;
            while (n < PRIN_CLASSES.length) {
                if (string.equals(PRIN_CLASSES[n])) {
                    jComboBox.setSelectedItem(ALL_PRIN_NAMES[n]);
                    break;
                }
                ++n;
            }
        }
    }

    void setPermissions(String string, JComboBox jComboBox) {
        if (string.equals(ALL_PERM_CLASS)) {
            jComboBox.setSelectedItem(ALL_PERM);
        } else if (string.equals(AUDIO_PERM_CLASS)) {
            jComboBox.setSelectedItem(AUDIO_PERM);
        } else if (string.equals(AUTH_PERM_CLASS)) {
            jComboBox.setSelectedItem(AUTH_PERM);
        } else if (string.equals(AWT_PERM_CLASS)) {
            jComboBox.setSelectedItem(AWT_PERM);
        } else if (string.equals(DELEGATION_PERM_CLASS)) {
            jComboBox.setSelectedItem(DELEGATION_PERM);
        } else if (string.equals(FILE_PERM_CLASS)) {
            jComboBox.setSelectedItem(FILE_PERM);
        } else if (string.equals(LOG_PERM_CLASS)) {
            jComboBox.setSelectedItem(LOG_PERM);
        } else if (string.equals(NET_PERM_CLASS)) {
            jComboBox.setSelectedItem(NET_PERM);
        } else if (string.equals(PRIVCRED_PERM_CLASS)) {
            jComboBox.setSelectedItem(PRIVCRED_PERM);
        } else if (string.equals(PROP_PERM_CLASS)) {
            jComboBox.setSelectedItem(PROPERTY_PERM);
        } else if (string.equals(REFLECT_PERM_CLASS)) {
            jComboBox.setSelectedItem(REFLECT_PERM);
        } else if (string.equals(RUNTIME_PERM_CLASS)) {
            jComboBox.setSelectedItem(RUNTIME_PERM);
        } else if (string.equals(SECURITY_PERM_CLASS)) {
            jComboBox.setSelectedItem(SECURITY_PERM);
        } else if (string.equals(SERIAL_PERM_CLASS)) {
            jComboBox.setSelectedItem(SERIAL_PERM);
        } else if (string.equals(SERVICE_PERM_CLASS)) {
            jComboBox.setSelectedItem(SERVICE_PERM);
        } else if (string.equals(SOCK_PERM_CLASS)) {
            jComboBox.setSelectedItem(SOCKET_PERM);
        } else if (string.equals(SQL_PERM_CLASS)) {
            jComboBox.setSelectedItem(SQL_PERM);
        } else if (string.equals(SSL_PERM_CLASS)) {
            jComboBox.setSelectedItem(SSL_PERM);
        }
    }

    String addSingleBackSlash(String string) {
        String string2 = new String();
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[1];
        while (n2 < n) {
            cArray[0] = string.charAt(n2);
            string2 = string2.concat(new String(cArray));
            if (cArray[0] == '\\') {
                string2 = string2.concat(new String(cArray));
                if (string.charAt(n2 + 1) == '\\') {
                    ++n2;
                }
            }
            ++n2;
        }
        return string2;
    }

    private String parsePrincipalString(String string, int n) {
        int n2 = string.indexOf(" ");
        int n3 = string.indexOf(" ", n2 + 1);
        String string2 = null;
        switch (n) {
            case 4: {
                string2 = string.substring(n2 + 1, n3);
                if (!string2.equals("*")) break;
                return "WILDCARD_PRINCIPAL_CLASS";
            }
            case 5: {
                string2 = string.substring(n3).trim();
                if (string2.indexOf("\"") != -1) {
                    return string2.substring(string2.indexOf("\"") + 1, string2.indexOf("\"", string2.indexOf("\"") + 1));
                }
                if (!string2.equals("*")) break;
                return "WILDCARD_PRINCIPAL_NAME";
            }
        }
        return string2;
    }

    private String parsePermissionString(String string, int n) {
        string = string.substring(string.indexOf(" ") + 1);
        switch (n) {
            case 0: {
                if (string.indexOf(ALL_PERM_CLASS) != -1) {
                    return new String(ALL_PERM_CLASS);
                }
                if (string.indexOf("\"") == -1) {
                    return string.substring(0, string.indexOf(";"));
                }
                return string.substring(0, string.indexOf("\"") - 1);
            }
            case 1: {
                if (string.indexOf(ALL_PERM_CLASS) != -1) {
                    return null;
                }
                if (string.indexOf("\"") == -1) {
                    return null;
                }
                return string.substring(string.indexOf("\"") + 1, string.indexOf("\"", string.indexOf("\"") + 1));
            }
            case 2: {
                if (string.indexOf(ALL_PERM_CLASS) != -1) {
                    return null;
                }
                if (string.indexOf("\"") == -1 || string.indexOf("\", \"") == -1) {
                    return null;
                }
                String string2 = string.substring(string.indexOf("\", \"") + 4, string.indexOf(";") - 1);
                if (string2.indexOf("signedBy") != -1) {
                    return string2.substring(0, string2.indexOf("signedBy") - 3);
                }
                return string2;
            }
            case 3: {
                if (string.indexOf("signedBy") == -1) {
                    return null;
                }
                return string.substring(string.indexOf("signedBy") + 10, string.indexOf(";") - 1);
            }
        }
        return null;
    }

    static {
        PERM_NAME = PolicyTool.rb.getString("Target Name:                                                    ");
        AUDIO_TARGETS = new String[]{"play", "record"};
        AUTH_TARGETS = new String[]{"doAs", "doAsPrivileged", "getSubject", "getSubjectFromDomainCombiner", "setReadOnly", "modifyPrincipals", "modifyPublicCredentials", "modifyPrivateCredentials", "refreshCredential", "destroyCredential", "createLoginContext.<" + PolicyTool.rb.getString("name") + ">", "getLoginConfiguration", "setLoginConfiguration", "refreshLoginConfiguration"};
        AWT_TARGETS = new String[]{"accessClipboard", "accessEventQueue", "listenToAllAWTEvents", "showWindowWithoutWarningBanner", "readDisplayPixels", "createRobot", "fullScreenExclusive"};
        FILE_TARGETS = new String[]{"<<ALL FILES>>"};
        LOG_TARGETS = new String[]{"control"};
        NET_TARGETS = new String[]{"setDefaultAuthenticator", "requestPasswordAuthentication", "specifyStreamHandler"};
        REF_TARGETS = new String[]{"suppressAccessChecks"};
        RUN_TARGETS = new String[]{"usePolicy", "createClassLoader", "getClassLoader", "setContextClassLoader", "setSecurityManager", "createSecurityManager", "exitVM", "shutdownHooks", "setFactory", "setIO", "modifyThread", "stopThread", "modifyThreadGroup", "getProtectionDomain", "readFileDescriptor", "writeFileDescriptor", "loadLibrary.<" + PolicyTool.rb.getString("library name") + ">", "accessClassInPackage.<" + PolicyTool.rb.getString("package name") + ">", "defineClassInPackage.<" + PolicyTool.rb.getString("package name") + ">", "accessDeclaredMembers", "queuePrintJob"};
        SEC_TARGETS = new String[]{"createAccessControlContext", "getDomainCombiner", "getPolicy", "setPolicy", "getProperty.<" + PolicyTool.rb.getString("property name") + ">", "setProperty.<" + PolicyTool.rb.getString("property name") + ">", "insertProvider.<" + PolicyTool.rb.getString("provider name") + ">", "removeProvider.<" + PolicyTool.rb.getString("provider name") + ">", "setSystemScope", "setIdentityPublicKey", "setIdentityInfo", "addIdentityCertificate", "removeIdentityCertificate", "printIdentity", "clearProviderProperties.<" + PolicyTool.rb.getString("provider name") + ">", "putProviderProperty.<" + PolicyTool.rb.getString("provider name") + ">", "removeProviderProperty.<" + PolicyTool.rb.getString("provider name") + ">", "getSignerPrivateKey", "setSignerKeyPair"};
        SER_TARGETS = new String[]{"enableSubclassImplementation", "enableSubstitution"};
        SQL_TARGETS = new String[]{"setLog"};
        SSL_TARGETS = new String[]{"setHostnameVerifier", "getSSLSessionContext"};
        PERM_ACTIONS = PolicyTool.rb.getString("Actions:                                                             ");
        ALL_PRIN_NAMES = new String[PRIN_CLASSES.length];
        int n = 0;
        while (n < PRIN_CLASSES.length) {
            ToolDialog.ALL_PRIN_NAMES[n] = PRIN_CLASSES[n].substring(PRIN_CLASSES[n].lastIndexOf(46) + 1);
            ++n;
        }
    }
}

