/**INC+***********************************************************************/
/*                                                                           */
/* Include: ms_c.h                                                           */
/*                                                                           */
/* Purpose: Standard include file for MS library                             */
/*                                                                           */
/* (C) COPYRIGHT DATA CONNECTION LIMITED 1989, 1990, 1991, 1992, 1993, 1994  */
/*                                                                           */
/**INC-***********************************************************************/

#ifndef MS_C_INCLUDED
#define MS_C_INCLUDED

#include <values_c.h>

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************/
/* MS API Versions                                                           */
/*****************************************************************************/
#define SNAPIX_API_MS_VERSION_1         1
#define SNAPIX_API_MS_VERSION_2         2

/*****************************************************************************/
/* Latest versions of the SNAP-IX APIs.                                      */
/*****************************************************************************/
#define SNAPIX_API_MS_CURRENT_VERSION       SNAPIX_API_MS_VERSION_2

#define ms(X, Y)    ms_version(SNAPIX_API_MS_CURRENT_VERSION, X, Y)

#define ms_async(W, X, Y, Z)   \
                    ms_async_version(SNAPIX_API_MS_CURRENT_VERSION, W, X, Y, Z)

#if defined (__STDC__) || defined (__cplusplus)

/*****************************************************************************/
/* Fully spec'd function declarations                                        */
/*****************************************************************************/

/*****************************************************************************/
/* Function type for MS -> Application callback                              */
/*****************************************************************************/
typedef void (*VMV_CALLBACK) (AP_UINT32       handle,
                              char           *vcb,
                              AP_CORR         correlator);

/*****************************************************************************/
/* Synchronous entry point for MS API library                                */
/*****************************************************************************/
extern void ms_version(AP_INT32        version,
                       AP_UINT32       handle,
                       void           *vcb);

/*****************************************************************************/
/* Asynchronous entry point for MS API library                               */
/*****************************************************************************/
extern AP_UINT16      ms_async_version(AP_INT32        version,
                                       AP_UINT32       handle,
                                       void           *vcb,
                                       VMV_CALLBACK    callback,
                                       AP_CORR         correlator);

#else
/*****************************************************************************/
/* K&R function specs                                                        */
/*****************************************************************************/

/*****************************************************************************/
/* Function type for MS -> Application callback                              */
/*****************************************************************************/
#define VMV_CALLBACK_VOID void
typedef VMV_CALLBACK_VOID (*VMV_CALLBACK) ();
#undef VMV_CALLBACK_VOID

/*****************************************************************************/
/* Synchronous entry point for MS API library                                */
/*****************************************************************************/
extern void ms_version();

/*****************************************************************************/
/* Asynchronous entry point for MS API library                               */
/*****************************************************************************/
extern AP_UINT16      ms_async_version();

#endif

/**STRUCT+********************************************************************/
/* Structure: CONNECT_MS_NODE                                                */
/*                                                                           */
/* Description: Connect to a Node and get a target handle which is then      */
/*              used on all subsequent verbs.                                */
/*****************************************************************************/
typedef struct connect_ms_node
{
  AP_UINT16      opcode;                       /* Verb operation code        */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;                   /* Primary return code        */
  AP_UINT32      secondary_rc;                 /* Secondary return code      */
  unsigned char  node_name[128];               /* Name of Node to connect to */
  AP_UINT32      target_handle;                /* Handle to identify Node on */
                                               /*   subsequent verbs         */
} CONNECT_MS_NODE;

/**STRUCT-********************************************************************/


/**STRUCT+********************************************************************/
/* Structure: DISCONNECT_MS_NODE                                             */
/*                                                                           */
/* Description: Disconnect from Node and free resources used for connection  */
/*****************************************************************************/
typedef struct disconnect_ms_node
{
  AP_UINT16      opcode;                            /* Verb operation code   */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;                        /* Primary return code   */
  AP_UINT32      secondary_rc;                      /* Secondary return code */
} DISCONNECT_MS_NODE;

/**STRUCT-********************************************************************/


/**STRUCT+********************************************************************/
/* Structure: MS_STATUS                                                      */
/*                                                                           */
/* Description: Informs the application of an abended connection             */
/*****************************************************************************/
typedef struct ms_status
{
  AP_UINT16      opcode;                      /* Verb operation code         */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;                  /* Primary return code         */
  AP_UINT32      secondary_rc;                /* Secondary return code       */
  AP_UINT32      status;                      /* status being reported       */
  AP_UINT32      dead_target_handle;          /* Handle of dead connection   */
                                              /* NULL for system termination */
  unsigned char  reserv1[32];                 /* reserved                    */
} MS_STATUS;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: TRANSFER_MS_DATA                                               */
/*                                                                           */
/* Description: Verb Control Block used to send alerts and NMVT responses    */
/*****************************************************************************/

typedef struct transfer_ms_data
{
  AP_UINT16      opcode;                    /* Verb operation code           */
  unsigned char  data_type;                 /* Type of data supplied by appl */
  unsigned char  format;
  AP_UINT16      primary_rc;                /* Primary return code           */
  AP_UINT32      secondary_rc;              /* Secondary return code         */
  unsigned char  options;                   /* Verb options                  */
  unsigned char  reserv3;                   /* reserved                      */
  unsigned char  originator_id[8];          /* Originator ID                 */
  unsigned char  pu_name[8];                /* Physical unit name            */
  unsigned char  reserv4[4];                /* reserved                      */
  AP_UINT16      dlen;                      /* Length of data                */
  unsigned char  *dptr;                     /* Data                          */
} TRANSFER_MS_DATA;

/**STRUCT-********************************************************************/

/*****************************************************************************/
/* Verb Control Block definitions for NMVT-level MS applications             */
/*****************************************************************************/

/**STRUCT+********************************************************************/
/* Structure: REGISTER_NMVT_APPLICATION                                      */
/*                                                                           */
/* Description: VCB used to register an MS application which processes       */
/*              incoming NMVTs                                               */
/*****************************************************************************/

typedef struct register_nmvt_application
{
  AP_UINT16      opcode;                 /* Verb operation code              */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;             /* Primary return code              */
  AP_UINT32      secondary_rc;           /* Secondary return code            */
  unsigned char  ms_appl_name[8];        /* MS application name              */
  AP_UINT16      ms_vector_key_type;     /* MS vector key accepted by appl   */
  unsigned char  conversion_required;    /* MDS level application requesting */
                                         /*  MDS_MUs                         */
} REGISTER_NMVT_APPLICATION;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: UNREGISTER_NMVT_APPLICATION                                    */
/*                                                                           */
/* Description: VCB used to terminate registration of NMVT-style MS          */
/*              application                                                  */
/*****************************************************************************/

typedef struct unregister_nmvt_application
{
  AP_UINT16      opcode;                            /* Verb operation code   */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;                        /* Primary return code   */
  AP_UINT32      secondary_rc;                      /* Secondary return code */
  unsigned char  ms_appl_name[8];                   /* MS application name   */
} UNREGISTER_NMVT_APPLICATION;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: NMVT_RECEIVED                                                  */
/*                                                                           */
/* Description: VCB indication containing NMVT for local application         */
/*****************************************************************************/

typedef struct nmvt_received
{
  AP_UINT16      opcode;                          /* Verb operation code     */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;                      /* Primary return code     */
  AP_UINT32      secondary_rc;                    /* Secondary return code   */
  unsigned char  pu_name[8];                      /* Physical unit name      */
  unsigned char  reserv3[6];                      /* reserved                */
  AP_UINT16      nmvt_length;                     /* Length of incoming NMVT */
  unsigned char  *nmvt;                           /* NMVT data               */
} NMVT_RECEIVED;

/**STRUCT-********************************************************************/

/*****************************************************************************/
/* Verb Control Block definitions for MDS-level MS applications              */
/*****************************************************************************/

/**STRUCT+********************************************************************/
/* Structure: REGISTER_MS_APPLICATION                                        */
/*                                                                           */
/* Description: VCB used to register MS application which uses Multiple      */
/*              Domain Support                                               */
/*****************************************************************************/

typedef struct register_ms_application
{
  AP_UINT16      opcode;                /* Verb operation code               */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;            /* Primary return code               */
  AP_UINT32      secondary_rc;          /* Secondary return code             */
  unsigned char  ms_appl_name[8];       /* MS application name               */
  unsigned char  ms_category[8];        /* MS category                       */
  AP_UINT16      max_rcv_size;          /* Maximum size that can be received */
} REGISTER_MS_APPLICATION;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: SEND_MDS_MU                                                    */
/*                                                                           */
/* Description: VCB used by MS application to send MDS_MU.                   */
/*****************************************************************************/

typedef struct send_mds_mu
{
  AP_UINT16      opcode;                            /* Verb operation code   */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;                        /* Primary return code   */
  AP_UINT32      secondary_rc;                      /* Secondary return code */
  unsigned char  options;                           /* Verb options          */
  unsigned char  reserv3;                           /* reserved              */
  unsigned char  originator_id[8];                  /* Originator ID         */
  unsigned char  pu_name[8];                        /* Physical unit name    */
  unsigned char  reserv4[4];                        /* reserved              */
  AP_UINT16      dlen;                              /* Length of data        */
  unsigned char  *dptr;                             /* Data                  */
} SEND_MDS_MU;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MDS_MU_RECEIVED                                                */
/*                                                                           */
/* Description: VCB indication containing MDS_MU for MS application          */
/*****************************************************************************/

typedef struct mds_mu_received
{
  AP_UINT16      opcode;                 /* Verb operation code              */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;             /* Primary return code              */
  AP_UINT32      secondary_rc;           /* Secondary return code            */
  unsigned char  first_message;          /* First message for current MDS_MU */
  unsigned char  last_message;           /* Last message for current MDS_MU  */
  unsigned char  pu_name[8];             /* Physical unit name               */
  unsigned char  reserv3[8];             /* reserved                         */
  AP_UINT16      mds_mu_length;          /* Length of incoming MDS_MU        */
  unsigned char  *mds_mu;                /* MDS_MU data                      */
} MDS_MU_RECEIVED;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: FP_NOTIFICATION                                                */
/*                                                                           */
/* Description: VCB indication containing Focal Point information            */
/*****************************************************************************/

typedef struct fp_notification
{
  AP_UINT16      opcode;             /* Verb operation code                  */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;         /* Primary return code                  */
  AP_UINT32      secondary_rc;       /* Secondary return code                */
  unsigned char  fp_routing;         /* routing to use with this focal point */
  unsigned char  reserv1;            /* reserved                             */
  AP_UINT16      fp_data_length;     /* Length of incoming focal point data  */
  unsigned char  *fp_data;           /* Focal point data                     */
} FP_NOTIFICATION;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: UNREGISTER_MS_APPLICATION                                      */
/*                                                                           */
/* Description: VCB used by MS application to terminate its registration     */
/*              with MS                                                      */
/*****************************************************************************/

typedef struct unregister_ms_application
{
  AP_UINT16      opcode;                            /* Verb operation code   */
  unsigned char  reserv2;
  unsigned char  format;
  AP_UINT16      primary_rc;                        /* Primary return code   */
  AP_UINT32      secondary_rc;                      /* Secondary return code */
  unsigned char  ms_appl_name[8];                   /* MS application name   */
} UNREGISTER_MS_APPLICATION;

/**STRUCT-********************************************************************/

#ifdef __cplusplus
}
#endif

#endif
