/**INC+***********************************************************************/
/* Header:    tpsrv_c.h                                                      */
/*                                                                           */
/* Purpose:   API definition for the TP server function                      */
/*                                                                           */
/* (C) COPYRIGHT DATA CONNECTION LIMITED 1997, 1999                          */
/*                                                                           */
/**INC-***********************************************************************/

#ifndef TPSRV_C_INCLUDED
#define TPSRV_C_INCLUDED

#include <values_c.h>

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************/
/* Attach notification callback definition                                   */
/*****************************************************************************/
typedef void (*AP_NOTIFY_CB)(unsigned char, unsigned char[8], AP_CORR);
typedef void (*AP_CALLBACK)(void *, unsigned char[8], AP_UINT32, AP_CORR);

/*****************************************************************************/
/* Main entry point                                                          */
/*****************************************************************************/
extern unsigned short tps_async(void *, AP_CALLBACK, AP_CORR);

/*****************************************************************************/
/* Reasons for a call to the nofify callback                                 */
/*****************************************************************************/
#define AP_ATTACH                 (0x01)
#define AP_TP_FILE_CHANGE         (0x02)

/*****************************************************************************/
/* VCBs for the TP Server API                                                */
/*****************************************************************************/
typedef struct register_tp_server
{
  AP_UINT16       opcode;
  unsigned char   rsrvd1;
  unsigned char   rsrvd2;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  AP_UINT32       tps_id;
  unsigned char   tp_file_updates;
  AP_NOTIFY_CB    notify_cb;
} REGISTER_TP_SERVER;


typedef struct unregister_tp_server
{
  AP_UINT16       opcode;
  unsigned char   rsrvd1;
  unsigned char   rsrvd2;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  AP_UINT32       tps_id;
} UNREGISTER_TP_SERVER;


typedef struct register_tp
{
  AP_UINT16       opcode;
  unsigned char   rsrvd1;
  unsigned char   rsrvd2;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  AP_UINT32       tps_id;
  AP_UINT32       res_id;
  unsigned char   tp_name[64];
  char            lu_alias[8];
  unsigned char   fqplu_name[17];
  unsigned char   tp_type;
  AP_INT32        rcv_alloc_timeout;
  AP_UINT16       modify_existing;
  AP_CORR         app_corr;
} REGISTER_TP;


typedef struct unregister_tp
{
  AP_UINT16       opcode;
  unsigned char   rsrvd1;
  unsigned char   rsrvd2;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  AP_UINT32       tps_id;
  AP_UINT32       res_id;
} UNREGISTER_TP;


typedef struct query_attach
{            
  AP_UINT16       opcode;
  unsigned char   rsrvd1;
  unsigned char   rsrvd2;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  AP_UINT32       tps_id;
  unsigned char   attach_id[8];
  unsigned char   tp_name[64];
  char            lu_alias[8];
  unsigned char   fq_plu_name[17];
  unsigned char   mode_name[8];
  AP_UINT16       max_pip_len;
  AP_UINT16       pip_dlen;
  unsigned char  *pip_dptr;
  AP_UINT16       max_fmh5_len;
  AP_UINT16       fmh5_dlen;
  unsigned char  *fmh5_dptr;
} QUERY_ATTACH;


typedef struct accept_attach
{
  AP_UINT16       opcode;
  unsigned char   rsrvd1;
  unsigned char   rsrvd2;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  AP_UINT32       tps_id;
  unsigned char   attach_id[8];
} ACCEPT_ATTACH;


typedef struct reject_attach
{
  AP_UINT16       opcode;
  unsigned char   rsrvd1;
  unsigned char   rsrvd2;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  AP_UINT32       tps_id;
  unsigned char   attach_id[8];
  AP_UINT32       reason;
} REJECT_ATTACH;


typedef struct abort_attach
{
  AP_UINT16       opcode;
  unsigned char   rsrvd1;
  unsigned char   rsrvd2;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  AP_UINT32       tps_id;
  unsigned char   attach_id[8];
  AP_UINT32       reason;
} ABORT_ATTACH;


#ifdef __cplusplus
}
#endif

#endif
